/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.spira;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.spira.BaseSpiraArtifact;
import org.json.JSONObject;

public abstract class PathSpiraArtifact
extends BaseSpiraArtifact {
    public String getPath() {
        String name = this.getName();
        name = name.replace("/", "\\/");
        PathSpiraArtifact parentSpiraArtifact = this.getParentSpiraArtifact();
        if (parentSpiraArtifact == null) {
            return "/" + name;
        }
        return JenkinsResultsParserUtil.combine(parentSpiraArtifact.getPath(), "/", name);
    }

    protected static String getParentPath(String path) {
        PathSpiraArtifact._validatePath(path);
        return path.substring(0, JenkinsResultsParserUtil.lastIndexOfRegex(path, "(?<!\\\\)\\/"));
    }

    protected static String getPathName(String path) {
        PathSpiraArtifact._validatePath(path);
        return path.substring(JenkinsResultsParserUtil.lastIndexOfRegex(path, "(?<!\\\\)\\/") + 1);
    }

    protected PathSpiraArtifact(JSONObject jsonObject) {
        super(jsonObject);
        this.jsonObject.put("Path", (Object)this.getPath());
    }

    protected abstract PathSpiraArtifact getParentSpiraArtifact();

    private static void _validatePath(String path) {
        if (path.endsWith("/") || !path.startsWith("/")) {
            throw new RuntimeException("Invalid path " + path);
        }
    }
}

