/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.spira;

import com.liferay.jenkins.results.parser.spira.SpiraCustomList;
import com.liferay.jenkins.results.parser.spira.SpiraCustomListValue;
import com.liferay.jenkins.results.parser.spira.SpiraCustomProperty;
import com.liferay.jenkins.results.parser.spira.SpiraCustomPropertyValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class MultiListSpiraCustomPropertyValue
extends SpiraCustomPropertyValue<List<SpiraCustomListValue>> {
    private SpiraCustomList _spiraCustomList;

    public SpiraCustomList getSpiraCustomList() {
        if (this._spiraCustomList != null) {
            return this._spiraCustomList;
        }
        SpiraCustomProperty spiraCustomProperty = this.getSpiraCustomProperty();
        return spiraCustomProperty.getSpiraCustomList();
    }

    @Override
    public List<SpiraCustomListValue> getValue() {
        ArrayList<SpiraCustomListValue> spiraCustomListValues = new ArrayList<SpiraCustomListValue>();
        JSONArray integerListValueJSONArray = this._getIntegerListValueJSONArray();
        if (integerListValueJSONArray == null) {
            return spiraCustomListValues;
        }
        SpiraCustomList spiraCustomList = this.getSpiraCustomList();
        for (int i = 0; i < integerListValueJSONArray.length(); ++i) {
            spiraCustomListValues.add(spiraCustomList.getSpiraCustomListValueByID(integerListValueJSONArray.getInt(i)));
        }
        return spiraCustomListValues;
    }

    @Override
    public String getValueString() {
        StringBuilder sb = new StringBuilder();
        Iterator iterator = this.getValue().iterator();
        while (iterator.hasNext()) {
            SpiraCustomListValue spiraCustomListValue = (SpiraCustomListValue)iterator.next();
            sb.append(spiraCustomListValue.getName());
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    protected MultiListSpiraCustomPropertyValue(JSONObject jsonObject, SpiraCustomProperty spiraCustomProperty) {
        super(jsonObject, spiraCustomProperty);
    }

    protected MultiListSpiraCustomPropertyValue(SpiraCustomListValue spiraCustomListValue, SpiraCustomProperty spiraCustomProperty) {
        super(new JSONObject(), spiraCustomProperty);
        this.jsonObject.put("Definition", (Object)this.getDefinitionJSONObject());
        JSONArray integerListValueJSONArray = new JSONArray();
        integerListValueJSONArray.put(spiraCustomListValue.getID());
        this.jsonObject.put("IntegerListValue", (Object)integerListValueJSONArray);
        this._spiraCustomList = spiraCustomListValue.getSpiraCustomList();
    }

    @Override
    protected JSONObject getCustomPropertyJSONObject() {
        JSONObject customPropertyJSONObject = super.getCustomPropertyJSONObject();
        customPropertyJSONObject.put("IntegerListValue", (Object)this._getIntegerListValueJSONArray());
        return customPropertyJSONObject;
    }

    @Override
    protected JSONObject getFilterJSONObject() {
        JSONObject filterJSONObject = super.getFilterJSONObject();
        Object spiraCustomListValues = this.getValue();
        SpiraCustomListValue spiraCustomListValue = (SpiraCustomListValue)spiraCustomListValues.get(0);
        filterJSONObject.put("IntValue", spiraCustomListValue.getID());
        return filterJSONObject;
    }

    @Override
    protected boolean matchesJSONObject(JSONObject customPropertyJSONObject) {
        JSONArray customPropertyJSONArray = customPropertyJSONObject.optJSONArray("IntegerListValue");
        if (customPropertyJSONArray == null || customPropertyJSONArray.isEmpty()) {
            return false;
        }
        Object spiraCustomListValues = this.getValue();
        if (spiraCustomListValues.isEmpty()) {
            return false;
        }
        for (int i = 0; i < customPropertyJSONArray.length(); ++i) {
            int spiraCustomListValueID = customPropertyJSONArray.getInt(i);
            Iterator iterator = spiraCustomListValues.iterator();
            while (iterator.hasNext()) {
                SpiraCustomListValue spiraCustomListValue = (SpiraCustomListValue)iterator.next();
                if (spiraCustomListValueID != spiraCustomListValue.getID()) continue;
                return true;
            }
        }
        return false;
    }

    private JSONArray _getIntegerListValueJSONArray() {
        return this.jsonObject.optJSONArray("IntegerListValue");
    }
}

