/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.spira;

import com.liferay.jenkins.results.parser.spira.SpiraCustomList;
import com.liferay.jenkins.results.parser.spira.SpiraCustomListValue;
import com.liferay.jenkins.results.parser.spira.SpiraCustomProperty;
import com.liferay.jenkins.results.parser.spira.SpiraCustomPropertyValue;
import org.json.JSONObject;

public class ListSpiraCustomPropertyValue
extends SpiraCustomPropertyValue<SpiraCustomListValue> {
    private SpiraCustomList _spiraCustomList;

    public SpiraCustomList getSpiraCustomList() {
        if (this._spiraCustomList != null) {
            return this._spiraCustomList;
        }
        SpiraCustomProperty spiraCustomProperty = this.getSpiraCustomProperty();
        this._spiraCustomList = SpiraCustomList.createSpiraCustomListByName(this.getSpiraProject(), spiraCustomProperty.getSpiraArtifactClass(), spiraCustomProperty.getName());
        return this._spiraCustomList;
    }

    @Override
    public SpiraCustomListValue getValue() {
        Integer integerValue = this._getIntegerValue();
        if (integerValue == null || integerValue == JSONObject.NULL) {
            return null;
        }
        SpiraCustomList spiraCustomList = this.getSpiraCustomList();
        return spiraCustomList.getSpiraCustomListValueByID(integerValue);
    }

    @Override
    public String getValueString() {
        SpiraCustomListValue spiraCustomListValue = this.getValue();
        if (spiraCustomListValue == null) {
            return "";
        }
        return spiraCustomListValue.getName();
    }

    protected ListSpiraCustomPropertyValue(JSONObject jsonObject, SpiraCustomProperty spiraCustomProperty) {
        super(jsonObject, spiraCustomProperty);
    }

    protected ListSpiraCustomPropertyValue(SpiraCustomListValue spiraCustomListValue, SpiraCustomProperty spiraCustomProperty) {
        super(new JSONObject(), spiraCustomProperty);
        this.jsonObject.put("Definition", (Object)this.getDefinitionJSONObject());
        this.jsonObject.put("IntegerValue", spiraCustomListValue.getID());
        this._spiraCustomList = spiraCustomListValue.getSpiraCustomList();
    }

    @Override
    protected JSONObject getCustomPropertyJSONObject() {
        JSONObject customPropertyJSONObject = super.getCustomPropertyJSONObject();
        customPropertyJSONObject.put("IntegerValue", this._getIntegerValue());
        return customPropertyJSONObject;
    }

    @Override
    protected JSONObject getFilterJSONObject() {
        JSONObject filterJSONObject = super.getFilterJSONObject();
        filterJSONObject.put("IntValue", this._getIntegerValue());
        return filterJSONObject;
    }

    @Override
    protected boolean matchesJSONObject(JSONObject customPropertyJSONObject) {
        return customPropertyJSONObject.optInt("IntegerValue") == this._getIntegerValue();
    }

    private int _getIntegerValue() {
        return this.jsonObject.optInt("IntegerValue");
    }
}

