/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.spira;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.spira.IndentLevelSpiraArtifact;
import com.liferay.jenkins.results.parser.spira.SearchQuery;
import com.liferay.jenkins.results.parser.spira.SpiraArtifact;
import com.liferay.jenkins.results.parser.spira.SpiraCustomProperty;
import com.liferay.jenkins.results.parser.spira.SpiraCustomPropertyValue;
import com.liferay.jenkins.results.parser.spira.SpiraProject;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BaseSpiraArtifact
implements SpiraArtifact {
    protected transient JSONObject jsonObject;
    private static final Map<Class<?>, Map<Integer, SpiraArtifact>> _idSpiraArtifactsMap = Collections.synchronizedMap(new HashMap());
    private static final Map<Class<?>, Map<String, IndentLevelSpiraArtifact>> _indentLevelSpiraArtifactsMap = Collections.synchronizedMap(new HashMap());

    public static int getArtifactTypeID(Class<? extends SpiraArtifact> spiraArtifactClass) {
        return (Integer)BaseSpiraArtifact._getClassField(spiraArtifactClass, "ARTIFACT_TYPE_ID");
    }

    public static String getArtifactTypeName(Class<? extends SpiraArtifact> spiraArtifactClass) {
        return (String)BaseSpiraArtifact._getClassField(spiraArtifactClass, "ARTIFACT_TYPE_NAME");
    }

    public static String getKeyID(Class<? extends SpiraArtifact> spiraArtifactClass) {
        return (String)BaseSpiraArtifact._getClassField(spiraArtifactClass, "KEY_ID");
    }

    public boolean equals(Object object) {
        SpiraProject spiraProject;
        if (!Objects.equals(this.getClass(), object.getClass())) {
            return false;
        }
        SpiraArtifact spiraArtifact = (SpiraArtifact)object;
        if (!(object instanceof SpiraProject) && !(spiraProject = spiraArtifact.getSpiraProject()).equals(this.getSpiraProject())) {
            return false;
        }
        return spiraArtifact.getID() == this.getID();
    }

    @Override
    public int getID() {
        return this.jsonObject.getInt(BaseSpiraArtifact.getKeyID(this.getClass()));
    }

    @Override
    public String getName() {
        return this.jsonObject.getString("Name");
    }

    @Override
    public List<SpiraCustomProperty> getSpiraCustomProperties() {
        return SpiraCustomProperty.getSpiraCustomProperties(this.getSpiraProject(), this.getClass(), new SearchQuery.SearchParameter[0]);
    }

    @Override
    public SpiraCustomPropertyValue getSpiraCustomPropertyValue(String spiraCustomPropertyName) {
        for (SpiraCustomPropertyValue spiraCustomPropertyValue : this.getSpiraCustomPropertyValues()) {
            SpiraCustomProperty spiraCustomProperty = spiraCustomPropertyValue.getSpiraCustomProperty();
            if (!spiraCustomPropertyName.equals(spiraCustomProperty.getName())) continue;
            return spiraCustomPropertyValue;
        }
        return null;
    }

    @Override
    public List<SpiraCustomPropertyValue> getSpiraCustomPropertyValues() {
        ArrayList<SpiraCustomPropertyValue> spiraCustomPropertyValues = new ArrayList<SpiraCustomPropertyValue>();
        if (!this.jsonObject.has("CustomProperties")) {
            return spiraCustomPropertyValues;
        }
        JSONArray customPropertiesJSONArray = this.jsonObject.getJSONArray("CustomProperties");
        for (int i = 0; i < customPropertiesJSONArray.length(); ++i) {
            JSONObject customPropertyJSONObject = customPropertiesJSONArray.getJSONObject(i);
            List<SpiraCustomProperty> spiraCustomProperties = this.getSpiraCustomProperties();
            SpiraCustomProperty spiraCustomProperty = spiraCustomProperties.get(customPropertyJSONObject.getInt("PropertyNumber") - 1);
            spiraCustomPropertyValues.add(SpiraCustomPropertyValue.getSpiraCustomPropertyValue(spiraCustomProperty, customPropertyJSONObject));
        }
        return spiraCustomPropertyValues;
    }

    @Override
    public SpiraProject getSpiraProject() {
        if (this instanceof SpiraProject) {
            return (SpiraProject)this;
        }
        return SpiraProject.getSpiraProjectByID(this.jsonObject.getInt("ProjectId"));
    }

    public int hashCode() {
        JSONObject jsonObject = this.toJSONObject();
        return jsonObject.hashCode();
    }

    @Override
    public JSONObject toJSONObject() {
        return this.jsonObject;
    }

    public String toString() {
        return this.jsonObject.toString();
    }

    protected static <S extends SpiraArtifact> void cacheSpiraArtifact(Class<S> spiraArtifactClass, S spiraArtifact) {
        BaseSpiraArtifact._putIDSpiraArtifact(spiraArtifactClass, spiraArtifact);
        if (spiraArtifact instanceof IndentLevelSpiraArtifact) {
            IndentLevelSpiraArtifact indentLevelSpiraArtifact = (IndentLevelSpiraArtifact)spiraArtifact;
            BaseSpiraArtifact._putIndentLevelSpiraArtifact(spiraArtifactClass, indentLevelSpiraArtifact);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void clearCachedSpiraArtifacts(Class<? extends SpiraArtifact> spiraArtifactClass) {
        Map<String, IndentLevelSpiraArtifact> indentLevelSpiraArtifactsMap;
        int cachedSpiraArtifactCount = 0;
        Map<Class<?>, Map<Object, SpiraArtifact>> map = _idSpiraArtifactsMap;
        synchronized (map) {
            Map<Integer, SpiraArtifact> idSpiraArtifactsMap = BaseSpiraArtifact._getIDSpiraArtifactsMap(spiraArtifactClass);
            cachedSpiraArtifactCount += idSpiraArtifactsMap.size();
            idSpiraArtifactsMap.clear();
        }
        map = _indentLevelSpiraArtifactsMap;
        synchronized (map) {
            indentLevelSpiraArtifactsMap = BaseSpiraArtifact._getIndentLevelSpiraArtifactsMap(spiraArtifactClass);
            indentLevelSpiraArtifactsMap.clear();
        }
        String artifactTypeName = BaseSpiraArtifact.getArtifactTypeName(spiraArtifactClass);
        System.out.println(JenkinsResultsParserUtil.combine("Cleared ", String.valueOf(cachedSpiraArtifactCount += indentLevelSpiraArtifactsMap.size()), " cached ", JenkinsResultsParserUtil.getNounForm(cachedSpiraArtifactCount, artifactTypeName + "s", artifactTypeName), " from memory."));
    }

    protected static <S extends SpiraArtifact> List<S> getSpiraArtifacts(Class<S> spiraArtifactClass, Supplier<List<JSONObject>> spiraArtifactSupplier, Function<JSONObject, S> spiraArtifactCreator, boolean checkCache, SearchQuery.SearchParameter ... searchParameters) {
        SearchQuery<S> cachedSearchQuery = SearchQuery.getCachedSearchQuery(spiraArtifactClass, searchParameters);
        if (cachedSearchQuery != null) {
            return cachedSearchQuery.getSpiraArtifacts();
        }
        SearchQuery<S> searchQuery = new SearchQuery<S>(spiraArtifactClass, searchParameters);
        String keyID = BaseSpiraArtifact.getKeyID(spiraArtifactClass);
        if (searchQuery.hasSearchParameter(keyID)) {
            SearchQuery.SearchParameter searchParameter;
            Integer id;
            Map<Integer, SpiraArtifact> idSpiraArtifactsMap = BaseSpiraArtifact._getIDSpiraArtifactsMap(spiraArtifactClass);
            if (!idSpiraArtifactsMap.containsKey(id = (Integer)(searchParameter = searchQuery.getSearchParameter(keyID)).getValue())) {
                for (JSONObject responseJSONObject : spiraArtifactSupplier.get()) {
                    spiraArtifactCreator.apply(responseJSONObject);
                }
            }
            if (idSpiraArtifactsMap.containsKey(id)) {
                SpiraArtifact spiraArtifact = idSpiraArtifactsMap.get(id);
                searchQuery.addSpiraArtifact(spiraArtifact);
                SearchQuery.cacheSearchQuery(searchQuery);
            }
            return searchQuery.getSpiraArtifacts();
        }
        if (searchQuery.hasSearchParameter("IndentLevel")) {
            SearchQuery.SearchParameter searchParameter = searchQuery.getSearchParameter("IndentLevel");
            String indentLevel = (String)searchParameter.getValue();
            Map<String, IndentLevelSpiraArtifact> indentLevelSpiraArtifactsMap = BaseSpiraArtifact._getIndentLevelSpiraArtifactsMap(spiraArtifactClass);
            if (!indentLevelSpiraArtifactsMap.containsKey(indentLevel)) {
                for (JSONObject responseJSONObject : spiraArtifactSupplier.get()) {
                    spiraArtifactCreator.apply(responseJSONObject);
                }
            }
            if (indentLevelSpiraArtifactsMap.containsKey(indentLevel)) {
                SpiraArtifact spiraArtifact = indentLevelSpiraArtifactsMap.get(indentLevel);
                searchQuery.addSpiraArtifact(spiraArtifact);
                SearchQuery.cacheSearchQuery(searchQuery);
            }
            return searchQuery.getSpiraArtifacts();
        }
        if (checkCache) {
            List<SpiraArtifact> spiraArtifacts = BaseSpiraArtifact._getSpiraArtifacts(spiraArtifactClass);
            for (SpiraArtifact spiraArtifact : spiraArtifacts) {
                if (!searchQuery.matches(spiraArtifact)) continue;
                searchQuery.addSpiraArtifact(spiraArtifact);
            }
            if (!searchQuery.isEmpty()) {
                SearchQuery.cacheSearchQuery(searchQuery);
                return searchQuery.getSpiraArtifacts();
            }
        }
        for (JSONObject responseJSONObject : spiraArtifactSupplier.get()) {
            SpiraArtifact spiraArtifact;
            spiraArtifact = (SpiraArtifact)spiraArtifactCreator.apply(responseJSONObject);
            if (!searchQuery.matches(spiraArtifact)) continue;
            searchQuery.addSpiraArtifact(spiraArtifact);
        }
        if (!searchQuery.isEmpty()) {
            SearchQuery.cacheSearchQuery(searchQuery);
        }
        return searchQuery.getSpiraArtifacts();
    }

    protected static <S extends SpiraArtifact> List<S> getSpiraArtifacts(Class<S> spiraArtifactClass, Supplier<List<JSONObject>> spiraArtifactSupplier, Function<JSONObject, S> spiraArtifactCreator, SearchQuery.SearchParameter ... searchParameters) {
        return BaseSpiraArtifact.getSpiraArtifacts(spiraArtifactClass, spiraArtifactSupplier, spiraArtifactCreator, false, searchParameters);
    }

    protected static <S extends SpiraArtifact> void removeCachedSpiraArtifacts(Class<S> spiraArtifactClass, List<S> spiraArtifacts) {
        for (SpiraArtifact spiraArtifact : spiraArtifacts) {
            BaseSpiraArtifact._removeIDSpiraArtifact(spiraArtifactClass, spiraArtifact);
            if (!(spiraArtifact instanceof IndentLevelSpiraArtifact)) continue;
            BaseSpiraArtifact._removeIndentLevelSpiraArtifact(spiraArtifactClass, (IndentLevelSpiraArtifact)spiraArtifact);
        }
    }

    protected static String toDateString(Calendar calendar) {
        return JenkinsResultsParserUtil.combine("/Date(", String.valueOf(calendar.getTimeInMillis()), ")/");
    }

    protected BaseSpiraArtifact(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    private static Object _getClassField(Class<? extends SpiraArtifact> spiraArtifactClass, String fieldName) {
        Class<? extends SpiraArtifact> clazz = spiraArtifactClass;
        RuntimeException runtimeException = null;
        while (true) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                return field.get(fieldName);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException exception) {
                if (runtimeException == null) {
                    runtimeException = new RuntimeException("Missing field " + fieldName + " in " + spiraArtifactClass.getName(), exception);
                }
                if (clazz != Object.class) {
                    clazz = clazz.getSuperclass();
                    continue;
                }
                throw runtimeException;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Integer, SpiraArtifact> _getIDSpiraArtifactsMap(Class<? extends SpiraArtifact> spiraArtifactClass) {
        Map<Class<?>, Map<Integer, SpiraArtifact>> map = _idSpiraArtifactsMap;
        synchronized (map) {
            Map<Integer, SpiraArtifact> spiraArtifactsMap = _idSpiraArtifactsMap.get(spiraArtifactClass);
            if (spiraArtifactsMap == null) {
                spiraArtifactsMap = Collections.synchronizedMap(new HashMap());
                _idSpiraArtifactsMap.put(spiraArtifactClass, spiraArtifactsMap);
            }
            return spiraArtifactsMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, IndentLevelSpiraArtifact> _getIndentLevelSpiraArtifactsMap(Class<? extends SpiraArtifact> spiraArtifactClass) {
        Map<Class<?>, Map<String, IndentLevelSpiraArtifact>> map = _indentLevelSpiraArtifactsMap;
        synchronized (map) {
            Map<String, IndentLevelSpiraArtifact> spiraArtifactsMap = _indentLevelSpiraArtifactsMap.get(spiraArtifactClass);
            if (spiraArtifactsMap == null) {
                spiraArtifactsMap = Collections.synchronizedMap(new HashMap());
                _indentLevelSpiraArtifactsMap.put(spiraArtifactClass, spiraArtifactsMap);
            }
            return spiraArtifactsMap;
        }
    }

    private static List<SpiraArtifact> _getSpiraArtifacts(Class<? extends SpiraArtifact> spiraArtifactClass) {
        Map<Integer, SpiraArtifact> spiraArtifactsMap = BaseSpiraArtifact._getIDSpiraArtifactsMap(spiraArtifactClass);
        return new ArrayList<SpiraArtifact>(spiraArtifactsMap.values());
    }

    private static void _putIDSpiraArtifact(Class<? extends SpiraArtifact> spiraArtifactClass, SpiraArtifact spiraArtifact) {
        Map<Integer, SpiraArtifact> idSpiraArtifactsMap = BaseSpiraArtifact._getIDSpiraArtifactsMap(spiraArtifactClass);
        idSpiraArtifactsMap.put(spiraArtifact.getID(), spiraArtifact);
    }

    private static void _putIndentLevelSpiraArtifact(Class<? extends SpiraArtifact> spiraArtifactClass, IndentLevelSpiraArtifact indentLevelSpiraArtifact) {
        Map<String, IndentLevelSpiraArtifact> indentLevelSpiraArtifactsMap = BaseSpiraArtifact._getIndentLevelSpiraArtifactsMap(spiraArtifactClass);
        indentLevelSpiraArtifactsMap.put(indentLevelSpiraArtifact.getIndentLevel(), indentLevelSpiraArtifact);
    }

    private static void _removeIDSpiraArtifact(Class<? extends SpiraArtifact> spiraArtifactClass, SpiraArtifact spiraArtifact) {
        Map<Integer, SpiraArtifact> idSpiraArtifactsMap = BaseSpiraArtifact._getIDSpiraArtifactsMap(spiraArtifactClass);
        idSpiraArtifactsMap.remove(spiraArtifact.getID());
    }

    private static void _removeIndentLevelSpiraArtifact(Class<? extends SpiraArtifact> spiraArtifactClass, IndentLevelSpiraArtifact indentLevelSpiraArtifact) {
        Map<String, IndentLevelSpiraArtifact> indentLevelSpiraArtifactsMap = BaseSpiraArtifact._getIndentLevelSpiraArtifactsMap(spiraArtifactClass);
        indentLevelSpiraArtifactsMap.remove(indentLevelSpiraArtifact.getIndentLevel());
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.jsonObject = new JSONObject(objectInputStream.readUTF());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeUTF(this.jsonObject.toString());
    }
}

