/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UpstreamFailureUtil {
    private static final String _URL_BASE_UPSTREAM_FAILURES_JOB = "https://test-1-0.liferay.com/userContent/testResults/";
    private static final JSONObject _defaultUpstreamFailuresJSONObject = new JSONObject("{\"SHA\":\"\",\"failedBatches\":[]}");
    private static boolean _upstreamComparisonAvailable = true;
    private static JSONObject _upstreamFailuresJobJSONObject;

    public static List<String> getUpstreamJobFailures(String type, TopLevelBuild topLevelBuild) {
        ArrayList<String> upstreamFailures = new ArrayList<String>();
        JSONObject upstreamJobFailuresJSONObject = UpstreamFailureUtil.getUpstreamJobFailuresJSONObject(topLevelBuild);
        JSONArray failedBatchesJSONArray = upstreamJobFailuresJSONObject.optJSONArray("failedBatches");
        if (failedBatchesJSONArray == null) {
            return upstreamFailures;
        }
        for (int i = 0; i < failedBatchesJSONArray.length(); ++i) {
            JSONObject failedBatchJSONObject = failedBatchesJSONArray.getJSONObject(i);
            String jobVariant = failedBatchJSONObject.getString("jobVariant");
            jobVariant = UpstreamFailureUtil._formatJobVariant(jobVariant);
            if (type.equals("build")) {
                upstreamFailures.add(UpstreamFailureUtil._formatUpstreamBuildFailure(jobVariant, failedBatchJSONObject.getString("result")));
                continue;
            }
            if (!type.equals("test")) continue;
            JSONArray failedTestsJSONArray = failedBatchJSONObject.getJSONArray("failedTests");
            for (int j = 0; j < failedTestsJSONArray.length(); ++j) {
                Object object = failedTestsJSONArray.get(j);
                upstreamFailures.add(UpstreamFailureUtil._formatUpstreamTestFailure(jobVariant, object.toString()));
            }
        }
        return upstreamFailures;
    }

    public static JSONObject getUpstreamJobFailuresJSONObject(TopLevelBuild topLevelBuild) {
        if (_upstreamFailuresJobJSONObject == null) {
            UpstreamFailureUtil.initUpstreamJobFailuresJSONObject(topLevelBuild);
        }
        return _upstreamFailuresJobJSONObject;
    }

    public static String getUpstreamJobFailuresSHA(TopLevelBuild topLevelBuild) {
        try {
            JSONObject upstreamJobFailuresJSONObject = UpstreamFailureUtil.getUpstreamJobFailuresJSONObject(topLevelBuild);
            return upstreamJobFailuresJSONObject.getString("SHA");
        }
        catch (JSONException jsonException) {
            System.out.println("Unable to get upstream acceptance failure data");
            jsonException.printStackTrace();
            return "";
        }
    }

    public static void initUpstreamJobFailuresJSONObject(TopLevelBuild topLevelBuild) {
        _upstreamFailuresJobJSONObject = _defaultUpstreamFailuresJSONObject;
        if (!topLevelBuild.isCompareToUpstream()) {
            return;
        }
        try {
            File upstreamJobFailuresJSONFile = new File(System.getenv("WORKSPACE"), "test.results.json");
            if (upstreamJobFailuresJSONFile.exists()) {
                String fileContent = JenkinsResultsParserUtil.read(upstreamJobFailuresJSONFile);
                _upstreamFailuresJobJSONObject = new JSONObject(fileContent);
            } else {
                _upstreamFailuresJobJSONObject = UpstreamFailureUtil._getUpstreamJobFailuresJSONObject(topLevelBuild);
                JenkinsResultsParserUtil.write(upstreamJobFailuresJSONFile, _upstreamFailuresJobJSONObject.toString());
            }
            System.out.println(JenkinsResultsParserUtil.combine("Comparing with test results from ", topLevelBuild.getAcceptanceUpstreamJobURL(), "/", String.valueOf(_upstreamFailuresJobJSONObject.getInt("buildNumber")), " at SHA ", _upstreamFailuresJobJSONObject.getString("SHA")));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.out.println("Unable to load upstream acceptance failure data");
            _upstreamComparisonAvailable = false;
        }
    }

    public static boolean isBuildFailingInUpstreamJob(Build build) {
        if (!UpstreamFailureUtil.isUpstreamComparisonAvailable() || !build.isCompareToUpstream()) {
            return false;
        }
        try {
            ArrayList<TestResult> testResults = new ArrayList<TestResult>();
            testResults.addAll(build.getTestResults("FAILED"));
            testResults.addAll(build.getTestResults("REGRESSION"));
            if (testResults.isEmpty()) {
                return UpstreamFailureUtil._isBuildFailingInUpstreamJob(build);
            }
            for (TestResult testResult : testResults) {
                if (!testResult.isUniqueFailure()) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            System.out.println("Unable to get upstream acceptance failure data.");
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean isTestFailingInUpstreamJob(TestResult testResult) {
        Build build = testResult.getBuild();
        if (!UpstreamFailureUtil.isUpstreamComparisonAvailable() || !build.isCompareToUpstream()) {
            return false;
        }
        TopLevelBuild topLevelBuild = build.getTopLevelBuild();
        try {
            String jobVariant = build.getJobVariant();
            jobVariant = UpstreamFailureUtil._formatJobVariant(jobVariant);
            for (String failure : UpstreamFailureUtil.getUpstreamJobFailures("test", topLevelBuild)) {
                if (!failure.equals(UpstreamFailureUtil._formatUpstreamTestFailure(jobVariant, testResult.getDisplayName()))) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            System.out.println("Unable to get upstream acceptance failure data.");
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean isUpstreamComparisonAvailable() {
        return _upstreamComparisonAvailable;
    }

    private static String _formatJobVariant(String jobVariant) {
        jobVariant = jobVariant.replaceAll("(.*)/.*", "$1");
        return jobVariant.replaceAll("_stable$", "");
    }

    private static String _formatUpstreamBuildFailure(String jobVariant, String testResult) {
        return JenkinsResultsParserUtil.combine(jobVariant, ",", testResult);
    }

    private static String _formatUpstreamTestFailure(String jobVariant, String testName) {
        return JenkinsResultsParserUtil.combine(testName, ",", jobVariant);
    }

    private static int _getLastCompletedUpstreamBuildNumber(TopLevelBuild topLevelBuild) {
        try {
            JSONObject lastCompletedBuildJSONObject = JenkinsResultsParserUtil.toJSONObject(topLevelBuild.getAcceptanceUpstreamJobURL() + "/lastCompletedBuild/api/json?tree=number", false);
            return lastCompletedBuildJSONObject.getInt("number");
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private static JSONObject _getUpstreamJobFailuresJSONObject(String jobName, String buildNumber) throws IOException {
        return JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(JenkinsResultsParserUtil.combine(_URL_BASE_UPSTREAM_FAILURES_JOB, jobName, "/builds/", buildNumber, "/test.results.json")), false, 5000);
    }

    private static JSONObject _getUpstreamJobFailuresJSONObject(TopLevelBuild topLevelBuild) throws IllegalStateException, IOException {
        int buildNumber;
        int oldestBuildNumber = Math.max(0, buildNumber - 20);
        String acceptanceUpstreamJobName = topLevelBuild.getAcceptanceUpstreamJobName();
        for (buildNumber = UpstreamFailureUtil._getLastCompletedUpstreamBuildNumber(topLevelBuild); buildNumber > oldestBuildNumber; --buildNumber) {
            JSONObject jsonObject = UpstreamFailureUtil._getUpstreamJobFailuresJSONObject(acceptanceUpstreamJobName, String.valueOf(buildNumber));
            String sha = jsonObject.getString("SHA");
            GitWorkingDirectory gitWorkingDirectory = GitWorkingDirectoryFactory.newGitWorkingDirectory(topLevelBuild.getBranchName(), (File)null, topLevelBuild.getBaseGitRepositoryName());
            if (!gitWorkingDirectory.refContainsSHA("HEAD", sha)) continue;
            return jsonObject;
        }
        throw new IllegalStateException("Unable to find comparable upstream test results");
    }

    private static boolean _isBuildFailingInUpstreamJob(Build build) {
        String jobVariant = build.getJobVariant();
        if (jobVariant == null) {
            return false;
        }
        String result = build.getResult();
        if (result == null) {
            return false;
        }
        jobVariant = UpstreamFailureUtil._formatJobVariant(jobVariant);
        TopLevelBuild topLevelBuild = build.getTopLevelBuild();
        for (String upstreamJobFailure : UpstreamFailureUtil.getUpstreamJobFailures("build", topLevelBuild)) {
            if (!upstreamJobFailure.equals(UpstreamFailureUtil._formatUpstreamBuildFailure(jobVariant, result))) continue;
            return true;
        }
        return false;
    }
}

