/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.AxisBuild;
import com.liferay.jenkins.results.parser.BaseBuild;
import com.liferay.jenkins.results.parser.BatchBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.BuildFactory;
import com.liferay.jenkins.results.parser.DatagramRequestUtil;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.SlaveOfflineRule;
import com.liferay.jenkins.results.parser.StatsDMetricsUtil;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.UpstreamFailureUtil;
import com.liferay.jenkins.results.parser.ValidationBuild;
import com.liferay.jenkins.results.parser.failure.message.generator.CIFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.CITestSuiteValidationFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.CompileFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.DownstreamFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.FailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.GenericFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.GitLPushFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.GradleTaskFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.InvalidGitCommitSHAFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.InvalidSenderSHAFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.JenkinsRegenFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.JenkinsSourceFormatFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.PoshiTestFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.PoshiValidationFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.RebaseFailureMessageGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.json.JSONObject;

public abstract class TopLevelBuild
extends BaseBuild {
    protected static final Pattern gitRepositoryTempMapNamePattern = Pattern.compile("git\\.(?<gitRepositoryType>.*)\\.properties");
    private static final FailureMessageGenerator[] _FAILURE_MESSAGE_GENERATORS = new FailureMessageGenerator[]{new CITestSuiteValidationFailureMessageGenerator(), new CompileFailureMessageGenerator(), new GitLPushFailureMessageGenerator(), new JenkinsRegenFailureMessageGenerator(), new JenkinsSourceFormatFailureMessageGenerator(), new InvalidGitCommitSHAFailureMessageGenerator(), new InvalidSenderSHAFailureMessageGenerator(), new RebaseFailureMessageGenerator(), new PoshiValidationFailureMessageGenerator(), new PoshiTestFailureMessageGenerator(), new GradleTaskFailureMessageGenerator(), new DownstreamFailureMessageGenerator(), new CIFailureMessageGenerator(), new GenericFailureMessageGenerator()};
    private static final long _MILLIS_DOWNSTREAM_BUILDS_LISTING_INTERVAL = 300000L;
    private static final String _URL_CHART_JS = "https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.5.0/Chart.min.js";
    private static ExecutorService _executorService = JenkinsResultsParserUtil.getNewThreadPoolExecutor(10, true);
    private boolean _compareToUpstream;
    private Build _controllerBuild;
    private long _lastDownstreamBuildsListingTimestamp = -1L;
    private String _metricsHostName;
    private int _metricsHostPort;
    private final boolean _sendBuildMetrics;
    private long _updateDuration;

    @Override
    public void addDownstreamBuilds(String ... urls) {
        super.addDownstreamBuilds(urls);
        if (this.getDownstreamBuildCount("completed") < this.getDownstreamBuildCount(null)) {
            this.setResult(null);
        }
    }

    @Override
    public void addTimelineData(BaseBuild.TimelineData timelineData) {
        timelineData.addTimelineData(this);
        if (this.getTopLevelBuild() == this) {
            this.addDownstreamBuildsTimelineData(timelineData);
        }
    }

    @Override
    public void archive(String archiveName) {
        super.archive(archiveName);
        if (this.getParentBuild() == null) {
            Properties archiveProperties = new Properties();
            archiveProperties.setProperty("top.level.build.url", this.replaceBuildURL(this.getBuildURL()));
            try {
                StringWriter sw = new StringWriter();
                archiveProperties.store(sw, null);
                this.writeArchiveFile(sw.toString(), archiveName + "/archive.properties");
            }
            catch (IOException ioException) {
                throw new RuntimeException("Unable to write archive properties");
            }
        }
        try {
            this.writeArchiveFile(this.getJenkinsReport(), this.getArchivePath() + "/jenkins-report.html");
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to archive Jenkins report", ioException);
        }
    }

    public String getAcceptanceUpstreamJobName() {
        String jobName = this.getJobName();
        if (jobName.contains("pullrequest")) {
            String branchName = this.getBranchName();
            if (branchName.startsWith("ee-")) {
                return jobName.replace("pullrequest", "upstream");
            }
            return jobName.replace("pullrequest", "upstream-dxp");
        }
        return "";
    }

    public String getAcceptanceUpstreamJobURL() {
        String jobName = this.getJobName();
        if (jobName.contains("pullrequest")) {
            String acceptanceUpstreamJobURL = JenkinsResultsParserUtil.combine("https://test-1-1.liferay.com/job/", this.getAcceptanceUpstreamJobName());
            try {
                JenkinsResultsParserUtil.toString(JenkinsResultsParserUtil.getLocalURL(acceptanceUpstreamJobURL), false, 0, 0, 0);
            }
            catch (IOException ioException) {
                return null;
            }
            return acceptanceUpstreamJobURL;
        }
        return null;
    }

    @Override
    public URL getArtifactsBaseURL() {
        StringBuilder sb = new StringBuilder();
        try {
            URL buildBaseArtifactURL = new URL(JenkinsResultsParserUtil.getBuildProperty("build.base.artifact.url"));
            sb.append(buildBaseArtifactURL);
        }
        catch (IOException ioException) {
            return null;
        }
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        JenkinsMaster jenkinsMaster = topLevelBuild.getJenkinsMaster();
        sb.append("/");
        sb.append(jenkinsMaster.getName());
        sb.append("/");
        sb.append(topLevelBuild.getStartTime());
        sb.append("/");
        sb.append(topLevelBuild.getJobName());
        sb.append("/");
        sb.append(topLevelBuild.getBuildNumber());
        try {
            return new URL(sb.toString());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public Map<String, String> getBaseGitRepositoryDetailsTempMap() {
        String gitRepositoryType = this.getBaseGitRepositoryType();
        String tempMapName = "git." + gitRepositoryType + ".properties";
        return this.getTempMap(tempMapName);
    }

    public String getCompanionBranchName() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        Map<String, String> gitRepositoryGitDetailsTempMap = topLevelBuild.getCompanionGitRepositoryDetailsTempMap();
        return gitRepositoryGitDetailsTempMap.get("github.sender.branch.name");
    }

    public Map<String, String> getCompanionGitRepositoryDetailsTempMap() {
        String branchName = this.getBranchName();
        String branchType = "ee";
        String gitRepositoryType = this.getBaseGitRepositoryType();
        if (branchName.endsWith("-private")) {
            branchType = "base";
        }
        String tempMapName = JenkinsResultsParserUtil.combine("git.", gitRepositoryType, ".", branchType, ".properties");
        return this.getTempMap(tempMapName);
    }

    public String getCompanionGitRepositorySHA() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        Map<String, String> gitRepositoryGitDetailsTempMap = topLevelBuild.getCompanionGitRepositoryDetailsTempMap();
        return gitRepositoryGitDetailsTempMap.get("github.sender.branch.sha");
    }

    public String getCompanionUsername() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        Map<String, String> gitRepositoryGitDetailsTempMap = topLevelBuild.getCompanionGitRepositoryDetailsTempMap();
        return gitRepositoryGitDetailsTempMap.get("github.sender.username");
    }

    public Build getControllerBuild() {
        if (this._controllerBuild != null) {
            return this._controllerBuild;
        }
        String controllerBuildURL = this.getParameterValue("CONTROLLER_BUILD_URL");
        if (controllerBuildURL == null || !controllerBuildURL.matches("https?://.*")) {
            return null;
        }
        this._controllerBuild = BuildFactory.newBuild(controllerBuildURL, null);
        return this._controllerBuild;
    }

    @Override
    public String getDisplayName() {
        String displayName = super.getDisplayName();
        if (this.getParentBuild() != null) {
            displayName = displayName + "/" + this.getParameterValue("JENKINS_JOB_VARIANT");
        }
        return displayName;
    }

    public List<AxisBuild> getDownstreamAxisBuilds() {
        ArrayList<AxisBuild> downstreamAxisBuilds = new ArrayList<AxisBuild>();
        for (BatchBuild downstreamBatchBuild : this.getDownstreamBatchBuilds()) {
            downstreamAxisBuilds.addAll(downstreamBatchBuild.getDownstreamAxisBuilds());
        }
        Collections.sort(downstreamAxisBuilds, new BaseBuild.BuildDisplayNameComparator());
        return downstreamAxisBuilds;
    }

    public List<BatchBuild> getDownstreamBatchBuilds() {
        ArrayList<BatchBuild> downstreamBatchBuilds = new ArrayList<BatchBuild>();
        List<Build> downstreamBuilds = this.getDownstreamBuilds(null);
        for (Build downstreamBuild : downstreamBuilds) {
            if (!(downstreamBuild instanceof BatchBuild)) continue;
            downstreamBatchBuilds.add((BatchBuild)downstreamBuild);
        }
        Collections.sort(downstreamBatchBuilds, new BaseBuild.BuildDisplayNameComparator());
        return downstreamBatchBuilds;
    }

    @Override
    public Element getGitHubMessageElement() {
        Collections.sort(this.downstreamBuilds, new BaseBuild.BuildDisplayNameComparator());
        if (this.getParentBuild() == null) {
            return this.getTopGitHubMessageElement();
        }
        return super.getGitHubMessageElement();
    }

    public String getJenkinsReport() {
        try {
            return JenkinsResultsParserUtil.toString(JenkinsResultsParserUtil.getLocalURL(this.getJenkinsReportURL()));
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get Jenkins report", ioException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getJenkinsReportElement() {
        long start = System.currentTimeMillis();
        try {
            Element element = Dom4JUtil.getNewElement("html", null, this.getJenkinsReportHeadElement(), this.getJenkinsReportBodyElement());
            return element;
        }
        finally {
            String duration = JenkinsResultsParserUtil.toDurationString(System.currentTimeMillis() - start);
            System.out.println("Jenkins reported generated in " + duration);
        }
    }

    public String getJenkinsReportURL() {
        if (this.fromArchive) {
            return this.getBuildURL() + "/jenkins-report.html";
        }
        JenkinsMaster jenkinsMaster = this.getJenkinsMaster();
        return JenkinsResultsParserUtil.combine("https://", jenkinsMaster.getName(), ".liferay.com/", "userContent/jobs/", this.getJobName(), "/builds/", String.valueOf(this.getBuildNumber()), "/jenkins-report.html");
    }

    @Override
    public Map<String, String> getMetricLabels() {
        TreeMap<String, String> metricLabels = new TreeMap<String, String>();
        metricLabels.put("job_type", "top-level");
        metricLabels.put("top_level_job_name", this.getJobName());
        return metricLabels;
    }

    @Override
    public String getStatusReport(int indentSize) {
        String statusReport = super.getStatusReport(indentSize);
        if (this.getDownstreamBuildCount(null) > 0) {
            while (statusReport.endsWith("\n")) {
                statusReport = statusReport.substring(0, statusReport.length() - 1);
            }
            statusReport = statusReport + " / ";
        }
        return statusReport + "Update took " + this._updateDuration + " milliseconds.\n";
    }

    @Override
    public String getStatusSummary() {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - 300000L >= this._lastDownstreamBuildsListingTimestamp) {
            StringBuilder sb = new StringBuilder(super.getStatusSummary());
            sb.append("\nRunning Builds: ");
            this._lastDownstreamBuildsListingTimestamp = System.currentTimeMillis();
            for (Build downstreamBuild : this.getDownstreamBuilds("running")) {
                sb.append("\n");
                sb.append(downstreamBuild.getBuildURL());
            }
            return sb.toString();
        }
        return super.getStatusSummary();
    }

    @Override
    public JSONObject getTestReportJSONObject(boolean cache) {
        return null;
    }

    @Override
    public String getTestSuiteName() {
        String testSuiteName = this.getParameterValue("CI_TEST_SUITE");
        if (testSuiteName == null) {
            testSuiteName = "default";
        }
        return testSuiteName;
    }

    public BaseBuild.TimelineData getTimelineData() {
        return new BaseBuild.TimelineData(500, this);
    }

    public Element getValidationGitHubMessageElement() {
        ValidationBuild validationBuild = null;
        for (Build downstreamBuild : this.downstreamBuilds) {
            if (!(downstreamBuild instanceof ValidationBuild)) continue;
            validationBuild = (ValidationBuild)downstreamBuild;
        }
        if (validationBuild == null) {
            throw new RuntimeException("Unable to find a validation build");
        }
        return validationBuild.getGitHubMessageElement();
    }

    @Override
    public boolean isCompareToUpstream() {
        return this._compareToUpstream;
    }

    @Override
    public boolean isUniqueFailure() {
        return true;
    }

    @Override
    public void setCompareToUpstream(boolean compareToUpstream) {
        this._compareToUpstream = compareToUpstream;
    }

    @Override
    public void takeSlaveOffline(SlaveOfflineRule slaveOfflineRule) {
    }

    @Override
    public synchronized void update() {
        long start = System.currentTimeMillis();
        super.update();
        this._updateDuration = System.currentTimeMillis() - start;
        if (this._sendBuildMetrics && !this.fromArchive && this.getParentBuild() == null) {
            if (!this.fromCompletedBuild) {
                this.sendBuildMetricsOnModifiedBuilds();
            } else {
                this.sendBuildMetrics(StatsDMetricsUtil.generateGaugeDeltaMetric("build_slave_usage_gauge", -1, this.getMetricLabels()));
            }
        }
    }

    protected TopLevelBuild(String url) {
        this(url, null);
    }

    protected TopLevelBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build.properties", ioException);
        }
        this._sendBuildMetrics = Boolean.valueOf(buildProperties.getProperty("build.metrics.send"));
        if (this._sendBuildMetrics) {
            this._metricsHostName = buildProperties.getProperty("build.metrics.host.name");
            String metricsHostPortString = buildProperties.getProperty("build.metrics.host.port");
            if (this._metricsHostName == null || metricsHostPortString == null) {
                throw new IllegalArgumentException("Properties \"build.metrics.host.name\" and \"build.metrics.host.port\" must be set to send build metrics");
            }
            try {
                this._metricsHostPort = Integer.parseInt(metricsHostPortString);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Please set \"build.metrics.host.port\" to an integer");
            }
            if (topLevelBuild == null) {
                this.sendBuildMetrics(StatsDMetricsUtil.generateGaugeDeltaMetric("build_slave_usage_gauge", 1, this.getMetricLabels()));
            }
        }
    }

    @Override
    protected void archiveJSON() {
        super.archiveJSON();
        try {
            Properties buildProperties = JenkinsResultsParserUtil.getBuildProperties();
            String gitRepositoryTypes = buildProperties.getProperty("repository.types");
            if (this.jobName.startsWith("test-subrepository-acceptance-pullrequest")) {
                gitRepositoryTypes = gitRepositoryTypes + "," + this.getBaseGitRepositoryName();
            }
            for (String gitRepositoryType : gitRepositoryTypes.split(",")) {
                try {
                    JSONObject gitRepositoryDetailsJSONObject = JenkinsResultsParserUtil.toJSONObject(this.getGitRepositoryDetailsPropertiesTempMapURL(gitRepositoryType));
                    Set set = gitRepositoryDetailsJSONObject.keySet();
                    if (set.isEmpty()) continue;
                    this.writeArchiveFile(gitRepositoryDetailsJSONObject.toString(4), this.getArchivePath() + "/git." + gitRepositoryType + ".properties.json");
                }
                catch (IOException ioException) {
                    throw new RuntimeException("Unable to create git." + gitRepositoryType + ".properties.json", ioException);
                }
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build properties", ioException);
        }
    }

    @Override
    protected void findDownstreamBuilds() {
        if (this.getParentBuild() != null) {
            return;
        }
        super.findDownstreamBuilds();
        String consoleText = this.getConsoleText();
        for (Build downstreamBuild : this.downstreamBuilds) {
            BaseBuild downstreamBaseBuild = (BaseBuild)downstreamBuild;
            downstreamBaseBuild.checkForReinvocation(consoleText);
        }
    }

    @Override
    protected List<String> findDownstreamBuildsInConsoleText() {
        if (this.getParentBuild() != null) {
            return Collections.emptyList();
        }
        String consoleText = this.getConsoleText();
        ArrayList<String> foundDownstreamBuildURLs = new ArrayList<String>();
        if (consoleText == null || consoleText.isEmpty()) {
            return foundDownstreamBuildURLs;
        }
        HashSet<String> downstreamBuildURLs = new HashSet<String>();
        for (Build downstreamBuild : this.getDownstreamBuilds(null)) {
            String downstreamBuildURL = downstreamBuild.getBuildURL();
            if (downstreamBuildURL == null) continue;
            downstreamBuildURLs.add(downstreamBuildURL);
        }
        if (this.getBuildURL() != null) {
            int i = consoleText.lastIndexOf("\nstop-current-job:");
            if (i != -1) {
                consoleText = consoleText.substring(0, i);
            }
            Matcher downstreamBuildURLMatcher = downstreamBuildURLPattern.matcher(consoleText.substring(this.consoleReadCursor));
            this.consoleReadCursor = consoleText.length();
            while (downstreamBuildURLMatcher.find()) {
                String url = downstreamBuildURLMatcher.group("url");
                Pattern reinvocationPattern = Pattern.compile(Pattern.quote(url) + " restarted at (?<url>[^\\s]*)\\.");
                Matcher reinvocationMatcher = reinvocationPattern.matcher(consoleText);
                while (reinvocationMatcher.find()) {
                    url = reinvocationMatcher.group("url");
                }
                if (foundDownstreamBuildURLs.contains(url) || downstreamBuildURLs.contains(url)) continue;
                foundDownstreamBuildURLs.add(url);
            }
        }
        return foundDownstreamBuildURLs;
    }

    protected Element getBaseBranchDetailsElement() {
        String baseBranchURL = JenkinsResultsParserUtil.combine("https://github.com/liferay/", this.getBaseGitRepositoryName(), "/tree/", this.getBranchName());
        String baseGitRepositoryName = this.getBaseGitRepositoryName();
        String baseGitRepositorySHA = null;
        baseGitRepositorySHA = !baseGitRepositoryName.equals("liferay-jenkins-ee") && baseGitRepositoryName.endsWith("-ee") ? this.getBaseGitRepositorySHA(baseGitRepositoryName.substring(0, baseGitRepositoryName.length() - 3)) : this.getBaseGitRepositorySHA(baseGitRepositoryName);
        Element baseGitBranchDetailsElement = Dom4JUtil.getNewElement("p", null, "Branch Name: ", Dom4JUtil.getNewAnchorElement(baseBranchURL, this.getBranchName()));
        if (baseGitRepositorySHA != null) {
            String baseGitRepositoryCommitURL = "https://github.com/liferay/" + baseGitRepositoryName + "/commit/" + baseGitRepositorySHA;
            Dom4JUtil.addToElement(baseGitBranchDetailsElement, Dom4JUtil.getNewElement("br"), "Branch GIT ID: ", Dom4JUtil.getNewAnchorElement(baseGitRepositoryCommitURL, baseGitRepositorySHA));
        }
        return baseGitBranchDetailsElement;
    }

    protected Element[] getBuildFailureElements() {
        Map<Build, Element> downstreamBuildFailureMessages = this.getDownstreamBuildMessages(this.getFailedDownstreamBuilds());
        ArrayList<Element> allCurrentBuildFailureElements = new ArrayList<Element>();
        ArrayList<Element> upstreamBuildFailureElements = new ArrayList<Element>();
        int maxFailureCount = 5;
        for (Map.Entry<Build, Element> entry : downstreamBuildFailureMessages.entrySet()) {
            Element upstreamJobFailureElement;
            Build failedDownstreamBuild = entry.getKey();
            Element failureElement = entry.getValue();
            if (failureElement != null) {
                if (!failedDownstreamBuild.isUniqueFailure()) {
                    upstreamBuildFailureElements.add(failureElement);
                    continue;
                }
                if (TopLevelBuild.isHighPriorityBuildFailureElement(failureElement)) {
                    allCurrentBuildFailureElements.add(0, failureElement);
                    continue;
                }
                allCurrentBuildFailureElements.add(failureElement);
            }
            if ((upstreamJobFailureElement = failedDownstreamBuild.getGitHubMessageUpstreamJobFailureElement()) == null) continue;
            upstreamBuildFailureElements.add(upstreamJobFailureElement);
        }
        ArrayList<Element> buildFailureElements = new ArrayList<Element>();
        buildFailureElements.add(Dom4JUtil.getNewElement("hr"));
        if (allCurrentBuildFailureElements.isEmpty() && upstreamBuildFailureElements.isEmpty()) {
            allCurrentBuildFailureElements.add(0, super.getGitHubMessageElement());
        }
        if (allCurrentBuildFailureElements.isEmpty() && !upstreamBuildFailureElements.isEmpty()) {
            buildFailureElements.add(Dom4JUtil.getNewElement("h4", null, "This pull contains no unique failures."));
        } else {
            String failureTitle = "Failures unique to this pull:";
            if (!UpstreamFailureUtil.isUpstreamComparisonAvailable() && this.isCompareToUpstream()) {
                failureTitle = "Failures (upstream comparison is not available):";
            }
            buildFailureElements.add(Dom4JUtil.getNewElement("h4", null, failureTitle));
            buildFailureElements.add(Dom4JUtil.getOrderedListElement(allCurrentBuildFailureElements, maxFailureCount));
        }
        String acceptanceUpstreamJobURL = this.getAcceptanceUpstreamJobURL();
        if (allCurrentBuildFailureElements.size() < maxFailureCount && !upstreamBuildFailureElements.isEmpty()) {
            Element acceptanceUpstreamJobLinkElement = Dom4JUtil.getNewAnchorElement(acceptanceUpstreamJobURL, "acceptance upstream results");
            Element upstreamJobFailureElement = Dom4JUtil.getNewElement("details", null, Dom4JUtil.getNewElement("summary", null, Dom4JUtil.getNewElement("strong", null, "Failures in common with ", acceptanceUpstreamJobLinkElement, " at ", UpstreamFailureUtil.getUpstreamJobFailuresSHA(this), ":")));
            int remainingFailureCount = maxFailureCount - allCurrentBuildFailureElements.size();
            Dom4JUtil.getOrderedListElement(upstreamBuildFailureElements, upstreamJobFailureElement, remainingFailureCount);
            buildFailureElements.add(Dom4JUtil.getNewElement("hr"));
            buildFailureElements.add(upstreamJobFailureElement);
        }
        if (this.jobName.contains("pullrequest") && upstreamBuildFailureElements.isEmpty() && acceptanceUpstreamJobURL != null) {
            Element upstreamResultElement = Dom4JUtil.getNewElement("h4");
            Dom4JUtil.addToElement(upstreamResultElement, "For upstream results, click ", Dom4JUtil.getNewAnchorElement(acceptanceUpstreamJobURL, "here"), ".");
            buildFailureElements.add(upstreamResultElement);
            Map<String, String> startPropertiesTempMap = this.getStartPropertiesTempMap();
            String subrepositoryMergePullMentionUsers = startPropertiesTempMap.get("SUBREPOSITORY_MERGE_PULL_MENTION_USERS");
            if (subrepositoryMergePullMentionUsers != null) {
                StringBuilder sb = new StringBuilder();
                sb.append("cc");
                for (String subrepositoryMergePullMentionUser : subrepositoryMergePullMentionUsers.split(",")) {
                    sb.append(" @");
                    sb.append(subrepositoryMergePullMentionUser);
                }
                buildFailureElements.add(Dom4JUtil.getNewElement("div", null, sb.toString()));
            }
        }
        return buildFailureElements.toArray(new Element[0]);
    }

    protected Element getCompanionBranchDetailsElement() {
        String baseGitRepositoryName = this.getBaseGitRepositoryName();
        String branchName = this.getBranchName();
        String companionGitRepositoryName = baseGitRepositoryName;
        if (branchName.equals("master")) {
            companionGitRepositoryName = companionGitRepositoryName + "-ee";
        }
        if (branchName.endsWith("-private")) {
            companionGitRepositoryName = baseGitRepositoryName.substring(0, baseGitRepositoryName.indexOf("-ee"));
        }
        String companionUsername = this.getCompanionUsername();
        String companionBranchURL = JenkinsResultsParserUtil.combine("https://github.com/", companionUsername, "/", companionGitRepositoryName, "/tree/", this.getCompanionBranchName());
        String companionGitRepositorySHA = this.getCompanionGitRepositorySHA();
        String companionGitRepositoryCommitURL = JenkinsResultsParserUtil.combine("https://github.com/", companionUsername, "/", companionGitRepositoryName, "/commit/", companionGitRepositorySHA);
        Element companionBranchDetailsElement = Dom4JUtil.getNewElement("p", null, "Branch Name: ", Dom4JUtil.getNewAnchorElement(companionBranchURL, this.getCompanionBranchName()));
        if (companionGitRepositorySHA != null) {
            Dom4JUtil.addToElement(companionBranchDetailsElement, Dom4JUtil.getNewElement("br"), "Branch GIT ID: ", Dom4JUtil.getNewAnchorElement(companionGitRepositoryCommitURL, companionGitRepositorySHA));
        }
        return companionBranchDetailsElement;
    }

    protected Element getDownstreamGitHubMessageElement() {
        Element failureMessageElement;
        String status = this.getStatus();
        if (!status.equals("completed") && this.getParentBuild() != null) {
            return null;
        }
        String result = this.getResult();
        if (result.equals("SUCCESS")) {
            return null;
        }
        Element messageElement = Dom4JUtil.getNewElement("div", null, Dom4JUtil.getNewAnchorElement(this.getBuildURL(), null, this.getDisplayName()));
        if (result.equals("ABORTED")) {
            messageElement.add(Dom4JUtil.toCodeSnippetElement("Build was aborted"));
        }
        if (result.equals("FAILURE") && (failureMessageElement = this.getFailureMessageElement()) != null) {
            messageElement.add(failureMessageElement);
        }
        return messageElement;
    }

    @Override
    protected ExecutorService getExecutorService() {
        return _executorService;
    }

    protected Element getFailedJobSummaryElement() {
        Element jobSummaryListElement = this.getJobSummaryListElement(false, null);
        int failCount = this.getDownstreamBuildCount(null) - this.getDownstreamBuildCountByResult("SUCCESS") + 1;
        return Dom4JUtil.getNewElement("div", null, Dom4JUtil.getNewElement("h4", null, String.valueOf(failCount), " Failed Jobs:"), jobSummaryListElement);
    }

    @Override
    protected FailureMessageGenerator[] getFailureMessageGenerators() {
        return _FAILURE_MESSAGE_GENERATORS;
    }

    @Override
    protected Element getGitHubMessageJobResultsElement() {
        int successCount = this.getDownstreamBuildCountByResult("SUCCESS");
        int failCount = this.getDownstreamBuildCount(null) - successCount + 1;
        return Dom4JUtil.getNewElement("div", null, Dom4JUtil.getNewElement("h6", null, "Job Results:"), Dom4JUtil.getNewElement("p", null, String.valueOf(successCount), JenkinsResultsParserUtil.getNounForm(successCount, " Jobs", " Job"), " Passed.", Dom4JUtil.getNewElement("br"), String.valueOf(failCount), JenkinsResultsParserUtil.getNounForm(failCount, " Jobs", " Job"), " Failed."));
    }

    protected String getGitRepositoryDetailsPropertiesTempMapURL(String gitRepositoryType) {
        if (this.fromArchive) {
            return JenkinsResultsParserUtil.combine(this.getBuildURL(), "git.", gitRepositoryType, ".properties.json");
        }
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        JenkinsMaster topLevelBuildJenkinsMaster = topLevelBuild.getJenkinsMaster();
        return JenkinsResultsParserUtil.combine("http://cloud-10-0-0-31.lax.liferay.com/osb-jenkins-web/map/", topLevelBuildJenkinsMaster.getName(), "/", topLevelBuild.getJobName(), "/", String.valueOf(topLevelBuild.getBuildNumber()), "/", topLevelBuild.getJobName(), "/git.", gitRepositoryType, ".properties");
    }

    protected Element getJenkinsReportBodyElement() {
        String buildURL = this.getBuildURL();
        Element headingElement = Dom4JUtil.getNewElement("h1", null, "Jenkins report for ", Dom4JUtil.getNewAnchorElement(buildURL, buildURL));
        Element subheadingElement = null;
        JSONObject jobJSONObject = this.getBuildJSONObject();
        String description = jobJSONObject.optString("description");
        if (!description.isEmpty()) {
            subheadingElement = Dom4JUtil.getNewElement("h2");
            try {
                Dom4JUtil.addRawXMLToElement(subheadingElement, description);
            }
            catch (DocumentException documentException) {
                throw new RuntimeException("Unable to parse description HTML " + description, documentException);
            }
        }
        return Dom4JUtil.getNewElement("body", null, headingElement, subheadingElement, this.getJenkinsReportSummaryElement(), this.getJenkinsReportTimelineElement(), this.getJenkinsReportTopLevelTableElement(), this.getJenkinsReportDownstreamElement());
    }

    @Override
    protected String getJenkinsReportBuildInfoCellElementTagName() {
        return "th";
    }

    protected Element getJenkinsReportChartJsScriptElement(String xData, String y1Data, String y2Data) {
        String resourceFileContent = null;
        try {
            resourceFileContent = JenkinsResultsParserUtil.getResourceFileContent("dependencies/chart_template.js");
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to load resource chart_template.js", ioException);
        }
        resourceFileContent = resourceFileContent.replace("'xData'", xData);
        resourceFileContent = resourceFileContent.replace("'y1Data'", y1Data);
        resourceFileContent = resourceFileContent.replace("'y2Data'", y2Data);
        Element scriptElement = Dom4JUtil.getNewElement("script");
        scriptElement.addText(resourceFileContent);
        return scriptElement;
    }

    protected Element getJenkinsReportDownstreamElement() {
        return Dom4JUtil.getNewElement("div", null, this.getJenkinsReportDownstreamTableElement(null, "queued", "Queued: "), this.getJenkinsReportDownstreamTableElement(null, "starting", "Starting: "), this.getJenkinsReportDownstreamTableElement(null, "running", "Running: "), this.getJenkinsReportDownstreamTableElement(null, "missing", "Missing: "), Dom4JUtil.getNewElement("h2", null, "Completed: "), this.getJenkinsReportDownstreamTableElement("ABORTED", "completed", "---- Aborted: "), this.getJenkinsReportDownstreamTableElement("FAILURE", "completed", "---- Failure: "), this.getJenkinsReportDownstreamTableElement("UNSTABLE", "completed", "---- Unstable: "), this.getJenkinsReportDownstreamTableElement("SUCCESS", "completed", "---- Success: "));
    }

    protected Element getJenkinsReportDownstreamTableElement(String result, String status, String captionText) {
        List<Element> tableRowElements = this.getJenkinsReportTableRowElements(result, status);
        if (tableRowElements.isEmpty()) {
            return null;
        }
        return Dom4JUtil.getNewElement("table", null, Dom4JUtil.getNewElement("caption", null, captionText, String.valueOf(this.getDownstreamBuildCount(result, status))), this.getJenkinsReportTableColumnHeadersElement(), tableRowElements.toArray(new Element[0]));
    }

    protected Element getJenkinsReportHeadElement() {
        Element headElement = Dom4JUtil.getNewElement("head");
        this.getResourceFileContentAsElement("style", headElement, "dependencies/jenkins_report.css");
        Element scriptElement = this.getResourceFileContentAsElement("script", headElement, "dependencies/jenkins_report.js");
        scriptElement.addAttribute("language", "javascript");
        return headElement;
    }

    protected Element getJenkinsReportSummaryElement() {
        Build longestRunningDownstreamBuild;
        Element summaryElement = Dom4JUtil.getNewElement("div", null, Dom4JUtil.getNewElement("p", null, "Start Time: ", this.toJenkinsReportDateString(new Date(this.getStartTime()), this.getJenkinsReportTimeZoneName())), Dom4JUtil.getNewElement("p", null, "Invocation Delay Time: ", JenkinsResultsParserUtil.toDurationString(this.getQueuingDuration())), Dom4JUtil.getNewElement("p", null, "Build Time: ", JenkinsResultsParserUtil.toDurationString(this.getDuration())), Dom4JUtil.getNewElement("p", null, "Total CPU Usage Time: ", JenkinsResultsParserUtil.toDurationString(this.getTotalDuration())), Dom4JUtil.getNewElement("p", null, "Total number of Jenkins slaves used: ", String.valueOf(this.getTotalSlavesUsedCount())), Dom4JUtil.getNewElement("p", null, "Average delay time for invoked build to start: ", JenkinsResultsParserUtil.toDurationString(this.getAverageDelayTime())));
        Build longestDelayedDownstreamBuild = this.getLongestDelayedDownstreamBuild();
        if (longestDelayedDownstreamBuild != null) {
            Dom4JUtil.getNewElement("p", summaryElement, "Longest delay time for invoked build to start: ", Dom4JUtil.getNewAnchorElement(longestDelayedDownstreamBuild.getBuildURL(), longestDelayedDownstreamBuild.getDisplayName()), " in: ", JenkinsResultsParserUtil.toDurationString(longestDelayedDownstreamBuild.getDelayTime()));
        }
        if ((longestRunningDownstreamBuild = this.getLongestRunningDownstreamBuild()) != null) {
            Dom4JUtil.getNewElement("p", summaryElement, "Longest Running Downstream Build: ", Dom4JUtil.getNewAnchorElement(longestRunningDownstreamBuild.getBuildURL(), longestRunningDownstreamBuild.getDisplayName()), " in: ", JenkinsResultsParserUtil.toDurationString(longestRunningDownstreamBuild.getDuration()));
        }
        try {
            TestResult longestRunningTest;
            Properties buildProperties = JenkinsResultsParserUtil.getBuildProperties();
            String longestRunningTestEnabled = buildProperties.getProperty("jenkins.report.longest.running.test.enabled", "false");
            if (longestRunningTestEnabled.equals("true") && (longestRunningTest = this.getLongestRunningTest()) != null) {
                Dom4JUtil.getNewElement("p", summaryElement, "Longest Running Test: ", Dom4JUtil.getNewAnchorElement(longestRunningTest.getTestReportURL(), longestRunningTest.getDisplayName()), " in: ", JenkinsResultsParserUtil.toDurationString(longestRunningTest.getDuration()));
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build properties", ioException);
        }
        return summaryElement;
    }

    protected Element getJenkinsReportTableColumnHeadersElement() {
        Element nameElement = Dom4JUtil.getNewElement("th", null, "Name");
        Element consoleElement = Dom4JUtil.getNewElement("th", null, "Console");
        Element testReportElement = Dom4JUtil.getNewElement("th", null, "Test Report");
        Element startTimeElement = Dom4JUtil.getNewElement("th", null, "Start Time");
        Element buildTimeElement = Dom4JUtil.getNewElement("th", null, "Build Time");
        Element statusElement = Dom4JUtil.getNewElement("th", null, "Status");
        Element resultElement = Dom4JUtil.getNewElement("th", null, "Result");
        Element tableColumnHeaderElement = Dom4JUtil.getNewElement("tr");
        Dom4JUtil.addToElement(tableColumnHeaderElement, nameElement, consoleElement, testReportElement, startTimeElement, buildTimeElement, statusElement, resultElement);
        return tableColumnHeaderElement;
    }

    protected Element getJenkinsReportTimelineElement() {
        Element canvasElement = Dom4JUtil.getNewElement("canvas");
        canvasElement.addAttribute("height", "300");
        canvasElement.addAttribute("id", "timeline");
        Element scriptElement = Dom4JUtil.getNewElement("script");
        scriptElement.addAttribute("src", _URL_CHART_JS);
        scriptElement.addText("");
        BaseBuild.TimelineData timelineData = this.getTimelineData();
        Element chartJSScriptElement = this.getJenkinsReportChartJsScriptElement(Arrays.toString(timelineData.getIndexData()), Arrays.toString(timelineData.getSlaveUsageData()), Arrays.toString(timelineData.getInvocationsData()));
        return Dom4JUtil.getNewElement("div", null, canvasElement, scriptElement, chartJSScriptElement);
    }

    protected Element getJenkinsReportTopLevelTableElement() {
        Element topLevelTableElement = Dom4JUtil.getNewElement("table");
        String result = this.getResult();
        if (result != null) {
            Dom4JUtil.getNewElement("caption", topLevelTableElement, "Top Level Build - ", Dom4JUtil.getNewElement("strong", null, this.getResult()));
        } else {
            Dom4JUtil.getNewElement("caption", topLevelTableElement, "Top Level Build - ", Dom4JUtil.getNewElement("strong", null, StringUtils.upperCase((String)this.getStatus())));
        }
        Dom4JUtil.addToElement(topLevelTableElement, this.getJenkinsReportTableColumnHeadersElement(), this.getJenkinsReportTableRowElement());
        List<Element> jenkinsReportStopWatchRecordElements = this.getJenkinsReportStopWatchRecordElements();
        Dom4JUtil.addToElement(topLevelTableElement, jenkinsReportStopWatchRecordElements.toArray());
        return topLevelTableElement;
    }

    protected Element getJobSummaryElement() {
        int successCount = this.getDownstreamBuildCountByResult("SUCCESS");
        String result = this.getResult();
        if (result != null && result.equals("SUCCESS")) {
            ++successCount;
        }
        Element detailsElement = Dom4JUtil.getNewElement("details", null, Dom4JUtil.getNewElement("summary", null, Dom4JUtil.getNewElement("strong", null, "ci:test:", this.getTestSuiteName(), " - ", String.valueOf(successCount), " out of ", String.valueOf(this.getDownstreamBuildCount(null) + 1), " jobs PASSED")));
        if (result != null && !result.equals("SUCCESS")) {
            Dom4JUtil.addToElement(detailsElement, this.getFailedJobSummaryElement());
        }
        if (this.getDownstreamBuildCountByResult("SUCCESS") > 0) {
            Dom4JUtil.addToElement(detailsElement, this.getSuccessfulJobSummaryElement());
        }
        return detailsElement;
    }

    protected Element getJobSummaryListElement() {
        Element jobSummaryListElement = Dom4JUtil.getNewElement("ul");
        ArrayList<Build> builds = new ArrayList<Build>();
        builds.add(this);
        builds.addAll(this.getDownstreamBuilds(null));
        for (Build build : builds) {
            Element jobSummaryListItemElement = Dom4JUtil.getNewElement("li", jobSummaryListElement, new Object[0]);
            jobSummaryListItemElement.add(build.getGitHubMessageBuildAnchorElement());
        }
        return jobSummaryListElement;
    }

    protected Element getJobSummaryListElement(boolean success, List<String> jobVariants) {
        Element jobSummaryListElement = Dom4JUtil.getNewElement("ul");
        ArrayList<Build> builds = new ArrayList<Build>();
        if (jobVariants != null) {
            builds.addAll(this.getJobVariantsDownstreamBuilds(jobVariants, null, null));
        } else {
            builds.add(this);
            builds.addAll(this.getDownstreamBuilds(null));
        }
        for (Build build : builds) {
            String result = build.getResult();
            if (result.equals("SUCCESS") != success) continue;
            Element jobSummaryListItemElement = Dom4JUtil.getNewElement("li", jobSummaryListElement, new Object[0]);
            jobSummaryListItemElement.add(build.getGitHubMessageBuildAnchorElement());
        }
        return jobSummaryListElement;
    }

    protected Element getMoreDetailsElement() {
        return Dom4JUtil.getNewElement("h5", null, "For more details click ", Dom4JUtil.getNewAnchorElement(this.getJenkinsReportURL(), "here"), ".");
    }

    protected Element getResourceFileContentAsElement(String tagName, Element parentElement, String resourceName) {
        String resourceFileContent = null;
        try {
            resourceFileContent = JenkinsResultsParserUtil.getResourceFileContent(resourceName);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to load resource " + resourceName, ioException);
        }
        return Dom4JUtil.getNewElement(tagName, parentElement, resourceFileContent);
    }

    protected Element getResultElement() {
        StringBuilder sb = new StringBuilder();
        String result = this.getResult();
        int successCount = this.getDownstreamBuildCountByResult("SUCCESS");
        if (result != null && result.matches("(APPROVED|SUCCESS)")) {
            ++successCount;
            sb.append(":heavy_check_mark: ");
        } else {
            sb.append(":x: ");
        }
        sb.append("ci:test:");
        sb.append(this.getTestSuiteName());
        sb.append(" - ");
        sb.append(String.valueOf(successCount));
        sb.append(" out of ");
        sb.append(String.valueOf(this.getDownstreamBuildCountByResult(null) + 1));
        sb.append(" jobs passed in ");
        sb.append(JenkinsResultsParserUtil.toDurationString(this.getDuration()));
        return Dom4JUtil.getNewElement("h3", null, sb.toString());
    }

    @Override
    protected String getStartPropertiesTempMapURL() {
        if (this.fromArchive) {
            return this.getBuildURL() + "/start.properties.json";
        }
        JenkinsMaster jenkinsMaster = this.getJenkinsMaster();
        return JenkinsResultsParserUtil.combine("http://cloud-10-0-0-31.lax.liferay.com/osb-jenkins-web/map/", jenkinsMaster.getName(), "/", this.getJobName(), "/", String.valueOf(this.getBuildNumber()), "/", this.getJobName(), "/", "start.properties");
    }

    @Override
    protected String getStopPropertiesTempMapURL() {
        if (this.fromArchive) {
            return this.getBuildURL() + "/stop.properties.json";
        }
        JenkinsMaster jenkinsMaster = this.getJenkinsMaster();
        return JenkinsResultsParserUtil.combine("http://cloud-10-0-0-31.lax.liferay.com/osb-jenkins-web/map/", jenkinsMaster.getName(), "/", this.getJobName(), "/", String.valueOf(this.getBuildNumber()), "/", this.getJobName(), "/", "stop.properties");
    }

    protected Element getSuccessfulJobSummaryElement() {
        Element jobSummaryListElement = this.getJobSummaryListElement(true, null);
        int successCount = this.getDownstreamBuildCountByResult("SUCCESS");
        String result = this.getResult();
        if (result != null && result.equals("SUCCESS")) {
            ++successCount;
        }
        return Dom4JUtil.getNewElement("details", null, Dom4JUtil.getNewElement("summary", null, Dom4JUtil.getNewElement("strong", null, String.valueOf(successCount), " Successful Jobs:")), jobSummaryListElement);
    }

    @Override
    protected String getTempMapURL(String tempMapName) {
        String tempMapURL = super.getTempMapURL(tempMapName);
        if (tempMapURL != null) {
            return tempMapURL;
        }
        Matcher matcher = gitRepositoryTempMapNamePattern.matcher(tempMapName);
        if (matcher.find()) {
            return this.getGitRepositoryDetailsPropertiesTempMapURL(matcher.group("gitRepositoryType"));
        }
        return null;
    }

    @Override
    protected int getTestCountByStatus(String status) {
        int testCount = 0;
        for (Build downstreamBuild : this.getDownstreamBuilds(null)) {
            if (!(downstreamBuild instanceof BaseBuild)) continue;
            BaseBuild downstreamBaseBuild = (BaseBuild)downstreamBuild;
            testCount += downstreamBaseBuild.getTestCountByStatus(status);
        }
        return testCount;
    }

    protected Element getTopGitHubMessageElement() {
        this.update();
        Element rootElement = Dom4JUtil.getNewElement("html");
        rootElement.add(this.getResultElement());
        Element detailsElement = Dom4JUtil.getNewElement("details", rootElement, Dom4JUtil.getNewElement("summary", null, "Click here for more details."), Dom4JUtil.getNewElement("h4", null, "Base Branch:"), this.getBaseBranchDetailsElement());
        String branchName = this.getBranchName();
        String companionBranchLabel = "Copied in Private Modules Branch:";
        if (branchName.endsWith("-private")) {
            companionBranchLabel = "Built off of Portal Core Branch:";
        }
        if (!branchName.startsWith("ee-") && this.getBaseGitRepositoryName().contains("liferay-portal")) {
            try {
                Dom4JUtil.addToElement(detailsElement, Dom4JUtil.getNewElement("h4", null, companionBranchLabel), this.getCompanionBranchDetailsElement());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Dom4JUtil.addToElement(detailsElement, this.getJobSummaryElement(), this.getMoreDetailsElement());
        String result = this.getResult();
        if (result != null && !result.equals("SUCCESS")) {
            Dom4JUtil.addToElement(detailsElement, this.getBuildFailureElements());
        }
        return rootElement;
    }

    protected String getUpstreamBranchSHA() {
        String upstreamBranchSHA = this.getParameterValue("GITHUB_UPSTREAM_BRANCH_SHA");
        if (upstreamBranchSHA == null || upstreamBranchSHA.isEmpty()) {
            Map<String, String> startPropertiesTempMap = this.getStartPropertiesTempMap();
            upstreamBranchSHA = startPropertiesTempMap.get("GITHUB_UPSTREAM_BRANCH_SHA");
        }
        return upstreamBranchSHA;
    }

    protected void sendBuildMetrics(String message) {
        if (this._sendBuildMetrics) {
            DatagramRequestUtil.send(message.trim(), this._metricsHostName, this._metricsHostPort);
        }
    }

    protected void sendBuildMetricsOnModifiedBuilds() {
        StringBuilder sb = new StringBuilder();
        Map<Map<String, String>, Integer> slaveUsages = this._getSlaveUsageByLabels();
        for (Map.Entry<Map<String, String>, Integer> slaveUsageEntry : slaveUsages.entrySet()) {
            Map<String, String> metricLabels = slaveUsageEntry.getKey();
            Integer slaveUsage = slaveUsageEntry.getValue();
            String buildMetricMessage = StatsDMetricsUtil.generateGaugeDeltaMetric("build_slave_usage_gauge", slaveUsage, metricLabels);
            if (buildMetricMessage == null) continue;
            sb.append(buildMetricMessage);
            sb.append("\n");
        }
        if (sb.length() > 0) {
            this.sendBuildMetrics(sb.toString());
        }
        this.sendBuildMetricsOnModifiedCompletedBuilds();
    }

    protected void sendBuildMetricsOnModifiedCompletedBuilds() {
        List<Build> modifiedCompletedBuilds = this.getModifiedDownstreamBuildsByStatus("completed");
        for (Build modifiedCompletedBuild : modifiedCompletedBuilds) {
            if (modifiedCompletedBuild instanceof BatchBuild) continue;
            this.sendBuildMetrics(StatsDMetricsUtil.generateTimerMetric("jenkins_job_build_duration", modifiedCompletedBuild.getDuration(), modifiedCompletedBuild.getMetricLabels()));
        }
    }

    private Map<Map<String, String>, Integer> _getSlaveUsageByLabels() {
        HashMap<Map<String, String>, Integer> slaveUsages = new HashMap<Map<String, String>, Integer>();
        List<Build> modifiedDownstreamBuilds = this.getModifiedDownstreamBuilds();
        for (Build modifiedDownstreamBuild : modifiedDownstreamBuilds) {
            Map<String, String> metricLabels = modifiedDownstreamBuild.getMetricLabels();
            Integer slaveUsage = (Integer)slaveUsages.get(metricLabels);
            if (slaveUsage == null) {
                slaveUsage = 0;
            }
            slaveUsage = slaveUsage + modifiedDownstreamBuild.getTotalSlavesUsedCount("running", true);
            slaveUsage = slaveUsage - modifiedDownstreamBuild.getTotalSlavesUsedCount("completed", true);
            slaveUsages.put(metricLabels, slaveUsage);
        }
        return slaveUsages;
    }
}

