/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitRepositoryJob;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.SubrepositoryGitWorkingDirectory;
import com.liferay.jenkins.results.parser.SubrepositoryTestClassJob;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class SubrepositoryGitRepositoryJob
extends GitRepositoryJob
implements SubrepositoryTestClassJob {
    protected PortalGitWorkingDirectory portalGitWorkingDirectory;
    protected boolean validationRequired;

    @Override
    public Set<String> getDistTypes() {
        String distTypes = JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "subrepo.dist.app.servers");
        return new TreeSet<String>(Arrays.asList(distTypes.split(",")));
    }

    @Override
    public GitWorkingDirectory getGitWorkingDirectory() {
        if (this.gitWorkingDirectory != null) {
            return this.gitWorkingDirectory;
        }
        this.checkGitRepositoryDir();
        this.gitWorkingDirectory = GitWorkingDirectoryFactory.newGitWorkingDirectory(this.getBranchName(), this.gitRepositoryDir.getPath());
        return this.gitWorkingDirectory;
    }

    @Override
    public PortalGitWorkingDirectory getPortalGitWorkingDirectory() {
        if (this.portalGitWorkingDirectory == null) {
            this.portalGitWorkingDirectory = GitWorkingDirectoryFactory.newPortalGitWorkingDirectory(this.getBranchName());
        }
        return this.portalGitWorkingDirectory;
    }

    @Override
    public SubrepositoryGitWorkingDirectory getSubrepositoryGitWorkingDirectory() {
        GitWorkingDirectory gitWorkingDirectory = this.getGitWorkingDirectory();
        if (!(gitWorkingDirectory instanceof SubrepositoryGitWorkingDirectory)) {
            throw new RuntimeException("Invalid subrepository Git working directory");
        }
        return (SubrepositoryGitWorkingDirectory)gitWorkingDirectory;
    }

    @Override
    public boolean isValidationRequired() {
        return this.validationRequired;
    }

    @Override
    public void setGitRepositoryDir(File repositoryDir) {
        String dirName = repositoryDir.getName();
        if (!dirName.endsWith("-private")) {
            dirName = dirName + "-private";
            repositoryDir = new File(repositoryDir.getParentFile(), dirName);
        }
        super.setGitRepositoryDir(repositoryDir);
    }

    protected SubrepositoryGitRepositoryJob(String jobName, Job.BuildProfile buildProfile, String repositoryName) {
        super(jobName, buildProfile);
        this.gitWorkingDirectory = GitWorkingDirectoryFactory.newSubrepositoryGitWorkingDirectory(jobName, repositoryName);
        this.setGitRepositoryDir(this.gitWorkingDirectory.getWorkingDirectory());
        this.checkGitRepositoryDir();
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build properties", ioException);
        }
        this.jobPropertiesFiles.add(new File(this.gitRepositoryDir, "test.properties"));
        this.jobPropertiesFiles.add(new File(JenkinsResultsParserUtil.combine(buildProperties.getProperty("base.repository.dir"), "/liferay-jenkins-ee/commands/dependencies", "/test-subrepository-batch.properties")));
        this.readJobProperties();
    }

    @Override
    protected Set<String> getRawBatchNames() {
        Properties jobProperties = this.getJobProperties();
        String batchNames = JenkinsResultsParserUtil.getProperty(jobProperties, "test.batch.names[" + this.getBranchName() + "]");
        if (batchNames == null) {
            batchNames = JenkinsResultsParserUtil.getProperty(jobProperties, "test.batch.names");
        }
        return this.getSetFromString(batchNames);
    }
}

