/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.SubrepositoryGitRepositoryJob;
import com.liferay.jenkins.results.parser.TestSuiteJob;
import java.util.Properties;
import java.util.Set;

public class SubrepositoryAcceptancePullRequestJob
extends SubrepositoryGitRepositoryJob
implements TestSuiteJob {
    private final String _testSuiteName;

    public SubrepositoryAcceptancePullRequestJob(String jobName, Job.BuildProfile buildProfile, String testSuiteName, String repositoryName) {
        super(jobName, buildProfile, repositoryName);
        this._testSuiteName = testSuiteName;
        this._setValidationRequired();
    }

    @Override
    public Set<String> getDistTypes() {
        Properties jobProperties = this.getJobProperties();
        String testBatchDistAppServers = JenkinsResultsParserUtil.getProperty(jobProperties, "subrepo.dist.app.servers[" + this._testSuiteName + "]");
        if (testBatchDistAppServers == null) {
            testBatchDistAppServers = JenkinsResultsParserUtil.getProperty(jobProperties, "subrepo.dist.app.servers");
        }
        return this.getSetFromString(testBatchDistAppServers);
    }

    @Override
    public String getTestSuiteName() {
        return this._testSuiteName;
    }

    @Override
    protected Set<String> getRawBatchNames() {
        String batchNames = JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "test.batch.names[" + this._testSuiteName + "]");
        if (batchNames == null) {
            return super.getRawBatchNames();
        }
        return this.getSetFromString(batchNames);
    }

    private void _setValidationRequired() {
        Properties jobProperties = this.getJobProperties();
        String testRunValidationProperty = JenkinsResultsParserUtil.getProperty(jobProperties, "test.run.validation[" + this._testSuiteName + "]");
        if (testRunValidationProperty == null) {
            testRunValidationProperty = JenkinsResultsParserUtil.getProperty(jobProperties, "test.run.validation");
        }
        this.validationRequired = Boolean.parseBoolean(testRunValidationProperty);
    }
}

