/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.DefaultTopLevelBuild;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalBranchInformationBuild;
import com.liferay.jenkins.results.parser.PullRequest;
import com.liferay.jenkins.results.parser.PullRequestBuild;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.failure.message.generator.FailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.GenericFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.RebaseFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.SourceFormatFailureMessageGenerator;
import org.dom4j.Element;

public class SourceFormatBuild
extends DefaultTopLevelBuild
implements PortalBranchInformationBuild,
PullRequestBuild {
    private static final String _NAME_TEST_SUITE = "sf";
    private PullRequest _pullRequest = new PullRequest(this.getParameterValue("PULL_REQUEST_URL"));

    @Override
    public String getBaseGitRepositoryName() {
        return this._pullRequest.getGitHubRemoteGitRepositoryName();
    }

    @Override
    public String getBaseGitRepositorySHA(String gitRepositoryName) {
        return this._pullRequest.getUpstreamBranchSHA();
    }

    @Override
    public String getBranchName() {
        return this._pullRequest.getUpstreamBranchName();
    }

    @Override
    public Element[] getBuildFailureElements() {
        return new Element[]{this.getFailureMessageElement()};
    }

    @Override
    public Build.BranchInformation getPortalBaseBranchInformation() {
        return null;
    }

    @Override
    public Build.BranchInformation getPortalBranchInformation() {
        return new PullRequestBranchInformation((Build)this, this._pullRequest);
    }

    @Override
    public PullRequest getPullRequest() {
        return this._pullRequest;
    }

    @Override
    public String getTestSuiteName() {
        return _NAME_TEST_SUITE;
    }

    @Override
    public Element getTopGitHubMessageElement() {
        this.update();
        Element detailsElement = Dom4JUtil.getNewElement("details", null, Dom4JUtil.getNewElement("summary", null, "Click here for more details."), Dom4JUtil.getNewElement("h4", null, "Base Branch:"), this.getBaseBranchDetailsElement(), Dom4JUtil.getNewElement("h4", null, "Sender Branch:"), this.getSenderBranchDetailsElement());
        String upstreamBranchName = this._pullRequest.getUpstreamBranchName();
        if (upstreamBranchName.contains("-private")) {
            Dom4JUtil.addToElement(detailsElement, Dom4JUtil.getNewElement("h4", null, "Companion Branch:"), this.getCompanionBranchDetailsElement());
        }
        String result = this.getResult();
        int successCount = 0;
        if (result.equals("SUCCESS")) {
            ++successCount;
        }
        Dom4JUtil.addToElement(detailsElement, String.valueOf(successCount), " out of ", String.valueOf(this.getDownstreamBuildCountByResult(null) + 1), "jobs PASSED");
        if (result.equals("SUCCESS")) {
            Dom4JUtil.addToElement(detailsElement, this.getSuccessfulJobSummaryElement());
        } else {
            Dom4JUtil.addToElement(detailsElement, this.getFailedJobSummaryElement());
        }
        Dom4JUtil.addToElement(detailsElement, this.getMoreDetailsElement());
        if (!result.equals("SUCCESS")) {
            Dom4JUtil.addToElement(detailsElement, this.getBuildFailureElements());
        }
        return Dom4JUtil.getNewElement("html", null, this.getResultElement(), detailsElement);
    }

    protected SourceFormatBuild(String url) {
        this(url, null);
    }

    protected SourceFormatBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
    }

    @Override
    protected FailureMessageGenerator[] getFailureMessageGenerators() {
        return new FailureMessageGenerator[]{new RebaseFailureMessageGenerator(), new SourceFormatFailureMessageGenerator(), new GenericFailureMessageGenerator()};
    }

    protected Element getSenderBranchDetailsElement() {
        String gitHubRemoteGitRepositoryName = this._pullRequest.getGitHubRemoteGitRepositoryName();
        String senderBranchName = this._pullRequest.getSenderBranchName();
        String senderUsername = this._pullRequest.getSenderUsername();
        String senderBranchURL = JenkinsResultsParserUtil.combine("https://github.com/", senderUsername, "/", gitHubRemoteGitRepositoryName, "/tree/", senderBranchName);
        String senderSHA = this._pullRequest.getSenderSHA();
        String senderCommitURL = JenkinsResultsParserUtil.combine("https://github.com/", senderUsername, "/", gitHubRemoteGitRepositoryName, "/commit/", senderSHA);
        return Dom4JUtil.getNewElement("p", null, "Branch Name: ", Dom4JUtil.getNewAnchorElement(senderBranchURL, senderBranchName), Dom4JUtil.getNewElement("br"), "Branch GIT ID: ", Dom4JUtil.getNewAnchorElement(senderCommitURL, senderSHA));
    }

    public static class PullRequestBranchInformation
    extends BaseBuild.DefaultBranchInformation {
        private final PullRequest _pullRequest;

        @Override
        public String getOriginName() {
            return this._pullRequest.getSenderUsername();
        }

        @Override
        public Integer getPullRequestNumber() {
            String pullRequestNumber = this._pullRequest.getNumber();
            if (pullRequestNumber == null || !pullRequestNumber.matches("\\d+")) {
                pullRequestNumber = "0";
            }
            return Integer.valueOf(pullRequestNumber);
        }

        @Override
        public String getReceiverUsername() {
            return this._pullRequest.getReceiverUsername();
        }

        @Override
        public String getRepositoryName() {
            return this._pullRequest.getGitRepositoryName();
        }

        @Override
        public String getSenderBranchName() {
            return this._pullRequest.getSenderBranchName();
        }

        @Override
        public String getSenderBranchSHA() {
            return this._pullRequest.getSenderSHA();
        }

        @Override
        public String getSenderUsername() {
            return this._pullRequest.getSenderUsername();
        }

        @Override
        public String getUpstreamBranchName() {
            return this._pullRequest.getUpstreamBranchName();
        }

        @Override
        public String getUpstreamBranchSHA() {
            return this._pullRequest.getUpstreamBranchSHA();
        }

        protected PullRequestBranchInformation(Build build, PullRequest pullRequest) {
            super(build, "portal");
            this._pullRequest = pullRequest;
        }
    }
}

