/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;

public class RemoteExecutor {
    private final List<String> _busySlaves = new ArrayList<String>();
    private String[] _commands;
    private final List<String> _errorSlaves = new ArrayList<String>();
    private final List<String> _finishedSlaves = new ArrayList<String>();
    private long _start;
    private String[] _targetSlaves;
    private long _threadsDurationTotal;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(int threadCount, String[] targetSlaves, String[] commands) {
        this._busySlaves.clear();
        this._commands = commands;
        this._errorSlaves.clear();
        this._finishedSlaves.clear();
        this._targetSlaves = targetSlaves;
        this._threadsDurationTotal = 0L;
        ExecutorService executorService = Executors.newFixedThreadPool(threadCount);
        System.out.println("Remote execution starting with " + threadCount + " threads.");
        try {
            this._start = System.currentTimeMillis();
            for (String targetSlave : this._targetSlaves) {
                executorService.execute(new RemoteExecutorThread(this, targetSlave));
            }
            while (this._finishedSlaves.size() + this._errorSlaves.size() < this._targetSlaves.length) {
                JenkinsResultsParserUtil.sleep(1000L);
            }
            if (!this._errorSlaves.isEmpty()) {
                System.out.println(this._errorSlaves.size() + " slaves failed to respond:\n" + this._errorSlaves);
            }
            int n = this._errorSlaves.size();
            return n;
        }
        finally {
            executorService.shutdown();
        }
    }

    private long _getAverageThreadDuration() {
        int threadsCompletedCount = this._finishedSlaves.size() + this._errorSlaves.size();
        if (threadsCompletedCount == 0) {
            return 0L;
        }
        return this._threadsDurationTotal / (long)threadsCompletedCount;
    }

    private void _onThreadComplete(RemoteExecutorThread remoteExecutorThread) {
        this._busySlaves.remove(remoteExecutorThread._targetSlave);
        if (!remoteExecutorThread._error) {
            this._finishedSlaves.add(remoteExecutorThread._targetSlave);
        } else {
            this._errorSlaves.add(remoteExecutorThread._targetSlave);
        }
        this._threadsDurationTotal += remoteExecutorThread._duration;
        StringBuffer sb = new StringBuffer();
        sb.append("Average thread duration: ");
        sb.append(this._getAverageThreadDuration());
        sb.append("ms\nBusy slaves:");
        sb.append(this._busySlaves.size());
        sb.append("\nFinished slaves:");
        sb.append(this._finishedSlaves.size());
        sb.append("\nTarget slaves:");
        sb.append(this._targetSlaves.length);
        sb.append("\nTotal duration: ");
        sb.append(System.currentTimeMillis() - this._start);
        sb.append("\n");
        System.out.println(sb.toString());
        if (this._finishedSlaves.size() + this._errorSlaves.size() == this._targetSlaves.length) {
            System.out.println("Remote execution completed in " + (System.currentTimeMillis() - this._start) + "ms.");
        }
    }

    private void _onThreadStart(RemoteExecutorThread remoteExecutorThread) {
        this._busySlaves.add(remoteExecutorThread._targetSlave);
    }

    private static class RemoteExecutorThread
    implements Runnable {
        private long _duration;
        private boolean _error;
        private final RemoteExecutor _remoteExecutor;
        private final String _targetSlave;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RemoteExecutor remoteExecutor = this._remoteExecutor;
            synchronized (remoteExecutor) {
                this._remoteExecutor._onThreadStart(this);
            }
            this._error = false;
            long start = System.currentTimeMillis();
            try {
                int returnCode = this._executeBashCommands();
                this._duration = System.currentTimeMillis() - start;
                if (returnCode != 0) {
                    this._handleError(null);
                }
            }
            catch (Exception exception) {
                this._handleError(exception.getMessage());
            }
            finally {
                RemoteExecutor remoteExecutor2 = this._remoteExecutor;
                synchronized (remoteExecutor2) {
                    this._remoteExecutor._onThreadComplete(this);
                }
            }
        }

        private RemoteExecutorThread(RemoteExecutor remoteExecutor, String targetSlave) {
            this._remoteExecutor = remoteExecutor;
            this._targetSlave = targetSlave;
        }

        private int _executeBashCommands() throws IOException, TimeoutException {
            StringBuffer sb = new StringBuffer("ssh -o NumberOfPasswordPrompts=0 ");
            sb.append(this._targetSlave);
            sb.append(" '");
            String[] commands = this._remoteExecutor._commands;
            for (int i = 0; i < commands.length; ++i) {
                sb.append(commands[i]);
                if (i >= commands.length - 1) continue;
                sb.append(" ; ");
            }
            sb.append("'");
            Process process = JenkinsResultsParserUtil.executeBashCommands(sb.toString());
            return process.exitValue();
        }

        private void _handleError(String errorMessage) {
            this._error = true;
            System.out.println("Remote execution failed on target slave: " + this._targetSlave + ".\n");
            if (errorMessage != null && !errorMessage.isEmpty()) {
                System.out.println(errorMessage);
            }
        }
    }
}

