/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitCommitFactory;
import com.liferay.jenkins.results.parser.GitHubRemoteGitCommit;
import com.liferay.jenkins.results.parser.GitHubRemoteGitRepository;
import com.liferay.jenkins.results.parser.GitRepositoryFactory;
import com.liferay.jenkins.results.parser.GitUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.RemoteGitBranch;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class PullRequest {
    private static final String _NAME_TEST_SUITE_DEFAULT = "default";
    private static final Pattern _gitHubPullRequestURLPattern = Pattern.compile(JenkinsResultsParserUtil.combine("https://github.com/(?<owner>[^/]+)/", "(?<gitHubRemoteGitRepositoryName>[^/]+)/pull/(?<number>\\d+)"));
    private Boolean _autoCloseCommentAvailable;
    private String _commonParentSHA;
    private GitHubRemoteGitRepository _gitHubRemoteGitRepository;
    private String _gitHubRemoteGitRepositoryName;
    private JSONObject _jsonObject;
    private final List<GitHubRemoteGitRepository.Label> _labels = new ArrayList<GitHubRemoteGitRepository.Label>();
    private RemoteGitBranch _liferayRemoteGitBranch;
    private Integer _number;
    private String _ownerUsername;
    private final String _testSuiteName;
    private TestSuiteStatus _testSuiteStatus = TestSuiteStatus.MISSING;

    public static boolean isValidGitHubPullRequestURL(String gitHubURL) {
        Matcher matcher = _gitHubPullRequestURLPattern.matcher(gitHubURL);
        return matcher.find();
    }

    public PullRequest(String gitHubURL) {
        this(gitHubURL, _NAME_TEST_SUITE_DEFAULT);
    }

    public PullRequest(String gitHubURL, String testSuiteName) {
        if (testSuiteName == null || testSuiteName.isEmpty()) {
            testSuiteName = _NAME_TEST_SUITE_DEFAULT;
        }
        this._testSuiteName = testSuiteName;
        Matcher matcher = _gitHubPullRequestURLPattern.matcher(gitHubURL);
        if (!matcher.find()) {
            throw new RuntimeException("Invalid GitHub URL " + gitHubURL);
        }
        this._gitHubRemoteGitRepositoryName = matcher.group("gitHubRemoteGitRepositoryName");
        this._number = Integer.parseInt(matcher.group("number"));
        this._ownerUsername = matcher.group("owner");
        this.refresh();
    }

    public Comment addComment(String body) {
        body = body.replaceAll("(\\>)\\s+(\\<)", "$1$2");
        body = body.replace("&quot;", "\\&quot;");
        JSONObject dataJSONObject = new JSONObject();
        dataJSONObject.put("body", (Object)body);
        try {
            JSONObject responseJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.combine(this._jsonObject.getString("issue_url"), "/comments"), dataJSONObject.toString());
            return new Comment(responseJSONObject);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to post comment in GitHub pull request " + this.getURL(), ioException);
        }
    }

    public boolean addLabel(GitHubRemoteGitRepository.Label label) {
        if (label == null || this.hasLabel(label.getName())) {
            return true;
        }
        GitHubRemoteGitRepository gitHubRemoteGitRepository = this.getGitHubRemoteGitRepository();
        GitHubRemoteGitRepository.Label gitRepositoryLabel = gitHubRemoteGitRepository.getLabel(label.getName());
        if (gitRepositoryLabel == null) {
            System.out.println(JenkinsResultsParserUtil.combine("GitHubRemoteGitRepository.Label ", label.getName(), " does not exist in ", this.getGitHubRemoteGitRepositoryName()));
            return false;
        }
        JSONArray jsonArray = new JSONArray();
        jsonArray.put((Object)label.getName());
        String gitHubApiUrl = JenkinsResultsParserUtil.getGitHubApiUrl(this.getGitHubRemoteGitRepositoryName(), this.getOwnerUsername(), "issues/" + this.getNumber() + "/labels");
        try {
            PullRequest._toString(gitHubApiUrl, jsonArray.toString());
        }
        catch (IOException ioException) {
            System.out.println("Unable to add label " + label.getName());
            ioException.printStackTrace();
            return false;
        }
        return true;
    }

    public void close() throws IOException {
        if (Objects.equals(this.getState(), "open")) {
            JSONObject postContentJSONObject = new JSONObject();
            postContentJSONObject.put("state", (Object)"closed");
            PullRequest._toString(this._jsonObject.getString("url"), postContentJSONObject.toString());
        }
        this._jsonObject.put("state", (Object)"closed");
    }

    public List<Comment> getComments() {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        String gitHubApiUrl = JenkinsResultsParserUtil.getGitHubApiUrl(this.getGitHubRemoteGitRepositoryName(), this.getOwnerUsername(), "issues/" + this.getNumber() + "/comments?page=");
        int page = 1;
        try {
            JSONArray jsonArray;
            while ((jsonArray = JenkinsResultsParserUtil.toJSONArray(gitHubApiUrl + page, false)).length() != 0) {
                for (int i = 0; i < jsonArray.length(); ++i) {
                    comments.add(new Comment(jsonArray.getJSONObject(i)));
                }
                ++page;
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get pull request comments", ioException);
        }
        return comments;
    }

    public String getCommonParentSHA() {
        return this._commonParentSHA;
    }

    public GitHubRemoteGitCommit getGitHubRemoteGitCommit() {
        return GitCommitFactory.newGitHubRemoteGitCommit(this.getOwnerUsername(), this.getGitHubRemoteGitRepositoryName(), this.getSenderSHA());
    }

    public GitHubRemoteGitRepository getGitHubRemoteGitRepository() {
        if (this._gitHubRemoteGitRepository == null) {
            this._gitHubRemoteGitRepository = (GitHubRemoteGitRepository)GitRepositoryFactory.getRemoteGitRepository("github.com", this._gitHubRemoteGitRepositoryName, this.getOwnerUsername());
        }
        return this._gitHubRemoteGitRepository;
    }

    public String getGitHubRemoteGitRepositoryName() {
        return this._gitHubRemoteGitRepositoryName;
    }

    public String getGitRepositoryName() {
        return this.getGitHubRemoteGitRepositoryName();
    }

    public String getHtmlURL() {
        return this._jsonObject.getString("html_url");
    }

    public String getJSON() {
        return this._jsonObject.toString(4);
    }

    public JSONObject getJSONObject() {
        return this._jsonObject;
    }

    public List<GitHubRemoteGitRepository.Label> getLabels() {
        return this._labels;
    }

    public String getLiferayRemoteBranchSHA() {
        RemoteGitBranch liferayRemoteGitBranch = this.getLiferayRemoteGitBranch();
        return liferayRemoteGitBranch.getSHA();
    }

    public RemoteGitBranch getLiferayRemoteGitBranch() {
        if (this._liferayRemoteGitBranch == null) {
            this._liferayRemoteGitBranch = GitUtil.getRemoteGitBranch(this.getUpstreamBranchName(), new File("."), "git@github.com:liferay/" + this.getGitRepositoryName());
        }
        return this._liferayRemoteGitBranch;
    }

    public String getLocalSenderBranchName() {
        return JenkinsResultsParserUtil.combine(this.getSenderUsername(), "-", this.getNumber(), "-", this.getSenderBranchName());
    }

    public String getNumber() {
        return String.valueOf(this._number);
    }

    public String getOwnerUsername() {
        return this._ownerUsername;
    }

    public String getReceiverUsername() {
        JSONObject baseJSONObject = this._jsonObject.getJSONObject("base");
        JSONObject userJSONObject = baseJSONObject.getJSONObject("user");
        return userJSONObject.getString("login");
    }

    public String getSenderBranchName() {
        JSONObject headJSONObject = this._jsonObject.getJSONObject("head");
        return headJSONObject.getString("ref");
    }

    public String getSenderRemoteURL() {
        return JenkinsResultsParserUtil.combine("git@github.com:", this.getSenderUsername(), "/", this.getGitHubRemoteGitRepositoryName());
    }

    public String getSenderSHA() {
        JSONObject headJSONObject = this._jsonObject.getJSONObject("head");
        return headJSONObject.getString("sha");
    }

    public JSONArray getSenderSHAStatusesJSONArray() {
        JSONArray statusesJSONArray = null;
        try {
            statusesJSONArray = JenkinsResultsParserUtil.toJSONArray(this._jsonObject.getString("statuses_url"));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return statusesJSONArray;
    }

    public JSONObject getSenderSHAStatusJSONObject() {
        JSONObject statusJSONObject = null;
        try {
            String statusURL = this._jsonObject.getString("statuses_url");
            statusURL = statusURL.replace("statuses", "status");
            statusJSONObject = JenkinsResultsParserUtil.toJSONObject(statusURL);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return statusJSONObject;
    }

    public String getSenderUsername() {
        JSONObject headJSONObject = this._jsonObject.getJSONObject("head");
        JSONObject userJSONObject = headJSONObject.getJSONObject("user");
        return userJSONObject.getString("login");
    }

    public String getState() {
        return this._jsonObject.getString("state");
    }

    public TestSuiteStatus getTestSuiteStatus() {
        return this._testSuiteStatus;
    }

    public String getTitle() {
        return this._jsonObject.getString("title");
    }

    public String getUpstreamBranchName() {
        JSONObject baseJSONObject = this._jsonObject.getJSONObject("base");
        return baseJSONObject.getString("ref");
    }

    public String getUpstreamBranchSHA() {
        JSONObject baseJSONObject = this._jsonObject.getJSONObject("base");
        return baseJSONObject.getString("sha");
    }

    public String getURL() {
        return JenkinsResultsParserUtil.getGitHubApiUrl(this._gitHubRemoteGitRepositoryName, this._ownerUsername, "pulls/" + this._number);
    }

    public boolean hasLabel(String labelName) {
        for (GitHubRemoteGitRepository.Label label : this._labels) {
            if (!labelName.equals(label.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isAutoCloseCommentAvailable() {
        if (this._autoCloseCommentAvailable != null) {
            return this._autoCloseCommentAvailable;
        }
        List<Comment> comments = this.getComments();
        for (Comment comment : comments) {
            String commentBody = comment.getBody();
            if (!commentBody.contains("auto-close=\"false\"")) continue;
            this._autoCloseCommentAvailable = true;
            return this._autoCloseCommentAvailable;
        }
        this._autoCloseCommentAvailable = false;
        return this._autoCloseCommentAvailable;
    }

    public void refresh() {
        try {
            this._jsonObject = JenkinsResultsParserUtil.toJSONObject(this.getURL(), false);
            JSONArray commitsJSONArray = JenkinsResultsParserUtil.toJSONArray(this._jsonObject.getString("commits_url"));
            JSONObject firstCommitJSONObject = commitsJSONArray.getJSONObject(0);
            JSONArray parentsJSONArray = firstCommitJSONObject.getJSONArray("parents");
            JSONObject firstParentJSONObject = parentsJSONArray.getJSONObject(0);
            this._commonParentSHA = firstParentJSONObject.getString("sha");
            this._labels.clear();
            JSONArray labelJSONArray = this._jsonObject.getJSONArray("labels");
            for (int i = 0; i < labelJSONArray.length(); ++i) {
                JSONObject labelJSONObject = labelJSONArray.getJSONObject(i);
                this._labels.add(new GitHubRemoteGitRepository.Label(labelJSONObject, this.getGitHubRemoteGitRepository()));
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public void removeComment(Comment comment) {
        this.removeComment(comment.getId());
    }

    public void removeComment(String id) {
        String editCommentURL = this._jsonObject.getString("issue_url");
        editCommentURL = editCommentURL.replaceFirst("issues/\\d+", "issues");
        try {
            PullRequest._toString(JenkinsResultsParserUtil.combine(editCommentURL, "/comments/", id), JenkinsResultsParserUtil.HttpRequestMethod.DELETE);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to delete comment in GitHub pull request " + this.getURL(), ioException);
        }
    }

    public void removeLabel(String labelName) {
        if (!this.hasLabel(labelName)) {
            return;
        }
        String path = JenkinsResultsParserUtil.combine("issues/", this.getNumber(), "/labels/", labelName);
        String gitHubApiUrl = JenkinsResultsParserUtil.getGitHubApiUrl(this.getGitHubRemoteGitRepositoryName(), this.getOwnerUsername(), path);
        try {
            PullRequest._toString(gitHubApiUrl, JenkinsResultsParserUtil.HttpRequestMethod.DELETE);
            this.refresh();
        }
        catch (IOException ioException) {
            System.out.println("Unable to remove label " + labelName);
            ioException.printStackTrace();
        }
    }

    public void resetAutoCloseCommentAvailable() {
        this._autoCloseCommentAvailable = null;
    }

    public void setTestSuiteStatus(TestSuiteStatus testSuiteStatus) {
        this.setTestSuiteStatus(testSuiteStatus, null);
    }

    public void setTestSuiteStatus(TestSuiteStatus testSuiteStatus, String targetURL) {
        this.setTestSuiteStatus(testSuiteStatus, targetURL, null);
    }

    public void setTestSuiteStatus(TestSuiteStatus testSuiteStatus, String targetURL, String senderSHA) {
        this._testSuiteStatus = testSuiteStatus;
        StringBuilder sb = new StringBuilder();
        sb.append("ci:test");
        if (!this._testSuiteName.equals(_NAME_TEST_SUITE_DEFAULT)) {
            sb.append(":");
            sb.append(this._testSuiteName);
        }
        sb.append(" ");
        String testSuiteLabelPrefix = sb.toString();
        ArrayList<String> oldLabelNames = new ArrayList<String>();
        for (GitHubRemoteGitRepository.Label label : this.getLabels()) {
            String name = label.getName();
            if (!name.startsWith(testSuiteLabelPrefix)) continue;
            oldLabelNames.add(label.getName());
        }
        for (String oldLabelName : oldLabelNames) {
            this.removeLabel(oldLabelName);
        }
        sb.append(" - ");
        sb.append(StringUtils.lowerCase((String)testSuiteStatus.toString()));
        GitHubRemoteGitRepository gitHubRemoteGitRepository = this.getGitHubRemoteGitRepository();
        GitHubRemoteGitRepository.Label testSuiteLabel = gitHubRemoteGitRepository.getLabel(sb.toString());
        if (testSuiteLabel == null && gitHubRemoteGitRepository.addLabel(testSuiteStatus.getColor(), "", sb.toString())) {
            testSuiteLabel = gitHubRemoteGitRepository.getLabel(sb.toString());
        }
        this.addLabel(testSuiteLabel);
        if (targetURL == null) {
            return;
        }
        if (testSuiteStatus == TestSuiteStatus.MISSING) {
            return;
        }
        GitHubRemoteGitCommit gitHubRemoteGitCommit = this.getGitHubRemoteGitCommit();
        if (senderSHA != null && senderSHA.matches("[0-9a-f]{7,40}")) {
            gitHubRemoteGitCommit = GitCommitFactory.newGitHubRemoteGitCommit(this.getOwnerUsername(), this.getGitHubRemoteGitRepositoryName(), senderSHA);
        }
        GitHubRemoteGitCommit.Status status = GitHubRemoteGitCommit.Status.valueOf(testSuiteStatus.toString());
        String context = _NAME_TEST_SUITE_DEFAULT;
        if (!this._testSuiteName.equals(_NAME_TEST_SUITE_DEFAULT)) {
            context = "liferay/ci:test:" + this._testSuiteName;
        }
        sb = new StringBuilder();
        sb.append("\"ci:test");
        if (!this._testSuiteName.equals(_NAME_TEST_SUITE_DEFAULT)) {
            sb.append(":");
            sb.append(this._testSuiteName);
        }
        sb.append("\"");
        if (testSuiteStatus == TestSuiteStatus.ERROR || testSuiteStatus == TestSuiteStatus.FAILURE) {
            sb.append(" has FAILED.");
        } else if (testSuiteStatus == TestSuiteStatus.PENDING) {
            sb.append(" is running.");
        } else if (testSuiteStatus == TestSuiteStatus.SUCCESS) {
            sb.append(" has PASSED.");
        }
        gitHubRemoteGitCommit.setStatus(status, context, sb.toString(), targetURL);
    }

    public Comment updateComment(Comment comment) {
        return this.updateComment(comment.getBody(), comment.getId());
    }

    public Comment updateComment(String body, String id) {
        body = body.replaceAll("(\\>)\\s+(\\<)", "$1$2");
        body = body.replace("&quot;", "\\&quot;");
        try {
            String editCommentURL = this._jsonObject.getString("issue_url");
            editCommentURL = editCommentURL.replaceFirst("issues/\\d+", "issues");
            return new Comment(JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.combine(editCommentURL, "/comments/", id), false, JenkinsResultsParserUtil.HttpRequestMethod.PATCH));
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to update comment in GitHub pull request " + this.getURL(), ioException);
        }
    }

    protected String getIssueURL() {
        return this._jsonObject.getString("issue_url");
    }

    protected void updateGithub() {
        JSONObject jsonObject = new JSONObject();
        ArrayList<String> labelNames = new ArrayList<String>();
        for (GitHubRemoteGitRepository.Label label : this._labels) {
            labelNames.add(label.getName());
        }
        jsonObject.put("labels", labelNames);
        try {
            JenkinsResultsParserUtil.toJSONObject(this.getIssueURL(), jsonObject.toString());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private static String _toString(String url, JenkinsResultsParserUtil.HttpRequestMethod httpRequestMethod) throws IOException {
        return JenkinsResultsParserUtil.toString(url, true, 10, httpRequestMethod, null, 30, 5000, null);
    }

    private static String _toString(String url, String postContent) throws IOException {
        return JenkinsResultsParserUtil.toString(url, false, 10, null, postContent, 30, 5000, null);
    }

    public static enum TestSuiteStatus {
        ERROR("fccdcc"),
        FAILURE("fccdcc"),
        MISSING("eeeeee"),
        PENDING("fff4c9"),
        SUCCESS("c7e8cb");

        private final String _color;

        public String getColor() {
            return this._color;
        }

        private TestSuiteStatus(String color) {
            this._color = color;
        }
    }

    public static class Comment {
        private static final SimpleDateFormat _UtcIso8601SimpleDateFormat;
        private final JSONObject _commentJSONObject;

        public Comment(JSONObject commentJSONObject) {
            this._commentJSONObject = commentJSONObject;
        }

        public String getBody() {
            return this._commentJSONObject.getString("body");
        }

        public Date getCreatedDate() {
            try {
                return _UtcIso8601SimpleDateFormat.parse(this._commentJSONObject.getString("created_at"));
            }
            catch (ParseException parseException) {
                throw new RuntimeException("Unable to parse created date " + this._commentJSONObject.getString("created_at"), parseException);
            }
        }

        public String getId() {
            return String.valueOf(this._commentJSONObject.getInt("id"));
        }

        public Date getModifiedDate() {
            try {
                return _UtcIso8601SimpleDateFormat.parse(this._commentJSONObject.getString("modified_at"));
            }
            catch (ParseException parseException) {
                throw new RuntimeException("Unable to parse modified date " + this._commentJSONObject.getString("modified_at"), parseException);
            }
        }

        public String getUserLogin() {
            JSONObject userJSONObject = this._commentJSONObject.getJSONObject("user");
            return userJSONObject.getString("login");
        }

        static {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            _UtcIso8601SimpleDateFormat = simpleDateFormat;
        }
    }
}

