/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseTopLevelBuildData;
import com.liferay.jenkins.results.parser.PortalBuildData;
import org.json.JSONObject;

public class PortalTopLevelBuildData
extends BaseTopLevelBuildData
implements PortalBuildData {
    private static final String[] _REQUIRED_KEYS = new String[]{"portal_github_url", "portal_upstream_branch_name"};
    private static final String _TYPE = "portal_top_level";

    public static boolean isValidJSONObject(JSONObject jsonObject) {
        return PortalTopLevelBuildData.isValidJSONObject(jsonObject, _TYPE);
    }

    @Override
    public String getPortalBranchSHA() {
        return this.getString("portal_branch_sha");
    }

    @Override
    public String getPortalGitHubBranchName() {
        return this.getGitHubBranchName(this.getPortalGitHubURL());
    }

    @Override
    public String getPortalGitHubRepositoryName() {
        return this.getGitHubRepositoryName(this.getPortalGitHubURL());
    }

    @Override
    public String getPortalGitHubURL() {
        return this.getString("portal_github_url");
    }

    @Override
    public String getPortalGitHubUsername() {
        return this.getGitHubUsername(this.getPortalGitHubURL());
    }

    @Override
    public String getPortalUpstreamBranchName() {
        return this.getString("portal_upstream_branch_name");
    }

    @Override
    public void setPortalBranchSHA(String portalBranchSHA) {
        this.put("portal_branch_sha", portalBranchSHA);
    }

    @Override
    public void setPortalGitHubURL(String portalGitHubURL) {
        this.put("portal_github_url", portalGitHubURL);
    }

    @Override
    public void setPortalUpstreamBranchName(String portalUpstreamBranchName) {
        this.put("portal_upstream_branch_name", portalUpstreamBranchName);
    }

    protected PortalTopLevelBuildData(String runID, String jobName, String buildURL) {
        super(runID, jobName, buildURL);
        this.setPortalGitHubURL("https://github.com/liferay/liferay-portal/tree/master");
        this.setPortalUpstreamBranchName("master");
        this.validateKeys(_REQUIRED_KEYS);
    }

    @Override
    protected String getType() {
        return _TYPE;
    }
}

