/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.AnalyticsCloudBranchInformationBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.DefaultTopLevelBuild;
import com.liferay.jenkins.results.parser.PluginsBranchInformationBuild;
import com.liferay.jenkins.results.parser.PortalBranchInformationBuild;
import com.liferay.jenkins.results.parser.PortalFixpackRelease;
import com.liferay.jenkins.results.parser.PortalFixpackReleaseBuild;
import com.liferay.jenkins.results.parser.PortalRelease;
import com.liferay.jenkins.results.parser.PortalReleaseBuild;
import com.liferay.jenkins.results.parser.TopLevelBuild;

public class PortalTopLevelBuild
extends DefaultTopLevelBuild
implements AnalyticsCloudBranchInformationBuild,
PluginsBranchInformationBuild,
PortalBranchInformationBuild,
PortalFixpackReleaseBuild,
PortalReleaseBuild {
    private PortalFixpackRelease _portalFixpackRelease;
    private PortalRelease _portalRelease;

    public PortalTopLevelBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
    }

    @Override
    public Build.BranchInformation getOSBAsahBranchInformation() {
        return this.getBranchInformation("osb.asah");
    }

    @Override
    public Build.BranchInformation getOSBFaroBranchInformation() {
        return this.getBranchInformation("osb.faro");
    }

    @Override
    public Build.BranchInformation getPluginsBranchInformation() {
        return this.getBranchInformation("plugins");
    }

    @Override
    public Build.BranchInformation getPortalBaseBranchInformation() {
        Build.BranchInformation portalBranchInformation = this.getPortalBranchInformation();
        String upstreamBranchName = portalBranchInformation.getUpstreamBranchName();
        if (upstreamBranchName.contains("-private")) {
            return this.getBranchInformation("portal.base");
        }
        return null;
    }

    @Override
    public Build.BranchInformation getPortalBranchInformation() {
        return this.getBranchInformation("portal");
    }

    @Override
    public PortalFixpackRelease getPortalFixpackRelease() {
        if (this._portalFixpackRelease != null) {
            return this._portalFixpackRelease;
        }
        Build controllerBuild = this.getControllerBuild();
        if (controllerBuild == null) {
            return null;
        }
        String portalFixPackVersion = controllerBuild.getParameterValue("PORTAL_FIX_PACK_VERSION");
        if (portalFixPackVersion == null) {
            return null;
        }
        this._portalFixpackRelease = new PortalFixpackRelease(portalFixPackVersion, this.getPortalRelease());
        return this._portalFixpackRelease;
    }

    @Override
    public PortalRelease getPortalRelease() {
        if (this._portalRelease != null) {
            return this._portalRelease;
        }
        Build controllerBuild = this.getControllerBuild();
        if (controllerBuild == null) {
            return null;
        }
        String portalBundleVersion = controllerBuild.getParameterValue("PORTAL_BUNDLE_VERSION");
        if (portalBundleVersion == null) {
            return null;
        }
        this._portalRelease = new PortalRelease(portalBundleVersion);
        return this._portalRelease;
    }
}

