/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseBuildRunner;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.BuildFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.JobFactory;
import com.liferay.jenkins.results.parser.PortalTestSuiteUpstreamControllerBuildData;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class PortalTestSuiteUpstreamControllerBuildRunner<S extends PortalTestSuiteUpstreamControllerBuildData>
extends BaseBuildRunner<S, Workspace> {
    private final List<String> _invokedTestSuiteNames = new ArrayList<String>();
    private List<String> _selectedTestSuiteNames;

    @Override
    public void run() {
        this.keepJenkinsBuild(true);
        this.invokeTestSuiteBuilds();
    }

    @Override
    public void tearDown() {
    }

    protected PortalTestSuiteUpstreamControllerBuildRunner(S buildData) {
        super(buildData);
    }

    protected String getInvocationCohortName() {
        String invocationCohortName = System.getenv("INVOCATION_COHORT_NAME");
        if (invocationCohortName != null && !invocationCohortName.isEmpty()) {
            return invocationCohortName;
        }
        Object buildData = this.getBuildData();
        return buildData.getCohortName();
    }

    protected String getJobURL() {
        String mostAvailableMasterURL = JenkinsResultsParserUtil.getMostAvailableMasterURL(JenkinsResultsParserUtil.combine("http://" + this.getInvocationCohortName() + ".liferay.com"), 1);
        PortalTestSuiteUpstreamControllerBuildData buildData = (PortalTestSuiteUpstreamControllerBuildData)this.getBuildData();
        return JenkinsResultsParserUtil.combine(mostAvailableMasterURL, "/job/test-portal-testsuite-upstream(", buildData.getPortalUpstreamBranchName(), ")");
    }

    protected String getTestPortalBuildProfile(String testSuite) {
        try {
            Properties buildProperties = JenkinsResultsParserUtil.getBuildProperties();
            PortalTestSuiteUpstreamControllerBuildData buildData = (PortalTestSuiteUpstreamControllerBuildData)this.getBuildData();
            String buildProfile = buildProperties.getProperty(JenkinsResultsParserUtil.combine("portal.testsuite.upstream.test.portal.build.profile[", buildData.getPortalUpstreamBranchName(), "][", testSuite, "]"));
            if (buildProfile == null) {
                buildProfile = buildProperties.getProperty("portal.testsuite.upstream.test.portal.build.profile");
            }
            return buildProfile;
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get portal build profile for test suite " + testSuite, ioException);
        }
    }

    @Override
    protected void initWorkspace() {
        this.setWorkspace(WorkspaceFactory.newSimpleWorkspace());
    }

    protected void invokeTestSuiteBuilds() {
        String jenkinsAuthenticationToken;
        List<String> testSuiteNames = this._getSelectedTestSuiteNames();
        if (testSuiteNames.isEmpty()) {
            System.out.println("There are no test suites to run at this time.");
            return;
        }
        try {
            Properties buildProperties = JenkinsResultsParserUtil.getBuildProperties();
            jenkinsAuthenticationToken = buildProperties.getProperty("jenkins.authentication.token");
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        PortalTestSuiteUpstreamControllerBuildData buildData = (PortalTestSuiteUpstreamControllerBuildData)this.getBuildData();
        for (String testSuiteName : testSuiteNames) {
            String testrayProjectName;
            String jobURL = this.getJobURL();
            StringBuilder sb = new StringBuilder();
            sb.append(jobURL);
            sb.append("/buildWithParameters?");
            sb.append("token=");
            sb.append(jenkinsAuthenticationToken);
            HashMap<String, Object> invocationParameters = new HashMap<String, Object>();
            invocationParameters.put("CI_TEST_SUITE", testSuiteName);
            invocationParameters.put("JENKINS_GITHUB_BRANCH_NAME", buildData.getJenkinsGitHubBranchName());
            invocationParameters.put("JENKINS_GITHUB_BRANCH_USERNAME", buildData.getJenkinsGitHubUsername());
            invocationParameters.put("PORTAL_GIT_COMMIT", buildData.getPortalBranchSHA());
            invocationParameters.put("PORTAL_GITHUB_URL", buildData.getPortalGitHubURL());
            String testPortalBuildProfile = this.getTestPortalBuildProfile(testSuiteName);
            if (testPortalBuildProfile != null) {
                invocationParameters.put("TEST_PORTAL_BUILD_PROFILE", testPortalBuildProfile);
            }
            if ((testrayProjectName = this._getTestrayProjectName(testSuiteName)) != null) {
                Object testrayBuildType = JenkinsResultsParserUtil.combine("[", buildData.getPortalUpstreamBranchName(), "] ci:test:", testSuiteName);
                String testraybuildName = JenkinsResultsParserUtil.combine(new String[]{testrayBuildType, " - ", String.valueOf(buildData.getBuildNumber()), " - ", JenkinsResultsParserUtil.toDateString(new Date(buildData.getStartTime()), "yyyy-MM-dd[HH:mm:ss]", "America/Los_Angeles")});
                if (this._getTestrayBuildType(testSuiteName) != null) {
                    testrayBuildType = this._getTestrayBuildType(testSuiteName);
                }
                invocationParameters.put("TESTRAY_BUILD_NAME", testraybuildName);
                invocationParameters.put("TESTRAY_BUILD_TYPE", testrayBuildType);
                invocationParameters.put("TESTRAY_PROJECT_NAME", testrayProjectName);
            }
            invocationParameters.putAll(buildData.getBuildParameters());
            for (Map.Entry invocationParameter : invocationParameters.entrySet()) {
                if (invocationParameter.getValue() == null) continue;
                sb.append("&");
                sb.append((String)invocationParameter.getKey());
                sb.append("=");
                sb.append((String)invocationParameter.getValue());
            }
            try {
                JenkinsResultsParserUtil.toString(sb.toString());
                System.out.println("Job for '" + testSuiteName + "' was invoked at " + jobURL);
                this._invokedTestSuiteNames.add(testSuiteName);
            }
            catch (IOException ioException) {
                System.out.println(JenkinsResultsParserUtil.combine("Unable to invoke a new build for test suite, '", testSuiteName, "'"));
                ioException.printStackTrace();
            }
        }
        buildData.setBuildDescription(JenkinsResultsParserUtil.join(", ", this._invokedTestSuiteNames));
        this.updateBuildDescription();
    }

    private List<Build> _getBuildHistory() {
        PortalTestSuiteUpstreamControllerBuildData buildData = (PortalTestSuiteUpstreamControllerBuildData)this.getBuildData();
        Build build = BuildFactory.newBuild(buildData.getBuildURL(), null);
        Job job = JobFactory.newJob(buildData.getJobName());
        return job.getBuildHistory(build.getJenkinsMaster());
    }

    private List<String> _getBuildTestSuiteNames(Build build) {
        String buildDescription = build.getBuildDescription();
        if (buildDescription == null || buildDescription.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(buildDescription.split("\\s*,\\s*"));
    }

    private Map<String, Long> _getCandidateTestSuiteStaleDurations() {
        Properties buildProperties;
        PortalTestSuiteUpstreamControllerBuildData buildData = (PortalTestSuiteUpstreamControllerBuildData)this.getBuildData();
        String upstreamBranchName = buildData.getPortalUpstreamBranchName();
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        LinkedHashMap<String, Long> candidateTestSuiteStaleDurations = new LinkedHashMap<String, Long>();
        for (String testSuiteName : this._getTestSuiteNames()) {
            String suiteStaleDuration = buildProperties.getProperty(JenkinsResultsParserUtil.combine("portal.testsuite.upstream.stale.duration[", upstreamBranchName, "][", testSuiteName, "]"));
            if (suiteStaleDuration == null) continue;
            candidateTestSuiteStaleDurations.put(testSuiteName, Long.parseLong(suiteStaleDuration) * 60L * 1000L);
        }
        return candidateTestSuiteStaleDurations;
    }

    private Map<String, Long> _getLatestTestSuiteStartTimes() {
        List<Build> builds = this._getBuildHistory();
        Object buildData = this.getBuildData();
        Build currentBuild = BuildFactory.newBuild(buildData.getBuildURL(), null);
        builds.remove(currentBuild);
        LinkedHashMap<String, Long> latestTestSuiteStartTimes = new LinkedHashMap<String, Long>();
        block0: for (String testSuiteName : this._getTestSuiteNames()) {
            for (Build build : builds) {
                List<String> buildTestSuiteNames = this._getBuildTestSuiteNames(build);
                if (!buildTestSuiteNames.contains(testSuiteName)) continue;
                latestTestSuiteStartTimes.put(testSuiteName, build.getStartTime());
                continue block0;
            }
        }
        return latestTestSuiteStartTimes;
    }

    private List<String> _getSelectedTestSuiteNames() {
        if (this._selectedTestSuiteNames != null) {
            return this._selectedTestSuiteNames;
        }
        this._selectedTestSuiteNames = new ArrayList<String>();
        Map<String, Long> candidateTestSuiteStaleDurations = this._getCandidateTestSuiteStaleDurations();
        Map<String, Long> latestTestSuiteStartTimes = this._getLatestTestSuiteStartTimes();
        PortalTestSuiteUpstreamControllerBuildData buildData = (PortalTestSuiteUpstreamControllerBuildData)this.getBuildData();
        Long startTime = buildData.getStartTime();
        for (Map.Entry<String, Long> entry : candidateTestSuiteStaleDurations.entrySet()) {
            String testSuiteName = entry.getKey();
            if (!latestTestSuiteStartTimes.containsKey(testSuiteName)) {
                this._selectedTestSuiteNames.add(testSuiteName);
                continue;
            }
            Long testSuiteIdleDuration = startTime - latestTestSuiteStartTimes.get(testSuiteName);
            if (testSuiteIdleDuration <= entry.getValue()) continue;
            this._selectedTestSuiteNames.add(testSuiteName);
        }
        return this._selectedTestSuiteNames;
    }

    private String _getTestrayBuildType(String testSuite) {
        try {
            Properties buildProperties = JenkinsResultsParserUtil.getBuildProperties();
            PortalTestSuiteUpstreamControllerBuildData buildData = (PortalTestSuiteUpstreamControllerBuildData)this.getBuildData();
            return buildProperties.getProperty(JenkinsResultsParserUtil.combine("portal.testsuite.upstream.testray.build.type[", buildData.getPortalUpstreamBranchName(), "][", testSuite, "]"));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private String _getTestrayProjectName(String testSuite) {
        try {
            Properties buildProperties = JenkinsResultsParserUtil.getBuildProperties();
            PortalTestSuiteUpstreamControllerBuildData buildData = (PortalTestSuiteUpstreamControllerBuildData)this.getBuildData();
            return buildProperties.getProperty(JenkinsResultsParserUtil.combine("portal.testsuite.upstream.testray.project.name[", buildData.getPortalUpstreamBranchName(), "][", testSuite, "]"));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private List<String> _getTestSuiteNames() {
        PortalTestSuiteUpstreamControllerBuildData buildData = (PortalTestSuiteUpstreamControllerBuildData)this.getBuildData();
        try {
            return JenkinsResultsParserUtil.getBuildPropertyAsList(true, JenkinsResultsParserUtil.combine("portal.testsuite.upstream.suites[", buildData.getPortalUpstreamBranchName(), "]"));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }
}

