/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalTopLevelBuildData;
import com.liferay.jenkins.results.parser.RemoteGitRef;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PortalTestSuiteUpstreamControllerBuildData
extends PortalTopLevelBuildData {
    private static final Pattern _jobNamePattern = Pattern.compile("[^\\(]+\\((?<upstreamBranchName>[^_\\)]+)(_(?<testSuiteName>[^\\)]+))?\\)");

    public String getPortalGitHubCompareURL(String previousPortalBranchSHA) {
        if (previousPortalBranchSHA == null || !previousPortalBranchSHA.matches("[0-9a-f]{40}")) {
            return null;
        }
        return JenkinsResultsParserUtil.combine("https://github.com/", this.getPortalGitHubUsername(), "/", this.getPortalGitHubRepositoryName(), "/compare/", previousPortalBranchSHA, "...", this.getPortalBranchSHA());
    }

    public String getTestrayBuildName() {
        String testrayProjectName = this.getTestrayProjectName();
        if (testrayProjectName == null) {
            return null;
        }
        return JenkinsResultsParserUtil.combine(this.getTestrayBuildType(), " - ", String.valueOf(this.getBuildNumber()), " - ", JenkinsResultsParserUtil.toDateString(new Date(this.getStartTime()), "yyyy-MM-dd[HH:mm:ss]", "America/Los_Angeles"));
    }

    public String getTestrayBuildType() {
        String testrayProjectName = this.getTestrayProjectName();
        if (testrayProjectName == null) {
            return null;
        }
        return JenkinsResultsParserUtil.combine("[", this.getPortalUpstreamBranchName(), "] ci:test:", this.getTestSuiteName());
    }

    public String getTestrayProjectName() {
        String testrayProjectName = System.getenv("TESTRAY_PROJECT_NAME");
        if (testrayProjectName != null && !testrayProjectName.isEmpty()) {
            return testrayProjectName;
        }
        return null;
    }

    public String getTestSuiteName() {
        String jobName = this.getJobName();
        Matcher matcher = _jobNamePattern.matcher(jobName);
        if (!matcher.find()) {
            throw new RuntimeException("Invalid job name " + jobName);
        }
        String testSuiteName = matcher.group("testSuiteName");
        if (testSuiteName == null) {
            testSuiteName = "default";
        }
        return testSuiteName;
    }

    protected PortalTestSuiteUpstreamControllerBuildData(String runID, String jobName, String buildURL) {
        super(runID, jobName, buildURL);
        this.setPortalBranchSHA(this._getPortalBranchSHA());
        this.setPortalGitHubURL(this._getPortalGitHubURL());
        this.setPortalUpstreamBranchName(this._getPortalUpstreamBranchName());
        String jenkinsGitHubURL = this.getBuildParameter("JENKINS_GITHUB_URL");
        if (jenkinsGitHubURL != null && !jenkinsGitHubURL.isEmpty()) {
            this.setJenkinsGitHubURL(jenkinsGitHubURL);
        }
    }

    private String _getPortalBranchSHA() {
        RemoteGitRef remoteGitRef = GitUtil.getRemoteGitRef(this._getPortalGitHubURL());
        return remoteGitRef.getSHA();
    }

    private String _getPortalGitHubURL() {
        String portalGitHubURL = System.getenv("PORTAL_GITHUB_URL");
        if (portalGitHubURL != null && !portalGitHubURL.isEmpty()) {
            return portalGitHubURL;
        }
        return JenkinsResultsParserUtil.combine("https://github.com/liferay/", this._getPortalRepositoryName(), "/tree/", this._getPortalUpstreamBranchName());
    }

    private String _getPortalRepositoryName() {
        String upstreamBranchName = this._getPortalUpstreamBranchName();
        if (upstreamBranchName.equals("master")) {
            return "liferay-portal";
        }
        return "liferay-portal-ee";
    }

    private String _getPortalUpstreamBranchName() {
        String jobName = this.getJobName();
        Matcher matcher = _jobNamePattern.matcher(jobName);
        if (!matcher.find()) {
            throw new RuntimeException("Invalid job name " + jobName);
        }
        return matcher.group("upstreamBranchName");
    }
}

