/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PortalRelease {
    private static final String[] _BASE_URL_STRINGS = new String[]{"http://mirrors.lax.liferay.com/releases.liferay.com/portal", "http://mirrors.lax.liferay.com/files.liferay.com/private/ee/portal", "https://releases.liferay.com/portal", "https://files.liferay.com/private/ee/portal"};
    private static final String _PORTAL_VERSION_REGEX = "(?<portalVersion>\\d\\.([\\d\\.]+)(\\-\\w\\w\\d?)?)";
    private static final Pattern _bundleFileNamePattern = Pattern.compile(".+\\-(?<portalVersion>\\d\\.([\\d\\.]+)(\\-\\w\\w\\d?)?).+\\.(7z|tar.gz|zip)");
    private static final Pattern _bundlesBaseURLPattern = Pattern.compile("https?://.+/(?<portalVersion>\\d\\.([\\d\\.]+)(\\-\\w\\w\\d?)?)");
    private static final Pattern _bundleURLPattern = Pattern.compile("(?<bundlesBaseURL>https?://.+)/(?<bundleFileName>[^\\/]+\\.(7z|tar.gz|zip))");
    private static final Pattern _dependenciesFileNamePattern = Pattern.compile("href=\\\"(?<fileName>liferay-[^\\\"]+-dependencies-[^\\\"]+\\.zip)\\\"");
    private static final Pattern _glassFishFileNamePattern = Pattern.compile("href=\\\"(?<fileName>liferay-[^\\\"]+-glassfish-[^\\\"]+\\.(7z|zip))\\\"");
    private static final Pattern _jbossFileNamePattern = Pattern.compile("href=\\\"(?<fileName>liferay-[^\\\"]+-jboss-[^\\\"]+\\.(7z|zip))\\\"");
    private static final Pattern _osgiFileNamePattern = Pattern.compile("href=\\\"(?<fileName>liferay-[^\\\"]+-osgi-[^\\\"]+\\.zip)\\\"");
    private static final Pattern _portalWarFileNamePattern = Pattern.compile("href=\\\"(?<fileName>liferay-[^\\\"]+-portal-[^\\\"]+\\.war)\\\"");
    private static final Pattern _sqlFileNamePattern = Pattern.compile("href=\\\"(?<fileName>liferay-[^\\\"]+-sql-[^\\\"]+\\.zip)\\\"");
    private static final Pattern _tomcatFileNamePattern = Pattern.compile("href=\\\"(?<fileName>liferay-[^\\\"]+-tomcat-[^\\\"]+\\.(7z|zip))\\\"");
    private static final Pattern _toolsFileNamePattern = Pattern.compile("href=\\\"(?<fileName>liferay-[^\\\"]+-tools-[^\\\"]+\\.zip)\\\"");
    private static final Pattern _wildFlyFileNamePattern = Pattern.compile("href=\\\"(?<fileName>liferay-[^\\\"]+-wildfly-[^\\\"]+\\.(7z|zip))\\\"");
    private final String _bundlesBaseURLContent;
    private final String _bundlesBaseURLString;
    private final String _portalVersion;

    public PortalRelease(String portalVersion) {
        this._portalVersion = portalVersion;
        String bundlesBaseURLContent = null;
        String bundlesBaseURLString = null;
        for (String baseURLString : _BASE_URL_STRINGS) {
            bundlesBaseURLString = baseURLString + "/" + this._portalVersion;
            try {
                bundlesBaseURLContent = JenkinsResultsParserUtil.toString(bundlesBaseURLString + "/", true, 0, 5, 0);
                break;
            }
            catch (IOException iOException) {
            }
        }
        if (bundlesBaseURLString == null || bundlesBaseURLContent == null) {
            throw new RuntimeException("Invalid portal version " + portalVersion);
        }
        this._bundlesBaseURLContent = bundlesBaseURLContent;
        this._bundlesBaseURLString = this._getNonMirrorsURLString(bundlesBaseURLString);
    }

    public PortalRelease(URL bundleURL) {
        String[] bundlesBaseURLStrings;
        Matcher bundleURLMatcher = _bundleURLPattern.matcher(bundleURL.toString());
        if (!bundleURLMatcher.find()) {
            throw new RuntimeException("Invalid URL " + bundleURL);
        }
        String portalVersion = null;
        String bundlesBaseURLString = bundleURLMatcher.group("bundlesBaseURL");
        Matcher bundlesBaseURLMatcher = _bundlesBaseURLPattern.matcher(bundlesBaseURLString);
        if (bundlesBaseURLMatcher.find()) {
            portalVersion = bundlesBaseURLMatcher.group("portalVersion");
        }
        if (portalVersion == null) {
            String bundleFileName = bundleURLMatcher.group("bundleFileName");
            Matcher bundleFileNameMatcher = _bundleFileNamePattern.matcher(bundleFileName);
            if (!bundleFileNameMatcher.find()) {
                throw new RuntimeException("Invalid bundle file name " + bundleFileName);
            }
            portalVersion = bundleFileNameMatcher.group("portalVersion");
        }
        this._portalVersion = portalVersion;
        String bundlesBaseURLContent = null;
        for (String bundlesBaseURLStringCandidate : bundlesBaseURLStrings = new String[]{bundlesBaseURLString, this._getMirrorsURLString(bundlesBaseURLString), JenkinsResultsParserUtil.getLocalURL(bundlesBaseURLString)}) {
            try {
                bundlesBaseURLContent = JenkinsResultsParserUtil.toString(bundlesBaseURLStringCandidate + "/", true, 0, 5, 0);
                break;
            }
            catch (IOException ioException) {
            }
        }
        if (bundlesBaseURLContent == null) {
            throw new RuntimeException("Invalid URL " + bundlesBaseURLString);
        }
        bundlesBaseURLString = JenkinsResultsParserUtil.getRemoteURL(bundlesBaseURLString);
        bundlesBaseURLString = this._getNonMirrorsURLString(bundlesBaseURLString);
        this._bundlesBaseURLContent = bundlesBaseURLContent;
        this._bundlesBaseURLString = bundlesBaseURLString;
    }

    public URL getDependenciesURL() {
        return this._getURL(_dependenciesFileNamePattern);
    }

    public URL getGlassFishURL() {
        return this._getURL(_glassFishFileNamePattern);
    }

    public String getHTMLReport() {
        URL[] urls;
        StringBuilder sb = new StringBuilder();
        sb.append("<ul>");
        for (URL url : urls = new URL[]{this.getDependenciesURL(), this.getGlassFishURL(), this.getJBossURL(), this.getOSGiURL(), this.getPortalWarURL(), this.getSQLURL(), this.getTomcatURL(), this.getToolsURL(), this.getWildFlyURL()}) {
            if (url == null) continue;
            String urlString = url.toString();
            sb.append("<li><a href=\"");
            sb.append(urlString);
            sb.append("\">");
            sb.append(urlString.replaceAll(".+/([^/]+)", "$1"));
            sb.append("</a></li>");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    public URL getJBossURL() {
        return this._getURL(_jbossFileNamePattern);
    }

    public URL getOSGiURL() {
        return this._getURL(_osgiFileNamePattern);
    }

    public String getPortalVersion() {
        return this._portalVersion;
    }

    public URL getPortalWarURL() {
        return this._getURL(_portalWarFileNamePattern);
    }

    public URL getSQLURL() {
        return this._getURL(_sqlFileNamePattern);
    }

    public URL getTomcatURL() {
        return this._getURL(_tomcatFileNamePattern);
    }

    public URL getToolsURL() {
        return this._getURL(_toolsFileNamePattern);
    }

    public URL getWildFlyURL() {
        return this._getURL(_wildFlyFileNamePattern);
    }

    private String _getMirrorsURLString(String urlString) {
        if (urlString == null) {
            throw new NullPointerException();
        }
        urlString = this._getNonMirrorsURLString(urlString);
        return urlString.replaceAll("https?:\\/\\/", "http://mirrors.lax.liferay.com/");
    }

    private String _getNonMirrorsURLString(String urlString) {
        urlString = urlString.replace("http://mirrors/", "https://");
        urlString = urlString.replace("http://mirrors.lax.liferay.com/", "https://");
        urlString = urlString.replace("https://release-1/1/", "http://release-1/1/");
        return urlString;
    }

    private URL _getURL(Pattern pattern) {
        Matcher matcher = pattern.matcher(this._bundlesBaseURLContent);
        if (!matcher.find()) {
            return null;
        }
        try {
            return new URL(this._getNonMirrorsURLString(this._bundlesBaseURLString + "/" + matcher.group("fileName")));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }
}

