/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitRepositoryJob;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import java.io.File;
import java.util.Set;

public abstract class PortalGitRepositoryJob
extends GitRepositoryJob
implements PortalTestClassJob {
    @Override
    public Set<String> getDistTypes() {
        String testBatchDistAppServers = JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "test.batch.dist.app.servers");
        return this.getSetFromString(testBatchDistAppServers);
    }

    @Override
    public PortalGitWorkingDirectory getPortalGitWorkingDirectory() {
        GitWorkingDirectory gitWorkingDirectory = this.getGitWorkingDirectory();
        if (!(gitWorkingDirectory instanceof PortalGitWorkingDirectory)) {
            throw new RuntimeException("Invalid portal Git working directory");
        }
        return (PortalGitWorkingDirectory)gitWorkingDirectory;
    }

    protected PortalGitRepositoryJob(String jobName, Job.BuildProfile buildProfile) {
        super(jobName, buildProfile);
        this.gitWorkingDirectory = this.getNewGitWorkingDirectory();
        this.setGitRepositoryDir(this.gitWorkingDirectory.getWorkingDirectory());
        this.checkGitRepositoryDir();
        this.jobPropertiesFiles.add(new File(this.gitRepositoryDir, "tools/sdk/build.properties"));
        this.jobPropertiesFiles.add(new File(this.gitRepositoryDir, "build.properties"));
        this.jobPropertiesFiles.add(new File(this.gitRepositoryDir, "test.properties"));
        this.readJobProperties();
    }

    protected GitWorkingDirectory getNewGitWorkingDirectory() {
        return GitWorkingDirectoryFactory.newPortalGitWorkingDirectory(this.getBranchName());
    }

    @Override
    protected Set<String> getRawBatchNames() {
        return this.getSetFromString(JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "test.batch.names"));
    }
}

