/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BatchBuildData;
import com.liferay.jenkins.results.parser.BatchBuildRunner;
import com.liferay.jenkins.results.parser.PortalBatchBuildData;
import com.liferay.jenkins.results.parser.PortalWorkspace;
import com.liferay.jenkins.results.parser.TestBatch;
import com.liferay.jenkins.results.parser.TestBatchFactory;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceFactory;
import java.io.File;

public abstract class PortalBatchBuildRunner<T extends PortalBatchBuildData, S extends PortalWorkspace>
extends BatchBuildRunner<T, S> {
    @Override
    public void run() {
        this.updateBuildDescription();
        this.setUpWorkspace();
        this.runTestBatch();
        this.publishArtifacts();
        this.updateBuildDescription();
    }

    protected PortalBatchBuildRunner(T portalBatchBuildData) {
        super(portalBatchBuildData);
    }

    @Override
    protected void initWorkspace() {
        PortalBatchBuildData portalBatchBuildData = (PortalBatchBuildData)this.getBuildData();
        Workspace batchWorkspace = WorkspaceFactory.newBatchWorkspace(portalBatchBuildData.getPortalGitHubURL(), portalBatchBuildData.getPortalUpstreamBranchName(), portalBatchBuildData.getBatchName(), portalBatchBuildData.getPortalBranchSHA());
        if (!(batchWorkspace instanceof PortalWorkspace)) {
            throw new RuntimeException("Invalid workspace");
        }
        this.setWorkspace((PortalWorkspace)batchWorkspace);
    }

    protected void publishArtifacts() {
        PortalBatchBuildData portalBatchBuildData = (PortalBatchBuildData)this.getBuildData();
        File artifactDir = portalBatchBuildData.getArtifactDir();
        if (artifactDir.exists()) {
            this.publishToUserContentDir(artifactDir);
        }
    }

    protected void runTestBatch() {
        TestBatch testBatch = TestBatchFactory.newTestBatch((BatchBuildData)this.getBuildData(), this.getWorkspace());
        testBatch.run();
    }
}

