/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseBatchBuildData;
import com.liferay.jenkins.results.parser.PortalBuildData;
import com.liferay.jenkins.results.parser.PortalTopLevelBuildData;
import com.liferay.jenkins.results.parser.TopLevelBuildData;
import java.util.Arrays;
import java.util.List;
import org.json.JSONObject;

public class PortalBatchBuildData
extends BaseBatchBuildData
implements PortalBuildData {
    private static final String _TYPE = "portal_batch";
    private static final List<String> _forbiddenKeys = Arrays.asList("portal_github_url", "portal_upstream_branch_name");

    public static boolean isValidJSONObject(JSONObject jsonObject) {
        return PortalBatchBuildData.isValidJSONObject(jsonObject, _TYPE);
    }

    @Override
    public String getPortalBranchSHA() {
        return this.optString("portal_branch_sha");
    }

    @Override
    public String getPortalGitHubBranchName() {
        return this.getGitHubBranchName(this.getPortalGitHubURL());
    }

    @Override
    public String getPortalGitHubRepositoryName() {
        return this.getGitHubRepositoryName(this.getPortalGitHubURL());
    }

    @Override
    public String getPortalGitHubURL() {
        TopLevelBuildData topLevelBuildData = this.getTopLevelBuildData();
        if (!(topLevelBuildData instanceof PortalTopLevelBuildData)) {
            throw new RuntimeException("Invalid top level build data");
        }
        PortalTopLevelBuildData portalTopLevelBuildData = (PortalTopLevelBuildData)topLevelBuildData;
        return portalTopLevelBuildData.getPortalGitHubURL();
    }

    @Override
    public String getPortalGitHubUsername() {
        return this.getGitHubUsername(this.getPortalGitHubURL());
    }

    @Override
    public String getPortalUpstreamBranchName() {
        TopLevelBuildData topLevelBuildData = this.getTopLevelBuildData();
        if (!(topLevelBuildData instanceof PortalTopLevelBuildData)) {
            throw new RuntimeException("Invalid top level build data");
        }
        PortalTopLevelBuildData portalTopLevelBuildData = (PortalTopLevelBuildData)topLevelBuildData;
        return portalTopLevelBuildData.getPortalUpstreamBranchName();
    }

    @Override
    public void put(String key, Object value) {
        if (_forbiddenKeys.contains(key)) {
            throw new IllegalArgumentException(key + " may not be set");
        }
        super.put(key, value);
    }

    @Override
    public void setPortalBranchSHA(String portalBranchSHA) {
        this.put("portal_branch_sha", portalBranchSHA);
    }

    @Override
    public void setPortalGitHubURL(String portalGitHubURL) {
        this.put("portal_github_url", portalGitHubURL);
    }

    @Override
    public void setPortalUpstreamBranchName(String portalUpstreamBranchName) {
        this.put("portal_upstream_branch_name", portalUpstreamBranchName);
    }

    protected PortalBatchBuildData(String runID, String jobName, String buildURL) {
        super(runID, jobName, buildURL);
    }

    @Override
    protected String getType() {
        return _TYPE;
    }
}

