/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BatchDependentJob;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalGitRepositoryJob;
import com.liferay.jenkins.results.parser.TestSuiteJob;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.SegmentTestClassGroup;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public abstract class PortalAcceptanceTestSuiteJob
extends PortalGitRepositoryJob
implements BatchDependentJob,
TestSuiteJob {
    private final String _testSuiteName;

    public PortalAcceptanceTestSuiteJob(String jobName, Job.BuildProfile buildProfile) {
        this(jobName, buildProfile, null);
    }

    public PortalAcceptanceTestSuiteJob(String jobName, Job.BuildProfile buildProfile, String testSuiteName) {
        super(jobName, buildProfile);
        if (testSuiteName == null) {
            testSuiteName = "default";
        }
        this._testSuiteName = testSuiteName;
    }

    @Override
    public Set<String> getDependentBatchNames() {
        return this.getFilteredBatchNames(this.getRawDependentBatchNames());
    }

    @Override
    public List<BatchTestClassGroup> getDependentBatchTestClassGroups() {
        return this.getBatchTestClassGroups(this.getRawDependentBatchNames());
    }

    @Override
    public Set<String> getDependentSegmentNames() {
        return this.getFilteredSegmentNames(this.getRawDependentBatchNames());
    }

    @Override
    public List<SegmentTestClassGroup> getDependentSegmentTestClassGroups() {
        return this.getSegmentTestClassGroups(this.getRawDependentBatchNames());
    }

    @Override
    public Set<String> getDistTypes() {
        Properties jobProperties = this.getJobProperties();
        String testBatchDistAppServers = JenkinsResultsParserUtil.getProperty(jobProperties, "test.batch.dist.app.servers[" + this._testSuiteName + "]");
        if (testBatchDistAppServers == null) {
            testBatchDistAppServers = JenkinsResultsParserUtil.getProperty(jobProperties, "test.batch.dist.app.servers");
        }
        Set<String> testBatchDistAppServersSet = this.getSetFromString(testBatchDistAppServers);
        if (!this._testSuiteName.equals("relevant")) {
            return testBatchDistAppServersSet;
        }
        String stableTestBatchDistAppServers = JenkinsResultsParserUtil.getProperty(jobProperties, "test.batch.dist.app.servers[stable]");
        if (stableTestBatchDistAppServers != null) {
            testBatchDistAppServersSet.addAll(this.getSetFromString(stableTestBatchDistAppServers));
        }
        return testBatchDistAppServersSet;
    }

    @Override
    public String getTestSuiteName() {
        return this._testSuiteName;
    }

    @Override
    protected Set<String> getRawBatchNames() {
        Properties jobProperties = this.getJobProperties();
        String testBatchNames = JenkinsResultsParserUtil.getProperty(jobProperties, "test.batch.names[" + this._testSuiteName + "]");
        if (testBatchNames == null) {
            testBatchNames = JenkinsResultsParserUtil.getProperty(jobProperties, "test.batch.names");
        }
        Set<String> batchNames = this.getSetFromString(testBatchNames);
        if (!this._testSuiteName.equals("relevant")) {
            return batchNames;
        }
        String stableTestBatchNames = JenkinsResultsParserUtil.getProperty(jobProperties, "test.batch.names[stable]");
        if (stableTestBatchNames != null) {
            batchNames.addAll(this.getSetFromString(stableTestBatchNames));
        }
        return batchNames;
    }

    protected Set<String> getRawDependentBatchNames() {
        String dependentBatchNames = JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "test.batch.names.smoke", this.getBranchName(), this.getTestSuiteName());
        if (dependentBatchNames == null || dependentBatchNames.isEmpty()) {
            return new HashSet<String>();
        }
        return this.getSetFromString(dependentBatchNames);
    }
}

