/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MethodLogger
implements InvocationHandler {
    private final Logger _logger;
    private final Object _object;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        this._logger.log(Level.INFO, JenkinsResultsParserUtil.combine("Starting ", this._getClassMethodName(method)));
        long start = System.currentTimeMillis();
        try {
            result = method.invoke(this._object, args);
        }
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (Throwable throwable2) {
                String duration = JenkinsResultsParserUtil.toDurationString(System.currentTimeMillis() - start);
                this._logger.log(Level.INFO, JenkinsResultsParserUtil.combine("Completed ", this._getClassMethodName(method), " in ", duration, ".\n"));
                throw throwable2;
            }
        }
        String duration = JenkinsResultsParserUtil.toDurationString(System.currentTimeMillis() - start);
        this._logger.log(Level.INFO, JenkinsResultsParserUtil.combine("Completed ", this._getClassMethodName(method), " in ", duration, ".\n"));
        return result;
    }

    protected MethodLogger(Object object) {
        Class<?> clazz = this.getClass();
        this._logger = Logger.getLogger(clazz.getName());
        this._object = object;
    }

    private String _getClassMethodName(Method method) {
        Class<?> clazz = this._object.getClass();
        return clazz.getSimpleName() + "." + method.getName();
    }
}

