/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BuildData;
import com.liferay.jenkins.results.parser.CentralMergePullRequestJob;
import com.liferay.jenkins.results.parser.DefaultPortalJob;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PluginsGitRepositoryJob;
import com.liferay.jenkins.results.parser.PortalAcceptancePullRequestJob;
import com.liferay.jenkins.results.parser.PortalAcceptanceUpstreamJob;
import com.liferay.jenkins.results.parser.PortalBuildData;
import com.liferay.jenkins.results.parser.PortalFixpackReleaseJob;
import com.liferay.jenkins.results.parser.PortalGitRepositoryJob;
import com.liferay.jenkins.results.parser.PortalHotfixReleaseJob;
import com.liferay.jenkins.results.parser.PortalReleaseJob;
import com.liferay.jenkins.results.parser.PortalTestSuiteUpstreamJob;
import com.liferay.jenkins.results.parser.PortalUpstreamJob;
import com.liferay.jenkins.results.parser.RootCauseAnalysisToolBatchJob;
import com.liferay.jenkins.results.parser.RootCauseAnalysisToolJob;
import com.liferay.jenkins.results.parser.SimpleJob;
import com.liferay.jenkins.results.parser.SubrepositoryAcceptancePullRequestJob;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JobFactory {
    private static final Map<String, Job> _jobs = new HashMap<String, Job>();

    public static Job newJob(BuildData buildData) {
        String portalUpstreamBranchName = null;
        if (buildData instanceof PortalBuildData) {
            PortalBuildData portalBuildData = (PortalBuildData)buildData;
            portalUpstreamBranchName = portalBuildData.getPortalUpstreamBranchName();
        }
        return JobFactory._newJob(buildData.getJobName(), null, portalUpstreamBranchName, null, null);
    }

    public static Job newJob(String jobName) {
        return JobFactory._newJob(jobName, null, null, null, null);
    }

    public static Job newJob(String jobName, String testSuiteName) {
        return JobFactory._newJob(jobName, testSuiteName, null, null, null);
    }

    public static Job newJob(String jobName, String testSuiteName, String portalBranchName) {
        return JobFactory._newJob(jobName, testSuiteName, portalBranchName, null, null);
    }

    public static Job newJob(String jobName, String testSuiteName, String portalBranchName, String repositoryName) {
        return JobFactory._newJob(jobName, testSuiteName, portalBranchName, repositoryName, null);
    }

    public static Job newJob(String jobName, String testSuiteName, String portalBranchName, String repositoryName, Job.BuildProfile buildProfile) {
        return JobFactory._newJob(jobName, testSuiteName, portalBranchName, repositoryName, buildProfile);
    }

    private static boolean _isCentralMergePullRequest(GitWorkingDirectory gitWorkingDirectory) {
        File modifiedFile;
        String modifiedFileName;
        List<File> currentBranchModifiedFiles = gitWorkingDirectory.getModifiedFilesList();
        return currentBranchModifiedFiles.size() == 1 && (modifiedFileName = (modifiedFile = currentBranchModifiedFiles.get(0)).getName()).equals("ci-merge");
    }

    private static Job _newJob(String jobName, String testSuiteName, String portalBranchName, String repositoryName, Job.BuildProfile buildProfile) {
        Job job;
        if (buildProfile == null) {
            buildProfile = Job.BuildProfile.PORTAL;
        }
        String jobKey = JenkinsResultsParserUtil.combine(jobName, "-", buildProfile.toString());
        if (testSuiteName != null && !testSuiteName.isEmpty()) {
            jobKey = JenkinsResultsParserUtil.combine(jobName, "-", testSuiteName);
        }
        if ((job = _jobs.get(jobKey)) != null) {
            return job;
        }
        if (jobName.equals("js-test-csv-report") || jobName.equals("junit-test-csv-report")) {
            PortalGitRepositoryJob portalGitRepositoryJob = new PortalGitRepositoryJob(jobName, buildProfile){

                @Override
                protected GitWorkingDirectory getNewGitWorkingDirectory() {
                    return GitWorkingDirectoryFactory.newGitWorkingDirectory(this.getBranchName(), System.getProperty("user.dir"));
                }
            };
            _jobs.put(jobKey, portalGitRepositoryJob);
            return _jobs.get(jobKey);
        }
        if (jobName.equals("root-cause-analysis-tool")) {
            _jobs.put(jobKey, new RootCauseAnalysisToolJob(jobName, buildProfile, portalBranchName));
            return _jobs.get(jobKey);
        }
        if (jobName.equals("root-cause-analysis-tool-batch")) {
            _jobs.put(jobKey, new RootCauseAnalysisToolBatchJob(jobName, buildProfile, portalBranchName));
            return _jobs.get(jobKey);
        }
        if (jobName.startsWith("test-plugins-acceptance-pullrequest(")) {
            PluginsGitRepositoryJob pluginsGitRepositoryJob = new PluginsGitRepositoryJob(jobName, buildProfile);
            _jobs.put(jobKey, pluginsGitRepositoryJob);
            return pluginsGitRepositoryJob;
        }
        if (jobName.startsWith("test-portal-acceptance-pullrequest(")) {
            PortalAcceptancePullRequestJob portalAcceptancePullRequestJob = new PortalAcceptancePullRequestJob(jobName, buildProfile, testSuiteName);
            if (JobFactory._isCentralMergePullRequest(portalAcceptancePullRequestJob.getGitWorkingDirectory())) {
                portalAcceptancePullRequestJob = new CentralMergePullRequestJob(jobName, buildProfile);
            }
            _jobs.put(jobKey, portalAcceptancePullRequestJob);
            return portalAcceptancePullRequestJob;
        }
        if (jobName.startsWith("test-portal-acceptance-upstream")) {
            _jobs.put(jobKey, new PortalAcceptanceUpstreamJob(jobName, buildProfile, testSuiteName));
            return _jobs.get(jobKey);
        }
        if (jobName.equals("test-portal-fixpack-release")) {
            _jobs.put(jobKey, new PortalFixpackReleaseJob(jobName, buildProfile, portalBranchName, testSuiteName));
            return _jobs.get(jobKey);
        }
        if (jobName.equals("test-portal-hotfix-release")) {
            _jobs.put(jobKey, new PortalHotfixReleaseJob(jobName, buildProfile, portalBranchName, testSuiteName));
            return _jobs.get(jobKey);
        }
        if (jobName.equals("test-portal-release")) {
            _jobs.put(jobKey, new PortalReleaseJob(jobName, buildProfile, portalBranchName, testSuiteName));
            return _jobs.get(jobKey);
        }
        if (jobName.startsWith("test-portal-testsuite-upstream(")) {
            _jobs.put(jobKey, new PortalTestSuiteUpstreamJob(jobName, buildProfile, testSuiteName));
            return _jobs.get(jobKey);
        }
        if (jobName.startsWith("test-portal-testsuite-upstream-controller(")) {
            _jobs.put(jobKey, new SimpleJob(jobName, buildProfile));
            return _jobs.get(jobKey);
        }
        if (jobName.startsWith("test-portal-upstream(")) {
            _jobs.put(jobKey, new PortalUpstreamJob(jobName, buildProfile));
            return _jobs.get(jobKey);
        }
        if (jobName.startsWith("test-subrepository-acceptance-pullrequest(")) {
            _jobs.put(jobKey, new SubrepositoryAcceptancePullRequestJob(jobName, buildProfile, testSuiteName, repositoryName));
            return _jobs.get(jobKey);
        }
        _jobs.put(jobKey, new DefaultPortalJob(jobName, buildProfile, testSuiteName));
        return _jobs.get(jobKey);
    }
}

