/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONObject;

public class JenkinsStopBuildUtil {
    private static final Pattern _buildURLPattern = Pattern.compile(".+://(?<hostName>[^.]+)(.liferay.com)?/job/(?<jobName>[^/]+).*/(?<buildNumber>\\d+)/");
    private static final Pattern _progressiveTextPattern = Pattern.compile("Build \\'.*\\' started at (?<url>.+)\\.");

    public static void stopBuild(String buildURL, String username, String password) throws Exception {
        JenkinsStopBuildUtil._stopDownstreamBuilds(buildURL, username, password);
        JenkinsStopBuildUtil._stopBuild(buildURL, username, password);
    }

    public static void stopBuild(TopLevelBuild topLevelBuild, String username, String password) throws Exception {
        JenkinsStopBuildUtil.stopDownstreamBuilds(topLevelBuild, username, password);
        JenkinsStopBuildUtil._stopBuild(topLevelBuild, username, password);
    }

    public static void stopDownstreamBuilds(TopLevelBuild topLevelBuild, String username, String password) throws Exception {
        List<Build> downstreamBuilds = topLevelBuild.getDownstreamBuilds("running");
        for (Build downstreamBuild : downstreamBuilds) {
            JenkinsStopBuildUtil._stopBuild(downstreamBuild, username, password);
        }
    }

    protected static String encodeAuthorizationFields(String username, String password) {
        String authorizationString = username + ":" + password;
        return new String(Base64.encodeBase64((byte[])authorizationString.getBytes()));
    }

    private static List<String> _getDownstreamURLs(String buildURL) throws Exception {
        ArrayList<String> downstreamURLs = new ArrayList<String>();
        String consoleOutput = JenkinsResultsParserUtil.toString(JenkinsResultsParserUtil.getLocalURL(buildURL + "/logText/progressiveText"));
        Matcher progressiveTextMatcher = _progressiveTextPattern.matcher(consoleOutput);
        while (progressiveTextMatcher.find()) {
            String urlString = progressiveTextMatcher.group("url");
            Matcher buildURLMatcher = _buildURLPattern.matcher(urlString);
            if (!buildURLMatcher.find()) continue;
            downstreamURLs.add(urlString);
        }
        return downstreamURLs;
    }

    private static void _stopBuild(Build build, String username, String password) throws Exception {
        JenkinsStopBuildUtil._stopBuild(build.getBuildURL(), username, password);
    }

    private static void _stopBuild(String buildURL, String username, String password) throws Exception {
        String normalizedBuildURL = JenkinsResultsParserUtil.fixURL(JenkinsResultsParserUtil.getLocalURL(buildURL));
        JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(normalizedBuildURL + "/api/json?tree=result", false);
        if (jsonObject.has("result") && jsonObject.isNull("result")) {
            URL urlObject = new URL(normalizedBuildURL + "/stop");
            HttpURLConnection httpConnection = (HttpURLConnection)urlObject.openConnection();
            httpConnection.setRequestMethod("POST");
            httpConnection.setRequestProperty("Authorization", "Basic " + JenkinsStopBuildUtil.encodeAuthorizationFields(username, password));
            System.out.println("Response from " + urlObject.toString() + ": " + httpConnection.getResponseCode() + " " + httpConnection.getResponseMessage());
        }
    }

    private static void _stopDownstreamBuilds(String buildURL, String username, String password) throws Exception {
        List<String> downstreamURLs = JenkinsStopBuildUtil._getDownstreamURLs(buildURL);
        for (String downstreamURL : downstreamURLs) {
            JenkinsStopBuildUtil._stopBuild(downstreamURL, username, password);
        }
    }
}

