/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.BuildFactory;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsNode;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONObject;

public class JenkinsSlave
implements JenkinsNode<JenkinsSlave> {
    private boolean _idle;
    private final JenkinsMaster _jenkinsMaster;
    private final String _name;
    private boolean _offline;

    public JenkinsSlave() {
        this(JenkinsResultsParserUtil.getHostName(JenkinsResultsParserUtil.getHostIPAddress()));
    }

    public JenkinsSlave(String hostname) {
        hostname = hostname.replaceAll("([^\\.]+).*", "$1");
        String jenkinsMasterName = JenkinsResultsParserUtil.getJenkinsMasterName(hostname);
        if (jenkinsMasterName == null) {
            throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to find Jenkins master name for Jenkins slave ", "hostname ", hostname));
        }
        this._jenkinsMaster = new JenkinsMaster(jenkinsMasterName);
        String jenkinsSlaveJSONObjectURL = JenkinsResultsParserUtil.getLocalURL(JenkinsResultsParserUtil.combine(this._jenkinsMaster.getURL(), "/computer/", hostname, "/api/json?tree=displayName,", "idle,offline"));
        JSONObject jenkinsSlaveJSONObject = null;
        try {
            jenkinsSlaveJSONObject = JenkinsResultsParserUtil.toJSONObject(jenkinsSlaveJSONObjectURL, false);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to retrieve Jenkins slave node JSON object from " + jenkinsSlaveJSONObjectURL, ioException);
        }
        this._name = jenkinsSlaveJSONObject.getString("displayName");
        this.update(jenkinsSlaveJSONObject);
    }

    @Override
    public int compareTo(JenkinsSlave jenkinsSlave) {
        return this._name.compareTo(jenkinsSlave.getName());
    }

    public boolean equals(Object object) {
        if (object instanceof JenkinsSlave) {
            JenkinsSlave jenkinsSlave = (JenkinsSlave)object;
            return this.compareTo(jenkinsSlave) == 0;
        }
        return super.equals(object);
    }

    public Build getCurrentBuild() {
        JSONObject jsonObject = null;
        String jsonObjectURL = JenkinsResultsParserUtil.combine(this._jenkinsMaster.getURL(), "computer/", this.getName(), "/api/json?tree=executors[currentExecutable[url]]");
        try {
            jsonObject = JenkinsResultsParserUtil.toJSONObject(jsonObjectURL, false);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to determine current build", ioException);
        }
        JSONArray jsonArray = jsonObject.getJSONArray("executors");
        jsonObject = jsonArray.getJSONObject(0);
        JSONObject currentExecutableJSONObject = jsonObject.getJSONObject("currentExecutable");
        String buildURL = currentExecutableJSONObject.optString("url");
        if (buildURL == null) {
            return null;
        }
        return BuildFactory.newBuild(buildURL, null);
    }

    @Override
    public JenkinsMaster getJenkinsMaster() {
        return this._jenkinsMaster;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public int hashCode() {
        String hashCodeString = this._jenkinsMaster.getName() + "_" + this._name;
        return hashCodeString.hashCode();
    }

    public boolean isIdle() {
        return this._idle;
    }

    public boolean isOffline() {
        return this._offline;
    }

    public boolean isReachable() {
        return JenkinsResultsParserUtil.isReachable(this.getName());
    }

    public void takeSlavesOffline(String offlineReason) {
        this._setSlaveStatus(offlineReason, true);
    }

    public void takeSlavesOnline(String offlineReason) {
        this._setSlaveStatus(offlineReason, false);
    }

    public String toString() {
        return this.getName();
    }

    public void update() {
        this._jenkinsMaster.update();
    }

    protected JenkinsSlave(JenkinsMaster jenkinsMaster, JSONObject jenkinsSlaveJSONObject) {
        this._jenkinsMaster = jenkinsMaster;
        this._name = jenkinsSlaveJSONObject.getString("displayName");
        this.update(jenkinsSlaveJSONObject);
    }

    protected void update(JSONObject jenkinsSlaveJSONObject) {
        this._idle = jenkinsSlaveJSONObject.getBoolean("idle");
        this._offline = jenkinsSlaveJSONObject.getBoolean("offline");
    }

    private void _setSlaveStatus(String offlineReason, boolean offlineStatus) {
        try {
            Class<JenkinsSlave> clazz = JenkinsSlave.class;
            String script = JenkinsResultsParserUtil.readInputStream(clazz.getResourceAsStream("dependencies/set-slave-status.groovy"));
            script = script.replace("${slaves}", this._name);
            script = script.replace("${offline.reason}", offlineReason.replaceAll("\n", "<br />\\\\n"));
            script = script.replace("${offline.status}", String.valueOf(offlineStatus));
            JenkinsResultsParserUtil.executeJenkinsScript(this._jenkinsMaster.getName(), script);
        }
        catch (IOException ioException) {
            System.out.println("Unable to set the status for slaves: " + this._name);
            ioException.printStackTrace();
        }
    }
}

