/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.google.common.collect.Lists;
import com.google.common.io.CountingInputStream;
import com.liferay.jenkins.results.parser.BufferedProcess;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.GitRepositoryFactory;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsSlave;
import com.liferay.jenkins.results.parser.LoadBalancerUtil;
import com.liferay.jenkins.results.parser.LocalGitRepository;
import com.liferay.jenkins.results.parser.NotificationUtil;
import com.liferay.jenkins.results.parser.ParallelExecutor;
import com.liferay.jenkins.results.parser.Retryable;
import com.liferay.jenkins.results.parser.SecurePrintStream;
import com.liferay.jenkins.results.parser.spira.SpiraRelease;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.SystemUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class JenkinsResultsParserUtil {
    public static final String[] CACHED_REPOSITORIES = new String[]{"liferay-jenkins-ee", "liferay-jenkins-results-parser-samples-ee", "liferay-portal"};
    public static final String URL_CACHE = JenkinsResultsParserUtil.initCacheURL();
    public static final String[] URLS_BUILD_PROPERTIES_DEFAULT = new String[]{URL_CACHE + "/liferay-jenkins-ee/build.properties", URL_CACHE + "/liferay-jenkins-ee/commands/build.properties", URL_CACHE + "/liferay-portal/build.properties", URL_CACHE + "/liferay-portal/ci.properties", URL_CACHE + "/liferay-portal/test.properties"};
    public static final String[] URLS_JENKINS_PROPERTIES_DEFAULT = new String[]{URL_CACHE + "/liferay-jenkins-ee/jenkins.properties"};
    public static boolean debug;
    protected static final String URL_DEPENDENCIES_FILE;
    protected static final String URL_DEPENDENCIES_HTTP;
    private static final long _BYTES_GIGA = 0x40000000L;
    private static final long _BYTES_KILO = 1024L;
    private static final long _BYTES_MEGA = 0x100000L;
    private static final String _DIST_PORTAL_BUNDLE_FILE_NAMES_DEFAULT = "git-hash,liferay-portal-bundle-tomcat.tar.gz,liferay-portal-source.tar.gz";
    private static final String _DIST_PORTAL_BUNDLES_URL_DEFAULT = "http://test-1-0/userContent/bundles/test-portal-acceptance-upstream";
    private static final String _DIST_PORTAL_JOB_URL_DEFAULT = "http://test-1-1/job/test-portal-acceptance-upstream";
    private static final long _MILLIS_BASH_COMMAND_TIMEOUT_DEFAULT = 3600000L;
    private static final long _MILLIS_DAY = 86400000L;
    private static final long _MILLIS_HOUR = 3600000L;
    private static final long _MILLIS_MINUTE = 60000L;
    private static final long _MILLIS_SECOND = 1000L;
    private static final int _MILLIS_TIMEOUT_DEFAULT = 0;
    private static final String _PREFIX_TO_STRING_CACHE = "toStringCache-";
    private static final int _RETRIES_SIZE_MAX_DEFAULT = 3;
    private static final int _SECONDS_RETRY_PERIOD_DEFAULT = 5;
    private static final String _URL_LOAD_BALANCER = "http://cloud-10-0-0-31.lax.liferay.com/osb-jenkins-web/load_balancer";
    private static final Pattern _buildIDPattern;
    private static final Hashtable<Object, Object> _buildProperties;
    private static String[] _buildPropertiesURLs;
    private static final Pattern _curlyBraceExpansionPattern;
    private static final Pattern _javaVersionPattern;
    private static final Pattern _jenkinsMasterPattern;
    private static Hashtable<?, ?> _jenkinsProperties;
    private static final Pattern _jenkinsSlavesPropertyNamePattern;
    private static final Pattern _localURLAuthorityPattern1;
    private static final Pattern _localURLAuthorityPattern2;
    private static final Pattern _nestedPropertyPattern;
    private static final Pattern _propertyOptionPattern;
    private static final Set<String> _redactTokens;
    private static final Pattern _remoteURLAuthorityPattern1;
    private static final Pattern _remoteURLAuthorityPattern2;
    private static final File _sshDir;
    private static final Set<String> _timeStamps;
    private static final Pattern _topLevelBuildURLPattern;
    private static final File _userHomeDir;

    public static void append(File file, String content) throws IOException {
        File parentDir;
        if (debug) {
            System.out.println(JenkinsResultsParserUtil.combine("Append to file ", file.getPath(), " with length ", String.valueOf(content.length())));
        }
        if ((parentDir = file.getParentFile()) != null && !parentDir.exists()) {
            if (debug) {
                System.out.println("Make parent directories for " + file);
            }
            parentDir.mkdirs();
        }
        try (OutputStream outputStream = Files.newOutputStream(Paths.get(file.toURI()), StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
            outputStream.write(content.getBytes());
        }
    }

    public static void appendToCacheFile(String key, String content) {
        File cacheFile = JenkinsResultsParserUtil._getCacheFile(key);
        boolean cacheFileCreated = false;
        if (!cacheFile.exists()) {
            cacheFileCreated = true;
        }
        try {
            JenkinsResultsParserUtil.append(cacheFile, content);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to append to cache file", ioException);
        }
        if (cacheFileCreated) {
            System.out.println("Created cache file in " + cacheFile.getPath());
            cacheFile.deleteOnExit();
        }
    }

    public static void clearCache() {
        File cacheDirectory = new File(System.getProperty("java.io.tmpdir"), "jenkins-cached-files");
        System.out.println("Clearing cache " + JenkinsResultsParserUtil.getCanonicalPath(cacheDirectory));
        if (!cacheDirectory.exists()) {
            return;
        }
        JenkinsResultsParserUtil.delete(cacheDirectory);
    }

    public static String combine(String ... strings) {
        if (strings == null || strings.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String string : strings) {
            sb.append(string);
        }
        return sb.toString();
    }

    public static <T> List<T> concatenate(List<List<T>> lists, boolean allowDuplicates) {
        AbstractCollection concatenatedCollection = new ArrayList();
        if (!allowDuplicates) {
            concatenatedCollection = new HashSet();
        }
        for (List<T> list : lists) {
            concatenatedCollection.addAll(list);
        }
        return new ArrayList(concatenatedCollection);
    }

    public static void copy(File sourceFile, File targetFile) throws IOException {
        try {
            if (!sourceFile.exists()) {
                throw new FileNotFoundException(sourceFile.getPath() + " does not exist");
            }
            if (sourceFile.isDirectory()) {
                targetFile.mkdir();
                for (File file : sourceFile.listFiles()) {
                    JenkinsResultsParserUtil.copy(file, new File(targetFile, file.getName()));
                }
                return;
            }
            File parentFile = targetFile.getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            try (FileInputStream fileInputStream = new FileInputStream(sourceFile);
                 FileOutputStream fileOutputStream = new FileOutputStream(targetFile);){
                Files.copy(Paths.get(sourceFile.toURI()), fileOutputStream);
                fileOutputStream.flush();
            }
        }
        catch (IOException ioException) {
            if (targetFile.exists()) {
                JenkinsResultsParserUtil.delete(targetFile);
            }
            throw ioException;
        }
    }

    public static JSONArray createJSONArray(String jsonString) {
        jsonString = jsonString.trim();
        while (jsonString.startsWith("\ufeff")) {
            jsonString = jsonString.substring(1);
        }
        return new JSONArray(jsonString);
    }

    public static JSONObject createJSONObject(String jsonString) throws IOException {
        jsonString = jsonString.trim();
        while (jsonString.startsWith("\ufeff")) {
            jsonString = jsonString.substring(1);
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        if (jsonObject.isNull("duration") || jsonObject.isNull("result") || jsonObject.isNull("url")) {
            return jsonObject;
        }
        String url = jsonObject.getString("url");
        if (!url.contains("AXIS_VARIABLE")) {
            return jsonObject;
        }
        Object result = jsonObject.get("result");
        if (result instanceof JSONObject) {
            return jsonObject;
        }
        if (jsonObject.getInt("duration") == 0 && result.equals("FAILURE")) {
            jsonObject.putOpt("result", (Object)JenkinsResultsParserUtil.getActualResult(url));
        }
        return jsonObject;
    }

    public static URL createURL(String urlString) throws Exception {
        URL url = new URL(urlString);
        return JenkinsResultsParserUtil.encode(url);
    }

    public static String decode(String url) throws UnsupportedEncodingException {
        return URLDecoder.decode(url, "UTF-8");
    }

    public static boolean delete(File file) {
        if (!file.exists()) {
            System.out.println("Unable to delete because file does not exist " + file.getPath());
            return false;
        }
        boolean successful = true;
        if (file.isDirectory()) {
            for (File subfile : file.listFiles()) {
                if (successful) {
                    successful = JenkinsResultsParserUtil.delete(subfile);
                    continue;
                }
                JenkinsResultsParserUtil.delete(subfile);
            }
        }
        if (successful) {
            return file.delete();
        }
        return successful;
    }

    public static String encode(String url) throws MalformedURLException, URISyntaxException {
        URL encodedURL = JenkinsResultsParserUtil.encode(new URL(url));
        return encodedURL.toExternalForm();
    }

    public static URL encode(URL url) throws MalformedURLException, URISyntaxException {
        URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
        String uriASCIIString = uri.toASCIIString();
        return new URL(uriASCIIString.replace("#", "%23"));
    }

    public static Process executeBashCommands(boolean exitOnFirstFail, File baseDir, long timeout, String ... commands) throws IOException, TimeoutException {
        System.out.print("Executing commands: ");
        for (String string : commands) {
            System.out.println(string);
        }
        String[] bashCommands = new String[3];
        bashCommands[0] = JenkinsResultsParserUtil.isWindows() ? "C:\\Program Files\\Git\\bin\\sh.exe" : "/bin/sh";
        bashCommands[1] = "-c";
        String commandTerminator = ";";
        if (exitOnFirstFail) {
            commandTerminator = "&&";
        }
        StringBuffer sb = new StringBuffer();
        if (JenkinsResultsParserUtil.isWindows()) {
            sb.append("export GIT_ASK_YESNO=false");
            sb.append(commandTerminator);
            sb.append(" ");
        }
        for (String command : commands) {
            if (JenkinsResultsParserUtil.isWindows()) {
                command = command.replaceAll("\\(", "\\\\\\\\(");
                command = command.replaceAll("\\)", "\\\\\\\\)");
            }
            sb.append(command);
            sb.append(commandTerminator);
            sb.append(" ");
        }
        sb.append("echo Finished executing Bash commands.\n");
        bashCommands[2] = sb.toString();
        ProcessBuilder processBuilder = new ProcessBuilder(bashCommands);
        processBuilder.directory(baseDir.getAbsoluteFile());
        BufferedProcess process = new BufferedProcess(2000000, processBuilder.start());
        long duration = 0L;
        long start = System.currentTimeMillis();
        int returnCode = -1;
        while (true) {
            try {
                returnCode = ((Process)process).exitValue();
                if (returnCode != 0) break;
                String standardOut = JenkinsResultsParserUtil.readInputStream(((Process)process).getInputStream(), true);
                duration = System.currentTimeMillis() - start;
                while (!standardOut.contains("Finished executing Bash commands.") && duration < timeout) {
                    JenkinsResultsParserUtil.sleep(10L);
                    standardOut = JenkinsResultsParserUtil.readInputStream(((Process)process).getInputStream(), true);
                    duration = System.currentTimeMillis() - start;
                }
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                duration = System.currentTimeMillis() - start;
                if (duration >= timeout) {
                    throw new TimeoutException("Timeout occurred while executing Bash commands: " + Arrays.toString(commands));
                }
                returnCode = -1;
                JenkinsResultsParserUtil.sleep(100L);
                continue;
            }
            break;
        }
        if (debug) {
            System.out.println("Output stream: " + JenkinsResultsParserUtil.readInputStream(((Process)process).getInputStream(), true));
        }
        if (debug && returnCode != 0) {
            System.out.println("Error stream: " + JenkinsResultsParserUtil.readInputStream(((Process)process).getErrorStream(), true));
        }
        return process;
    }

    public static Process executeBashCommands(boolean exitOnFirstFail, String ... commands) throws IOException, TimeoutException {
        return JenkinsResultsParserUtil.executeBashCommands(exitOnFirstFail, new File("."), 3600000L, commands);
    }

    public static Process executeBashCommands(String ... commands) throws IOException, TimeoutException {
        return JenkinsResultsParserUtil.executeBashCommands(true, new File("."), 3600000L, commands);
    }

    public static void executeBashCommandService(String command, File baseDir, Map<String, String> environments, long maxLogSize) {
        JenkinsResultsParserUtil._executeCommandService(command, baseDir, environments, maxLogSize, false);
    }

    public static void executeBatchCommandService(String command, File baseDir, Map<String, String> environments, long maxLogSize) {
        if (!JenkinsResultsParserUtil.isWindows()) {
            throw new RuntimeException("Invalid OS: " + SystemUtils.OS_NAME);
        }
        JenkinsResultsParserUtil._executeCommandService(command, baseDir, environments, maxLogSize, true);
    }

    public static void executeJenkinsScript(String jenkinsMasterName, String script) {
        try {
            URL urlObject = new URL(JenkinsResultsParserUtil.fixURL(JenkinsResultsParserUtil.getLocalURL("http://" + jenkinsMasterName + "/script")));
            HttpURLConnection httpURLConnection = (HttpURLConnection)urlObject.openConnection();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setRequestMethod("POST");
            Properties buildProperties = JenkinsResultsParserUtil.getBuildProperties(false);
            BasicHTTPAuthorization httpAuthorization = new BasicHTTPAuthorization(buildProperties.getProperty("jenkins.admin.user.token"), buildProperties.getProperty("jenkins.admin.user.name"));
            httpURLConnection.setRequestProperty("Authorization", ((Object)httpAuthorization).toString());
            try (OutputStream outputStream = httpURLConnection.getOutputStream();){
                script = "script=" + script;
                outputStream.write(script.getBytes("UTF-8"));
                outputStream.flush();
            }
            httpURLConnection.connect();
            System.out.println(JenkinsResultsParserUtil.combine("Response from ", urlObject.toString(), ": ", String.valueOf(httpURLConnection.getResponseCode()), " ", httpURLConnection.getResponseMessage()));
        }
        catch (IOException ioException) {
            System.out.println("Unable to execute Jenkins script");
            ioException.printStackTrace();
        }
    }

    public static String expandSlaveRange(String value) {
        StringBuilder sb = new StringBuilder();
        for (String hostName : value.split(",")) {
            int x = (hostName = hostName.trim()).indexOf("..");
            if (x == -1) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(hostName);
                continue;
            }
            int y = hostName.lastIndexOf("-") + 1;
            String prefix = hostName.substring(0, y);
            int first = Integer.parseInt(hostName.substring(y, x));
            int last = Integer.parseInt(hostName.substring(x + 2));
            for (int current = first; current <= last; ++current) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(prefix);
                sb.append(current);
            }
        }
        return sb.toString();
    }

    public static List<File> findFiles(File baseDir, String regex) {
        ArrayList<File> files = new ArrayList<File>();
        for (File file : baseDir.listFiles()) {
            String fileName = file.getName();
            if (file.isDirectory()) {
                files.addAll(JenkinsResultsParserUtil.findFiles(file, regex));
                continue;
            }
            if (!fileName.matches(regex)) continue;
            files.add(file);
        }
        return files;
    }

    public static String fixFileName(String fileName) {
        String prefix = "";
        if (fileName.startsWith("file:")) {
            prefix = "file:";
            fileName = fileName.substring(prefix.length());
        }
        fileName = fileName.replace(">", "[gt]");
        fileName = fileName.replace("<", "[lt]");
        fileName = fileName.replace("|", "[pi]");
        fileName = fileName.replace("?", "[qt]");
        fileName = fileName.replace(":", "[sc]");
        return prefix + fileName;
    }

    public static String fixJSON(String json) {
        json = json.replaceAll("'", "&#39;");
        json = json.replaceAll("<", "&#60;");
        json = json.replaceAll(">", "&#62;");
        json = json.replaceAll("\\(", "&#40;");
        json = json.replaceAll("\\)", "&#41;");
        json = json.replaceAll("\\[", "&#91;");
        json = json.replaceAll("\\\"", "&#34;");
        json = json.replaceAll("\\\\", "&#92;");
        json = json.replaceAll("\\]", "&#93;");
        json = json.replaceAll("\\{", "&#123;");
        json = json.replaceAll("\\}", "&#125;");
        json = json.replaceAll("\n", "<br />");
        json = json.replaceAll("\t", "&#09;");
        json = json.replaceAll("\u00bb", "&raquo;");
        return json;
    }

    public static String fixURL(String url) {
        url = url.replace(" ", "%20");
        url = url.replace("#", "%23");
        url = url.replace("(", "%28");
        url = url.replace(")", "%29");
        url = url.replace("[", "%5B");
        url = url.replace("]", "%5D");
        return url;
    }

    public static List<Build> flatten(List<Build> builds) {
        ArrayList<Build> flattenedBuilds = new ArrayList<Build>();
        for (Build build : builds) {
            flattenedBuilds.add(build);
            List<Build> downstreamBuilds = build.getDownstreamBuilds(null);
            if (downstreamBuilds.isEmpty()) continue;
            flattenedBuilds.addAll(JenkinsResultsParserUtil.flatten(downstreamBuilds));
        }
        return flattenedBuilds;
    }

    public static String getActualResult(String buildURL) throws IOException {
        String progressiveText = JenkinsResultsParserUtil.toString(JenkinsResultsParserUtil.getLocalURL(buildURL + "/logText/progressiveText"), false);
        if (progressiveText.contains("Finished:")) {
            if (progressiveText.contains("Finished: SUCCESS")) {
                return "SUCCESS";
            }
            if (progressiveText.contains("Finished: UNSTABLE")) {
                return "FAILURE";
            }
            if (progressiveText.contains("Finished: FAILURE")) {
                return "FAILURE";
            }
        }
        return null;
    }

    public static String getAxisVariable(JSONObject jsonObject) {
        JSONArray actionsJSONArray = (JSONArray)jsonObject.get("actions");
        for (int i = 0; i < actionsJSONArray.length(); ++i) {
            JSONObject actionsJSONObject;
            JSONArray parametersJSONArray;
            Object object = actionsJSONArray.get(i);
            if (object.equals(JSONObject.NULL) || (parametersJSONArray = (actionsJSONObject = actionsJSONArray.getJSONObject(i)).optJSONArray("parameters")) == null) continue;
            for (int j = 0; j < parametersJSONArray.length(); ++j) {
                JSONObject parametersJSONObject = parametersJSONArray.getJSONObject(j);
                String name = parametersJSONObject.getString("name");
                if (!name.contains("AXIS_VARIABLE")) continue;
                return parametersJSONObject.getString("value");
            }
        }
        return "";
    }

    public static String getAxisVariable(String axisBuildURL) {
        String url = null;
        try {
            url = JenkinsResultsParserUtil.decode(axisBuildURL);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unable to encode " + axisBuildURL);
        }
        String label = "AXIS_VARIABLE=";
        int x = url.indexOf(label);
        if (x != -1) {
            url = url.substring(x + label.length());
            int y = url.indexOf(",");
            return url.substring(0, y);
        }
        return "";
    }

    public static File getBaseGitRepositoryDir() {
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return new File(buildProperties.getProperty("base.repository.dir"));
    }

    public static String getBuildID(String topLevelBuildURL, String testSuiteName) {
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build.properties", ioException);
        }
        Matcher matcher = _topLevelBuildURLPattern.matcher(topLevelBuildURL);
        matcher.find();
        StringBuilder sb = new StringBuilder();
        sb.append(matcher.group("cohortNumber"));
        String masterNumber = matcher.group("masterNumber");
        sb.append(String.format("%02d", Integer.parseInt(masterNumber)));
        sb.append(buildProperties.getProperty("spira.release.id[" + matcher.group("jobName") + "][" + testSuiteName + "]"));
        sb.append("_");
        sb.append(matcher.group("buildNumber"));
        return sb.toString();
    }

    public static String getBuildParameter(String buildURL, String key) {
        Map<String, String> buildParameters = JenkinsResultsParserUtil.getBuildParameters(buildURL);
        if (buildParameters.containsKey(key)) {
            return buildParameters.get(key);
        }
        throw new RuntimeException("Unable to find build parameter '" + key + "' at " + buildURL);
    }

    public static Map<String, String> getBuildParameters(String buildURL) {
        HashMap<String, String> buildParameters = new HashMap<String, String>();
        if (!buildURL.endsWith("/")) {
            buildURL = buildURL + "/";
        }
        String buildParametersURL = JenkinsResultsParserUtil.getLocalURL(JenkinsResultsParserUtil.combine(buildURL, "api/json?tree=actions[parameters[name,value]]"));
        try {
            JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(buildParametersURL);
            JSONArray actionsJSONArray = jsonObject.getJSONArray("actions");
            for (int i = 0; i < actionsJSONArray.length(); ++i) {
                JSONObject actionJSONObject;
                Object actions = actionsJSONArray.get(i);
                if (actions == JSONObject.NULL || !(actionJSONObject = actionsJSONArray.getJSONObject(i)).has("parameters")) continue;
                JSONArray parametersJSONArray = actionJSONObject.getJSONArray("parameters");
                for (int j = 0; j < parametersJSONArray.length(); ++j) {
                    JSONObject parameterJSONObject = parametersJSONArray.getJSONObject(j);
                    buildParameters.put(parameterJSONObject.getString("name"), parameterJSONObject.getString("value"));
                }
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException();
        }
        return buildParameters;
    }

    public static Properties getBuildProperties() throws IOException {
        return JenkinsResultsParserUtil.getBuildProperties(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getBuildProperties(boolean checkCache) throws IOException {
        Properties properties = new Properties();
        Hashtable<Object, Object> hashtable = _buildProperties;
        synchronized (hashtable) {
            if (checkCache && !_buildProperties.isEmpty()) {
                properties.putAll((Map<?, ?>)_buildProperties);
                return properties;
            }
            if (_buildPropertiesURLs == null) {
                _buildPropertiesURLs = URLS_BUILD_PROPERTIES_DEFAULT;
            }
            for (String url : _buildPropertiesURLs) {
                properties.load(new StringReader(JenkinsResultsParserUtil.toString(JenkinsResultsParserUtil.getLocalURL(url), false, 0, null, null, 0, 0, null)));
            }
            _buildProperties.clear();
            _buildProperties.putAll(properties);
        }
        return properties;
    }

    public static String getBuildProperty(boolean checkCache, String propertyName) throws IOException {
        Properties buildProperties = JenkinsResultsParserUtil.getBuildProperties(checkCache);
        return buildProperties.getProperty(propertyName);
    }

    public static String getBuildProperty(String propertyName) throws IOException {
        return JenkinsResultsParserUtil.getBuildProperty(true, propertyName);
    }

    public static List<String> getBuildPropertyAsList(boolean checkCache, String key) throws IOException {
        Properties buildProperties = JenkinsResultsParserUtil.getBuildProperties(checkCache);
        String propertyContent = buildProperties.getProperty(key);
        if (propertyContent == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(propertyContent.split(","));
    }

    public static String getBuildURLByBuildID(String buildID) {
        Matcher matcher = _buildIDPattern.matcher(buildID);
        matcher.find();
        StringBuilder sb = new StringBuilder();
        sb.append("https://test-");
        sb.append(matcher.group("cohortNumber"));
        sb.append("-");
        sb.append(Integer.parseInt(matcher.group("masterNumber")));
        sb.append(".liferay.com/job/");
        sb.append(SpiraRelease.getJobNameByID(Integer.parseInt(matcher.group("spiraReleaseID"))));
        sb.append("/");
        sb.append(matcher.group("buildNumber"));
        return sb.toString();
    }

    public static BufferedReader getCachedFileBufferedReader(String key) {
        File cachedTextFile = JenkinsResultsParserUtil._getCacheFile(key);
        if (!cachedTextFile.exists()) {
            return null;
        }
        try {
            return Files.newBufferedReader(Paths.get(cachedTextFile.toURI()));
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get buffered reader for " + cachedTextFile.getPath(), ioException);
        }
    }

    public static String getCachedText(String key) {
        File cachedTextFile = JenkinsResultsParserUtil._getCacheFile(key);
        if (!cachedTextFile.exists()) {
            return null;
        }
        try {
            return JenkinsResultsParserUtil.read(cachedTextFile);
        }
        catch (IOException ioException) {
            return null;
        }
    }

    public static long getCacheFileSize(String key) {
        File cacheFile = JenkinsResultsParserUtil._getCacheFile(key);
        if (cacheFile == null || !cacheFile.exists()) {
            return 0L;
        }
        return cacheFile.length();
    }

    public static String getCanonicalPath(File file) {
        File canonicalFile = null;
        try {
            canonicalFile = file.getCanonicalFile();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get canonical file", ioException);
        }
        return JenkinsResultsParserUtil._getCanonicalPath(canonicalFile);
    }

    public static String getCohortName() {
        String jenkinsURL = System.getenv("JENKINS_URL");
        return JenkinsResultsParserUtil.getCohortName(jenkinsURL);
    }

    public static String getCohortName(String masterHostname) {
        if (masterHostname == null) {
            return null;
        }
        Matcher matcher = _jenkinsMasterPattern.matcher(masterHostname);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group("cohortName");
    }

    public static List<File> getDirectoriesContainingFiles(List<File> directories, List<File> files) {
        ArrayList<File> directoriesContainingFiles = new ArrayList<File>(directories.size());
        for (File directory : directories) {
            if (!directory.isDirectory()) continue;
            boolean containsFile = false;
            for (File file : files) {
                if (!JenkinsResultsParserUtil.isFileInDirectory(directory, file)) continue;
                containsFile = true;
                break;
            }
            if (!containsFile) continue;
            directoriesContainingFiles.add(directory);
        }
        return directoriesContainingFiles;
    }

    public static String getDistinctTimeStamp() {
        String timeStamp;
        while (_timeStamps.contains(timeStamp = String.valueOf(System.currentTimeMillis()))) {
        }
        _timeStamps.add(timeStamp);
        return timeStamp;
    }

    public static String getDistPortalBundlesBuildURL(String portalBranchName) {
        try {
            JSONObject jobJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil._getDistPortalJobURL(portalBranchName) + "/api/json?tree=builds[number]", false);
            JSONArray buildsJSONArray = jobJSONObject.getJSONArray("builds");
            Pattern distPortalBundleFileNamesPattern = JenkinsResultsParserUtil._getDistPortalBundleFileNamesPattern(portalBranchName);
            for (int i = 0; i < buildsJSONArray.length(); ++i) {
                JSONObject buildJSONObject = buildsJSONArray.optJSONObject(i);
                if (buildJSONObject == null) continue;
                String distPortalBundlesBuildURL = JenkinsResultsParserUtil.combine(JenkinsResultsParserUtil._getDistPortalBundlesURL(portalBranchName), "/", String.valueOf(buildJSONObject.getInt("number")), "/");
                try {
                    Matcher matcher = distPortalBundleFileNamesPattern.matcher(JenkinsResultsParserUtil.toString(distPortalBundlesBuildURL, false));
                    if (!matcher.find()) continue;
                    return distPortalBundlesBuildURL;
                }
                catch (IOException ioException) {
                    System.out.println("WARNING: " + ioException.getMessage());
                }
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return null;
    }

    public static String getEnvironmentVariable(String environmentVariableName) {
        String environmentVariableValue = System.getenv(environmentVariableName);
        if (environmentVariableValue == null || environmentVariableValue.isEmpty()) {
            throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to find required environment variable '", environmentVariableName, "'"));
        }
        return environmentVariableValue;
    }

    public static List<File> getExcludedFiles(List<PathMatcher> excludesPathMatchers, List<File> files) {
        ArrayList<File> excludedFiles = new ArrayList<File>(files.size());
        for (File file : files) {
            if (!JenkinsResultsParserUtil.isFileExcluded(excludesPathMatchers, file)) continue;
            excludedFiles.add(file);
        }
        return excludedFiles;
    }

    public static String getGitHubAPIRateLimitStatusMessage() {
        try {
            JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject("https://api.github.com/rate_limit");
            jsonObject = jsonObject.getJSONObject("rate");
            return JenkinsResultsParserUtil._getGitHubAPIRateLimitStatusMessage(jsonObject.getInt("limit"), jsonObject.getInt("remaining"), jsonObject.getLong("reset"));
        }
        catch (Exception exception) {
            System.out.println("Unable to get GitHub API rate limit");
            return "";
        }
    }

    public static String getGitHubApiSearchUrl(List<String> filters) {
        return JenkinsResultsParserUtil.combine("https://api.github.com/search/issues?q=", JenkinsResultsParserUtil.join("+", filters));
    }

    public static String getGitHubApiUrl(String gitRepositoryName, String username, String path) {
        return JenkinsResultsParserUtil.combine("https://api.github.com/repos/", username, "/", gitRepositoryName, "/", path.replaceFirst("^/*", ""));
    }

    public static List<String> getGitHubCacheHostnames() {
        try {
            Properties buildProperties = JenkinsResultsParserUtil.getBuildProperties();
            String gitHubCacheHostnames = buildProperties.getProperty("github.cache.hostnames");
            String cohortName = JenkinsResultsParserUtil.getCohortName();
            if (cohortName != null && buildProperties.containsKey("github.cache.hostnames[" + cohortName + "]")) {
                gitHubCacheHostnames = buildProperties.getProperty("github.cache.hostnames[" + cohortName + "]");
            }
            return Lists.newArrayList((Object[])gitHubCacheHostnames.split(","));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public static String[] getGlobsFromProperty(String globProperty) {
        ArrayList<String> curlyBraceExpansionList = new ArrayList<String>();
        Matcher curlyBraceMatcher = _curlyBraceExpansionPattern.matcher(globProperty);
        while (curlyBraceMatcher.find()) {
            int index = curlyBraceExpansionList.size();
            String value = curlyBraceMatcher.group();
            curlyBraceExpansionList.add(value);
            globProperty = globProperty.replace(value, JenkinsResultsParserUtil.combine("${", String.valueOf(index), "}"));
        }
        ArrayList<String> globs = new ArrayList<String>();
        for (String tempGlob : globProperty.split(",")) {
            Matcher matcher = _nestedPropertyPattern.matcher(tempGlob);
            String glob = tempGlob;
            while (matcher.find()) {
                Integer index = Integer.parseInt(matcher.group(1));
                glob = glob.replace(matcher.group(), (CharSequence)curlyBraceExpansionList.get(index));
            }
            globs.add(glob);
        }
        return globs.toArray(new String[0]);
    }

    public static String getHostIPAddress() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return "127.0.0.1";
        }
    }

    public static String getHostName(String defaultHostName) {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return defaultHostName;
        }
    }

    public static List<File> getIncludedFiles(File basedir, String[] excludes, String[] includes) {
        if (includes == null) {
            return new ArrayList<File>();
        }
        final ArrayList<PathMatcher> excludesPathMatchers = new ArrayList<PathMatcher>();
        if (excludes != null && excludes.length > 0) {
            excludesPathMatchers.addAll(JenkinsResultsParserUtil.toPathMatchers(null, excludes));
        }
        final List<PathMatcher> includesPathMatchers = JenkinsResultsParserUtil.toPathMatchers(null, includes);
        final ArrayList<File> includedFiles = new ArrayList<File>();
        try {
            Files.walkFileTree(basedir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path filePath, BasicFileAttributes basicFileAttributes) throws IOException {
                    for (PathMatcher pathMatcher : excludesPathMatchers) {
                        if (!pathMatcher.matches(filePath)) continue;
                        return FileVisitResult.CONTINUE;
                    }
                    for (PathMatcher pathMatcher : includesPathMatchers) {
                        if (!pathMatcher.matches(filePath)) continue;
                        includedFiles.add(filePath.toFile());
                        break;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return includedFiles;
    }

    public static List<File> getIncludedFiles(List<PathMatcher> excludesPathMatchers, List<PathMatcher> includesPathMatchers, List<File> files) {
        ArrayList<File> includedFiles = new ArrayList<File>(files.size());
        for (File file : files) {
            if (!JenkinsResultsParserUtil.isFileIncluded(excludesPathMatchers, includesPathMatchers, file)) continue;
            includedFiles.add(file);
        }
        return includedFiles;
    }

    public static List<URL> getIncludedResourceURLs(String[] resourceIncludesRelativeGlobs, File rootDir) throws IOException {
        final List<PathMatcher> pathMatchers = JenkinsResultsParserUtil.toPathMatchers(JenkinsResultsParserUtil.getCanonicalPath(rootDir) + File.separator, resourceIncludesRelativeGlobs);
        final ArrayList<URL> includedResourceURLs = new ArrayList<URL>();
        Path rootDirPath = rootDir.toPath();
        if (!Files.exists(rootDirPath, new LinkOption[0])) {
            System.out.println(JenkinsResultsParserUtil.combine("Directory ", rootDirPath.toString(), " does not exist."));
            return includedResourceURLs;
        }
        Files.walkFileTree(rootDirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path filePath, BasicFileAttributes basicFileAttributes) throws IOException {
                for (PathMatcher pathMatcher : pathMatchers) {
                    if (!pathMatcher.matches(filePath)) continue;
                    URI uri = filePath.toUri();
                    includedResourceURLs.add(uri.toURL());
                    break;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return includedResourceURLs;
    }

    public static float getJavaVersionNumber() {
        Matcher matcher = _javaVersionPattern.matcher(System.getProperty("java.version"));
        if (!matcher.find()) {
            throw new RuntimeException("Unable to determine Java version number");
        }
        return Float.parseFloat(matcher.group(1));
    }

    public static String getJenkinsMasterName(String jenkinsSlaveName) {
        jenkinsSlaveName = jenkinsSlaveName.replaceAll("([^\\.]+).*", "$1");
        Map<String, List<String>> jenkinsNodeMap = JenkinsResultsParserUtil.getJenkinsNodeMap();
        if (jenkinsNodeMap != null) {
            for (Map.Entry<String, List<String>> entry : jenkinsNodeMap.entrySet()) {
                List<String> jenkinsSlaveNames = entry.getValue();
                if (!jenkinsSlaveNames.contains(jenkinsSlaveName)) continue;
                return entry.getKey();
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Unable to get Jenkins master name for slave ");
        sb.append(jenkinsSlaveName);
        sb.append(".\n");
        sb.append("Jenkins Node Map:\n");
        if (jenkinsNodeMap != null) {
            for (Map.Entry<String, List<String>> entry : jenkinsNodeMap.entrySet()) {
                sb.append(entry.getKey());
                sb.append("\n    ");
                for (String jenkinsNodeName : entry.getValue()) {
                    sb.append(" ");
                    sb.append(jenkinsNodeName);
                }
                sb.append("\n");
            }
        }
        NotificationUtil.sendEmail(sb.toString(), "jenkins", "Unable to get Jenkins master name", "peter.yoo@liferay.com");
        return null;
    }

    public static List<JenkinsMaster> getJenkinsMasters(Properties buildProperties, int minimumRAM, int maximumSlavesPerHost, String prefix) {
        ArrayList<JenkinsMaster> jenkinsMasters = new ArrayList<JenkinsMaster>();
        int i = 1;
        while (buildProperties.containsKey("master.slaves(" + prefix + "-" + i + ")")) {
            JenkinsMaster jenkinsMaster = new JenkinsMaster(prefix + "-" + i);
            if (jenkinsMaster.getSlaveRAM() >= minimumRAM && jenkinsMaster.getSlavesPerHost() <= maximumSlavesPerHost) {
                jenkinsMasters.add(jenkinsMaster);
            }
            ++i;
        }
        return jenkinsMasters;
    }

    public static Map<String, List<String>> getJenkinsNodeMap() {
        Retryable<Map<String, List<String>>> retryable = new Retryable<Map<String, List<String>>>(false, 2, 10, true){
            private boolean _checkCache = true;

            @Override
            public Map<String, List<String>> execute() {
                Properties buildProperties = null;
                HashMap<String, List<String>> jenkinsNodeMap = new HashMap<String, List<String>>();
                try {
                    buildProperties = JenkinsResultsParserUtil.getBuildProperties(this._checkCache);
                }
                catch (IOException ioException) {
                    throw new RuntimeException("Unable to get build properties", ioException);
                }
                for (Object propertyName : buildProperties.keySet()) {
                    Matcher jenkinsSlavesPropertyNameMatcher = _jenkinsSlavesPropertyNamePattern.matcher(propertyName.toString());
                    if (!jenkinsSlavesPropertyNameMatcher.matches()) continue;
                    String jenkinsMasterName = jenkinsSlavesPropertyNameMatcher.group(1);
                    List<String> jenkinsSlaveNames = JenkinsResultsParserUtil.getSlaves(buildProperties, jenkinsMasterName, null, false);
                    jenkinsNodeMap.put(jenkinsMasterName, jenkinsSlaveNames);
                }
                if (jenkinsNodeMap.isEmpty()) {
                    this._checkCache = false;
                    throw new RuntimeException("Unable to load Jenkins node map");
                }
                return jenkinsNodeMap;
            }
        };
        return (Map)retryable.executeWithRetries();
    }

    public static Properties getJenkinsProperties() throws IOException {
        Properties properties = new Properties();
        if (_jenkinsProperties != null && !_jenkinsProperties.isEmpty()) {
            properties.putAll((Map<?, ?>)_jenkinsProperties);
            return properties;
        }
        for (String url : URLS_JENKINS_PROPERTIES_DEFAULT) {
            properties.load(new StringReader(JenkinsResultsParserUtil.toString(JenkinsResultsParserUtil.getLocalURL(url), false)));
        }
        LocalGitRepository localGitRepository = GitRepositoryFactory.getLocalGitRepository("liferay-jenkins-ee", "master");
        File jenkinsPropertiesFile = new File(localGitRepository.getDirectory(), "jenkins.properties");
        if (jenkinsPropertiesFile.exists()) {
            properties.putAll((Map<?, ?>)JenkinsResultsParserUtil.getProperties(jenkinsPropertiesFile));
        }
        _jenkinsProperties = properties;
        return properties;
    }

    public static String getJobVariant(JSONObject jsonObject) {
        JSONArray actionsJSONArray = jsonObject.getJSONArray("actions");
        for (int i = 0; i < actionsJSONArray.length(); ++i) {
            JSONObject actionsJSONObject;
            Object object = actionsJSONArray.get(i);
            if (object.equals(JSONObject.NULL) || !(actionsJSONObject = actionsJSONArray.getJSONObject(i)).has("parameters")) continue;
            JSONArray parametersJSONArray = actionsJSONObject.getJSONArray("parameters");
            for (int j = 0; j < parametersJSONArray.length(); ++j) {
                JSONObject parametersJSONObject = parametersJSONArray.getJSONObject(j);
                if (!"JOB_VARIANT".contains(parametersJSONObject.getString("name"))) continue;
                return parametersJSONObject.getString("value");
            }
        }
        return "";
    }

    public static String getJobVariant(String json) {
        return JenkinsResultsParserUtil.getJobVariant(new JSONObject(json));
    }

    public static Properties getLocalLiferayJenkinsEEBuildProperties() {
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build properties", ioException);
        }
        File localLiferayJenkinsEEBuildPropertiesFile = new File(buildProperties.getProperty("base.repository.dir"), JenkinsResultsParserUtil.combine("liferay-jenkins-ee", File.separator, "commands", File.separator, "build.properties"));
        return JenkinsResultsParserUtil.getProperties(localLiferayJenkinsEEBuildPropertiesFile);
    }

    public static String getLocalURL(String remoteURL) {
        if (remoteURL.contains("${dependencies.url}")) {
            String fileURL = (remoteURL = JenkinsResultsParserUtil.fixFileName(remoteURL)).replace("${dependencies.url}", URL_DEPENDENCIES_FILE);
            File file = new File(fileURL.substring("file:".length()));
            remoteURL = file.exists() ? fileURL : remoteURL.replace("${dependencies.url}", URL_DEPENDENCIES_HTTP);
        }
        if (remoteURL.startsWith("file")) {
            remoteURL = JenkinsResultsParserUtil.fixFileName(remoteURL);
        }
        String localURL = remoteURL;
        String localURLQueryString = "";
        int x = remoteURL.indexOf("?");
        if (x != -1) {
            localURL = remoteURL.substring(0, x);
            localURLQueryString = remoteURL.substring(x);
        }
        Matcher remoteURLAuthorityMatcher1 = _remoteURLAuthorityPattern1.matcher(localURL);
        Matcher remoteURLAuthorityMatcher2 = _remoteURLAuthorityPattern2.matcher(localURL);
        if (remoteURLAuthorityMatcher1.find()) {
            String localURLAuthority = JenkinsResultsParserUtil.combine("http://", remoteURLAuthorityMatcher1.group(1), "-", remoteURLAuthorityMatcher1.group(2), "/", remoteURLAuthorityMatcher1.group(2), "/");
            String remoteURLAuthority = remoteURLAuthorityMatcher1.group(0);
            localURL = localURL.replaceAll(remoteURLAuthority, localURLAuthority);
        } else if (remoteURLAuthorityMatcher2.find()) {
            String localURLAuthority = JenkinsResultsParserUtil.combine("http://", remoteURLAuthorityMatcher2.group(1), "/");
            String remoteURLAuthority = remoteURLAuthorityMatcher2.group(0);
            localURL = localURL.replaceAll(remoteURLAuthority, localURLAuthority);
        }
        return localURL + localURLQueryString;
    }

    public static String getMostAvailableMasterURL(String baseInvocationURL, int invokedBatchSize) {
        return JenkinsResultsParserUtil.getMostAvailableMasterURL(baseInvocationURL, null, invokedBatchSize, JenkinsMaster.getSlaveRAMMinimumDefault(), JenkinsMaster.getSlavesPerHostDefault());
    }

    public static String getMostAvailableMasterURL(String baseInvocationURL, String blacklist, int invokedBatchSize, int minimumRAM, int maximumSlavesPerHost) {
        StringBuilder sb = new StringBuilder();
        sb.append(_URL_LOAD_BALANCER);
        sb.append("?baseInvocationURL=");
        sb.append(baseInvocationURL);
        if (blacklist != null) {
            sb.append("&blacklist=");
            sb.append(blacklist);
        }
        if (invokedBatchSize > 0) {
            sb.append("&invokedJobBatchSize=");
            sb.append(invokedBatchSize);
        }
        if (minimumRAM > 0) {
            sb.append("&minimumRAM=");
            sb.append(minimumRAM);
        }
        try {
            JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(sb.toString(), false);
            return jsonObject.getString("mostAvailableMasterURL");
        }
        catch (IOException ioException1) {
            Properties buildProperties = null;
            try {
                buildProperties = JenkinsResultsParserUtil.getBuildProperties(false);
            }
            catch (IOException ioException2) {
                throw new RuntimeException("Unable to get build properties", ioException2);
            }
            List<JenkinsMaster> availableJenkinsMasters = LoadBalancerUtil.getAvailableJenkinsMasters(LoadBalancerUtil.getMasterPrefix(baseInvocationURL), blacklist, minimumRAM, maximumSlavesPerHost, buildProperties);
            Random random = new Random(System.currentTimeMillis());
            JenkinsMaster randomJenkinsMaster = availableJenkinsMasters.get(random.nextInt(availableJenkinsMasters.size()));
            return "http://" + randomJenkinsMaster.getName();
        }
    }

    public static ThreadPoolExecutor getNewThreadPoolExecutor(int maximumPoolSize, boolean autoShutDown) {
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(maximumPoolSize);
        if (autoShutDown) {
            threadPoolExecutor.setKeepAliveTime(5L, TimeUnit.SECONDS);
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            threadPoolExecutor.setCorePoolSize(maximumPoolSize);
            threadPoolExecutor.setMaximumPoolSize(maximumPoolSize);
        }
        return threadPoolExecutor;
    }

    public static String getNounForm(int count, String plural, String singular) {
        if (count == 1) {
            return singular;
        }
        return plural;
    }

    public static String getPathRelativeTo(File file, File relativeToFile) {
        try {
            String filePath = JenkinsResultsParserUtil.getCanonicalPath(file);
            return filePath.replace(JenkinsResultsParserUtil.getCanonicalPath(relativeToFile) + "/", "");
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException("Unable to get relative path", runtimeException);
        }
    }

    public static Properties getProperties(File ... propertiesFiles) {
        Properties properties = new Properties();
        for (File propertiesFile : propertiesFiles) {
            if (propertiesFile == null || !propertiesFile.exists()) continue;
            properties.putAll((Map<?, ?>)JenkinsResultsParserUtil._getProperties(propertiesFile));
        }
        return properties;
    }

    public static String getProperty(Properties properties, String name) {
        return JenkinsResultsParserUtil._getProperty(properties, new ArrayList<String>(), name);
    }

    public static String getProperty(Properties properties, String basePropertyName, boolean useBasePropertyAsDefault, String ... opts) {
        if (opts == null || opts.length == 0) {
            return JenkinsResultsParserUtil._getProperty(properties, new ArrayList<String>(), basePropertyName);
        }
        LinkedHashSet<String> optSet = new LinkedHashSet<String>(Arrays.asList(opts));
        optSet.remove(null);
        opts = optSet.toArray(new String[0]);
        Properties matchingProperties = new Properties();
        for (Object key : properties.keySet()) {
            String keyString = key.toString();
            if (!keyString.matches(Pattern.quote(basePropertyName) + "(\\[.*|$)")) continue;
            matchingProperties.setProperty(keyString, properties.getProperty(keyString));
        }
        Set<Set<String>> targetOptSets = JenkinsResultsParserUtil._getOrderedOptSets(opts);
        String propertyName = null;
        Map<String, Set<String>> propertyOptRegexSets = JenkinsResultsParserUtil._getPropertyOptRegexSets(matchingProperties.stringPropertyNames());
        for (Map.Entry<String, Set<String>> entry : propertyOptRegexSets.entrySet()) {
            Set<String> propertyOptRegexSet = entry.getValue();
            for (Set<String> targetOptSet : targetOptSets) {
                if (propertyOptRegexSet.size() > targetOptSet.size()) continue;
                boolean matchesAllPropertyOptRegexes = true;
                for (String targetOpt : targetOptSet) {
                    boolean matchesPropertyOptRegex = false;
                    for (String propertyOptRegex : propertyOptRegexSet) {
                        if (!targetOpt.matches(propertyOptRegex)) continue;
                        matchesPropertyOptRegex = true;
                        break;
                    }
                    if (matchesPropertyOptRegex) continue;
                    matchesAllPropertyOptRegexes = false;
                }
                if (!matchesAllPropertyOptRegexes) continue;
                propertyName = entry.getKey();
                break;
            }
            if (propertyName == null) continue;
            break;
        }
        if (propertyName != null) {
            return JenkinsResultsParserUtil._getProperty(properties, new ArrayList<String>(), propertyName);
        }
        if (useBasePropertyAsDefault) {
            return JenkinsResultsParserUtil._getProperty(properties, new ArrayList<String>(), basePropertyName);
        }
        return null;
    }

    public static String getProperty(Properties properties, String basePropertyName, String ... opts) {
        return JenkinsResultsParserUtil.getProperty(properties, basePropertyName, true, opts);
    }

    public static String getRandomGitHubDevNodeHostname() {
        return JenkinsResultsParserUtil.getRandomGitHubDevNodeHostname(null);
    }

    public static String getRandomGitHubDevNodeHostname(List<String> excludedHostnames) {
        List<String> gitHubDevNodeHostnames = JenkinsResultsParserUtil.getGitHubCacheHostnames();
        if (excludedHostnames != null) {
            for (String excludedHostname : excludedHostnames) {
                gitHubDevNodeHostnames.remove(excludedHostname);
            }
        }
        return JenkinsResultsParserUtil.getRandomString(gitHubDevNodeHostnames);
    }

    public static List<String> getRandomList(List<String> list, int size) {
        if (list.size() < size) {
            throw new IllegalStateException("Size must not exceed the size of the list");
        }
        if (size == list.size()) {
            return list;
        }
        ArrayList<String> randomList = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            String item = null;
            while (randomList.contains(item = JenkinsResultsParserUtil.getRandomString(list))) {
            }
            randomList.add(item);
        }
        return randomList;
    }

    public static <T> T getRandomListItem(List<T> list) {
        return list.get(JenkinsResultsParserUtil.getRandomValue(0, list.size() - 1));
    }

    public static String getRandomString(Collection<String> collection) {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException("Collection is null or empty");
        }
        int randomIndex = JenkinsResultsParserUtil.getRandomValue(0, collection.size() - 1);
        Iterator<String> iterator = collection.iterator();
        for (int i = 0; i < randomIndex - 1; ++i) {
            iterator.next();
        }
        return iterator.next();
    }

    public static int getRandomValue(int start, int end) {
        int size = Math.abs(end - start) + 1;
        double randomDouble = Math.random();
        return Math.min(start, end) + (int)Math.floor((double)size * randomDouble);
    }

    public static List<JenkinsSlave> getReachableJenkinsSlaves(List<JenkinsMaster> jenkinsMasters, Integer targetSlaveCount) {
        ArrayList callables = new ArrayList(jenkinsMasters.size());
        for (final JenkinsMaster jenkinsMaster : jenkinsMasters) {
            Callable<List<JenkinsSlave>> callable = new Callable<List<JenkinsSlave>>(){

                @Override
                public List<JenkinsSlave> call() throws Exception {
                    jenkinsMaster.update();
                    return jenkinsMaster.getOnlineJenkinsSlaves();
                }
            };
            callables.add(callable);
        }
        ThreadPoolExecutor threadPoolExecutor = JenkinsResultsParserUtil.getNewThreadPoolExecutor(jenkinsMasters.size(), true);
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, threadPoolExecutor);
        List onlineJenkinsSlaves = JenkinsResultsParserUtil.concatenate(parallelExecutor.execute(), false);
        Collections.sort(onlineJenkinsSlaves);
        if (targetSlaveCount == null) {
            targetSlaveCount = onlineJenkinsSlaves.size();
        }
        ArrayList<JenkinsSlave> reachableJenkinsSlaves = new ArrayList<JenkinsSlave>(targetSlaveCount);
        while (reachableJenkinsSlaves.size() < targetSlaveCount) {
            JenkinsSlave randomJenkinsSlave = (JenkinsSlave)JenkinsResultsParserUtil.getRandomListItem(onlineJenkinsSlaves);
            onlineJenkinsSlaves.remove(randomJenkinsSlave);
            if (randomJenkinsSlave.isReachable()) {
                reachableJenkinsSlaves.add(randomJenkinsSlave);
            }
            if (!onlineJenkinsSlaves.isEmpty() || reachableJenkinsSlaves.size() >= targetSlaveCount) continue;
            throw new RuntimeException("Unable to find enough reachable Jenkins slaves");
        }
        return reachableJenkinsSlaves;
    }

    public static String getRegexLiteral(String string) {
        if (string == null) {
            throw new NullPointerException("String is null");
        }
        String specialCharactersString = "\\^$.|?*+()[]{}";
        StringBuilder sb = new StringBuilder();
        for (char character : string.toCharArray()) {
            if (specialCharactersString.indexOf(character) != -1) {
                sb.append('\\');
            }
            sb.append(character);
        }
        return sb.toString();
    }

    public static String getRemoteURL(String localURL) {
        if (localURL.startsWith("file")) {
            localURL = JenkinsResultsParserUtil.fixFileName(localURL);
        }
        String remoteURL = localURL;
        String remoteURLQueryString = "";
        int x = localURL.indexOf("?");
        if (x != -1) {
            remoteURL = localURL.substring(0, x);
            remoteURLQueryString = localURL.substring(x);
        }
        Matcher localURLAuthorityMatcher1 = _localURLAuthorityPattern1.matcher(remoteURL);
        Matcher localURLAuthorityMatcher2 = _localURLAuthorityPattern2.matcher(remoteURL);
        if (localURLAuthorityMatcher1.find()) {
            String localURLAuthority = localURLAuthorityMatcher1.group(0);
            String remoteURLAuthority = JenkinsResultsParserUtil.combine("https://", localURLAuthorityMatcher1.group(2), ".liferay.com/", localURLAuthorityMatcher1.group(3), "/");
            remoteURL = remoteURL.replaceAll(localURLAuthority, remoteURLAuthority);
        } else if (localURLAuthorityMatcher2.find()) {
            String localURLAuthority = localURLAuthorityMatcher2.group(0);
            String remoteURLAuthority = JenkinsResultsParserUtil.combine("https://", localURLAuthorityMatcher2.group(1), ".liferay.com/");
            remoteURL = remoteURL.replaceAll(localURLAuthority, remoteURLAuthority);
        }
        return remoteURL + remoteURLQueryString;
    }

    public static String getResourceFileContent(String resourceName) throws IOException {
        try (InputStream resourceStream = JenkinsResultsParserUtil.class.getResourceAsStream(resourceName);){
            String string = JenkinsResultsParserUtil.readInputStream(resourceStream);
            return string;
        }
    }

    public static List<String> getSlaves(Properties buildProperties, String jenkinsMasterPatternString) {
        return JenkinsResultsParserUtil.getSlaves(buildProperties, jenkinsMasterPatternString, null, false);
    }

    public static List<String> getSlaves(Properties buildProperties, String jenkinsMasterPatternString, Integer targetSlaveCount, boolean validate) {
        LinkedHashSet<String> slaves = new LinkedHashSet<String>();
        Pattern jenkinsSlavesPropertyNamePattern = Pattern.compile("master.slaves\\(" + jenkinsMasterPatternString + "\\)");
        for (Object propertyName : buildProperties.keySet()) {
            Matcher jenkinsSlavesPropertyNameMatcher = jenkinsSlavesPropertyNamePattern.matcher(propertyName.toString());
            if (!jenkinsSlavesPropertyNameMatcher.find()) continue;
            String slavesString = JenkinsResultsParserUtil.expandSlaveRange(buildProperties.getProperty(propertyName.toString()));
            for (String slave : slavesString.split(",")) {
                slaves.add(slave.trim());
            }
        }
        if (targetSlaveCount == null) {
            if (!validate) {
                return new ArrayList<String>(slaves);
            }
            targetSlaveCount = slaves.size();
        }
        if (slaves.size() < targetSlaveCount) {
            throw new IllegalStateException("Target size exceeds the number of available slaves");
        }
        ArrayList<String> randomSlaves = new ArrayList<String>(targetSlaveCount);
        while (randomSlaves.size() < targetSlaveCount) {
            String randomSlave = JenkinsResultsParserUtil.getRandomString(slaves);
            slaves.remove(randomSlave);
            if (!validate || JenkinsResultsParserUtil.isReachable(randomSlave)) {
                randomSlaves.add(randomSlave);
            }
            if (!slaves.isEmpty() || randomSlaves.size() >= targetSlaveCount) continue;
            throw new RuntimeException("Unable to find enough reachable slaves");
        }
        return randomSlaves;
    }

    public static List<String> getSlaves(String jenkinsMasterPatternString) throws Exception {
        return JenkinsResultsParserUtil.getSlaves(JenkinsResultsParserUtil.getBuildProperties(), jenkinsMasterPatternString);
    }

    public static File getSshDir() {
        return _sshDir;
    }

    public static List<File> getSubdirectories(int depth, File rootDirectory) {
        if (!rootDirectory.isDirectory()) {
            return Collections.emptyList();
        }
        ArrayList<File> subdirectories = new ArrayList<File>();
        if (depth == 0) {
            subdirectories.add(rootDirectory);
        } else {
            for (File file : rootDirectory.listFiles()) {
                if (!file.isDirectory()) continue;
                subdirectories.addAll(JenkinsResultsParserUtil.getSubdirectories(depth - 1, file));
            }
        }
        return subdirectories;
    }

    public static File getUserHomeDir() {
        return _userHomeDir;
    }

    public static boolean isCINode() {
        String hostName = JenkinsResultsParserUtil.getHostName("");
        return hostName.startsWith("cloud-10-0-") || hostName.startsWith("test-");
    }

    public static boolean isFileExcluded(List<PathMatcher> excludesPathMatchers, File file) {
        return JenkinsResultsParserUtil.isFileExcluded(excludesPathMatchers, file.toPath());
    }

    public static boolean isFileExcluded(List<PathMatcher> excludesPathMatchers, Path path) {
        if (excludesPathMatchers != null) {
            for (PathMatcher excludesPathMatcher : excludesPathMatchers) {
                if (!excludesPathMatcher.matches(path)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isFileIncluded(List<PathMatcher> excludesPathMatchers, List<PathMatcher> includesPathMatchers, File file) {
        return JenkinsResultsParserUtil.isFileIncluded(excludesPathMatchers, includesPathMatchers, file.toPath());
    }

    public static boolean isFileIncluded(List<PathMatcher> excludesPathMatchers, List<PathMatcher> includesPathMatchers, Path path) {
        if (JenkinsResultsParserUtil.isFileExcluded(excludesPathMatchers, path)) {
            return false;
        }
        if (includesPathMatchers != null && !includesPathMatchers.isEmpty()) {
            for (PathMatcher includesPathMatcher : includesPathMatchers) {
                if (!includesPathMatcher.matches(path)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean isFileInDirectory(File directory, File file) {
        if (directory == null) {
            throw new IllegalArgumentException("Directory is null");
        }
        if (file == null) {
            throw new IllegalArgumentException("File is null");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory.getName() + " is not a directory");
        }
        String directoryCanonicalPath = JenkinsResultsParserUtil.getCanonicalPath(directory) + "/";
        String fileCanonicalPath = JenkinsResultsParserUtil.getCanonicalPath(file);
        return fileCanonicalPath.startsWith(directoryCanonicalPath);
    }

    public static boolean isJSONArrayEqual(JSONArray expectedJSONArray, JSONArray actualJSONArray) {
        if (expectedJSONArray.length() != actualJSONArray.length()) {
            return false;
        }
        for (int i = 0; i < expectedJSONArray.length(); ++i) {
            Object actual = actualJSONArray.get(i);
            Object expected = expectedJSONArray.get(i);
            if (JenkinsResultsParserUtil._isJSONExpectedAndActualEqual(expected, actual)) continue;
            return false;
        }
        return true;
    }

    public static boolean isJSONObjectEqual(JSONObject expectedJSONObject, JSONObject actualJSONObject) {
        JSONArray namesJSONArray = expectedJSONObject.names();
        for (int i = 0; i < namesJSONArray.length(); ++i) {
            Object actual;
            String name = namesJSONArray.getString(i);
            if (!actualJSONObject.has(name)) {
                return false;
            }
            Object expected = expectedJSONObject.get(name);
            if (JenkinsResultsParserUtil._isJSONExpectedAndActualEqual(expected, actual = actualJSONObject.get(name))) continue;
            return false;
        }
        return true;
    }

    public static boolean isReachable(String hostname) {
        try {
            InetAddress inetAddress = InetAddress.getByName(hostname);
            return inetAddress.isReachable(5000);
        }
        catch (IOException ioException) {
            System.out.println("Unable to reach " + hostname);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isServerPortReachable(String hostname, int port) {
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(hostname, port), 5000);
            boolean bl = true;
            return bl;
        }
        catch (IOException ioException) {
            System.out.println(JenkinsResultsParserUtil.combine("Unable to reach ", hostname, ":", String.valueOf(port)));
            return false;
        }
    }

    public static boolean isWindows() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    public static String join(String delimiter, List<String> list) {
        return JenkinsResultsParserUtil.join(delimiter, list.toArray(new String[0]));
    }

    public static String join(String delimiter, String ... strings) {
        StringBuilder sb = new StringBuilder();
        for (String string : strings) {
            if (sb.length() > 0) {
                sb.append(delimiter);
            }
            sb.append(string);
        }
        return sb.toString();
    }

    public static void keepJenkinsBuild(boolean keepBuildLogs, int buildNumber, String jobName, String masterHostname) {
        StringBuilder sb = new StringBuilder();
        sb.append("def job = Jenkins.instance.getItemByFullName(\"");
        sb.append(jobName);
        sb.append("\"); ");
        sb.append("def build = job.getBuildByNumber(");
        sb.append(buildNumber);
        sb.append("); ");
        sb.append("build.keepLog(");
        sb.append(keepBuildLogs);
        sb.append(");");
        JenkinsResultsParserUtil.executeJenkinsScript(masterHostname, sb.toString());
    }

    public static int lastIndexOfRegex(String string, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(string);
        int lastIndex = -1;
        while (matcher.find()) {
            lastIndex = matcher.start();
        }
        return lastIndex;
    }

    public static void move(File sourceFile, File targetFile) throws IOException {
        JenkinsResultsParserUtil.copy(sourceFile, targetFile);
        if (!JenkinsResultsParserUtil.delete(sourceFile)) {
            throw new IOException("Unable to delete " + sourceFile);
        }
    }

    public static <T> List<List<T>> partitionByCount(List<T> list, int count) {
        int listSize = list.size();
        int partitionSize = 1;
        if (listSize > count) {
            partitionSize = listSize / count;
            if (listSize % count > 0) {
                ++partitionSize;
            }
        }
        return Lists.partition(list, (int)partitionSize);
    }

    public static void printTable(String[][] table) {
        int columnNumber;
        if (table.length == 0) {
            return;
        }
        int[] maxColumnWidth = new int[table[0].length];
        for (String[] row : table) {
            for (int columnNumber2 = 0; columnNumber2 < row.length; ++columnNumber2) {
                String item = row[columnNumber2];
                if (maxColumnWidth[columnNumber2] > item.length()) continue;
                maxColumnWidth[columnNumber2] = item.length();
            }
        }
        StringBuilder rowsStringBuilder = new StringBuilder();
        for (String[] row : table) {
            for (int columnNumber3 = 0; columnNumber3 < row.length; ++columnNumber3) {
                String cellText = row[columnNumber3];
                rowsStringBuilder.append(String.format(JenkinsResultsParserUtil.combine("| %-", String.valueOf(maxColumnWidth[columnNumber3]), "s "), cellText));
            }
            rowsStringBuilder.append("|\n");
        }
        int rowTotalSize = rowsStringBuilder.indexOf("\n");
        StringBuilder tableStringBuilder = new StringBuilder();
        for (columnNumber = 0; columnNumber < rowTotalSize; ++columnNumber) {
            tableStringBuilder.append("-");
        }
        tableStringBuilder.append("\n");
        tableStringBuilder.append((CharSequence)rowsStringBuilder);
        for (columnNumber = 0; columnNumber < rowTotalSize; ++columnNumber) {
            tableStringBuilder.append("-");
        }
        System.out.println(tableStringBuilder.toString());
    }

    public static String read(File file) throws IOException {
        return new String(Files.readAllBytes(Paths.get(file.toURI())));
    }

    public static String readInputStream(InputStream inputStream) throws IOException {
        return JenkinsResultsParserUtil.readInputStream(inputStream, false);
    }

    public static String readInputStream(InputStream inputStream, boolean resetAfterReading) throws IOException {
        if (resetAfterReading && !inputStream.markSupported()) {
            Class<?> inputStreamClass = inputStream.getClass();
            System.out.println("Unable to reset after reading input stream " + inputStreamClass.getName());
        }
        if (resetAfterReading && inputStream.markSupported()) {
            inputStream.mark(Integer.MAX_VALUE);
        }
        StringBuffer sb = new StringBuffer();
        byte[] bytes = new byte[1024];
        int size = inputStream.read(bytes);
        while (size > 0) {
            sb.append(new String(Arrays.copyOf(bytes, size)));
            size = inputStream.read(bytes);
        }
        if (resetAfterReading && inputStream.markSupported()) {
            inputStream.reset();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String redact(String string) {
        Set<String> set;
        if (_redactTokens.isEmpty()) {
            set = _redactTokens;
            synchronized (set) {
                JenkinsResultsParserUtil._initializeRedactTokens();
            }
        }
        set = _redactTokens;
        synchronized (set) {
            for (String redactToken : _redactTokens) {
                string = string.replace(redactToken, "[REDACTED]");
            }
        }
        return string;
    }

    public static List<File> removeExcludedFiles(List<PathMatcher> excludesPathMatchers, List<File> files) {
        List<File> excludedFiles = JenkinsResultsParserUtil.getExcludedFiles(excludesPathMatchers, files);
        files.removeAll(excludedFiles);
        return files;
    }

    public static void saveToCacheFile(String key, String text) {
        File cacheFile = JenkinsResultsParserUtil._getCacheFile(key);
        try {
            JenkinsResultsParserUtil.write(cacheFile, text);
            cacheFile.deleteOnExit();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to save to cache file", ioException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBuildProperties(Hashtable<Object, Object> buildProperties) {
        _buildPropertiesURLs = null;
        Hashtable<Object, Object> hashtable = _buildProperties;
        synchronized (hashtable) {
            _buildProperties.clear();
            if (buildProperties != null) {
                _buildProperties.putAll(buildProperties);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBuildProperties(String ... urls) {
        Hashtable<Object, Object> hashtable = _buildProperties;
        synchronized (hashtable) {
            _buildProperties.clear();
        }
        _buildPropertiesURLs = urls;
    }

    public static void sleep(long duration) {
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    public static BufferedReader toBufferedReader(String url, boolean checkCache) throws IOException {
        return JenkinsResultsParserUtil.toBufferedReader(url, checkCache, 3, null, null, 5, 0, null);
    }

    public static BufferedReader toBufferedReader(String url, boolean checkCache, int maxRetries, HttpRequestMethod method, String postContent, int retryPeriod, int timeout, HTTPAuthorization httpAuthorizationHeader) throws IOException {
        File file;
        if (!JenkinsResultsParserUtil.isCINode() && url.startsWith("file:") && url.contains("liferay-jenkins-results-parser-samples-ee") && !(file = new File(url.replace("file:", ""))).exists()) {
            if (url.contains("json?")) {
                url = url.substring(0, url.indexOf("json?") + 4);
            }
            if (url.contains("json[qt]")) {
                url = url.substring(0, url.indexOf("json[qt]") + 4);
            }
        }
        if (url.contains("/userContent/") && timeout == 0) {
            timeout = 5000;
        }
        if (method == null) {
            method = postContent != null ? HttpRequestMethod.POST : HttpRequestMethod.GET;
        }
        url = JenkinsResultsParserUtil.fixURL(url);
        String key = url.replace("//", "/");
        if (checkCache && !url.startsWith("file:")) {
            File cachedFile;
            if (debug) {
                System.out.println("Loading " + url);
            }
            if ((cachedFile = JenkinsResultsParserUtil._getCacheFile(_PREFIX_TO_STRING_CACHE + key)) != null && cachedFile.exists()) {
                FileReader fileReader = new FileReader(cachedFile);
                return new BufferedReader(fileReader);
            }
        }
        int retryCount = 0;
        while (true) {
            try {
                URL urlObject;
                URLConnection urlConnection;
                Properties buildProperties;
                if (debug) {
                    System.out.println("Downloading " + url);
                }
                if (httpAuthorizationHeader == null && url.startsWith("https://api.github.com")) {
                    buildProperties = JenkinsResultsParserUtil.getBuildProperties();
                    httpAuthorizationHeader = new TokenHTTPAuthorization(buildProperties.getProperty("github.access.token"));
                }
                if (httpAuthorizationHeader == null && url.matches("https://liferay.spiraservice.net.+")) {
                    buildProperties = JenkinsResultsParserUtil.getBuildProperties();
                    httpAuthorizationHeader = new BasicHTTPAuthorization(buildProperties.getProperty("spira.admin.user.token"), buildProperties.getProperty("spira.admin.user.name"));
                }
                if (httpAuthorizationHeader == null && url.matches("https://test-\\d+-\\d+.liferay.com/.+")) {
                    buildProperties = JenkinsResultsParserUtil.getBuildProperties();
                    httpAuthorizationHeader = new BasicHTTPAuthorization(buildProperties.getProperty("jenkins.admin.user.token"), buildProperties.getProperty("jenkins.admin.user.name"));
                }
                if ((urlConnection = (urlObject = new URL(url)).openConnection()) instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
                    if (method == HttpRequestMethod.PATCH) {
                        httpURLConnection.setRequestMethod("POST");
                        httpURLConnection.setRequestProperty("X-HTTP-Method-Override", "PATCH");
                    } else {
                        httpURLConnection.setRequestMethod(method.name());
                    }
                    if (url.startsWith("https://api.github.com") && httpURLConnection instanceof HttpsURLConnection) {
                        SSLContext sslContext = null;
                        try {
                            if (JenkinsResultsParserUtil.getJavaVersionNumber() < 1.8f) {
                                sslContext = SSLContext.getInstance("TLSv1.2");
                                sslContext.init(null, null, null);
                                HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpURLConnection;
                                httpsURLConnection.setSSLSocketFactory(sslContext.getSocketFactory());
                            }
                        }
                        catch (KeyManagementException | NoSuchAlgorithmException exception) {
                            throw new RuntimeException("Unable to set SSL context to TLS v1.2", exception);
                        }
                    }
                    if (httpAuthorizationHeader != null) {
                        httpURLConnection.setRequestProperty("accept", "application/json");
                        httpURLConnection.setRequestProperty("Authorization", httpAuthorizationHeader.toString());
                        httpURLConnection.setRequestProperty("Content-Type", "application/json");
                    }
                    if (postContent != null) {
                        if (method == null) {
                            httpURLConnection.setRequestMethod("POST");
                        }
                        httpURLConnection.setDoOutput(true);
                        try (OutputStream outputStream = httpURLConnection.getOutputStream();){
                            outputStream.write(postContent.getBytes("UTF-8"));
                            outputStream.flush();
                        }
                    }
                }
                if (timeout != 0) {
                    urlConnection.setConnectTimeout(timeout);
                    urlConnection.setReadTimeout(timeout);
                }
                urlConnection.connect();
                if (url.startsWith("https://api.github.com")) {
                    try {
                        int limit = Integer.parseInt(urlConnection.getHeaderField("X-RateLimit-Limit"));
                        int remaining = Integer.parseInt(urlConnection.getHeaderField("X-RateLimit-Remaining"));
                        long reset = Long.parseLong(urlConnection.getHeaderField("X-RateLimit-Reset"));
                        System.out.println(JenkinsResultsParserUtil.combine(JenkinsResultsParserUtil._getGitHubAPIRateLimitStatusMessage(limit, remaining, reset), "\n    ", url));
                    }
                    catch (Exception exception) {
                        System.out.println("Unable to parse GitHub API rate limit headers");
                        exception.printStackTrace();
                    }
                }
                return new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            }
            catch (IOException ioException) {
                if (ioException instanceof UnknownHostException && url.matches("http://test-\\d+-\\d+/.*")) {
                    return JenkinsResultsParserUtil.toBufferedReader(url.replaceAll("http://(test-\\d+-\\d+)(/.*)", "https://$1.liferay.com$2"), checkCache, maxRetries, method, postContent, retryPeriod, timeout, httpAuthorizationHeader);
                }
                if (maxRetries >= 0 && ++retryCount >= maxRetries) {
                    throw ioException;
                }
                System.out.println("Retrying " + url + " in " + retryPeriod + " seconds");
                JenkinsResultsParserUtil.sleep(1000 * retryPeriod);
                continue;
            }
            break;
        }
    }

    public static String toByteCountString(long byteCount) {
        long gigabyteCount = byteCount / 0x40000000L;
        if (gigabyteCount > 0L) {
            return gigabyteCount + " GB";
        }
        long megabyteCount = byteCount / 0x100000L;
        if (megabyteCount > 0L) {
            return megabyteCount + " MB";
        }
        long kilobyteCount = byteCount / 1024L;
        if (kilobyteCount > 0L) {
            return kilobyteCount + " KB";
        }
        return byteCount + " B";
    }

    public static String toDateString(Date date, String timeZoneName) {
        return JenkinsResultsParserUtil.toDateString(date, "MMM dd, yyyy h:mm:ss a z", timeZoneName);
    }

    public static String toDateString(Date date, String format, String timeZoneName) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        if (timeZoneName != null) {
            sdf.setTimeZone(TimeZone.getTimeZone(timeZoneName));
        }
        return sdf.format(date);
    }

    public static String toDurationString(long duration) {
        long remainingDuration = duration;
        StringBuilder sb = new StringBuilder();
        remainingDuration = JenkinsResultsParserUtil._appendDurationStringForUnit(remainingDuration, 86400000L, false, sb, "day", "days");
        remainingDuration = JenkinsResultsParserUtil._appendDurationStringForUnit(remainingDuration, 3600000L, false, sb, "hour", "hours");
        remainingDuration = JenkinsResultsParserUtil._appendDurationStringForUnit(remainingDuration, 60000L, true, sb, "minute", "minutes");
        if (duration < 60000L) {
            remainingDuration = JenkinsResultsParserUtil._appendDurationStringForUnit(remainingDuration, 1000L, true, sb, "second", "seconds");
        }
        if (duration < 1000L) {
            JenkinsResultsParserUtil._appendDurationStringForUnit(remainingDuration, 1L, true, sb, "ms", "ms");
        }
        String durationString = sb.toString();
        if ((durationString = durationString.trim()).equals("")) {
            durationString = "0 ms";
        }
        return durationString;
    }

    public static void toFile(URL url, File file) {
        try {
            System.out.println(JenkinsResultsParserUtil.combine("Downloading ", url.toString(), " to ", JenkinsResultsParserUtil.getCanonicalPath(file)));
            FileUtils.copyURLToFile((URL)url, (File)file);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public static JSONArray toJSONArray(String url) throws IOException {
        return JenkinsResultsParserUtil.toJSONArray(url, true, 3, null, 5, 0, null);
    }

    public static JSONArray toJSONArray(String url, boolean checkCache) throws IOException {
        return JenkinsResultsParserUtil.toJSONArray(url, checkCache, 3, null, 5, 0, null);
    }

    public static JSONArray toJSONArray(String url, boolean checkCache, int maxRetries, String postContent, int retryPeriod, int timeout) throws IOException {
        return JenkinsResultsParserUtil.toJSONArray(url, checkCache, maxRetries, postContent, retryPeriod, timeout, null);
    }

    public static JSONArray toJSONArray(String url, boolean checkCache, int maxRetries, String postContent, int retryPeriod, int timeout, HTTPAuthorization httpAuthorization) throws IOException {
        String response = JenkinsResultsParserUtil.toString(url, checkCache, maxRetries, null, postContent, retryPeriod, timeout, httpAuthorization);
        if (response == null || response.endsWith("was truncated due to its size.")) {
            return null;
        }
        return new JSONArray(response);
    }

    public static JSONArray toJSONArray(String url, String postContent) throws IOException {
        return JenkinsResultsParserUtil.toJSONArray(url, false, 3, postContent, 5, 0, null);
    }

    public static JSONArray toJSONArray(String url, String postContent, HTTPAuthorization httpAuthorization) throws IOException {
        return JenkinsResultsParserUtil.toJSONArray(url, false, 3, postContent, 5, 0, httpAuthorization);
    }

    public static JSONObject toJSONObject(String url) throws IOException {
        return JenkinsResultsParserUtil.toJSONObject(url, true, 3, null, null, 5, 0, null);
    }

    public static JSONObject toJSONObject(String url, boolean checkCache) throws IOException {
        return JenkinsResultsParserUtil.toJSONObject(url, checkCache, 3, null, null, 5, 0, null);
    }

    public static JSONObject toJSONObject(String url, boolean checkCache, HttpRequestMethod method) throws IOException {
        return JenkinsResultsParserUtil.toJSONObject(url, checkCache, 3, method, null, 5, 0, null);
    }

    public static JSONObject toJSONObject(String url, boolean checkCache, int timeout) throws IOException {
        return JenkinsResultsParserUtil.toJSONObject(url, checkCache, 3, null, null, 5, timeout, null);
    }

    public static JSONObject toJSONObject(String url, boolean checkCache, int maxRetries, HttpRequestMethod method, String postContent, int retryPeriod, int timeout, HTTPAuthorization httpAuthorization) throws IOException {
        String response = JenkinsResultsParserUtil.toString(url, checkCache, maxRetries, null, postContent, retryPeriod, timeout, httpAuthorization);
        if (response == null || response.endsWith("was truncated due to its size.")) {
            return null;
        }
        return JenkinsResultsParserUtil.createJSONObject(response);
    }

    public static JSONObject toJSONObject(String url, boolean checkCache, int maxRetries, int retryPeriod, int timeout) throws IOException {
        return JenkinsResultsParserUtil.toJSONObject(url, checkCache, maxRetries, null, null, retryPeriod, timeout, null);
    }

    public static JSONObject toJSONObject(String url, boolean checkCache, int maxRetries, String postContent, int retryPeriod, int timeout) throws IOException {
        return JenkinsResultsParserUtil.toJSONObject(url, checkCache, maxRetries, null, postContent, retryPeriod, timeout, null);
    }

    public static JSONObject toJSONObject(String url, String postContent) throws IOException {
        return JenkinsResultsParserUtil.toJSONObject(url, false, 3, null, postContent, 5, 0, null);
    }

    public static JSONObject toJSONObject(String url, String postContent, HTTPAuthorization httpAuthorization) throws IOException {
        return JenkinsResultsParserUtil.toJSONObject(url, false, 3, null, postContent, 5, 0, httpAuthorization);
    }

    public static List<PathMatcher> toPathMatchers(String prefix, String ... globs) {
        if (prefix == null) {
            prefix = "";
        }
        FileSystem fileSystem = FileSystems.getDefault();
        ArrayList<PathMatcher> pathMatchers = new ArrayList<PathMatcher>(globs.length);
        for (String glob : globs) {
            pathMatchers.add(fileSystem.getPathMatcher(JenkinsResultsParserUtil.combine("glob:", prefix, glob)));
        }
        return pathMatchers;
    }

    public static Properties toProperties(String url) throws IOException {
        Properties properties = new Properties();
        properties.load(new StringReader(JenkinsResultsParserUtil.toString(url)));
        return properties;
    }

    public static String toString(String url) throws IOException {
        return JenkinsResultsParserUtil.toString(url, true, 3, null, null, 5, 0, null);
    }

    public static String toString(String url, boolean checkCache) throws IOException {
        return JenkinsResultsParserUtil.toString(url, checkCache, 3, null, null, 5, 0, null);
    }

    public static String toString(String url, boolean checkCache, HttpRequestMethod method) throws IOException {
        return JenkinsResultsParserUtil.toString(url, checkCache, 3, method, null, 5, 0, null);
    }

    public static String toString(String url, boolean checkCache, HttpRequestMethod method, String postContent) throws IOException {
        return JenkinsResultsParserUtil.toString(url, checkCache, 3, method, postContent, 5, 0, null);
    }

    public static String toString(String url, boolean checkCache, int timeout) throws IOException {
        return JenkinsResultsParserUtil.toString(url, checkCache, 3, null, null, 5, timeout, null);
    }

    public static String toString(String url, boolean checkCache, int maxRetries, HttpRequestMethod method, String postContent, int retryPeriod, int timeout, HTTPAuthorization httpAuthorizationHeader) throws IOException {
        try (BufferedReader bufferedReader = JenkinsResultsParserUtil.toBufferedReader(url, checkCache, maxRetries, method, postContent, retryPeriod, timeout, httpAuthorizationHeader);){
            StringBuilder sb = new StringBuilder();
            String line = bufferedReader.readLine();
            while (line != null) {
                sb.append(line);
                sb.append("\n");
                line = bufferedReader.readLine();
            }
            int bytes = sb.length();
            String content = sb.toString();
            if (checkCache && !url.startsWith("file:") && bytes < 0x300000) {
                url = JenkinsResultsParserUtil.fixURL(url);
                String key = url.replace("//", "/");
                JenkinsResultsParserUtil.saveToCacheFile(_PREFIX_TO_STRING_CACHE + key, content);
            }
            String string = content;
            return string;
        }
    }

    public static String toString(String url, boolean checkCache, int maxRetries, int retryPeriodSeconds, int timeout) throws IOException {
        return JenkinsResultsParserUtil.toString(url, checkCache, maxRetries, null, null, retryPeriodSeconds, timeout, null);
    }

    public static String toString(String url, boolean checkCache, int maxRetries, String postContent, int retryPeriod, int timeout) throws IOException {
        return JenkinsResultsParserUtil.toString(url, checkCache, maxRetries, null, postContent, retryPeriod, timeout, null);
    }

    public static String toString(String url, HttpRequestMethod method) throws IOException {
        return JenkinsResultsParserUtil.toString(url, true, 3, method, null, 5, 0, null);
    }

    public static String toString(String url, HttpRequestMethod method, String postContent) throws IOException {
        return JenkinsResultsParserUtil.toString(url, false, 3, method, postContent, 5, 0, null);
    }

    public static String toString(String url, String postContent) throws IOException {
        return JenkinsResultsParserUtil.toString(url, false, 3, null, postContent, 5, 0, null);
    }

    public static String toString(String url, String postContent, HTTPAuthorization httpAuthorization) throws IOException {
        return JenkinsResultsParserUtil.toString(url, false, 3, null, postContent, 5, 0, httpAuthorization);
    }

    public static void updateBuildDescription(String buildDescription, int buildNumber, String jobName, String masterHostname) {
        buildDescription = buildDescription.replaceAll("\"", "\\\\\"");
        buildDescription = buildDescription.replaceAll("'", "\\\\'");
        String jenkinsScript = JenkinsResultsParserUtil.combine("def job = Jenkins.instance.getItemByFullName(\"", jobName, "\"); def build = job.getBuildByNumber(", String.valueOf(buildNumber), "); build.description = \"", buildDescription, "\";");
        JenkinsResultsParserUtil.executeJenkinsScript(masterHostname, jenkinsScript);
    }

    public static void updateBuildResult(int buildNumber, String buildResult, String jobName, String masterHostname) {
        String jenkinsScript = JenkinsResultsParserUtil.combine("def job = Jenkins.instance.getItemByFullName(\"", jobName, "\"); ", "def build = job.getBuildByNumber(", String.valueOf(buildNumber), "); build.@result = hudson.model.Result.", buildResult, ";");
        JenkinsResultsParserUtil.executeJenkinsScript(masterHostname, jenkinsScript);
    }

    public static void write(File file, String content) throws IOException {
        if (debug) {
            System.out.println("Write file " + file + " with length " + content.length());
        }
        if (file.exists()) {
            file.delete();
        }
        JenkinsResultsParserUtil.append(file, content);
    }

    public static void write(String path, String content) throws IOException {
        if (path.startsWith("${dependencies.url}")) {
            path = path.replace("${dependencies.url}", URL_DEPENDENCIES_FILE.replace("file:", ""));
        }
        JenkinsResultsParserUtil.write(new File(path), content);
    }

    public static void writePropertiesFile(File propertiesFile, Properties properties, boolean verbose) {
        if (propertiesFile.exists()) {
            propertiesFile.delete();
        }
        if (properties.isEmpty()) {
            return;
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(propertiesFile);){
            properties.store(fileOutputStream, "Generated by com.liferay.jenkins.results.parser");
        }
        catch (IOException ioException) {
            System.out.println("Unable to write properties file " + propertiesFile);
            ioException.printStackTrace();
        }
        if (verbose) {
            System.out.println("#");
            System.out.println("# " + propertiesFile);
            System.out.println("#\n");
            try {
                System.out.println(JenkinsResultsParserUtil.read(propertiesFile));
            }
            catch (IOException ioException) {
                throw new RuntimeException("Unable to read properties file " + propertiesFile, ioException);
            }
        }
    }

    protected static String initCacheURL() {
        File cacheDir;
        String cacheDirPath = System.getenv("CACHE_DIR");
        if (cacheDirPath != null && (cacheDir = new File(cacheDirPath)).exists()) {
            String cachedRepository;
            File cacheRepositoryDir;
            String[] stringArray = CACHED_REPOSITORIES;
            int n = stringArray.length;
            for (int i = 0; i < n && (cacheRepositoryDir = new File(cacheDir, cachedRepository = stringArray[i])).exists(); ++i) {
            }
            System.out.println("Using " + cacheDirPath + " for cached files");
            return "file://" + cacheDirPath;
        }
        return "http://mirrors-no-cache.lax.liferay.com/github.com/liferay";
    }

    private static long _appendDurationStringForUnit(long duration, long millisInUnit, boolean round, StringBuilder sb, String unitDescriptionSingular, String unitDescriptionPlural) {
        if (duration >= millisInUnit) {
            long units = duration / millisInUnit;
            long remainder = duration % millisInUnit;
            if (round && remainder >= millisInUnit / 2L) {
                ++units;
            }
            sb.append(units);
            sb.append(" ");
            sb.append(JenkinsResultsParserUtil.getNounForm((int)units, unitDescriptionPlural, unitDescriptionSingular));
            sb.append(" ");
            return remainder;
        }
        return duration;
    }

    private static void _executeCommandService(final String command, final File baseDir, final Map<String, String> environments, final long maxLogSize, final boolean batchCommand) {
        if (batchCommand && !JenkinsResultsParserUtil.isWindows()) {
            throw new RuntimeException("Invalid OS: " + SystemUtils.OS_NAME);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StringBuilder sb = new StringBuilder();
                try {
                    if (JenkinsResultsParserUtil.isWindows()) {
                        if (batchCommand) {
                            sb.append("cmd.exe /c ");
                        } else {
                            sb.append("C:\\Program Files\\Git\\bin\\sh.exe ");
                        }
                    } else {
                        sb.append("/bin/sh ");
                    }
                    sb.append(command);
                    Runtime runtime = Runtime.getRuntime();
                    String[] environmentParameters = new String[environments.size()];
                    int i = 0;
                    for (Map.Entry environment : environments.entrySet()) {
                        environmentParameters[i] = JenkinsResultsParserUtil.combine((String)environment.getKey(), "=", (String)environment.getValue());
                        ++i;
                    }
                    Process process = runtime.exec(sb.toString(), environmentParameters, baseDir);
                    try (CountingInputStream countingInputStream = new CountingInputStream(process.getInputStream());
                         InputStreamReader inputStreamReader = new InputStreamReader((InputStream)countingInputStream, StandardCharsets.UTF_8);){
                        int logCharInt = 0;
                        while ((logCharInt = inputStreamReader.read()) != -1) {
                            if (countingInputStream.getCount() > maxLogSize) continue;
                            System.out.print((char)logCharInt);
                        }
                    }
                    process.waitFor();
                }
                catch (IOException | InterruptedException exception) {
                    throw new RuntimeException(exception);
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    private static File _getCacheFile(String key) {
        String fileName = JenkinsResultsParserUtil.combine(System.getProperty("java.io.tmpdir"), "/jenkins-cached-files/", String.valueOf(key.hashCode()), ".txt");
        return new File(fileName);
    }

    private static String _getCanonicalPath(File canonicalFile) {
        File parentCanonicalFile = canonicalFile.getParentFile();
        if (parentCanonicalFile == null) {
            String absolutePath = canonicalFile.getAbsolutePath();
            return absolutePath.substring(0, absolutePath.indexOf(File.separator));
        }
        String parentFileCanonicalPath = JenkinsResultsParserUtil._getCanonicalPath(parentCanonicalFile);
        return JenkinsResultsParserUtil.combine(parentFileCanonicalPath, "/", canonicalFile.getName());
    }

    private static Pattern _getDistPortalBundleFileNamesPattern(String portalBranchName) {
        try {
            String distPortalBundleFileNames = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "dist.portal.bundle.file.names", portalBranchName);
            if (distPortalBundleFileNames == null) {
                distPortalBundleFileNames = _DIST_PORTAL_BUNDLE_FILE_NAMES_DEFAULT;
            }
            StringBuilder sb = new StringBuilder();
            ArrayList distPortalBundleFileNamesList = Lists.newArrayList((Object[])distPortalBundleFileNames.split("\\s*,\\s*"));
            Collections.sort(distPortalBundleFileNamesList);
            for (String distPortalBundleFileName : distPortalBundleFileNamesList) {
                String quotedDistPortalBundleFileName = Pattern.quote(distPortalBundleFileName);
                sb.append("\\<a href=\"");
                sb.append(quotedDistPortalBundleFileName);
                sb.append("\"\\>");
                sb.append(quotedDistPortalBundleFileName);
                sb.append("\\</a\\>.*");
            }
            sb.setLength(sb.length() - 2);
            return Pattern.compile(sb.toString(), 32);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to load build properties", ioException);
        }
    }

    private static String _getDistPortalBundlesURL(String portalBranchName) {
        try {
            String distPortalBundlesURL = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "dist.portal.bundles.url", portalBranchName);
            if (distPortalBundlesURL != null) {
                return distPortalBundlesURL;
            }
        }
        catch (IOException ioException) {
            System.out.println("WARNING: " + ioException.getMessage());
        }
        return JenkinsResultsParserUtil.combine(_DIST_PORTAL_BUNDLES_URL_DEFAULT, "(", portalBranchName, ")/");
    }

    private static String _getDistPortalJobURL(String portalBranchName) {
        try {
            String distPortalJobURL = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "dist.portal.job.url", portalBranchName);
            if (distPortalJobURL != null) {
                return distPortalJobURL;
            }
        }
        catch (IOException ioException) {
            System.out.println("WARNING: " + ioException.getMessage());
        }
        return JenkinsResultsParserUtil.combine(_DIST_PORTAL_JOB_URL_DEFAULT, "(", portalBranchName, ")");
    }

    private static String _getFilteredPropertyValue(String propertyValue) {
        if (propertyValue == null) {
            return null;
        }
        ArrayList<String> propertyValues = new ArrayList<String>();
        for (String value : propertyValue.split("\\s*,\\s*")) {
            if (value.startsWith("#")) continue;
            propertyValues.add(value);
        }
        return JenkinsResultsParserUtil.join(",", propertyValues);
    }

    private static String _getGitHubAPIRateLimitStatusMessage(int limit, int remaining, long reset) {
        StringBuilder sb = new StringBuilder();
        sb.append(remaining);
        sb.append(" GitHub API calls out of ");
        sb.append(limit);
        sb.append(" remain. GitHub API call limit will reset in ");
        sb.append(JenkinsResultsParserUtil.toDurationString(1000L * reset - System.currentTimeMillis()));
        sb.append(".");
        return sb.toString();
    }

    private static Set<Set<String>> _getOrderedOptSets(String ... opts) {
        LinkedHashSet<Set<String>> optSets = new LinkedHashSet<Set<String>>();
        optSets.add(new LinkedHashSet<String>(Arrays.asList(opts)));
        int optCount = opts.length;
        for (int i = optCount - 1; i >= 0; --i) {
            String[] childOpts = new String[optCount - 1];
            if (childOpts.length == 0) continue;
            for (int j = 0; j < optCount; ++j) {
                if (j < i) {
                    childOpts[j] = opts[j];
                    continue;
                }
                if (j <= i) continue;
                childOpts[j - 1] = opts[j];
            }
            optSets.addAll(JenkinsResultsParserUtil._getOrderedOptSets(childOpts));
        }
        LinkedHashSet<Set<String>> orderedOptSet = new LinkedHashSet<Set<String>>();
        for (int i = optCount; i > 0; --i) {
            for (Set set : optSets) {
                if (set.size() != i) continue;
                orderedOptSet.add(set);
            }
        }
        return orderedOptSet;
    }

    private static Properties _getProperties(File basePropertiesFile) {
        String[] environments;
        if (!basePropertiesFile.exists()) {
            throw new RuntimeException("Unable to find properties file " + basePropertiesFile.getPath());
        }
        ArrayList<File> propertiesFiles = new ArrayList<File>();
        propertiesFiles.add(basePropertiesFile);
        String propertiesFileName = basePropertiesFile.getName();
        for (String environment : environments = new String[]{System.getenv("HOSTNAME"), System.getenv("HOST"), System.getenv("COMPUTERNAME"), System.getProperty("user.name")}) {
            File environmentPropertyFile;
            if (environment == null || !(environmentPropertyFile = new File(basePropertiesFile.getParentFile(), propertiesFileName.replace(".properties", "." + environment + ".properties"))).exists()) continue;
            propertiesFiles.add(environmentPropertyFile);
        }
        Properties properties = new Properties();
        try {
            for (File propertiesFile : propertiesFiles) {
                properties.load(new FileInputStream(propertiesFile));
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to load properties file " + basePropertiesFile.getPath(), ioException);
        }
        for (String propertyName : properties.stringPropertyNames()) {
            properties.setProperty(propertyName, JenkinsResultsParserUtil.getProperty(properties, propertyName));
        }
        return properties;
    }

    private static String _getProperty(Properties properties, List<String> previousNames, String name) {
        if (previousNames.contains(name)) {
            if (previousNames.size() > 1) {
                StringBuilder sb = new StringBuilder();
                sb.append("Circular property reference chain found\n");
                for (String previousName : previousNames) {
                    sb.append(previousName);
                    sb.append(" -> ");
                }
                sb.append(name);
                throw new IllegalStateException(sb.toString());
            }
            return JenkinsResultsParserUtil.combine("${", name, "}");
        }
        previousNames.add(name);
        if (!properties.containsKey(name)) {
            return null;
        }
        String value = JenkinsResultsParserUtil._getFilteredPropertyValue(properties.getProperty(name));
        Matcher matcher = _nestedPropertyPattern.matcher(value);
        String newValue = value;
        while (matcher.find()) {
            String propertyGroup = matcher.group(0);
            String propertyName = matcher.group(1);
            if (!properties.containsKey(propertyName)) continue;
            newValue = newValue.replace(propertyGroup, JenkinsResultsParserUtil._getProperty(properties, new ArrayList<String>(previousNames), propertyName));
        }
        return newValue;
    }

    private static Map<String, Set<String>> _getPropertyOptRegexSets(Set<String> propertyNames) {
        HashMap propertyOptSets = new HashMap();
        HashMap<String, Integer> propertyOptSetSizes = new HashMap<String, Integer>();
        HashMap<String, Integer> propertyRegexCounts = new HashMap<String, Integer>();
        int maxOptCount = 0;
        for (String propertyName : propertyNames) {
            Matcher matcher = _propertyOptionPattern.matcher(propertyName);
            LinkedHashSet<String> optSet = new LinkedHashSet<String>();
            while (matcher.find()) {
                String opt = matcher.group("opt");
                opt = Pattern.quote(opt);
                optSet.add(opt.replaceAll("\\*", "\\\\E.+\\\\Q"));
            }
            if (optSet.size() > maxOptCount) {
                maxOptCount = optSet.size();
            }
            propertyOptSetSizes.put(propertyName, optSet.size());
            propertyOptSets.put(propertyName, optSet);
            int regexCount = 0;
            for (String opt : optSet) {
                if (!opt.contains(".+")) continue;
                ++regexCount;
            }
            propertyRegexCounts.put(propertyName, regexCount);
        }
        LinkedHashMap<String, Set<String>> propertyOptRegexSets = new LinkedHashMap<String, Set<String>>();
        for (int i = maxOptCount; i >= 0; --i) {
            for (int j = 0; j <= i; ++j) {
                for (Map.Entry entry : propertyOptSets.entrySet()) {
                    String propertyName = (String)entry.getKey();
                    int optSetSize = (Integer)propertyOptSetSizes.get(propertyName);
                    int regexCount = (Integer)propertyRegexCounts.get(propertyName);
                    if (optSetSize != i || regexCount != j) continue;
                    propertyOptRegexSets.put(propertyName, (Set<String>)entry.getValue());
                }
            }
        }
        return propertyOptRegexSets;
    }

    private static String _getRedactTokenKey(int index) {
        return "github.message.redact.token[" + index + "]";
    }

    private static void _initializeRedactTokens() {
        Properties properties = null;
        try {
            properties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build properties", ioException);
        }
        _redactTokens.clear();
        int i = 1;
        while (properties.containsKey(JenkinsResultsParserUtil._getRedactTokenKey(i))) {
            String key = JenkinsResultsParserUtil._getRedactTokenKey(i);
            String redactToken = JenkinsResultsParserUtil.getProperty(properties, key);
            if (redactToken != null) {
                if (redactToken.length() < 5 && redactToken.matches("\\d+")) {
                    System.out.println(JenkinsResultsParserUtil.combine("Ignoring ", key, " because the value is numeric and ", "less than 5 characters long."));
                } else if (!redactToken.isEmpty()) {
                    _redactTokens.add(redactToken);
                }
            }
            ++i;
        }
        _redactTokens.remove("test");
    }

    private static boolean _isJSONExpectedAndActualEqual(Object expected, Object actual) {
        return !(actual instanceof JSONObject ? !(expected instanceof JSONObject) || !JenkinsResultsParserUtil.isJSONObjectEqual((JSONObject)expected, (JSONObject)actual) : (actual instanceof JSONArray ? !(expected instanceof JSONArray) || !JenkinsResultsParserUtil.isJSONArrayEqual((JSONArray)expected, (JSONArray)actual) : !actual.equals(expected)));
    }

    static {
        URL_DEPENDENCIES_HTTP = URL_CACHE + "/liferay-jenkins-results-parser-samples-ee/1/";
        File dependenciesDir = new File("src/test/resources/dependencies/");
        try {
            URI uri = dependenciesDir.toURI();
            URL url = uri.toURL();
            URL_DEPENDENCIES_FILE = url.toString();
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
        _buildIDPattern = Pattern.compile("(?<cohortNumber>[\\d]{1})(?<masterNumber>[\\d]{2})(?<spiraReleaseID>[\\d]+)_(?<buildNumber>[\\d]+)");
        _buildProperties = new Hashtable();
        _curlyBraceExpansionPattern = Pattern.compile("\\{.*?\\}");
        _javaVersionPattern = Pattern.compile("(\\d+\\.\\d+)");
        _jenkinsMasterPattern = Pattern.compile("(?<cohortName>test-\\d+)-\\d+");
        _jenkinsSlavesPropertyNamePattern = Pattern.compile("master.slaves\\((.+)\\)");
        _localURLAuthorityPattern1 = Pattern.compile("http://((release|test)-[0-9]+)/([0-9]+)/");
        _localURLAuthorityPattern2 = Pattern.compile("http://(test-[0-9]+-[0-9]+)/");
        _nestedPropertyPattern = Pattern.compile("\\$\\{([^\\}]+)\\}");
        _propertyOptionPattern = Pattern.compile("\\[(?<opt>[^\\]]+)\\]");
        _redactTokens = new HashSet<String>();
        _remoteURLAuthorityPattern1 = Pattern.compile("https://(release|test).liferay.com/([0-9]+)/");
        _remoteURLAuthorityPattern2 = Pattern.compile("https://(test-[0-9]+-[0-9]+).liferay.com/");
        _sshDir = new File(JenkinsResultsParserUtil.getUserHomeDir(), ".ssh"){
            {
                if (!this.exists()) {
                    this.mkdirs();
                }
            }
        };
        _timeStamps = new HashSet<String>();
        _topLevelBuildURLPattern = Pattern.compile("http(?:|s):\\/\\/test-(?<cohortNumber>[\\d]{1})-(?<masterNumber>[\\d]{1,2}).*(?:|\\.liferay\\.com)\\/job\\/(?<jobName>[\\w\\W]*?)\\/(?<buildNumber>[0-9]*)");
        _userHomeDir = new File(System.getProperty("user.home"));
        try {
            JenkinsResultsParserUtil._initializeRedactTokens();
            System.setErr(new SecurePrintStream(System.err));
            System.setOut(new SecurePrintStream(System.out));
            System.out.println("Securing standard error and out");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class TokenHTTPAuthorization
    extends HTTPAuthorization {
        protected String token;

        public TokenHTTPAuthorization(String token) {
            super(HTTPAuthorization.Type.TOKEN);
            this.token = token;
        }

        public String toString() {
            return JenkinsResultsParserUtil.combine("token ", this.token);
        }
    }

    public static enum HttpRequestMethod {
        DELETE,
        GET,
        HEAD,
        OPTIONS,
        PATCH,
        POST,
        PUT,
        TRACE;

    }

    public static abstract class HTTPAuthorization {
        protected Type type;

        public Type getType() {
            return this.type;
        }

        protected HTTPAuthorization(Type type) {
            this.type = type;
        }

        public static enum Type {
            BASIC,
            TOKEN;

        }
    }

    public static class BasicHTTPAuthorization
    extends HTTPAuthorization {
        protected String password;
        protected String username;

        public BasicHTTPAuthorization(String password, String username) {
            super(HTTPAuthorization.Type.BASIC);
            this.password = password;
            this.username = username;
        }

        public String toString() {
            String authorization = JenkinsResultsParserUtil.combine(this.username, ":", this.password);
            return JenkinsResultsParserUtil.combine("Basic ", Base64.encodeBase64String((byte[])authorization.getBytes()));
        }
    }
}

