/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsNode;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.JenkinsSlave;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.TreeMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class JenkinsMaster
implements JenkinsNode<JenkinsMaster> {
    public static final Integer SLAVE_RAM_DEFAULT = 16;
    public static final Integer SLAVES_PER_HOST_DEFAULT = 2;
    protected static long maxRecentBatchAge = 120000L;
    private boolean _available;
    private final Map<Long, Integer> _batchSizes = new TreeMap<Long, Integer>();
    private List<String> _buildURLs = new ArrayList<String>();
    private final Map<String, JenkinsSlave> _jenkinsSlavesMap = new HashMap<String, JenkinsSlave>();
    private final String _masterName;
    private final String _masterURL;
    private int _queueCount;
    private List<String> _queuedBuildURLs = new ArrayList<String>();
    private int _reportedAvailableSlavesCount;
    private final Integer _slaveRAM;
    private final Integer _slavesPerHost;

    public static Integer getSlaveRAMMinimumDefault() {
        try {
            String propertyValue = JenkinsResultsParserUtil.getBuildProperty("slave.ram.minimum.default");
            return Integer.valueOf(propertyValue);
        }
        catch (Exception exception) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unable to get property '");
            sb.append("slave.ram.minimum.default");
            sb.append("', defaulting to '");
            sb.append(SLAVE_RAM_DEFAULT);
            sb.append("'");
            System.out.println(sb.toString());
            exception.printStackTrace();
            return SLAVE_RAM_DEFAULT;
        }
    }

    public static Integer getSlavesPerHostDefault() {
        try {
            String propertyValue = JenkinsResultsParserUtil.getBuildProperty("slaves.per.host.default");
            return Integer.valueOf(propertyValue);
        }
        catch (Exception exception) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unable to get property '");
            sb.append("slaves.per.host.default");
            sb.append("', defaulting to '");
            sb.append(SLAVES_PER_HOST_DEFAULT);
            sb.append("'");
            System.out.println(sb.toString());
            exception.printStackTrace();
            return SLAVES_PER_HOST_DEFAULT;
        }
    }

    public JenkinsMaster(String masterName) {
        this._masterName = masterName.contains(".") ? masterName.substring(0, masterName.indexOf(".")) : masterName;
        try {
            Properties properties = JenkinsResultsParserUtil.getBuildProperties();
            this._masterURL = properties.getProperty(JenkinsResultsParserUtil.combine("jenkins.local.url[", this._masterName, "]"));
            Integer slaveRAM = JenkinsMaster.getSlaveRAMMinimumDefault();
            String slaveRAMString = JenkinsResultsParserUtil.getProperty(properties, JenkinsResultsParserUtil.combine("master.property(", this._masterName, "/slave.ram)"));
            if (slaveRAMString != null && slaveRAMString.matches("\\d+")) {
                slaveRAM = Integer.valueOf(slaveRAMString);
            }
            this._slaveRAM = slaveRAM;
            Integer slavesPerHost = JenkinsMaster.getSlavesPerHostDefault();
            String slavesPerHostString = JenkinsResultsParserUtil.getProperty(properties, JenkinsResultsParserUtil.combine("master.property(", this._masterName, "/slaves.per.host)"));
            if (slavesPerHostString != null && slavesPerHostString.matches("\\d+")) {
                slavesPerHost = Integer.valueOf(slavesPerHostString);
            }
            this._slavesPerHost = slavesPerHost;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to determine URL for master " + this._masterName, exception);
        }
    }

    public synchronized void addRecentBatch(int batchSize) {
        this._batchSizes.put(System.currentTimeMillis() + maxRecentBatchAge, batchSize);
        this.getAvailableSlavesCount();
    }

    @Override
    public int compareTo(JenkinsMaster jenkinsMaster) {
        int result;
        Integer value = null;
        Integer availableSlavesCount = this.getAvailableSlavesCount();
        Integer otherAvailableSlavesCount = jenkinsMaster.getAvailableSlavesCount();
        if (availableSlavesCount > 0 || otherAvailableSlavesCount > 0) {
            value = availableSlavesCount.compareTo(otherAvailableSlavesCount);
        }
        if (value == null || value == 0) {
            Float averageQueueLength = Float.valueOf(this.getAverageQueueLength());
            Float otherAverageQueueLength = Float.valueOf(jenkinsMaster.getAverageQueueLength());
            value = -1 * averageQueueLength.compareTo(otherAverageQueueLength);
        }
        if (value != 0) {
            return -value.intValue();
        }
        Random random = new Random();
        while ((result = random.nextInt(3) - 1) == 0) {
        }
        return result;
    }

    public int getAvailableSlavesCount() {
        return this.getIdleJenkinsSlavesCount() - this._queueCount - this._getRecentBatchSizesTotal();
    }

    public float getAverageQueueLength() {
        return ((float)this._queueCount + (float)this._getRecentBatchSizesTotal()) / (float)this.getOnlineJenkinsSlavesCount();
    }

    public List<String> getBuildURLs() {
        return this._buildURLs;
    }

    public int getIdleJenkinsSlavesCount() {
        int idleSlavesCount = 0;
        for (JenkinsSlave jenkinsSlave : this._jenkinsSlavesMap.values()) {
            if (jenkinsSlave.isOffline() || !jenkinsSlave.isIdle()) continue;
            ++idleSlavesCount;
        }
        return idleSlavesCount;
    }

    @Override
    public JenkinsMaster getJenkinsMaster() {
        return this;
    }

    public JenkinsSlave getJenkinsSlave(String jenkinsSlaveName) {
        if (this._jenkinsSlavesMap.isEmpty()) {
            this.update();
        }
        return this._jenkinsSlavesMap.get(jenkinsSlaveName);
    }

    @Override
    public String getName() {
        return this._masterName;
    }

    public int getOfflineJenkinsSlavesCount() {
        int offlineJenkinsSlavesCount = 0;
        for (JenkinsSlave jenkinsSlave : this._jenkinsSlavesMap.values()) {
            if (!jenkinsSlave.isOffline()) continue;
            ++offlineJenkinsSlavesCount;
        }
        return offlineJenkinsSlavesCount;
    }

    public List<JenkinsSlave> getOnlineJenkinsSlaves() {
        ArrayList<JenkinsSlave> onlineJenkinsSlaves = new ArrayList<JenkinsSlave>();
        for (JenkinsSlave jenkinsSlave : this._jenkinsSlavesMap.values()) {
            if (jenkinsSlave.isOffline()) continue;
            onlineJenkinsSlaves.add(jenkinsSlave);
        }
        return onlineJenkinsSlaves;
    }

    public int getOnlineJenkinsSlavesCount() {
        int onlineJenkinsSlavesCount = 0;
        for (JenkinsSlave jenkinsSlave : this._jenkinsSlavesMap.values()) {
            if (jenkinsSlave.isOffline()) continue;
            ++onlineJenkinsSlavesCount;
        }
        return onlineJenkinsSlavesCount;
    }

    public List<String> getQueuedBuildURLs() {
        return this._queuedBuildURLs;
    }

    public Integer getSlaveRAM() {
        return this._slaveRAM;
    }

    public Integer getSlavesPerHost() {
        return this._slavesPerHost;
    }

    public String getURL() {
        return this._masterURL;
    }

    public boolean isAvailable() {
        return this._available;
    }

    public String toString() {
        return JenkinsResultsParserUtil.combine("{availableSlavesCount=", String.valueOf(this.getAvailableSlavesCount()), ", masterURL=", this._masterURL, ", recentBatchSizesTotal=", String.valueOf(this._getRecentBatchSizesTotal()), ", reportedAvailableSlavesCount=", String.valueOf(this._reportedAvailableSlavesCount), "}");
    }

    public void update() {
        JSONObject computerAPIJSONObject = null;
        JSONObject queueAPIJSONObject = null;
        try {
            computerAPIJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(JenkinsResultsParserUtil.combine(this._masterURL, "/computer/api/json?tree=computer[displayName,", "executors[currentExecutable[url]],idle,offline]")), false, 5000);
            queueAPIJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(JenkinsResultsParserUtil.combine(this._masterURL, "/queue/api/json?tree=items[task[name,url],why]")), false, 5000);
        }
        catch (Exception exception) {
            System.out.println("Unable to read " + this._masterURL);
            this._available = false;
            return;
        }
        this._available = true;
        JSONArray computerJSONArray = computerAPIJSONObject.getJSONArray("computer");
        for (int i = 0; i < computerJSONArray.length(); ++i) {
            JSONObject computerJSONObject = computerJSONArray.getJSONObject(i);
            String jenkinsSlaveName = computerJSONObject.getString("displayName");
            if (jenkinsSlaveName.equals("master")) continue;
            JenkinsSlave jenkinsSlave = this._jenkinsSlavesMap.get(jenkinsSlaveName);
            if (jenkinsSlave != null) {
                jenkinsSlave.update(computerJSONObject);
            } else {
                jenkinsSlave = new JenkinsSlave(this, computerJSONObject);
                this._jenkinsSlavesMap.put(jenkinsSlave.getName(), jenkinsSlave);
            }
            String computerClassName = computerJSONObject.getString("_class");
            if (!computerClassName.contains("hudson.slaves.SlaveComputer")) continue;
            JSONArray executorsJSONArray = computerJSONObject.getJSONArray("executors");
            for (int j = 0; j < executorsJSONArray.length(); ++j) {
                JSONObject currentExecutableJSONObject;
                JSONObject executorJSONObject = executorsJSONArray.getJSONObject(j);
                if (!executorJSONObject.has("currentExecutable") || executorJSONObject.get("currentExecutable") == JSONObject.NULL || !(currentExecutableJSONObject = executorJSONObject.getJSONObject("currentExecutable")).has("url")) continue;
                this._buildURLs.add(currentExecutableJSONObject.getString("url"));
            }
        }
        this._queueCount = 0;
        if (!queueAPIJSONObject.has("items")) {
            return;
        }
        JSONArray itemsJSONArray = queueAPIJSONObject.getJSONArray("items");
        for (int i = 0; i < itemsJSONArray.length(); ++i) {
            String taskName;
            JSONObject itemJSONObject = itemsJSONArray.getJSONObject(i);
            JSONObject taskJSONObject = null;
            if (itemJSONObject.has("task")) {
                taskJSONObject = itemJSONObject.getJSONObject("task");
            }
            if (taskJSONObject != null && (taskName = taskJSONObject.getString("name")).equals("verification-node")) continue;
            if (itemJSONObject.has("why")) {
                String why = itemJSONObject.optString("why");
                if (why.startsWith("There are no nodes") || why.contains("already in progress") || why.endsWith("is offline")) continue;
                if (taskJSONObject != null && taskJSONObject.has("url")) {
                    this._queuedBuildURLs.add(taskJSONObject.getString("url"));
                }
            }
            ++this._queueCount;
        }
    }

    private synchronized int _getRecentBatchSizesTotal() {
        long currentTimestamp = System.currentTimeMillis();
        int recentBatchSizesTotal = 0;
        ArrayList<Long> expiredTimestamps = new ArrayList<Long>(this._batchSizes.size());
        for (Map.Entry<Long, Integer> entry : this._batchSizes.entrySet()) {
            Long expirationTimestamp = entry.getKey();
            if (expirationTimestamp < currentTimestamp) {
                expiredTimestamps.add(expirationTimestamp);
                continue;
            }
            recentBatchSizesTotal += entry.getValue().intValue();
        }
        for (Long expiredTimestamp : expiredTimestamps) {
            this._batchSizes.remove(expiredTimestamp);
        }
        return recentBatchSizesTotal;
    }
}

