/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.CISystemStatusReportUtil;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.ParallelExecutor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;

public class JenkinsCohort {
    private static final Pattern _buildNumberPattern = Pattern.compile(".*\\/([0-9]+)");
    private static final Pattern _jobNamePattern = Pattern.compile("https?:.*job\\/(.*?)\\/");
    private final Map<String, JenkinsCohortJob> _jenkinsCohortJobsMap = new HashMap<String, JenkinsCohortJob>();
    private Map<String, JenkinsMaster> _jenkinsMastersMap = new HashMap<String, JenkinsMaster>();
    private final String _name;

    public JenkinsCohort(String name) {
        this._name = name;
        this.update();
    }

    public int getIdleJenkinsSlaveCount() {
        int idleJenkinsSlaveCount = 0;
        for (JenkinsMaster jenkinsMaster : this._jenkinsMastersMap.values()) {
            idleJenkinsSlaveCount += jenkinsMaster.getIdleJenkinsSlavesCount();
        }
        return idleJenkinsSlaveCount;
    }

    public String getName() {
        return this._name;
    }

    public int getOfflineJenkinsSlaveCount() {
        int offlineJenkinsSlaveCount = 0;
        for (JenkinsMaster jenkinsMaster : this._jenkinsMastersMap.values()) {
            offlineJenkinsSlaveCount += jenkinsMaster.getOfflineJenkinsSlavesCount();
        }
        return offlineJenkinsSlaveCount;
    }

    public int getOnlineJenkinsSlaveCount() {
        int onlineJenkinsSlaveCount = 0;
        for (JenkinsMaster jenkinsMaster : this._jenkinsMastersMap.values()) {
            onlineJenkinsSlaveCount += jenkinsMaster.getOnlineJenkinsSlavesCount();
        }
        return onlineJenkinsSlaveCount;
    }

    public int getQueuedBuildCount() {
        int queuedBuildCount = 0;
        for (JenkinsCohortJob jenkinsCohortJob : this._jenkinsCohortJobsMap.values()) {
            queuedBuildCount += jenkinsCohortJob.getQueuedBuildCount();
        }
        return queuedBuildCount;
    }

    public int getRunningBuildCount() {
        int runningBuildCount = 0;
        for (JenkinsCohortJob jenkinsCohortJob : this._jenkinsCohortJobsMap.values()) {
            runningBuildCount += jenkinsCohortJob.getRunningBuildCount();
        }
        return runningBuildCount;
    }

    public void update() {
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get Jenkins properties", ioException);
        }
        if (this._jenkinsMastersMap.isEmpty()) {
            List<JenkinsMaster> jenkinsMasters = JenkinsResultsParserUtil.getJenkinsMasters(buildProperties, JenkinsMaster.getSlaveRAMMinimumDefault(), JenkinsMaster.getSlavesPerHostDefault(), this.getName());
            for (JenkinsMaster jenkinsMaster : jenkinsMasters) {
                this._jenkinsMastersMap.put(jenkinsMaster.getName(), jenkinsMaster);
            }
        }
        ArrayList callables = new ArrayList();
        final List<String> buildURLs = Collections.synchronizedList(new ArrayList());
        for (final JenkinsMaster jenkinsMaster : this._jenkinsMastersMap.values()) {
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() {
                    jenkinsMaster.update();
                    buildURLs.addAll(jenkinsMaster.getBuildURLs());
                    buildURLs.addAll(jenkinsMaster.getQueuedBuildURLs());
                    return null;
                }
            };
            callables.add(callable);
        }
        ThreadPoolExecutor threadPoolExecutor = JenkinsResultsParserUtil.getNewThreadPoolExecutor(this._jenkinsMastersMap.size(), true);
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, threadPoolExecutor);
        parallelExecutor.execute();
        for (String buildURL : buildURLs) {
            this._loadBuildURL(buildURL);
        }
    }

    public void writeDataJavaScriptFile(String filePath) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("var jenkinsDataGeneratedDate = new Date(");
        sb.append(System.currentTimeMillis());
        sb.append(");\nvar nodeData = ");
        JSONArray nodeDataTableJSONArray = new JSONArray();
        nodeDataTableJSONArray.put(Arrays.asList("Occupied Nodes", "Online Nodes", "Queued Builds", "Offline Nodes", "Idle Nodes"));
        nodeDataTableJSONArray.put(Arrays.asList(this.getRunningBuildCount(), this.getOnlineJenkinsSlaveCount(), this.getQueuedBuildCount(), this.getOfflineJenkinsSlaveCount(), this.getIdleJenkinsSlaveCount()));
        sb.append(nodeDataTableJSONArray.toString());
        sb.append(";\nvar buildLoadData = ");
        JSONArray buildLoadDataTableJSONArray = new JSONArray();
        buildLoadDataTableJSONArray.put(Arrays.asList("Name", "Total Builds", "Current Builds", "Queued Builds", "Top Level Builds"));
        for (JenkinsCohortJob jenkinsCohortJob : this._jenkinsCohortJobsMap.values()) {
            List<String> topLevelBuildURLs = jenkinsCohortJob.getTopLevelBuildURLs();
            buildLoadDataTableJSONArray.put(Arrays.asList(jenkinsCohortJob.getJobName(), this._createJSONArray(jenkinsCohortJob.getTotalBuildCount(), this._formatBuildCountText(jenkinsCohortJob.getTotalBuildCount(), jenkinsCohortJob.getTotalBuildPercentage())), this._createJSONArray(jenkinsCohortJob.getRunningBuildCount(), this._formatBuildCountText(jenkinsCohortJob.getRunningBuildCount(), jenkinsCohortJob.getRunningBuildPercentage())), this._createJSONArray(jenkinsCohortJob.getQueuedBuildCount(), this._formatBuildCountText(jenkinsCohortJob.getQueuedBuildCount(), jenkinsCohortJob.getQueuedBuildPercentage())), topLevelBuildURLs.size()));
        }
        sb.append(buildLoadDataTableJSONArray.toString());
        sb.append(";");
        JenkinsResultsParserUtil.write(filePath, sb.toString());
    }

    private JSONArray _createJSONArray(Object ... items) {
        JSONArray jsonArray = new JSONArray();
        for (Object item : items) {
            jsonArray.put(item);
        }
        return jsonArray;
    }

    private String _formatBuildCountText(int buildCount, String buildPercentage) {
        return buildCount + " (" + buildPercentage + ")";
    }

    private void _loadBuildURL(String buildURL) {
        Matcher jobNameMatcher = _jobNamePattern.matcher(buildURL);
        jobNameMatcher.find();
        String jobName = jobNameMatcher.group(1);
        String batchJobName = null;
        if (jobName.contains("-batch")) {
            batchJobName = jobName;
            jobName = jobName.replace("-batch", "");
        }
        if (!this._jenkinsCohortJobsMap.containsKey(jobName)) {
            this._jenkinsCohortJobsMap.put(jobName, new JenkinsCohortJob(jobName));
        }
        JenkinsCohortJob jenkinsCohortJob = this._jenkinsCohortJobsMap.get(jobName);
        Matcher buildNumberMatcher = _buildNumberPattern.matcher(buildURL);
        if (buildNumberMatcher.find()) {
            jenkinsCohortJob.incrementRunningJobCount();
        } else {
            jenkinsCohortJob.incrementQueuedJobCount();
        }
        if (batchJobName == null) {
            jenkinsCohortJob.addTopLevelBuildURL(buildURL);
        }
    }

    private class JenkinsCohortJob {
        private final String _jenkinsCohortJobName;
        private int _queuedBuildCount;
        private int _runningBuildCount;
        private List<String> _topLevelBuildURLs = new ArrayList<String>();

        public JenkinsCohortJob(String jenkinsCohortJobName) {
            this._jenkinsCohortJobName = jenkinsCohortJobName;
        }

        public void addTopLevelBuildURL(String topLevelBuildURL) {
            this._topLevelBuildURLs.add(topLevelBuildURL);
        }

        public String getJobName() {
            return this._jenkinsCohortJobName;
        }

        public int getQueuedBuildCount() {
            return this._queuedBuildCount;
        }

        public String getQueuedBuildPercentage() {
            return CISystemStatusReportUtil.getPercentage(this._queuedBuildCount, JenkinsCohort.this.getQueuedBuildCount());
        }

        public int getRunningBuildCount() {
            return this._runningBuildCount;
        }

        public String getRunningBuildPercentage() {
            return CISystemStatusReportUtil.getPercentage(this._runningBuildCount, JenkinsCohort.this.getRunningBuildCount());
        }

        public List<String> getTopLevelBuildURLs() {
            return this._topLevelBuildURLs;
        }

        public int getTotalBuildCount() {
            return this._queuedBuildCount + this._runningBuildCount;
        }

        public String getTotalBuildPercentage() {
            return CISystemStatusReportUtil.getPercentage(this.getTotalBuildCount(), JenkinsCohort.this.getRunningBuildCount() + JenkinsCohort.this.getQueuedBuildCount());
        }

        public void incrementQueuedJobCount() {
            ++this._queuedBuildCount;
        }

        public void incrementRunningJobCount() {
            ++this._runningBuildCount;
        }
    }
}

