/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseTestResult;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.json.JSONObject;

public class JUnitTestResult
extends BaseTestResult {
    private static final int _LINES_ERROR_STACK_DISPLAY_SIZE_MAX = 1500;
    private static final String _URL_BASE_LOGS_DEFAULT = "https://testray.liferay.com/reports/production/logs";
    private final String _className;
    private final long _duration;
    private final String _errorDetails;
    private final String _errorStackTrace;
    private final String _status;
    private final String _testName;

    @Override
    public String getClassName() {
        return this._className;
    }

    @Override
    public String getDisplayName() {
        return JenkinsResultsParserUtil.combine(this.getSimpleClassName(), ".", this.getTestName());
    }

    @Override
    public long getDuration() {
        return this._duration;
    }

    @Override
    public String getErrorDetails() {
        return this._errorDetails;
    }

    @Override
    public String getErrorStackTrace() {
        return this._errorStackTrace;
    }

    @Override
    public Element getGitHubElement() {
        Element downstreamBuildListItemElement = Dom4JUtil.getNewElement("div", null, new Object[0]);
        downstreamBuildListItemElement.add(Dom4JUtil.getNewAnchorElement(this.getTestReportURL(), this.getDisplayName()));
        String errorStackTrace = this.getErrorStackTrace();
        if (errorStackTrace != null && !errorStackTrace.isEmpty()) {
            String trimmedStackTrace = StringUtils.abbreviate((String)errorStackTrace, (int)1500);
            downstreamBuildListItemElement.add(Dom4JUtil.toCodeSnippetElement(trimmedStackTrace));
        }
        return downstreamBuildListItemElement;
    }

    @Override
    public String getPackageName() {
        String className = this.getClassName();
        int x = className.lastIndexOf(".");
        if (x < 0) {
            return "(root)";
        }
        return className.substring(0, x);
    }

    @Override
    public String getSimpleClassName() {
        String className = this.getClassName();
        int x = className.lastIndexOf(".");
        return className.substring(x + 1);
    }

    @Override
    public String getStatus() {
        return this._status;
    }

    @Override
    public String getTestName() {
        return this._testName;
    }

    @Override
    public String getTestrayLogsURL() {
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build properties", ioException);
        }
        String logBaseURL = null;
        if (buildProperties.containsKey("log.base.url")) {
            logBaseURL = buildProperties.getProperty("log.base.url");
        }
        if (logBaseURL == null) {
            logBaseURL = _URL_BASE_LOGS_DEFAULT;
        }
        Build build = this.getBuild();
        Map<String, String> startPropertiesTempMap = build.getStartPropertiesTempMap();
        return JenkinsResultsParserUtil.combine(logBaseURL, "/", startPropertiesTempMap.get("TOP_LEVEL_MASTER_HOSTNAME"), "/", startPropertiesTempMap.get("TOP_LEVEL_START_TIME"), "/", startPropertiesTempMap.get("TOP_LEVEL_JOB_NAME"), "/", startPropertiesTempMap.get("TOP_LEVEL_BUILD_NUMBER"), "/", build.getJobVariant(), "/", this.getAxisNumber());
    }

    @Override
    public String getTestReportURL() {
        StringBuilder sb = new StringBuilder();
        Build build = this.getBuild();
        sb.append(build.getBuildURL());
        sb.append("/testReport/");
        sb.append(this.getPackageName());
        sb.append("/");
        sb.append(this.getSimpleClassName());
        sb.append("/");
        sb.append(this.getEncodedTestName());
        String testReportURL = sb.toString();
        if (testReportURL.startsWith("http")) {
            try {
                return JenkinsResultsParserUtil.encode(testReportURL);
            }
            catch (MalformedURLException | URISyntaxException exception) {
                System.out.println("Unable to encode the test report " + testReportURL);
            }
        }
        return testReportURL;
    }

    protected JUnitTestResult(Build build, JSONObject caseJSONObject) {
        super(build);
        this._className = caseJSONObject.getString("className");
        this._duration = (long)(caseJSONObject.getDouble("duration") * 1000.0);
        this._status = caseJSONObject.getString("status");
        this._testName = caseJSONObject.getString("name");
        if (this._status.equals("FAILED") && caseJSONObject.has("errorDetails") && caseJSONObject.has("errorStackTrace")) {
            this._errorDetails = caseJSONObject.optString("errorDetails");
            this._errorStackTrace = caseJSONObject.optString("errorStackTrace");
        } else {
            this._errorDetails = null;
            this._errorStackTrace = null;
        }
    }

    protected String getEncodedTestName() {
        StringBuilder sb = new StringBuilder(this.getTestName());
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (Character.isJavaIdentifierPart(c)) continue;
            sb.setCharAt(i, '_');
        }
        return sb.toString();
    }
}

