/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitBranchFactory;
import com.liferay.jenkins.results.parser.GitRemote;
import com.liferay.jenkins.results.parser.GitRepositoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.RemoteGitBranch;
import com.liferay.jenkins.results.parser.RemoteGitRef;
import com.liferay.jenkins.results.parser.RemoteGitRepository;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GitUtil {
    public static final long MILLIS_RETRY_DELAY = 30000L;
    public static final long MILLIS_TIMEOUT = 120000L;
    public static final int RETRIES_SIZE_MAX = 1;
    private static final String _HOSTNAME_GITHUB_CACHE_PROXY = "github-dev.liferay.com";
    private static final Pattern _dnsDebugPattern = Pattern.compile("Unable to resolve hostname (?<hostname>[^:]+): ");
    private static final Pattern _gitHubRefURLPattern = Pattern.compile(JenkinsResultsParserUtil.combine("https://github.com/(?<username>[^/]+)/", "(?<gitRepositoryName>[^/]+)/tree/(?<refName>[^/]+)"));

    public static void clone(String remoteURL, File workingDirectory) {
        String command = JenkinsResultsParserUtil.combine("git clone ", remoteURL, " ", JenkinsResultsParserUtil.getCanonicalPath(workingDirectory));
        Process process = null;
        try {
            process = JenkinsResultsParserUtil.executeBashCommands(command);
        }
        catch (IOException | TimeoutException exception) {
            throw new RuntimeException("Unable to clone " + remoteURL, exception);
        }
        if (process != null && process.exitValue() != 0) {
            String errorString = null;
            try {
                errorString = JenkinsResultsParserUtil.readInputStream(process.getErrorStream());
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
            throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to clone ", remoteURL, "\n", errorString));
        }
    }

    public static String getDefaultBranchName(File workingDirectory) {
        String defaultBranchName = GitUtil._getDefaultBranchName(workingDirectory, "origin");
        if (defaultBranchName == null) {
            defaultBranchName = GitUtil._getDefaultBranchName(workingDirectory, "upstream");
        }
        return defaultBranchName;
    }

    public static String getPrivateRepositoryName(String repositoryName) {
        if (repositoryName.endsWith("-ee") || repositoryName.endsWith("-private")) {
            return repositoryName;
        }
        if (repositoryName.startsWith("com-liferay")) {
            return repositoryName + "-private";
        }
        return repositoryName + "-ee";
    }

    public static String getPublicRepositoryName(String repositoryName) {
        if (!repositoryName.endsWith("-ee") && !repositoryName.endsWith("-private")) {
            return repositoryName;
        }
        if (repositoryName.startsWith("com-liferay")) {
            return repositoryName.replace("-private", "");
        }
        return repositoryName.replace("-ee", "");
    }

    public static RemoteGitBranch getRemoteGitBranch(String remoteGitBranchName, File workingDirectory, String remoteURL) {
        RemoteGitRef remoteGitRef = GitUtil.getRemoteGitRef(remoteGitBranchName, workingDirectory, remoteURL);
        if (!(remoteGitRef instanceof RemoteGitBranch)) {
            throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to find remote Git branch ", remoteGitBranchName, " on remote URL ", remoteURL));
        }
        return (RemoteGitBranch)remoteGitRef;
    }

    public static List<RemoteGitBranch> getRemoteGitBranches(String remoteGitBranchName, File workingDirectory, String remoteURL) {
        ArrayList<RemoteGitBranch> remoteGitBranches = new ArrayList<RemoteGitBranch>();
        for (RemoteGitRef remoteGitRef : GitUtil.getRemoteGitRefs(remoteGitBranchName, workingDirectory, remoteURL)) {
            if (!(remoteGitRef instanceof RemoteGitBranch)) continue;
            remoteGitBranches.add((RemoteGitBranch)remoteGitRef);
        }
        return remoteGitBranches;
    }

    public static RemoteGitRef getRemoteGitRef(String gitHubURL) {
        Matcher matcher = _gitHubRefURLPattern.matcher(gitHubURL);
        if (!matcher.find()) {
            throw new RuntimeException("Invalid GitHub URL " + gitHubURL);
        }
        String remoteGitRepositoryURL = JenkinsResultsParserUtil.combine("git@github.com:", matcher.group("username"), "/", matcher.group("gitRepositoryName"), ".git");
        return GitUtil.getRemoteGitRef(matcher.group("refName"), new File("."), remoteGitRepositoryURL);
    }

    public static RemoteGitRef getRemoteGitRef(String remoteGitBranchName, File workingDirectory, String remoteURL) {
        List<RemoteGitRef> remoteGitRefs = null;
        if (remoteURL.contains(_HOSTNAME_GITHUB_CACHE_PROXY)) {
            ArrayList<String> usedGitHubDevNodeHostnames = new ArrayList<String>(3);
            while (usedGitHubDevNodeHostnames.size() < 3 && (remoteGitRefs == null || remoteGitRefs.isEmpty())) {
                String gitHubDevNodeHostname = JenkinsResultsParserUtil.getRandomGitHubDevNodeHostname(usedGitHubDevNodeHostnames);
                String gitHubDevNodeRemoteURL = remoteURL.replace(_HOSTNAME_GITHUB_CACHE_PROXY, gitHubDevNodeHostname);
                if (gitHubDevNodeHostname.startsWith("slave-")) {
                    gitHubDevNodeRemoteURL = GitUtil.toSlaveGitHubDevNodeRemoteURL(remoteURL, gitHubDevNodeHostname.substring(6));
                }
                try {
                    remoteGitRefs = GitUtil.getRemoteGitRefs(remoteGitBranchName, workingDirectory, gitHubDevNodeRemoteURL);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                usedGitHubDevNodeHostnames.add(gitHubDevNodeHostname);
            }
        } else {
            remoteGitRefs = GitUtil.getRemoteGitRefs(remoteGitBranchName, workingDirectory, remoteURL);
        }
        if (remoteGitRefs == null || remoteGitRefs.isEmpty()) {
            throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to find remote Git ref ", remoteGitBranchName, " on remote URL ", remoteURL));
        }
        return remoteGitRefs.get(0);
    }

    public static List<RemoteGitRef> getRemoteGitRefs(String remoteGitBranchName, File workingDirectory, String remoteURL) {
        if (!GitUtil.isValidRemoteURL(remoteURL)) {
            throw new IllegalArgumentException("Invalid remote url " + remoteURL);
        }
        String command = null;
        command = remoteGitBranchName != null ? JenkinsResultsParserUtil.combine("git ls-remote -h -t ", remoteURL, " ", remoteGitBranchName) : JenkinsResultsParserUtil.combine("git ls-remote -h ", remoteURL);
        ExecutionResult executionResult = GitUtil.executeBashCommands(3, 30000L, 600000L, workingDirectory, command);
        if (executionResult.getExitValue() != 0) {
            throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to get remote refs from ", remoteURL, "\n", executionResult.getStandardError()));
        }
        String input = executionResult.getStandardOut();
        ArrayList<RemoteGitRef> remoteGitRefs = new ArrayList<RemoteGitRef>();
        Matcher remoteURLMatcher = GitRemote.getRemoteURLMatcher(remoteURL);
        remoteURLMatcher.find();
        String username = "liferay";
        try {
            username = remoteURLMatcher.group("username");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        RemoteGitRepository remoteGitRepository = GitRepositoryFactory.getRemoteGitRepository(remoteURLMatcher.group("hostname"), remoteURLMatcher.group("gitRepositoryName"), username);
        String[] stringArray = input.split("\n");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            Pattern gitLsRemotePattern = GitRemote.gitLsRemotePattern;
            String line = stringArray[i];
            Matcher gitLsRemoteMatcher = gitLsRemotePattern.matcher(line);
            if (!gitLsRemoteMatcher.find()) continue;
            remoteGitRefs.add(GitBranchFactory.newRemoteGitRef(remoteGitRepository, gitLsRemoteMatcher.group("name"), gitLsRemoteMatcher.group("sha"), gitLsRemoteMatcher.group("type")));
        }
        System.out.println("getRemoteGitRefs found " + remoteGitRefs.size() + " refs at " + remoteURL + ".");
        return remoteGitRefs;
    }

    public static boolean isValidGitHubRefURL(String gitHubURL) {
        Matcher matcher = _gitHubRefURLPattern.matcher(gitHubURL);
        return matcher.find();
    }

    public static boolean isValidRemoteURL(String remoteURL) {
        Matcher matcher = GitRemote.getRemoteURLMatcher(remoteURL);
        return matcher != null;
    }

    public static String toSlaveGitHubDevNodeRemoteURL(String gitHubDevRemoteURL, String slaveGitHubDevNodeHostname) {
        String hostname;
        Matcher matcher = GitRemote.getRemoteURLMatcher(gitHubDevRemoteURL);
        if (matcher != null && matcher.find() && (hostname = matcher.group("hostname")) != null && hostname.endsWith("github-dev")) {
            return JenkinsResultsParserUtil.combine("root@", slaveGitHubDevNodeHostname, ":/opt/dev/projects/github/", matcher.group("gitRepositoryName"));
        }
        throw new IllegalArgumentException("Invalid github-dev remote url " + gitHubDevRemoteURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ExecutionResult executeBashCommands(int maxRetries, long retryDelay, long timeout, File workingDirectory, String ... commands) {
        Process process = null;
        int retries = 0;
        ArrayList<String> usedGitHubDevNodeHostnames = new ArrayList<String>(maxRetries);
        while (retries < maxRetries) {
            int i;
            String[] modifiedCommands = Arrays.copyOf(commands, commands.length);
            String gitHubDevNodeHostname = JenkinsResultsParserUtil.getRandomGitHubDevNodeHostname(usedGitHubDevNodeHostnames);
            usedGitHubDevNodeHostnames.add(gitHubDevNodeHostname);
            if (gitHubDevNodeHostname.startsWith("slave-")) {
                gitHubDevNodeHostname = gitHubDevNodeHostname.substring(6);
                for (i = 0; i < modifiedCommands.length; ++i) {
                    String modifiedCommand = modifiedCommands[i];
                    if (!modifiedCommand.contains(_HOSTNAME_GITHUB_CACHE_PROXY)) continue;
                    Matcher matcher = GitRemote.getRemoteURLMatcher(modifiedCommands[i]);
                    if (matcher != null) {
                        while (matcher.find()) {
                            retryDelay = 0L;
                            modifiedCommand = modifiedCommand.replaceFirst(matcher.group(0), GitUtil.toSlaveGitHubDevNodeRemoteURL(matcher.group(0), gitHubDevNodeHostname));
                        }
                    }
                    modifiedCommands[i] = modifiedCommand;
                }
            } else {
                for (i = 0; i < modifiedCommands.length; ++i) {
                    modifiedCommands[i] = modifiedCommands[i].replace(_HOSTNAME_GITHUB_CACHE_PROXY, gitHubDevNodeHostname);
                    if (retryDelay == 0L || !modifiedCommands[i].contains(_HOSTNAME_GITHUB_CACHE_PROXY)) continue;
                    retryDelay = 0L;
                }
            }
            try {
                ++retries;
                process = JenkinsResultsParserUtil.executeBashCommands(true, workingDirectory, timeout, modifiedCommands);
            }
            catch (IOException | TimeoutException exception) {
                if (retries == maxRetries) {
                    throw new RuntimeException("Unable to execute bash commands: " + Arrays.toString(commands), exception);
                }
                exception.printStackTrace();
            }
            finally {
                try {
                    if (process != null && process.exitValue() == 0) break;
                    if (retries >= maxRetries) continue;
                    usedGitHubDevNodeHostnames.add(gitHubDevNodeHostname);
                    System.out.println("Unable to execute bash commands retrying... ");
                    JenkinsResultsParserUtil.sleep(retryDelay);
                }
                finally {
                    if (process == null) continue;
                    GitUtil._debugDNS(process);
                }
            }
        }
        String standardErr = "";
        try {
            standardErr = JenkinsResultsParserUtil.readInputStream(process.getErrorStream());
        }
        catch (IOException ioException) {
            standardErr = "";
        }
        String standardOut = "";
        try {
            standardOut = JenkinsResultsParserUtil.readInputStream(process.getInputStream());
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to read process input stream", ioException);
        }
        return new ExecutionResult(process.exitValue(), standardErr.trim(), standardOut.trim());
    }

    private static void _debugDNS(Process process) {
        String standardErr = "";
        try {
            standardErr = JenkinsResultsParserUtil.readInputStream(process.getErrorStream());
        }
        catch (IOException ioException) {
            standardErr = "";
        }
        Matcher matcher = _dnsDebugPattern.matcher(standardErr);
        if (matcher.find()) {
            String hostname = matcher.group("hostname");
            try {
                Process digProcess = JenkinsResultsParserUtil.executeBashCommands("dig " + hostname, "dig @10.0.1.11 " + hostname);
                System.out.println(JenkinsResultsParserUtil.readInputStream(digProcess.getInputStream()));
            }
            catch (Exception exception) {
                System.out.println("Unable to execute debug DNS: " + exception.getMessage());
            }
        }
    }

    private static String _getDefaultBranchName(File workingDirectory, String gitRemoteName) {
        ExecutionResult executionResult = GitUtil.executeBashCommands(1, 30000L, 120000L, workingDirectory, JenkinsResultsParserUtil.combine("git remote show ", gitRemoteName, " | grep \"HEAD branch\" | ", "cut -d \":\" -f 2"));
        if (executionResult.getExitValue() != 0) {
            return null;
        }
        String defaultBranchName = executionResult.getStandardOut();
        defaultBranchName = defaultBranchName.replace("Finished executing Bash commands.", "");
        if ((defaultBranchName = defaultBranchName.trim()).isEmpty()) {
            return null;
        }
        return defaultBranchName;
    }

    public static class ExecutionResult {
        private final int _exitValue;
        private final String _standardError;
        private final String _standardOut;

        public int getExitValue() {
            return this._exitValue;
        }

        public String getStandardError() {
            return this._standardError;
        }

        public String getStandardOut() {
            return this._standardOut;
        }

        protected ExecutionResult(int exitValue, String standardError, String standardOut) {
            this._exitValue = exitValue;
            this._standardError = standardError;
            this._standardOut = standardOut.endsWith("\nFinished executing Bash commands.") ? standardOut.substring(0, standardOut.indexOf("\nFinished executing Bash commands.")) : standardOut;
        }
    }
}

