/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.CompanionPortalWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.DefaultLocalGitRepository;
import com.liferay.jenkins.results.parser.DefaultRemoteGitRepository;
import com.liferay.jenkins.results.parser.GitHubRemoteGitRepository;
import com.liferay.jenkins.results.parser.GitRemote;
import com.liferay.jenkins.results.parser.JenkinsWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.LegacyWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.LocalGitRepository;
import com.liferay.jenkins.results.parser.OtherPortalWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.PluginsWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.PortalPluginsWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.PrimaryPortalWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.PullRequest;
import com.liferay.jenkins.results.parser.RemoteGitRef;
import com.liferay.jenkins.results.parser.RemoteGitRepository;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import java.util.regex.Matcher;
import org.json.JSONObject;

public class GitRepositoryFactory {
    public static WorkspaceGitRepository getDependencyWorkspaceGitRepository(String repositoryType, WorkspaceGitRepository workspaceGitRepository, PullRequest pullRequest, String upstreamBranchName) {
        if (repositoryType.equals("portal.companion")) {
            return new CompanionPortalWorkspaceGitRepository(pullRequest, upstreamBranchName, workspaceGitRepository);
        }
        if (repositoryType.equals("portal.other")) {
            return new OtherPortalWorkspaceGitRepository(pullRequest, upstreamBranchName);
        }
        if (repositoryType.equals("portal.plugins")) {
            return new PortalPluginsWorkspaceGitRepository(pullRequest, upstreamBranchName);
        }
        throw new RuntimeException("Unsupported dependency workspace Git repository");
    }

    public static WorkspaceGitRepository getDependencyWorkspaceGitRepository(String repositoryType, WorkspaceGitRepository workspaceGitRepository, RemoteGitRef remoteGitRef, String upstreamBranchName) {
        if (repositoryType.equals("portal.companion")) {
            return new CompanionPortalWorkspaceGitRepository(remoteGitRef, upstreamBranchName, workspaceGitRepository);
        }
        if (repositoryType.equals("portal.other")) {
            return new OtherPortalWorkspaceGitRepository(remoteGitRef, upstreamBranchName);
        }
        if (repositoryType.equals("portal.plugins")) {
            return new PortalPluginsWorkspaceGitRepository(remoteGitRef, upstreamBranchName);
        }
        throw new RuntimeException("Unsupported dependency workspace Git repository");
    }

    public static LocalGitRepository getLocalGitRepository(String repositoryName, String upstreamBranchName) {
        return new DefaultLocalGitRepository(repositoryName, upstreamBranchName);
    }

    public static RemoteGitRepository getRemoteGitRepository(GitRemote gitRemote) {
        String hostname = gitRemote.getHostname();
        if (hostname.equalsIgnoreCase("github.com")) {
            return new GitHubRemoteGitRepository(gitRemote);
        }
        return new DefaultRemoteGitRepository(gitRemote);
    }

    public static RemoteGitRepository getRemoteGitRepository(String remoteURL) {
        Matcher matcher = GitRemote.getRemoteURLMatcher(remoteURL);
        if (matcher == null || !matcher.find()) {
            throw new RuntimeException("Invalid remote URL " + remoteURL);
        }
        String patternString = String.valueOf(matcher.pattern());
        String username = "liferay";
        if (patternString.contains("(?<username>")) {
            username = matcher.group("username");
        }
        return GitRepositoryFactory.getRemoteGitRepository(matcher.group("hostname"), matcher.group("gitRepositoryName"), username);
    }

    public static RemoteGitRepository getRemoteGitRepository(String hostname, String gitRepositoryName, String username) {
        if (hostname.equalsIgnoreCase("github.com")) {
            return new GitHubRemoteGitRepository(gitRepositoryName, username);
        }
        return new DefaultRemoteGitRepository(hostname, gitRepositoryName, username);
    }

    public static WorkspaceGitRepository getWorkspaceGitRepository(JSONObject jsonObject) {
        String jsonObjectType = GitRepositoryFactory._getType(jsonObject);
        if (jsonObjectType.equals("portal.companion")) {
            return new CompanionPortalWorkspaceGitRepository(jsonObject);
        }
        if (jsonObjectType.equals("portal")) {
            return new PrimaryPortalWorkspaceGitRepository(jsonObject);
        }
        if (jsonObjectType.equals("jenkins")) {
            return new JenkinsWorkspaceGitRepository(jsonObject);
        }
        if (jsonObjectType.equals("legacy")) {
            return new LegacyWorkspaceGitRepository(jsonObject);
        }
        if (jsonObjectType.equals("portal.other")) {
            return new OtherPortalWorkspaceGitRepository(jsonObject);
        }
        if (jsonObjectType.equals("plugins")) {
            return new PluginsWorkspaceGitRepository(jsonObject);
        }
        if (jsonObjectType.equals("portal.plugins")) {
            return new PortalPluginsWorkspaceGitRepository(jsonObject);
        }
        throw new RuntimeException("Invalid JSONObject " + jsonObject);
    }

    public static WorkspaceGitRepository getWorkspaceGitRepository(String gitHubURL, PullRequest pullRequest, String upstreamBranchName) {
        if (gitHubURL.contains("/liferay-jenkins-ee")) {
            return new JenkinsWorkspaceGitRepository(pullRequest, upstreamBranchName);
        }
        if (gitHubURL.contains("/liferay-plugins")) {
            return new PluginsWorkspaceGitRepository(pullRequest, upstreamBranchName);
        }
        if (gitHubURL.contains("/liferay-portal")) {
            return new PrimaryPortalWorkspaceGitRepository(pullRequest, upstreamBranchName);
        }
        if (gitHubURL.contains("/liferay-qa-portal-legacy-ee")) {
            return new LegacyWorkspaceGitRepository(pullRequest, upstreamBranchName);
        }
        throw new RuntimeException("Unsupported workspace Git repository");
    }

    public static WorkspaceGitRepository getWorkspaceGitRepository(String gitHubURL, RemoteGitRef remoteGitRef, String upstreamBranchName) {
        if (gitHubURL.contains("/liferay-jenkins-ee")) {
            return new JenkinsWorkspaceGitRepository(remoteGitRef, upstreamBranchName);
        }
        if (gitHubURL.contains("/liferay-plugins")) {
            return new PluginsWorkspaceGitRepository(remoteGitRef, upstreamBranchName);
        }
        if (gitHubURL.contains("/liferay-portal")) {
            return new PrimaryPortalWorkspaceGitRepository(remoteGitRef, upstreamBranchName);
        }
        if (gitHubURL.contains("/liferay-qa-portal-legacy-ee")) {
            return new LegacyWorkspaceGitRepository(remoteGitRef, upstreamBranchName);
        }
        throw new RuntimeException("Unsupported workspace Git repository");
    }

    private static String _getType(JSONObject jsonObject) {
        String type = jsonObject.optString("type");
        if (type == null) {
            return "";
        }
        return type;
    }
}

