/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.google.common.collect.Lists;
import com.liferay.jenkins.results.parser.BaseRemoteGitRepository;
import com.liferay.jenkins.results.parser.GitRemote;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class GitHubRemoteGitRepository
extends BaseRemoteGitRepository {
    private static final int _PAGES_LABEL_PAGES_SIZE_MAX = 10;
    private static final Map<String, List<Label>> _labelsLists = new ConcurrentHashMap<String, List<Label>>();
    private String _labelRequestURL;

    public boolean addLabel(String color, String description, String name) {
        if (this.hasLabel(name)) {
            return true;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("color", (Object)color);
        jsonObject.put("name", (Object)name);
        if (description != null && !description.isEmpty()) {
            jsonObject.put("description", (Object)description);
        }
        String labelRequestURL = this.getLabelRequestURL();
        try {
            JenkinsResultsParserUtil.toString(labelRequestURL, jsonObject.toString());
            _labelsLists.remove(labelRequestURL);
        }
        catch (IOException ioException) {
            System.out.println("Unable to add label " + name);
            ioException.printStackTrace();
            return false;
        }
        return true;
    }

    public void deleteLabel(Label oldLabel) {
        this.updateLabel(null, null, null, oldLabel);
    }

    public Label getLabel(String name) {
        for (Label label : this.getLabels()) {
            if (!name.equals(label.getName())) continue;
            return label;
        }
        return null;
    }

    public List<Label> getLabels() {
        String labelRequestURL = this.getLabelRequestURL();
        if (_labelsLists.containsKey(labelRequestURL)) {
            return _labelsLists.get(labelRequestURL);
        }
        HashSet<Label> labels = new HashSet<Label>();
        for (int page = 1; page <= 10; ++page) {
            JSONArray labelsJSONArray;
            try {
                labelsJSONArray = JenkinsResultsParserUtil.toJSONArray(JenkinsResultsParserUtil.combine(labelRequestURL, "?page=", String.valueOf(page)), false);
            }
            catch (IOException ioException) {
                throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to get labels for ", this.getName(), " Git repository"), ioException);
            }
            if (labelsJSONArray.length() == 0) break;
            for (int i = 0; i < labelsJSONArray.length(); ++i) {
                labels.add(new Label((JSONObject)labelsJSONArray.get(i), this));
            }
        }
        _labelsLists.put(labelRequestURL, Lists.newArrayList(labels));
        return Lists.newArrayList(labels);
    }

    public boolean hasLabel(String name) {
        return this.getLabel(name) != null;
    }

    public void updateLabel(String color, String description, String name, Label oldLabel) {
        if (!this.hasLabel(oldLabel.getName())) {
            throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to update or delete label ", oldLabel.getName(), " because it does not exist in the ", this.getName(), " Git repository"));
        }
        JSONObject jsonObject = null;
        if (name != null) {
            jsonObject = new JSONObject();
            jsonObject.put("color", (Object)color);
            jsonObject.put("name", (Object)name);
            if (description != null && !description.isEmpty()) {
                jsonObject.put("description", (Object)description);
            }
        }
        String labelRequestURL = JenkinsResultsParserUtil.combine(this.getLabelRequestURL(), "/", oldLabel.getName());
        try {
            if (jsonObject == null) {
                JenkinsResultsParserUtil.toString(labelRequestURL, false, JenkinsResultsParserUtil.HttpRequestMethod.DELETE);
            } else {
                JenkinsResultsParserUtil.toString(labelRequestURL, JenkinsResultsParserUtil.HttpRequestMethod.PATCH, jsonObject.toString());
            }
            _labelsLists.remove(this.getLabelRequestURL());
        }
        catch (IOException ioException) {
            if (jsonObject == null) {
                System.out.println("Unable to delete label " + oldLabel.getName());
            } else {
                System.out.println("Unable to update label " + oldLabel.getName());
            }
            ioException.printStackTrace();
        }
    }

    protected GitHubRemoteGitRepository(GitRemote gitRemote) {
        super(gitRemote);
        String hostname = this.getHostname();
        if (!hostname.equals("github.com")) {
            throw new IllegalArgumentException(this.getName() + " is not a GitHub repository");
        }
    }

    protected GitHubRemoteGitRepository(String gitHubRemoteGitRepositoryName, String username) {
        super("github.com", gitHubRemoteGitRepositoryName, username);
    }

    protected String getLabelRequestURL() {
        if (this._labelRequestURL != null) {
            return this._labelRequestURL;
        }
        this._labelRequestURL = JenkinsResultsParserUtil.getGitHubApiUrl(this.getName(), this.getUsername(), "/labels");
        return this._labelRequestURL;
    }

    protected void setLabelRequestURL(String labelRequestURL) {
        this._labelRequestURL = labelRequestURL;
    }

    public static class Label {
        private final GitHubRemoteGitRepository _gitHubRemoteGitRepository;
        private final JSONObject _jsonObject;

        public Label(JSONObject jsonObject, GitHubRemoteGitRepository gitHubRemoteGitRepository) {
            this._jsonObject = jsonObject;
            this._gitHubRemoteGitRepository = gitHubRemoteGitRepository;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Label)) {
                return false;
            }
            Label label = (Label)object;
            return Objects.equals(this.getColor(), label.getColor()) && Objects.equals(this.getName(), label.getName());
        }

        public String getColor() {
            return this._jsonObject.getString("color");
        }

        public String getDescription() {
            return this._jsonObject.optString("description");
        }

        public GitHubRemoteGitRepository getGitHubRemoteGitRepository() {
            return this._gitHubRemoteGitRepository;
        }

        public String getName() {
            return this._jsonObject.getString("name");
        }

        public int hashCode() {
            String name = this.getName();
            return name.hashCode();
        }

        public String toString() {
            return this._jsonObject.toString(4);
        }
    }
}

