/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseGitCommit;
import com.liferay.jenkins.results.parser.GitCommit;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;

public class GitHubRemoteGitCommit
extends BaseGitCommit {
    private final String _gitHubUsername;

    public String getGitHubCommitURL() {
        return JenkinsResultsParserUtil.combine("https://github.com/", this._gitHubUsername, "/", this.getGitRepositoryName(), "/commit/", this.getSHA());
    }

    public void setStatus(Status status, String context, String description, String targetURL) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("state", (Object)StringUtils.lowerCase((String)status.toString()));
        if (context != null) {
            jsonObject.put("context", (Object)context);
        }
        if (description != null) {
            jsonObject.put("description", (Object)description);
        }
        if (targetURL != null && targetURL.matches("https?\\:\\/\\/.*")) {
            jsonObject.put("target_url", (Object)targetURL);
        }
        try {
            JenkinsResultsParserUtil.toJSONObject(this.getGitHubStatusURL(), jsonObject.toString());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    protected GitHubRemoteGitCommit(String gitHubUsername, String gitRepositoryName, String message, String sha, GitCommit.Type type, long commitTime) {
        super(gitRepositoryName, message, sha, type, commitTime);
        this._gitHubUsername = gitHubUsername;
    }

    protected String getGitHubStatusURL() {
        return JenkinsResultsParserUtil.getGitHubApiUrl(this.getGitRepositoryName(), this._gitHubUsername, "statuses/" + this.getSHA());
    }

    public static enum Status {
        ERROR,
        FAILURE,
        PENDING,
        SUCCESS;

    }
}

