/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.DefaultLocalGitCommit;
import com.liferay.jenkins.results.parser.GitCommit;
import com.liferay.jenkins.results.parser.GitHubRemoteGitCommit;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.LocalGitCommit;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class GitCommitFactory {
    private static final Map<String, GitHubRemoteGitCommit> _gitHubRemoteGitCommits = new HashMap<String, GitHubRemoteGitCommit>();

    public static GitHubRemoteGitCommit newGitHubRemoteGitCommit(String gitHubUsername, String gitRepositoryName, String sha) {
        String gitHubCommitURL = GitCommitFactory._getGitHubCommitURL(gitHubUsername, gitRepositoryName, sha);
        if (_gitHubRemoteGitCommits.containsKey(gitHubCommitURL)) {
            return _gitHubRemoteGitCommits.get(gitHubCommitURL);
        }
        try {
            JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(gitHubCommitURL);
            JSONObject commitJSONObject = jsonObject.getJSONObject("commit");
            String message = commitJSONObject.getString("message");
            JSONObject committerJSONObject = commitJSONObject.getJSONObject("committer");
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                Date date = simpleDateFormat.parse(committerJSONObject.getString("date"));
                GitHubRemoteGitCommit remoteGitCommit = new GitHubRemoteGitCommit(gitHubUsername, gitRepositoryName, message, sha, GitCommitFactory._getGitCommitType(message), date.getTime());
                _gitHubRemoteGitCommits.put(gitHubCommitURL, remoteGitCommit);
                return remoteGitCommit;
            }
            catch (ParseException parseException) {
                throw new RuntimeException(parseException);
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get commit details", ioException);
        }
    }

    public static LocalGitCommit newLocalGitCommit(GitWorkingDirectory gitWorkingDirectory, String message, String sha, long commitTime) {
        return new DefaultLocalGitCommit(gitWorkingDirectory, message, sha, GitCommitFactory._getGitCommitType(message), commitTime);
    }

    private static GitCommit.Type _getGitCommitType(String message) {
        if (message.startsWith("archive:ignore")) {
            return GitCommit.Type.LEGACY_ARCHIVE;
        }
        return GitCommit.Type.MANUAL;
    }

    private static String _getGitHubCommitURL(String gitHubUsername, String gitRepositoryName, String sha) {
        return JenkinsResultsParserUtil.getGitHubApiUrl(gitRepositoryName, gitHubUsername, "commits/" + sha);
    }
}

