/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BatchPortalWorkspace;
import com.liferay.jenkins.results.parser.PortalWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import java.util.Properties;

public class FunctionalBatchPortalWorkspace
extends BatchPortalWorkspace {
    protected FunctionalBatchPortalWorkspace(String portalGitHubURL, String portalUpstreamBranchName, String portalBranchSHA) {
        super(portalGitHubURL, portalUpstreamBranchName, portalBranchSHA);
        this._setPortalBuildProperties();
        this._setPortalReleaseProperties();
    }

    @Override
    protected void setUpWorkspaceGitRepositories() {
        super.setUpWorkspaceGitRepositories();
        if (this.legacyWorkspaceGitRepository != null) {
            this.legacyWorkspaceGitRepository.setUp();
        }
    }

    @Override
    protected void tearDownWorkspaceGitRepositories() {
        super.tearDownWorkspaceGitRepositories();
        if (this.legacyWorkspaceGitRepository != null) {
            this.legacyWorkspaceGitRepository.tearDown();
        }
    }

    private void _setPortalBuildProperties() {
        Properties properties = new Properties();
        properties.put("jsp.precompile", "on");
        PortalWorkspaceGitRepository primaryPortalWorkspaceGitRepository = this.getPrimaryPortalWorkspaceGitRepository();
        primaryPortalWorkspaceGitRepository.setPortalBuildProperties(properties);
    }

    private void _setPortalReleaseProperties() {
        WorkspaceGitRepository pluginsWorkspaceGitRepository = this.getPluginsWorkspaceGitRepository();
        if (pluginsWorkspaceGitRepository == null) {
            return;
        }
        Properties properties = new Properties();
        properties.put("lp.plugins.dir", String.valueOf(pluginsWorkspaceGitRepository.getDirectory()));
        PortalWorkspaceGitRepository primaryPortalWorkspaceGitRepository = this.getPrimaryPortalWorkspaceGitRepository();
        primaryPortalWorkspaceGitRepository.setPortalReleaseProperties(properties);
    }
}

