/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseTestResult;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.CucumberFeatureResult;
import com.liferay.jenkins.results.parser.CucumberScenarioResult;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import org.dom4j.Element;

public class CucumberTestResult
extends BaseTestResult {
    private final CucumberFeatureResult _cucumberFeatureResult;
    private final CucumberScenarioResult _cucumberScenarioResult;

    @Override
    public String getClassName() {
        return this._cucumberFeatureResult.getName();
    }

    public CucumberFeatureResult getCucumberFeatureResult() {
        return this._cucumberFeatureResult;
    }

    public CucumberScenarioResult getCucumberScenarioResult() {
        return this._cucumberScenarioResult;
    }

    @Override
    public String getDisplayName() {
        return this._cucumberScenarioResult.getScenarioName();
    }

    @Override
    public long getDuration() {
        return this._cucumberScenarioResult.getDuration();
    }

    @Override
    public String getErrorDetails() {
        return this._cucumberScenarioResult.getErrorDetails();
    }

    @Override
    public String getErrorStackTrace() {
        return this._cucumberScenarioResult.getErrorStacktrace();
    }

    @Override
    public Element getGitHubElement() {
        String testReportURL = this.getTestReportURL();
        Element downstreamBuildListItemElement = Dom4JUtil.getNewElement("div", null, new Object[0]);
        downstreamBuildListItemElement.add(Dom4JUtil.getNewAnchorElement(testReportURL, this.getDisplayName()));
        Dom4JUtil.addToElement(downstreamBuildListItemElement, " - ", Dom4JUtil.getNewAnchorElement(this.getConsoleOutputURL(), "Console Output"));
        String errorDetails = this.getErrorDetails();
        if (errorDetails != null && !errorDetails.isEmpty()) {
            Dom4JUtil.addToElement(downstreamBuildListItemElement, Dom4JUtil.toCodeSnippetElement(errorDetails));
        }
        if (this.hasLiferayLog()) {
            Dom4JUtil.addToElement(downstreamBuildListItemElement, " - ", Dom4JUtil.getNewAnchorElement(this.getLiferayLogURL(), "Liferay Log"));
        }
        return downstreamBuildListItemElement;
    }

    @Override
    public String getPackageName() {
        return null;
    }

    @Override
    public String getSimpleClassName() {
        return this._cucumberFeatureResult.getName();
    }

    @Override
    public String getStatus() {
        return this._cucumberScenarioResult.getStatus();
    }

    @Override
    public String getTestName() {
        return this._cucumberScenarioResult.getScenarioName();
    }

    @Override
    public String getTestReportURL() {
        return this._cucumberFeatureResult.getURL();
    }

    protected CucumberTestResult(Build build, CucumberScenarioResult cucumberScenarioResult) {
        super(build);
        if (cucumberScenarioResult == null) {
            throw new IllegalArgumentException("Scenario result is null");
        }
        this._cucumberScenarioResult = cucumberScenarioResult;
        this._cucumberFeatureResult = cucumberScenarioResult.getCucumberFeatureResult();
    }
}

