/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.CucumberFeatureResult;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;

public class CucumberScenarioResult
implements Serializable {
    private static final Pattern _durationPattern = Pattern.compile("((?<mins>\\d+)\\:)?(?<secs>\\d+)\\.(?<ms>\\d{3})");
    private transient Document _backgroundDocument;
    private final CucumberFeatureResult _cucumberFeatureResult;
    private transient Document _scenarioDocument;

    public long getBackgroundDuration() {
        return this._getDuration(this._getBackgroundDocument());
    }

    public String getBackgroundName() {
        Document backgroundDocument = this._getBackgroundDocument();
        if (backgroundDocument == null) {
            return null;
        }
        return "Background: " + this._getName(backgroundDocument);
    }

    public String getBackgroundStatus() {
        return this._getStatus(this._getBackgroundDocument());
    }

    public List<Step> getBackgroundSteps() {
        return this._getSteps(this._getBackgroundDocument());
    }

    public CucumberFeatureResult getCucumberFeatureResult() {
        return this._cucumberFeatureResult;
    }

    public long getDuration() {
        return this.getBackgroundDuration() + this.getScenarioDuration();
    }

    public String getErrorDetails() {
        String status = this.getStatus();
        if (status.equals("PASSED")) {
            return null;
        }
        for (Step step : this.getSteps()) {
            String errorDetails = step.getErrorDetails();
            if (errorDetails == null) continue;
            return errorDetails;
        }
        return null;
    }

    public String getErrorStacktrace() {
        String status = this.getStatus();
        if (status.equals("PASSED")) {
            return null;
        }
        for (Step step : this.getSteps()) {
            String errorStacktrace = step.getErrorStacktrace();
            if (errorStacktrace == null) continue;
            return errorStacktrace;
        }
        return null;
    }

    public long getScenarioDuration() {
        return this._getDuration(this._getScenarioDocument());
    }

    public String getScenarioName() {
        return JenkinsResultsParserUtil.combine(this._getKeyword(this._getScenarioDocument()), ": ", this._getName(this._getScenarioDocument()));
    }

    public String getScenarioStatus() {
        return this._getStatus(this._getScenarioDocument());
    }

    public List<Step> getScenarioSteps() {
        return this._getSteps(this._getScenarioDocument());
    }

    public String getStatus() {
        String backgroundStatus = this.getBackgroundStatus();
        String scenarioStatus = this.getScenarioStatus();
        if (backgroundStatus.equals("PASSED") && scenarioStatus.equals("PASSED")) {
            return "PASSED";
        }
        return "FAILED";
    }

    public List<Step> getSteps() {
        ArrayList<Step> steps = new ArrayList<Step>();
        steps.addAll(this.getBackgroundSteps());
        steps.addAll(this.getScenarioSteps());
        return steps;
    }

    protected CucumberScenarioResult(CucumberFeatureResult cucumberFeatureResult, Document scenarioDocument, Document backgroundDocument) {
        this._cucumberFeatureResult = cucumberFeatureResult;
        this._scenarioDocument = scenarioDocument;
        this._backgroundDocument = backgroundDocument;
        if (this._scenarioDocument == null) {
            throw new RuntimeException("Scenario Document is null");
        }
    }

    private static long _getDurationFromString(String durationString) {
        String mins;
        Matcher matcher = _durationPattern.matcher(durationString);
        if (!matcher.find()) {
            return 0L;
        }
        long duration = Long.valueOf(matcher.group("ms"));
        String secs = matcher.group("secs");
        if (secs != null && !secs.isEmpty()) {
            duration += Long.valueOf(secs) * 1000L;
        }
        if ((mins = matcher.group("mins")) != null && !mins.isEmpty()) {
            duration += Long.valueOf(mins) * 1000L * 60L;
        }
        return duration;
    }

    private Document _getBackgroundDocument() {
        return this._backgroundDocument;
    }

    private long _getDuration(Document document) {
        Element element = (Element)Dom4JUtil.getNodeByXPath(document, "//div[@class='element']/span[contains(@class,'duration')]");
        if (element == null) {
            return 0L;
        }
        return CucumberScenarioResult._getDurationFromString(element.getTextTrim());
    }

    private String _getKeyword(Document document) {
        if (document == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("//div[@class='element']/span/div[contains(@class,'brief')]");
        sb.append("/span[contains(@class,'keyword')]");
        Node node = Dom4JUtil.getNodeByXPath(document, sb.toString());
        if (node == null) {
            return null;
        }
        return node.getText();
    }

    private String _getName(Document document) {
        if (document == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("//div[@class='element']/span/div[contains(@class,'brief')]");
        sb.append("/span[@class='name']");
        Node node = Dom4JUtil.getNodeByXPath(document, sb.toString());
        if (node == null) {
            return null;
        }
        return node.getText();
    }

    private Document _getScenarioDocument() {
        return this._scenarioDocument;
    }

    private String _getStatus(Document document) {
        if (document == null) {
            return "PASSED";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("//div[@class='element']/span[@data-toggle='collapse']");
        sb.append("/div[contains(@class,'brief')]");
        Element statusElement = (Element)Dom4JUtil.getNodeByXPath(document, sb.toString());
        if (statusElement == null) {
            return "FAILED";
        }
        String classes = statusElement.attributeValue("class");
        if (classes.contains("passed")) {
            return "PASSED";
        }
        return "FAILED";
    }

    private List<Step> _getSteps(Document document) {
        ArrayList<Step> steps = new ArrayList<Step>();
        List<Node> nodes = Dom4JUtil.getNodesByXPath(document, "//div[@class='step']");
        for (Node node : nodes) {
            Document stepDocument;
            try {
                stepDocument = Dom4JUtil.parse(node.asXML());
            }
            catch (DocumentException documentException) {
                continue;
            }
            steps.add(new Step(stepDocument));
        }
        return steps;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        try {
            this._backgroundDocument = Dom4JUtil.parse(objectInputStream.readUTF());
            this._scenarioDocument = Dom4JUtil.parse(objectInputStream.readUTF());
        }
        catch (DocumentException documentException) {
            throw new RuntimeException(documentException);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeUTF(this._backgroundDocument.asXML());
        objectOutputStream.writeUTF(this._scenarioDocument.asXML());
    }

    public static class Step
    implements Serializable {
        private transient Document _document;

        public long getDuration() {
            Element element = (Element)Dom4JUtil.getNodeByXPath(this._getDocument(), "//div[@class='step']/div/span[contains(@class,'duration')]");
            if (element == null) {
                return 0L;
            }
            return CucumberScenarioResult._getDurationFromString(element.getTextTrim());
        }

        public String getErrorDetails() {
            String status = this.getStatus();
            if (status.equals("PASSED")) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("//div[@class='step']/div[@class='inner-level']");
            sb.append("/div[contains(@class,'message')]/div/a");
            Element element = (Element)Dom4JUtil.getNodeByXPath(this._getDocument(), sb.toString());
            if (element == null) {
                return null;
            }
            return element.getText();
        }

        public String getErrorStacktrace() {
            String status = this.getStatus();
            if (status.equals("PASSED")) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("//div[@class='step']/div[@class='inner-level']");
            sb.append("/div[contains(@class,'message')]/div/pre");
            Element element = (Element)Dom4JUtil.getNodeByXPath(this._getDocument(), sb.toString());
            if (element == null) {
                return null;
            }
            return element.getText();
        }

        public String getName() {
            Element element = (Element)Dom4JUtil.getNodeByXPath(this._getDocument(), "//div[@class='step']/div/span[@class='name']");
            if (element == null) {
                return "";
            }
            return element.getStringValue();
        }

        public String getStatus() {
            Element element = (Element)Dom4JUtil.getNodeByXPath(this._getDocument(), "//div[@class='step']/div[contains(@class,'brief')]");
            if (element == null) {
                return "PASSED";
            }
            String classAttributeValue = element.attributeValue("class");
            if (classAttributeValue.contains("passed")) {
                return "PASSED";
            }
            return "FAILED";
        }

        private Step(Document document) {
            this._document = document;
        }

        private Document _getDocument() {
            return this._document;
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            try {
                this._document = Dom4JUtil.parse(objectInputStream.readUTF());
            }
            catch (DocumentException documentException) {
                throw new RuntimeException("Unable to deserialize document", documentException);
            }
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeUTF(this._document.asXML());
        }
    }
}

