/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.CucumberScenarioResult;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;

public class CucumberFeatureResult
implements Serializable {
    private List<CucumberScenarioResult> _cucumberScenarioResults;
    private transient Document _document;
    private final String _url;

    public List<CucumberScenarioResult> getCucumberScenarioResults() {
        if (this._cucumberScenarioResults != null) {
            return this._cucumberScenarioResults;
        }
        this._cucumberScenarioResults = new ArrayList<CucumberScenarioResult>();
        List<Node> nodes = Dom4JUtil.getNodesByXPath(this._getDocument(), "//div[contains(@class,'elements')]/div[@class='element']");
        Document backgroundDocument = null;
        Document scenarioDocument = null;
        for (Node node : nodes) {
            Node scenarioNameNode;
            Document document;
            try {
                document = Dom4JUtil.parse(node.asXML());
            }
            catch (DocumentException documentException) {
                continue;
            }
            Node backgroundNameNode = Dom4JUtil.getNodeByXPath(document, "//span[contains(.,'Background')]");
            if (backgroundNameNode != null) {
                backgroundDocument = document;
            }
            if ((scenarioNameNode = Dom4JUtil.getNodeByXPath(document, "//span[contains(.,'Scenario')]")) != null) {
                scenarioDocument = document;
            }
            if (scenarioDocument == null) continue;
            CucumberScenarioResult cucumberScenarioResult = new CucumberScenarioResult(this, scenarioDocument, backgroundDocument);
            backgroundDocument = null;
            scenarioDocument = null;
            this._cucumberScenarioResults.add(cucumberScenarioResult);
        }
        return this._cucumberScenarioResults;
    }

    public String getDescription() {
        Node node = Dom4JUtil.getNodeByXPath(this._getDocument(), "//div[@class='feature']/div[contains(@class,'description')]");
        if (node == null) {
            return "";
        }
        return node.getText();
    }

    public String getName() {
        StringBuilder sb = new StringBuilder();
        sb.append("//span[contains(@class,'keyword') and ");
        sb.append("contains(.,'Feature')]/parent::div/span[@class='name']");
        Node node = Dom4JUtil.getNodeByXPath(this._getDocument(), sb.toString());
        return "Feature: " + node.getText();
    }

    public List<String> getTags() {
        List<Node> nodes = Dom4JUtil.getNodesByXPath(this._getDocument(), "//div[@class='feature']/div[contains(@class,'tags')]/a");
        ArrayList<String> tags = new ArrayList<String>();
        for (Node node : nodes) {
            tags.add(node.getText());
        }
        return tags;
    }

    public String getURL() {
        return this._url;
    }

    protected CucumberFeatureResult(Build build, Node node) {
        if (build == null) {
            throw new IllegalArgumentException("Build is null");
        }
        if (node == null) {
            throw new IllegalArgumentException("Node is null");
        }
        Element element = (Element)node;
        Element anchorElement = element.element("a");
        this._url = JenkinsResultsParserUtil.combine(build.getBuildURL(), "cucumber-html-reports/", anchorElement.attributeValue("href"));
    }

    private Document _getDocument() {
        if (this._document != null) {
            return this._document;
        }
        try {
            String documentContent = JenkinsResultsParserUtil.toString(this.getURL(), false);
            documentContent = documentContent.replaceAll(Pattern.quote("&nbsp;"), " ");
            documentContent = documentContent.replaceAll(Pattern.quote("<br>"), "<br />");
            this._document = Dom4JUtil.parse(documentContent);
            return this._document;
        }
        catch (IOException | DocumentException exception) {
            throw new RuntimeException(exception);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        try {
            this._document = Dom4JUtil.parse(objectInputStream.readUTF());
        }
        catch (DocumentException documentException) {
            throw new RuntimeException("Unable to deserialize document", documentException);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Document document = this._getDocument();
        objectOutputStream.writeUTF(document.asXML());
    }
}

