/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.AxisBuild;
import com.liferay.jenkins.results.parser.BatchBuild;
import com.liferay.jenkins.results.parser.CucumberFeatureResult;
import com.liferay.jenkins.results.parser.CucumberScenarioResult;
import com.liferay.jenkins.results.parser.CucumberTestResult;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TestResultFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;

public class CucumberAxisBuild
extends AxisBuild {
    private List<CucumberFeatureResult> _cucumberFeatureResults;
    private Document _document;

    public List<CucumberFeatureResult> getCucumberFeatureResults() {
        if (this._cucumberFeatureResults != null) {
            return this._cucumberFeatureResults;
        }
        this._cucumberFeatureResults = new ArrayList<CucumberFeatureResult>();
        List<Node> nodes = Dom4JUtil.getNodesByXPath(this._getDocument(), "//tbody/tr/td[@class='tagname']");
        for (Node node : nodes) {
            CucumberFeatureResult cucumberFeatureResult = new CucumberFeatureResult(this, node);
            cucumberFeatureResult.getCucumberScenarioResults();
            this._cucumberFeatureResults.add(cucumberFeatureResult);
        }
        return this._cucumberFeatureResults;
    }

    public List<CucumberTestResult> getCucumberTestResults(String testStatus) {
        ArrayList<CucumberTestResult> cucumberTestResults = new ArrayList<CucumberTestResult>();
        for (TestResult testResult : this.getTestResults(testStatus)) {
            if (!(testResult instanceof CucumberTestResult)) continue;
            cucumberTestResults.add((CucumberTestResult)testResult);
        }
        return cucumberTestResults;
    }

    @Override
    public List<TestResult> getTestResults(String testStatus) {
        ArrayList<TestResult> testResults = new ArrayList<TestResult>();
        for (CucumberScenarioResult cucumberScenarioResult : this._getCucumberScenarioResults()) {
            testResults.add(TestResultFactory.newCucumberTestResultTestResult(this, cucumberScenarioResult));
        }
        return testResults;
    }

    protected CucumberAxisBuild(String url, BatchBuild parentBatchBuild) {
        super(JenkinsResultsParserUtil.getLocalURL(url), parentBatchBuild);
    }

    private List<CucumberScenarioResult> _getCucumberScenarioResults() {
        ArrayList<CucumberScenarioResult> cucumberScenarioResults = new ArrayList<CucumberScenarioResult>();
        for (CucumberFeatureResult cucumberFeatureResult : this.getCucumberFeatureResults()) {
            cucumberScenarioResults.addAll(cucumberFeatureResult.getCucumberScenarioResults());
        }
        return cucumberScenarioResults;
    }

    private Document _getDocument() {
        if (this._document != null) {
            return this._document;
        }
        try {
            String content = JenkinsResultsParserUtil.toString(this.getBuildURL() + "/cucumber-html-reports/overview-features.html");
            content = content.replaceAll("&nbsp;", " ");
            content = content.replaceAll("<br>", "<br/>");
            int x = content.indexOf("<table id=\"tablesorter\"");
            String end = "</table>";
            int y = content.indexOf(end, x) + end.length();
            this._document = Dom4JUtil.parse(content.substring(x, y));
            return this._document;
        }
        catch (IOException | DocumentException exception) {
            throw new RuntimeException(exception);
        }
    }
}

