/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.AntException;
import com.liferay.jenkins.results.parser.AntUtil;
import com.liferay.jenkins.results.parser.BasePortalWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.BuildDatabase;
import com.liferay.jenkins.results.parser.BuildDatabaseUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PullRequest;
import com.liferay.jenkins.results.parser.RemoteGitRef;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import java.io.File;
import java.io.IOException;
import org.json.JSONObject;

public class CompanionPortalWorkspaceGitRepository
extends BasePortalWorkspaceGitRepository {
    public static final String TYPE = "portal.companion";
    private final WorkspaceGitRepository _parentWorkspaceGitRepository;

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void setUp() {
        super.setUp();
        String parentUpstreamBranchName = this._parentWorkspaceGitRepository.getUpstreamBranchName();
        if (parentUpstreamBranchName.contains("-private")) {
            try {
                JenkinsResultsParserUtil.write(new File(this._parentWorkspaceGitRepository.getDirectory(), "git-commit-portal"), this.getBranchSHA());
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
            try {
                AntUtil.callTarget(this._parentWorkspaceGitRepository.getDirectory(), "build-working-dir.xml", "prepare-working-dir");
            }
            catch (AntException antException) {
                throw new RuntimeException(antException);
            }
            return;
        }
        File modulesPrivateDir = new File(this.getDirectory(), "modules/private");
        if (!modulesPrivateDir.exists()) {
            return;
        }
        File parentModulesPrivateDir = new File(this._parentWorkspaceGitRepository.getDirectory(), "modules/private");
        try {
            JenkinsResultsParserUtil.copy(modulesPrivateDir, parentModulesPrivateDir);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    protected CompanionPortalWorkspaceGitRepository(JSONObject jsonObject) {
        super(jsonObject);
        BuildDatabase buildDatabase = BuildDatabaseUtil.getBuildDatabase();
        this._parentWorkspaceGitRepository = buildDatabase.getWorkspaceGitRepository("portal");
    }

    protected CompanionPortalWorkspaceGitRepository(PullRequest pullRequest, String upstreamBranchName, WorkspaceGitRepository parentWorkspaceGitRepository) {
        super(pullRequest, upstreamBranchName);
        this._parentWorkspaceGitRepository = parentWorkspaceGitRepository;
    }

    protected CompanionPortalWorkspaceGitRepository(RemoteGitRef remoteGitRef, String upstreamBranchName, WorkspaceGitRepository parentWorkspaceGitRepository) {
        super(remoteGitRef, upstreamBranchName);
        this._parentWorkspaceGitRepository = parentWorkspaceGitRepository;
    }
}

