/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitRemote;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.LocalGitBranch;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONObject;

public class CentralGitSubrepository {
    private Boolean _centralPullRequestCandidate;
    private final String _centralUpstreamBranchName;
    private final Properties _ciProperties;
    private final Properties _gitrepoProperties;
    private final String _gitSubrepositoryDirectory;
    private final String _gitSubrepositoryName;
    private final String _gitSubrepositoryUpstreamBranchName;
    private String _gitSubrepositoryUpstreamCommit;
    private final String _gitSubrepositoryUsername;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CentralGitSubrepository(File gitrepoFile, String centralUpstreamBranchName) throws IOException {
        this._centralUpstreamBranchName = centralUpstreamBranchName;
        this._ciProperties = new Properties();
        this._gitrepoProperties = new Properties();
        this._gitrepoProperties.load(new FileInputStream(gitrepoFile));
        this._gitSubrepositoryName = this._getGitSubrepositoryName();
        StringBuilder sb = new StringBuilder();
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build properties", ioException);
        }
        sb.append(buildProperties.getProperty("base.repository.dir"));
        sb.append("/");
        sb.append(this._gitSubrepositoryName);
        if (!this._gitSubrepositoryName.endsWith("-private")) {
            sb.append("-private");
        }
        this._gitSubrepositoryDirectory = sb.toString();
        this._gitSubrepositoryUpstreamBranchName = this._centralUpstreamBranchName;
        this._gitSubrepositoryUsername = this._getGitSubrepositoryUsername();
        String tempBranchName = "temp-" + System.currentTimeMillis();
        GitWorkingDirectory gitWorkingDirectory = GitWorkingDirectoryFactory.newGitWorkingDirectory(this._gitSubrepositoryUpstreamBranchName, this._gitSubrepositoryDirectory, this._gitSubrepositoryName);
        LocalGitBranch upstreamLocalGitBranch = null;
        LocalGitBranch tempLocalGitBranch = null;
        try {
            tempLocalGitBranch = gitWorkingDirectory.createLocalGitBranch(tempBranchName);
            gitWorkingDirectory.checkoutLocalGitBranch(tempLocalGitBranch);
            GitRemote upstreamGitRemote = gitWorkingDirectory.getGitRemote("upstream");
            upstreamLocalGitBranch = gitWorkingDirectory.getLocalGitBranch(this._gitSubrepositoryUpstreamBranchName, true);
            gitWorkingDirectory.fetch(upstreamLocalGitBranch, gitWorkingDirectory.getRemoteGitBranch(this._gitSubrepositoryUpstreamBranchName, upstreamGitRemote, true));
            if (upstreamLocalGitBranch != null && tempLocalGitBranch != null && gitWorkingDirectory.localGitBranchExists(tempLocalGitBranch.getName())) {
                gitWorkingDirectory.checkoutLocalGitBranch(upstreamLocalGitBranch);
                gitWorkingDirectory.deleteLocalGitBranch(tempLocalGitBranch);
            }
        }
        catch (Throwable throwable) {
            if (upstreamLocalGitBranch != null && tempLocalGitBranch != null && gitWorkingDirectory.localGitBranchExists(tempLocalGitBranch.getName())) {
                gitWorkingDirectory.checkoutLocalGitBranch(upstreamLocalGitBranch);
                gitWorkingDirectory.deleteLocalGitBranch(tempLocalGitBranch);
            }
            throw throwable;
        }
        try {
            File ciPropertiesFile = new File(this._gitSubrepositoryDirectory, "ci.properties");
            this._ciProperties.load(new FileInputStream(ciPropertiesFile));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Unable to find ci.properties in " + this._gitSubrepositoryDirectory);
        }
    }

    public String getCIProperty(String key) {
        return this._ciProperties.getProperty(key);
    }

    public String getGitSubrepositoryName() {
        return this._gitSubrepositoryName;
    }

    public String getGitSubrepositoryUpstreamCommit() throws IOException {
        if (this._gitSubrepositoryUpstreamCommit == null) {
            this._gitSubrepositoryUpstreamCommit = this._getGitSubrepositoryUpstreamCommit();
        }
        return this._gitSubrepositoryUpstreamCommit;
    }

    public boolean isAutoPullEnabled() {
        String mode = this._gitrepoProperties.getProperty("mode", "push");
        if (!mode.equals("pull")) {
            return false;
        }
        return Boolean.parseBoolean(this._gitrepoProperties.getProperty("autopull", "false"));
    }

    public boolean isCentralPullRequestCandidate() throws IOException {
        if (this._centralPullRequestCandidate == null) {
            this._centralPullRequestCandidate = this._isCentralPullRequestCandidate();
        }
        return this._centralPullRequestCandidate;
    }

    public boolean isGitSubrepositoryUpstreamCommitMerged() throws IOException {
        String gitSubrepositoryMergedCommit = this._gitrepoProperties.getProperty("commit", "");
        return gitSubrepositoryMergedCommit.equals(this.getGitSubrepositoryUpstreamCommit());
    }

    private String _getGitSubrepositoryName() {
        String remote = this._gitrepoProperties.getProperty("remote");
        int x = remote.indexOf("/") + 1;
        int y = remote.indexOf(".git");
        return remote.substring(x, y);
    }

    private String _getGitSubrepositoryUpstreamCommit() throws IOException {
        String path = JenkinsResultsParserUtil.combine("git/refs/heads/", this._gitSubrepositoryUpstreamBranchName);
        String url = JenkinsResultsParserUtil.getGitHubApiUrl(this._gitSubrepositoryName, this._gitSubrepositoryUsername, path);
        JSONObject branchJSONObject = JenkinsResultsParserUtil.toJSONObject(url, false);
        JSONObject objectJSONObject = branchJSONObject.getJSONObject("object");
        return objectJSONObject.getString("sha");
    }

    private String _getGitSubrepositoryUsername() {
        String remote = this._gitrepoProperties.getProperty("remote");
        int x = remote.indexOf(":") + 1;
        int y = remote.indexOf("/");
        return remote.substring(x, y);
    }

    private String _getMergePullRequestURL() throws IOException {
        JSONArray statusesJSONArray;
        String path = JenkinsResultsParserUtil.combine("commits/", this.getGitSubrepositoryUpstreamCommit(), "/statuses");
        String url = JenkinsResultsParserUtil.getGitHubApiUrl(this._gitSubrepositoryName, this._gitSubrepositoryUsername, path);
        for (int i = 0; i < 15 && (statusesJSONArray = new JSONArray(JenkinsResultsParserUtil.toString(JenkinsResultsParserUtil.combine(url, "?page=", String.valueOf(i + 1)), true))) != null && statusesJSONArray.length() != 0; ++i) {
            for (int j = 0; j < statusesJSONArray.length(); ++j) {
                JSONObject statusesJSONObject = statusesJSONArray.getJSONObject(j);
                String context = statusesJSONObject.getString("context");
                if (!context.equals("liferay/central-pull-request")) continue;
                return statusesJSONObject.getString("target_url");
            }
        }
        return null;
    }

    private Boolean _isCentralPullRequestCandidate() throws IOException {
        if (!this.isAutoPullEnabled()) {
            return false;
        }
        if (this.isGitSubrepositoryUpstreamCommitMerged()) {
            System.out.println(JenkinsResultsParserUtil.combine("SKIPPED: ", this._gitSubrepositoryName, " contains merged commit https://github.com/", this._gitSubrepositoryUsername, "/", this._gitSubrepositoryName, "/commit/", this.getGitSubrepositoryUpstreamCommit()));
            return false;
        }
        String mergePullRequestURL = this._getMergePullRequestURL();
        if (mergePullRequestURL != null) {
            System.out.println(JenkinsResultsParserUtil.combine("SKIPPED: ", this._gitSubrepositoryName, " contains an open merge pull request ", mergePullRequestURL));
            return false;
        }
        return true;
    }
}

