/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsCohort;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.spira.SearchQuery;
import com.liferay.jenkins.results.parser.spira.SpiraProject;
import com.liferay.jenkins.results.parser.spira.SpiraRelease;
import com.liferay.jenkins.results.parser.spira.SpiraReleaseBuild;
import java.io.IOException;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONObject;

public class CISystemStatusReportUtil {
    private static final Properties _buildProperties;
    private static final DateTimeFormatter _dateTimeFormatter;
    private static final HashMap<LocalDate, List<SpiraReleaseBuild>> _recentSpiraReleaseBuilds;

    public static void writeJenkinsDataJavaScriptFile(String filePath) throws IOException {
        JenkinsCohort jenkinsCohort = new JenkinsCohort(_buildProperties.getProperty("ci.system.status.report.jenkins.cohort"));
        jenkinsCohort.writeDataJavaScriptFile(filePath);
    }

    public static void writeSpiraDataJavaScriptFile(String filePath) throws IOException {
        SpiraProject spiraProject = SpiraProject.getSpiraProjectByID(SpiraProject.getID("dxp"));
        SpiraRelease spiraRelease = spiraProject.getSpiraReleaseByID(SpiraRelease.getID("test-portal-acceptance-pullrequest(master)", "relevant"));
        List<SpiraReleaseBuild> spiraReleaseBuilds = SpiraReleaseBuild.getSpiraReleaseBuilds(spiraProject, spiraRelease, new SearchQuery.SearchParameter[0]);
        for (SpiraReleaseBuild spiraReleaseBuild : spiraReleaseBuilds) {
            LocalDate localDate = LocalDate.parse(spiraReleaseBuild.getCreationDate(), _dateTimeFormatter);
            if (!_recentSpiraReleaseBuilds.containsKey(localDate)) continue;
            List<SpiraReleaseBuild> builds = _recentSpiraReleaseBuilds.get(localDate);
            builds.add(spiraReleaseBuild);
            _recentSpiraReleaseBuilds.put(localDate, builds);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("var relevantSuiteBuildData = ");
        JSONObject relevantSuiteBuildDataJSONObject = CISystemStatusReportUtil._getrelevantSuiteBuildDataJSONObject();
        sb.append(relevantSuiteBuildDataJSONObject.toString());
        sb.append("\nvar spiraDataGeneratedDate = new Date(");
        sb.append(System.currentTimeMillis());
        sb.append(");\nvar successRateData = ");
        JSONArray successRateTableDataJSONArray = CISystemStatusReportUtil._getSuccessRateDataJSONArray();
        sb.append(successRateTableDataJSONArray.toString());
        sb.append(";");
        JenkinsResultsParserUtil.write(filePath, sb.toString());
    }

    protected static String getPercentage(Integer dividend, Integer divisor) {
        double quotient = 0.0;
        if (divisor != 0) {
            quotient = (double)dividend.intValue() / (double)divisor.intValue();
        }
        DecimalFormat decimalFormat = new DecimalFormat("###.##%");
        return decimalFormat.format(quotient);
    }

    private static JSONObject _getrelevantSuiteBuildDataJSONObject() {
        JSONObject relevantSuiteBuildDataJSONObject = new JSONObject();
        JSONArray datesJSONArray = new JSONArray();
        JSONArray failedBuildsJSONArray = new JSONArray();
        JSONArray passedBuildsJSONArray = new JSONArray();
        JSONArray unstableBuildsJSONArray = new JSONArray();
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>(_recentSpiraReleaseBuilds.keySet());
        Collections.sort(dates);
        for (LocalDate date : dates) {
            datesJSONArray.put((Object)date.toString());
            int failedBuilds = 0;
            int passedBuilds = 0;
            int unstableBuilds = 0;
            for (SpiraReleaseBuild spiraReleaseBuild : _recentSpiraReleaseBuilds.get(date)) {
                String buildStatusName = spiraReleaseBuild.getBuildStatusName();
                if (buildStatusName.equals("Failed")) {
                    ++failedBuilds;
                    continue;
                }
                if (buildStatusName.equals("Succeeded")) {
                    ++passedBuilds;
                    continue;
                }
                if (!buildStatusName.equals("Unstable")) continue;
                ++unstableBuilds;
            }
            passedBuildsJSONArray.put(passedBuilds);
            failedBuildsJSONArray.put(failedBuilds);
            unstableBuildsJSONArray.put(unstableBuilds);
        }
        relevantSuiteBuildDataJSONObject.put("dates", (Object)datesJSONArray);
        relevantSuiteBuildDataJSONObject.put("failed", (Object)failedBuildsJSONArray);
        relevantSuiteBuildDataJSONObject.put("succeeded", (Object)passedBuildsJSONArray);
        relevantSuiteBuildDataJSONObject.put("unstable", (Object)unstableBuildsJSONArray);
        return relevantSuiteBuildDataJSONObject;
    }

    private static JSONArray _getSuccessRateDataJSONArray() {
        JSONArray successRateDataJSONArray = new JSONArray();
        JSONArray titlesJSONArray = new JSONArray();
        titlesJSONArray.put((Object)"Time Period");
        titlesJSONArray.put((Object)"Adjusted Success Rate");
        titlesJSONArray.put((Object)"Success Rate");
        titlesJSONArray.put((Object)"Builds Run");
        successRateDataJSONArray.put((Object)titlesJSONArray);
        LocalDateTime currentLocalDateTime = LocalDateTime.now(ZoneOffset.UTC);
        successRateDataJSONArray.put((Object)CISystemStatusReportUtil._getSuccessRateJSONArray("Last 24 Hours", currentLocalDateTime.minusDays(1L), currentLocalDateTime));
        successRateDataJSONArray.put((Object)CISystemStatusReportUtil._getSuccessRateJSONArray("Last 7 Days", currentLocalDateTime.minusDays(7L), currentLocalDateTime));
        successRateDataJSONArray.put((Object)CISystemStatusReportUtil._getSuccessRateJSONArray("Previous 7 Days", currentLocalDateTime.minusDays(14L), currentLocalDateTime.minusDays(7L)));
        return successRateDataJSONArray;
    }

    private static JSONArray _getSuccessRateJSONArray(String title, LocalDateTime startLocalDateTime, LocalDateTime endLocalDateTime) {
        if (startLocalDateTime.compareTo(endLocalDateTime) >= 0) {
            throw new IllegalArgumentException("Start time must preceed end time");
        }
        JSONArray successRateJSONArray = new JSONArray();
        HashSet<LocalDate> localDates = new HashSet<LocalDate>();
        int i = 0;
        while (startLocalDateTime.compareTo(endLocalDateTime.minusDays(i)) <= 0) {
            LocalDateTime localDateTime = endLocalDateTime.minusDays(i);
            localDates.add(localDateTime.toLocalDate());
            ++i;
        }
        int failedBuilds = 0;
        int passedBuilds = 0;
        int unstableBuilds = 0;
        for (LocalDate localDate : localDates) {
            for (SpiraReleaseBuild spiraReleaseBuild : _recentSpiraReleaseBuilds.get(localDate)) {
                LocalDateTime localDateTime = LocalDateTime.parse(spiraReleaseBuild.getCreationDate(), _dateTimeFormatter);
                if (startLocalDateTime.compareTo(localDateTime) >= 0 || endLocalDateTime.compareTo(localDateTime) <= 0) continue;
                String buildStatusName = spiraReleaseBuild.getBuildStatusName();
                if (buildStatusName.equals("Failed")) {
                    ++failedBuilds;
                    continue;
                }
                if (buildStatusName.equals("Succeeded")) {
                    ++passedBuilds;
                    continue;
                }
                if (!buildStatusName.equals("Unstable")) continue;
                ++unstableBuilds;
            }
        }
        int totalBuilds = failedBuilds + passedBuilds + unstableBuilds;
        successRateJSONArray.put((Object)title);
        successRateJSONArray.put((Object)CISystemStatusReportUtil.getPercentage(passedBuilds + unstableBuilds, totalBuilds));
        successRateJSONArray.put((Object)CISystemStatusReportUtil.getPercentage(passedBuilds, totalBuilds));
        successRateJSONArray.put(totalBuilds);
        return successRateJSONArray;
    }

    static {
        _dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        try {
            _buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build.properties", ioException);
        }
        _recentSpiraReleaseBuilds = new HashMap<LocalDate, List<SpiraReleaseBuild>>(){
            {
                LocalDate localDate = LocalDate.now(ZoneOffset.UTC);
                int spiraHistoryLength = Integer.parseInt(_buildProperties.getProperty("ci.system.status.report.spira.history.length"));
                for (int i = 0; i < spiraHistoryLength; ++i) {
                    this.put(localDate.minusDays(i), new ArrayList());
                }
            }
        };
    }
}

