/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.AxisBuild;
import com.liferay.jenkins.results.parser.BaseBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.MultiPattern;
import com.liferay.jenkins.results.parser.ReinvokeRule;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;
import org.json.JSONArray;
import org.json.JSONObject;

public class BatchBuild
extends BaseBuild {
    protected final String batchName;
    protected final Pattern majorVersionPattern = Pattern.compile("((\\d+)\\.?(\\d+?)).*");
    private static ExecutorService _executorService = JenkinsResultsParserUtil.getNewThreadPoolExecutor(10, true);
    private static final Pattern _jobVariantPattern = Pattern.compile("(?<batchName>[^/]+)(/.*)?");

    @Override
    public void addTimelineData(BaseBuild.TimelineData timelineData) {
        this.addDownstreamBuildsTimelineData(timelineData);
    }

    @Override
    public String getAppServer() {
        return this.getSpiraPropertyValue("app.server");
    }

    @Override
    public URL getArtifactsBaseURL() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        StringBuilder sb = new StringBuilder();
        sb.append(topLevelBuild.getArtifactsBaseURL());
        sb.append("/");
        sb.append(this.getParameterValue("JOB_VARIANT"));
        try {
            return new URL(sb.toString());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public String getBatchName() {
        return this.batchName;
    }

    @Override
    public String getBrowser() {
        return this.getSpiraPropertyValue("browser");
    }

    @Override
    public String getDatabase() {
        return this.getSpiraPropertyValue("database");
    }

    public List<AxisBuild> getDownstreamAxisBuilds() {
        ArrayList<AxisBuild> downstreamAxisBuilds = new ArrayList<AxisBuild>();
        List<Build> downstreamBuilds = this.getDownstreamBuilds(null);
        for (Build downstreamBuild : downstreamBuilds) {
            if (!(downstreamBuild instanceof AxisBuild)) continue;
            downstreamAxisBuilds.add((AxisBuild)downstreamBuild);
        }
        Collections.sort(downstreamAxisBuilds, new BaseBuild.BuildDisplayNameComparator());
        return downstreamAxisBuilds;
    }

    @Override
    public Element getGitHubMessageElement() {
        Collections.sort(this.downstreamBuilds, new BaseBuild.BuildDisplayNameComparator());
        Element messageElement = super.getGitHubMessageElement();
        if (messageElement == null) {
            return messageElement;
        }
        String result = this.getResult();
        if (result.equals("ABORTED") && this.getDownstreamBuildCount(null) == 0) {
            return messageElement;
        }
        Map<Build, Element> downstreamBuildFailureMessages = this.getDownstreamBuildMessages(this.getFailedDownstreamBuilds());
        ArrayList<Element> failureElements = new ArrayList<Element>();
        ArrayList<Element> upstreamJobFailureElements = new ArrayList<Element>();
        for (Map.Entry<Build, Element> entry : downstreamBuildFailureMessages.entrySet()) {
            Element failureElement;
            Build failedDownstreamBuild = entry.getKey();
            Element upstreamJobFailureElement = failedDownstreamBuild.getGitHubMessageUpstreamJobFailureElement();
            if (upstreamJobFailureElement != null) {
                upstreamJobFailureElements.add(upstreamJobFailureElement);
            }
            if ((failureElement = entry.getValue()) == null) continue;
            if (BatchBuild.isHighPriorityBuildFailureElement(failureElement)) {
                failureElements.add(0, failureElement);
                continue;
            }
            failureElements.add(failureElement);
        }
        if (!upstreamJobFailureElements.isEmpty()) {
            this.upstreamJobFailureMessageElement = this.getGitHubMessageElement(true);
            Dom4JUtil.getOrderedListElement(upstreamJobFailureElements, this.upstreamJobFailureMessageElement, 4);
        }
        Dom4JUtil.getOrderedListElement(failureElements, messageElement, 4);
        if (failureElements.size() >= 4) {
            Dom4JUtil.getNewElement("strong", messageElement, "Click ", Dom4JUtil.getNewAnchorElement(this.getBuildURL() + "testReport", "here"), " for more failures.");
        }
        if (failureElements.isEmpty()) {
            return null;
        }
        return messageElement;
    }

    @Override
    public Long getInvokedTime() {
        if (this.invokedTime != null) {
            return this.invokedTime;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\\s*\\[echo\\]\\s*");
        sb.append(Pattern.quote(this.getJobName()));
        String jobVariant = this.getJobVariant();
        if (jobVariant != null && !jobVariant.isEmpty()) {
            sb.append("/");
            sb.append(Pattern.quote(jobVariant));
        }
        sb.append("\\s*invoked time: (?<invokedTime>[^\\n]*)");
        Pattern pattern = Pattern.compile(sb.toString());
        Build parentBuild = this.getParentBuild();
        String parentConsoleText = parentBuild.getConsoleText();
        for (String line : parentConsoleText.split("\n")) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            Properties buildProperties = null;
            try {
                buildProperties = JenkinsResultsParserUtil.getBuildProperties();
            }
            catch (IOException ioException) {
                throw new RuntimeException("Unable to get build properties", ioException);
            }
            SimpleDateFormat sdf = new SimpleDateFormat(buildProperties.getProperty("jenkins.report.date.format"));
            Date date = null;
            try {
                date = sdf.parse(matcher.group("invokedTime"));
            }
            catch (ParseException parseException) {
                throw new RuntimeException("Unable to get invoked time", parseException);
            }
            this.invokedTime = date.getTime();
            return this.invokedTime;
        }
        return this.getStartTime();
    }

    @Override
    public String getJDK() {
        return this.getSpiraPropertyValue("java.jdk");
    }

    @Override
    public Map<String, String> getMetricLabels() {
        Map<String, String> metricLabels = super.getMetricLabels();
        metricLabels.put("job_type", this.batchName);
        return metricLabels;
    }

    @Override
    public String getOperatingSystem() {
        return this.getSpiraPropertyValue("operating.system");
    }

    public String getSpiraPropertyValue(String propertyType) {
        String propertyName = this._getSpiraPropertyNameFromBatchName(propertyType);
        return JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "test.batch.spira.property.value", propertyType, propertyName);
    }

    @Override
    public List<TestResult> getTestResults(String testStatus) {
        String status = this.getStatus();
        if (!status.equals("completed")) {
            return Collections.emptyList();
        }
        JSONObject testReportJSONObject = this.getTestReportJSONObject(false);
        JSONArray childReportsJSONArray = testReportJSONObject.optJSONArray("childReports");
        if (childReportsJSONArray == null) {
            return Collections.emptyList();
        }
        ArrayList<TestResult> testResults = new ArrayList<TestResult>();
        for (int i = 0; i < childReportsJSONArray.length(); ++i) {
            String axisVariable;
            AxisBuild axisBuild;
            Matcher axisBuildURLMatcher;
            JSONArray suitesJSONArray;
            JSONObject resultJSONObject;
            String axisBuildURL;
            JSONObject childJSONObject;
            JSONObject childReportJSONObject = childReportsJSONArray.optJSONObject(i);
            if (childReportJSONObject == null || (childJSONObject = childReportJSONObject.optJSONObject("child")) == null || (axisBuildURL = childJSONObject.optString("url")) == null || (resultJSONObject = childReportJSONObject.optJSONObject("result")) == null || (suitesJSONArray = resultJSONObject.getJSONArray("suites")) == null) continue;
            if (this.fromArchive) {
                Pattern archiveBuildURLPattern = AxisBuild.archiveBuildURLPattern;
                axisBuildURLMatcher = archiveBuildURLPattern.matcher(axisBuildURL);
                if (!axisBuildURLMatcher.find()) {
                    throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to match archived axis build URL ", axisBuildURL, " with archived build URL pattern.", archiveBuildURLPattern.pattern()));
                }
            } else {
                MultiPattern buildURLMultiPattern = AxisBuild.buildURLMultiPattern;
                axisBuildURLMatcher = buildURLMultiPattern.find(axisBuildURL);
                if (axisBuildURLMatcher == null) continue;
            }
            if ((axisBuild = this.getAxisBuild(axisVariable = axisBuildURLMatcher.group("axisVariable"))) == null) continue;
            testResults.addAll(this.getTestResults(axisBuild, suitesJSONArray, testStatus));
        }
        return testResults;
    }

    @Override
    public long getTotalDuration() {
        long totalDuration = super.getTotalDuration();
        return totalDuration - this.getDuration();
    }

    @Override
    public int getTotalSlavesUsedCount() {
        return this.getTotalSlavesUsedCount(null, false);
    }

    @Override
    public int getTotalSlavesUsedCount(String status, boolean modifiedBuildsOnly) {
        return this.getTotalSlavesUsedCount(status, modifiedBuildsOnly, true);
    }

    @Override
    public synchronized void update() {
        super.update();
        if (this.badBuildNumbers.size() >= 1) {
            return;
        }
        String status = this.getStatus();
        String result = this.getResult();
        if (status.equals("completed") && result.equals("SUCCESS") || this.fromArchive) {
            return;
        }
        boolean reinvoked = false;
        block0: for (Build downstreamBuild : this.getDownstreamBuilds("completed")) {
            if (reinvoked) break;
            for (ReinvokeRule reinvokeRule : this.reinvokeRules) {
                String downstreamBuildResult = downstreamBuild.getResult();
                if (downstreamBuildResult == null || downstreamBuildResult.equals("SUCCESS") || !reinvokeRule.matches(downstreamBuild)) continue;
                this.reinvoke(reinvokeRule);
                reinvoked = true;
                continue block0;
            }
        }
    }

    protected BatchBuild(String url) {
        this(url, null);
    }

    protected BatchBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
        String jobVariant = this.getJobVariant();
        if (jobVariant != null && !jobVariant.isEmpty()) {
            Matcher matcher = _jobVariantPattern.matcher(jobVariant);
            if (!matcher.matches()) {
                throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to find batch name of batch build from ", "job variant '", jobVariant, "'. Job variant must match pattern '", _jobVariantPattern.pattern(), "'."));
            }
            this.batchName = matcher.group("batchName");
        } else {
            this.batchName = null;
        }
    }

    protected AxisBuild getAxisBuild(String axisVariable) {
        for (AxisBuild downstreamAxisBuild : this.getDownstreamAxisBuilds()) {
            if (!axisVariable.equals(downstreamAxisBuild.getAxisVariable())) continue;
            return downstreamAxisBuild;
        }
        return null;
    }

    @Override
    protected ExecutorService getExecutorService() {
        return _executorService;
    }

    @Override
    protected Element getFailureMessageElement() {
        return null;
    }

    @Override
    protected Element getGitHubMessageJobResultsElement() {
        return this.getGitHubMessageJobResultsElement(false);
    }

    @Override
    protected Element getGitHubMessageJobResultsElement(boolean showCommonFailuresCount) {
        String result = this.getResult();
        int failCount = this.getDownstreamBuildCountByResult("FAILURE");
        int successCount = this.getDownstreamBuildCountByResult("SUCCESS");
        if (result.equals("UNSTABLE")) {
            failCount = this.getTestCountByStatus("FAILURE");
            successCount = this.getTestCountByStatus("SUCCESS");
            if (this.isCompareToUpstream()) {
                List<TestResult> upstreamJobFailureTestResults = this.getUpstreamJobFailureTestResults();
                int upstreamFailCount = upstreamJobFailureTestResults.size();
                failCount = showCommonFailuresCount ? upstreamFailCount : (failCount -= upstreamFailCount);
            }
        }
        return Dom4JUtil.getNewElement("div", null, Dom4JUtil.getNewElement("h6", null, "Job Results:"), Dom4JUtil.getNewElement("p", null, String.valueOf(successCount), JenkinsResultsParserUtil.getNounForm(successCount, " Tests", " Test"), " Passed.", Dom4JUtil.getNewElement("br"), String.valueOf(failCount), JenkinsResultsParserUtil.getNounForm(failCount, " Tests", " Test"), " Failed.", this.getFailureMessageElement()));
    }

    @Override
    protected String getJenkinsReportBuildInfoCellElementTagName() {
        return "th";
    }

    @Override
    protected List<Element> getJenkinsReportTableRowElements(String result, String status) {
        ArrayList<Element> tableRowElements = new ArrayList<Element>();
        tableRowElements.add(this.getJenkinsReportTableRowElement());
        for (AxisBuild downstreamAxisBuild : this.getDownstreamAxisBuilds()) {
            tableRowElements.addAll(downstreamAxisBuild.getJenkinsReportTableRowElements(downstreamAxisBuild.getResult(), downstreamAxisBuild.getStatus()));
        }
        return tableRowElements;
    }

    @Override
    protected int getTestCountByStatus(String status) {
        JSONObject testReportJSONObject = this.getTestReportJSONObject(false);
        int failCount = testReportJSONObject.getInt("failCount");
        if (status.equals("SUCCESS")) {
            int totalCount = testReportJSONObject.getInt("totalCount");
            int skipCount = testReportJSONObject.getInt("skipCount");
            return totalCount - skipCount - failCount;
        }
        if (status.equals("FAILURE")) {
            return failCount;
        }
        throw new IllegalArgumentException("Invalid status: " + status);
    }

    private String _getSpiraPropertyNameFromBatchName(String propertyType) {
        String batchName = this.getBatchName();
        if (batchName == null || batchName.isEmpty()) {
            return null;
        }
        Properties jobProperties = this.getJobProperties();
        String propertyNamePrefix = JenkinsResultsParserUtil.combine("test.batch.spira.property.name[", propertyType, "]");
        HashSet<String> propertyNames = new HashSet<String>();
        for (Object jobPropertyNameObject : jobProperties.keySet()) {
            String propertyName;
            if (!(jobPropertyNameObject instanceof String)) continue;
            String jobPropertyNameRegex = JenkinsResultsParserUtil.combine(Pattern.quote(propertyNamePrefix), "\\[([^\\]+)\\]");
            String jobPropertyName = jobPropertyNameObject.toString();
            if (!jobPropertyName.matches(jobPropertyNameRegex) || !batchName.contains(propertyName = jobPropertyName.replaceAll(jobPropertyNameRegex, "$1"))) continue;
            propertyNames.add(propertyName);
        }
        if (propertyNames.isEmpty()) {
            return null;
        }
        String targetPropertyName = "";
        for (String propertyName : propertyNames) {
            if (propertyName.length() <= targetPropertyName.length()) continue;
            targetPropertyName = propertyName;
        }
        return targetPropertyName;
    }
}

