/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.google.common.collect.Lists;
import com.liferay.jenkins.results.parser.BaseLocalGitRepository;
import com.liferay.jenkins.results.parser.BuildDatabase;
import com.liferay.jenkins.results.parser.BuildDatabaseUtil;
import com.liferay.jenkins.results.parser.GitCommitFactory;
import com.liferay.jenkins.results.parser.GitHubDevSyncUtil;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.LocalGitBranch;
import com.liferay.jenkins.results.parser.LocalGitCommit;
import com.liferay.jenkins.results.parser.LocalGitRepository;
import com.liferay.jenkins.results.parser.PullRequest;
import com.liferay.jenkins.results.parser.RemoteGitRef;
import com.liferay.jenkins.results.parser.TestSuiteJob;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BaseWorkspaceGitRepository
extends BaseLocalGitRepository
implements WorkspaceGitRepository {
    private static final String[] _CI_KEYS_REQUIRED = new String[]{"git_hub_dev_branch_name"};
    private static final String _REGEX_SHA = "[0-9a-f]{7,40}";
    private static final String[] _REQUIRED_KEYS = new String[]{"branch_head_sha", "branch_name", "branch_sha", "git_hub_url", "type"};
    private List<LocalGitCommit> _historicalLocalGitCommits;
    private final Map<String, Properties> _propertiesFilesMap = new HashMap<String, Properties>();

    @Override
    public String getFileContent(String filePath) {
        File file = new File(this.getDirectory(), filePath);
        try {
            String fileContent = JenkinsResultsParserUtil.read(file);
            return fileContent.trim();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    public String getGitHubDevBranchName() {
        return this.getString("git_hub_dev_branch_name");
    }

    @Override
    public String getGitHubURL() {
        return this.getString("git_hub_url");
    }

    @Override
    public List<LocalGitCommit> getHistoricalLocalGitCommits() {
        if (this._historicalLocalGitCommits != null) {
            return this._historicalLocalGitCommits;
        }
        if (!this.has("commits")) {
            return new ArrayList<LocalGitCommit>();
        }
        this._historicalLocalGitCommits = new ArrayList<LocalGitCommit>();
        JSONArray commitsJSONArray = this.getJSONArray("commits");
        GitWorkingDirectory gitWorkingDirectory = this.getGitWorkingDirectory();
        for (int i = 0; i < commitsJSONArray.length(); ++i) {
            JSONObject commitJSONObject = commitsJSONArray.getJSONObject(i);
            this._historicalLocalGitCommits.add(GitCommitFactory.newLocalGitCommit(gitWorkingDirectory, commitJSONObject.getString("message"), commitJSONObject.getString("sha"), commitJSONObject.getLong("commitTime")));
        }
        return this._historicalLocalGitCommits;
    }

    @Override
    public Properties getWorkspaceJobProperties(String propertyType, Job job) {
        Properties jobProperties = job.getJobProperties();
        HashSet<String> workspaceJobPropertyNames = new HashSet<String>();
        for (String jobPropertyName : jobProperties.stringPropertyNames()) {
            String workspaceJobPropertyName;
            if (!jobPropertyName.startsWith(propertyType) || (workspaceJobPropertyName = this._getWorkspaceJobPropertyName(jobPropertyName)) == null) continue;
            workspaceJobPropertyNames.add(workspaceJobPropertyName);
        }
        Properties workspaceJobProperties = new Properties();
        for (String workspaceJobPropertyName : workspaceJobPropertyNames) {
            String workspaceJobPropertyValue = JenkinsResultsParserUtil.getProperty(jobProperties, propertyType, workspaceJobPropertyName, this.getUpstreamBranchName());
            if (workspaceJobPropertyValue == null && job instanceof TestSuiteJob) {
                TestSuiteJob testSuiteJob = (TestSuiteJob)job;
                workspaceJobPropertyValue = JenkinsResultsParserUtil.getProperty(jobProperties, propertyType, workspaceJobPropertyName, testSuiteJob.getTestSuiteName());
            }
            if (workspaceJobPropertyValue == null && JenkinsResultsParserUtil.isWindows()) {
                workspaceJobPropertyValue = JenkinsResultsParserUtil.getProperty(jobProperties, propertyType, workspaceJobPropertyName, "windows");
            }
            if (workspaceJobPropertyValue == null) continue;
            workspaceJobProperties.put(workspaceJobPropertyName, workspaceJobPropertyValue);
        }
        return workspaceJobProperties;
    }

    @Override
    public List<List<LocalGitCommit>> partitionLocalGitCommits(List<LocalGitCommit> localGitCommits, int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("Invalid count " + count);
        }
        int localGitCommitsSize = 0;
        if (localGitCommits != null && !localGitCommits.isEmpty()) {
            localGitCommitsSize = localGitCommits.size();
        }
        if (count > localGitCommitsSize) {
            throw new IllegalArgumentException(JenkinsResultsParserUtil.combine(String.valueOf(localGitCommitsSize), " commits cannot be split into ", String.valueOf(count), " lists"));
        }
        ArrayList lastLocalGitCommitsPartition = Lists.newArrayList((Object[])new LocalGitCommit[]{localGitCommits.get(localGitCommitsSize - 1)});
        ArrayList<List<LocalGitCommit>> localGitCommitsPartitions = new ArrayList<List<LocalGitCommit>>(count);
        if (localGitCommits.size() > 1) {
            localGitCommitsPartitions.addAll(JenkinsResultsParserUtil.partitionByCount(localGitCommits.subList(0, localGitCommitsSize - 2), count - 1));
        }
        localGitCommitsPartitions.add(lastLocalGitCommitsPartition);
        return localGitCommitsPartitions;
    }

    @Override
    public void setBranchSHA(String branchSHA) {
        if (branchSHA == null) {
            throw new RuntimeException("Branch SHA is null");
        }
        if (!branchSHA.matches(_REGEX_SHA)) {
            throw new RuntimeException("Branch SHA is invalid");
        }
        this.put("branch_sha", branchSHA);
    }

    @Override
    public void setUp() {
        System.out.println();
        System.out.println("##");
        System.out.println("## " + this.getDirectory());
        System.out.println("## " + this.toString());
        System.out.println("##");
        System.out.println();
        GitWorkingDirectory gitWorkingDirectory = this.getGitWorkingDirectory();
        if (!gitWorkingDirectory.localSHAExists(this._getBranchHeadSHA())) {
            GitHubDevSyncUtil.fetchCacheBranchFromGitHubDev(gitWorkingDirectory, this.getGitHubDevBranchName());
        }
        LocalGitBranch localGitBranch = gitWorkingDirectory.createLocalGitBranch(this._getBranchName(), true, this.getBranchSHA());
        gitWorkingDirectory.createLocalGitBranch(localGitBranch, true);
        gitWorkingDirectory.checkoutLocalGitBranch(localGitBranch);
        gitWorkingDirectory.reset("--hard " + localGitBranch.getSHA());
        gitWorkingDirectory.clean();
        gitWorkingDirectory.displayLog();
    }

    @Override
    public void storeCommitHistory(List<String> commitSHAs) {
        List<LocalGitCommit> historicalLocalGitCommits = this.getHistoricalLocalGitCommits();
        ArrayList<String> requiredCommitSHAs = new ArrayList<String>();
        requiredCommitSHAs.addAll(commitSHAs);
        JSONArray commitsJSONArray = new JSONArray();
        GitWorkingDirectory gitWorkingDirectory = this.getGitWorkingDirectory();
        for (int index = 0; index < COMMITS_HISTORY_SIZE_MAX; index += COMMITS_HISTORY_GROUP_SIZE.intValue()) {
            int currentGroupSize = COMMITS_HISTORY_GROUP_SIZE;
            if (index > COMMITS_HISTORY_SIZE_MAX - COMMITS_HISTORY_GROUP_SIZE) {
                currentGroupSize = COMMITS_HISTORY_SIZE_MAX % COMMITS_HISTORY_GROUP_SIZE;
            }
            List<LocalGitCommit> localGitCommits = gitWorkingDirectory.log(index, currentGroupSize);
            for (LocalGitCommit localGitCommit : localGitCommits) {
                historicalLocalGitCommits.add(localGitCommit);
                commitsJSONArray.put((Object)localGitCommit.toJSONObject());
                String sha = localGitCommit.getSHA();
                if (requiredCommitSHAs.contains(sha)) {
                    requiredCommitSHAs.remove(sha);
                }
                if (!requiredCommitSHAs.isEmpty()) continue;
                break;
            }
            if (requiredCommitSHAs.isEmpty()) break;
        }
        if (!requiredCommitSHAs.isEmpty()) {
            throw new RuntimeException("Unable to find the following SHAs: " + requiredCommitSHAs);
        }
        this.put("commits", commitsJSONArray);
    }

    @Override
    public void tearDown() {
        GitWorkingDirectory gitWorkingDirectory = this.getGitWorkingDirectory();
        LocalGitBranch upstreamLocalGitBranch = gitWorkingDirectory.getUpstreamLocalGitBranch();
        System.out.println();
        System.out.println("##");
        System.out.println("## " + upstreamLocalGitBranch.toString());
        System.out.println("##");
        System.out.println();
        gitWorkingDirectory.checkoutLocalGitBranch(upstreamLocalGitBranch);
        gitWorkingDirectory.reset("--hard " + upstreamLocalGitBranch.getSHA());
        gitWorkingDirectory.clean();
        gitWorkingDirectory.cleanTempBranches();
        gitWorkingDirectory.displayLog();
    }

    public String toString() {
        return JenkinsResultsParserUtil.combine(this.getGitHubURL(), " - ", this.getBranchSHA());
    }

    @Override
    public void writePropertiesFiles() {
        for (Map.Entry<String, Properties> entry : this._propertiesFilesMap.entrySet()) {
            JenkinsResultsParserUtil.writePropertiesFile(new File(this.getDirectory(), entry.getKey()), entry.getValue(), true);
        }
    }

    protected BaseWorkspaceGitRepository(JSONObject jsonObject) {
        super(jsonObject);
        this.validateKeys(_REQUIRED_KEYS);
        if (JenkinsResultsParserUtil.isCINode()) {
            this.validateKeys(_CI_KEYS_REQUIRED);
        }
    }

    protected BaseWorkspaceGitRepository(PullRequest pullRequest, String upstreamBranchName) {
        super(pullRequest.getGitHubRemoteGitRepositoryName(), upstreamBranchName);
        this._setGitHubURL(pullRequest.getHtmlURL());
        LocalGitBranch localGitBranch = GitHubDevSyncUtil.createCacheLocalGitBranch((LocalGitRepository)this, pullRequest, JenkinsResultsParserUtil.isCINode());
        this._setBranchHeadSHA(localGitBranch.getSHA());
        this._setBranchName(localGitBranch.getName());
        this.setBranchSHA(localGitBranch.getSHA());
        this._setType();
        this.validateKeys(_REQUIRED_KEYS);
        if (JenkinsResultsParserUtil.isCINode()) {
            this._setGitHubDevBranchName(GitHubDevSyncUtil.getCacheBranchName(pullRequest));
            this.validateKeys(_CI_KEYS_REQUIRED);
        }
    }

    protected BaseWorkspaceGitRepository(RemoteGitRef remoteGitRef, String upstreamBranchName) {
        super(remoteGitRef.getRepositoryName(), upstreamBranchName);
        this._setGitHubURL(JenkinsResultsParserUtil.combine("https://github.com/", remoteGitRef.getUsername(), "/", remoteGitRef.getRepositoryName(), "/tree/", remoteGitRef.getName()));
        LocalGitBranch localGitBranch = GitHubDevSyncUtil.createCacheLocalGitBranch((LocalGitRepository)this, remoteGitRef, JenkinsResultsParserUtil.isCINode());
        this._setBranchHeadSHA(localGitBranch.getSHA());
        this._setBranchName(localGitBranch.getName());
        this.setBranchSHA(localGitBranch.getSHA());
        this._setType();
        this.validateKeys(_REQUIRED_KEYS);
        if (JenkinsResultsParserUtil.isCINode()) {
            this._setGitHubDevBranchName(GitHubDevSyncUtil.getCacheBranchName(remoteGitRef));
            this.validateKeys(_CI_KEYS_REQUIRED);
        }
    }

    protected String getBranchSHA() {
        return this.optString("branch_sha");
    }

    @Override
    protected void put(String key, Object value) {
        super.put(key, value);
        BuildDatabase buildDatabase = BuildDatabaseUtil.getBuildDatabase();
        buildDatabase.putWorkspaceGitRepository(this.getType(), this);
    }

    protected void setProperties(String filePath, Properties properties) {
        if (!this._propertiesFilesMap.containsKey(filePath)) {
            this._propertiesFilesMap.put(filePath, new Properties());
        }
        Properties fileProperties = this._propertiesFilesMap.get(filePath);
        fileProperties.putAll((Map<?, ?>)properties);
        this._propertiesFilesMap.put(filePath, fileProperties);
    }

    private String _getBranchHeadSHA() {
        return this.getString("branch_head_sha");
    }

    private String _getBranchName() {
        return this.getString("branch_name");
    }

    private String _getWorkspaceJobPropertyName(String jobPropertyName) {
        Stack<Integer> stack = new Stack<Integer>();
        Integer start = null;
        Integer end = null;
        for (int i = 0; i < jobPropertyName.length(); ++i) {
            char c = jobPropertyName.charAt(i);
            if (c == '[') {
                stack.push(i);
                if (start == null) {
                    start = i;
                }
            }
            if (c != ']' || start == null) continue;
            stack.pop();
            if (!stack.isEmpty()) continue;
            end = i;
            break;
        }
        if (start != null && end != null) {
            return jobPropertyName.substring(start + 1, end);
        }
        return null;
    }

    private void _setBranchHeadSHA(String branchHeadSHA) {
        if (branchHeadSHA == null) {
            throw new RuntimeException("Branch head SHA is null");
        }
        if (!branchHeadSHA.matches(_REGEX_SHA)) {
            throw new RuntimeException("Branch head SHA is invalid");
        }
        this.put("branch_head_sha", branchHeadSHA);
    }

    private void _setBranchName(String branchName) {
        if (branchName == null) {
            throw new RuntimeException("Branch name is null");
        }
        this.put("branch_name", branchName);
    }

    private void _setGitHubDevBranchName(String gitHubDevBranchName) {
        if (gitHubDevBranchName == null) {
            throw new RuntimeException("GitHub dev branch name is null");
        }
        this.put("git_hub_dev_branch_name", gitHubDevBranchName);
    }

    private void _setGitHubURL(String gitHubURL) {
        if (gitHubURL == null) {
            throw new RuntimeException("GitHub URL is null");
        }
        this.put("git_hub_url", gitHubURL);
    }

    private void _setType() {
        this.put("type", this.getType());
    }
}

