/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.AxisBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TestClassResult;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.UpstreamFailureUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class BaseTestResult
implements TestResult {
    private static final String _URL_BASE_LOGS_DEFAULT = "https://testray.liferay.com/reports/production/logs";
    private final Build _build;
    private TestClassResult _testClassResult;

    @Override
    public Build getBuild() {
        return this._build;
    }

    @Override
    public TestClassResult getTestClassResult() {
        List<TestClassResult> testClassResults = this._build.getTestClassResults();
        if (testClassResults == null || testClassResults.isEmpty()) {
            return null;
        }
        String testClassName = this.getClassName();
        for (TestClassResult testClassResult : this._build.getTestClassResults()) {
            if (!testClassName.equals(testClassResult.getClassName())) continue;
            this._testClassResult = testClassResult;
            break;
        }
        return this._testClassResult;
    }

    @Override
    public boolean isFailing() {
        String status = this.getStatus();
        return !status.equals("FIXED") && !status.equals("PASSED") && !status.equals("SKIPPED");
    }

    @Override
    public boolean isUniqueFailure() {
        return !UpstreamFailureUtil.isTestFailingInUpstreamJob(this);
    }

    protected BaseTestResult(Build build) {
        if (build == null) {
            throw new IllegalArgumentException("Build is null");
        }
        this._build = build;
    }

    protected String getAxisNumber() {
        Build build = this.getBuild();
        if (build instanceof AxisBuild) {
            AxisBuild axisBuild = (AxisBuild)build;
            return axisBuild.getAxisNumber();
        }
        return "INVALID_AXIS_NUMBER";
    }

    protected String getConsoleOutputURL() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTestrayLogsURL());
        sb.append("/jenkins-console.txt.gz");
        return sb.toString();
    }

    protected String getLiferayLogURL() {
        StringBuilder sb = new StringBuilder();
        String name = this.getDisplayName();
        sb.append(this.getTestrayLogsURL());
        sb.append("/");
        sb.append(name.replace('#', '_'));
        sb.append("/liferay-log.txt.gz");
        return sb.toString();
    }

    protected String getTestrayLogsURL() {
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build properties", ioException);
        }
        String logBaseURL = null;
        if (buildProperties.containsKey("log.base.url")) {
            logBaseURL = buildProperties.getProperty("log.base.url");
        }
        if (logBaseURL == null) {
            logBaseURL = _URL_BASE_LOGS_DEFAULT;
        }
        Build build = this.getBuild();
        Map<String, String> startPropertiesTempMap = build.getStartPropertiesTempMap();
        return JenkinsResultsParserUtil.combine(logBaseURL, "/", startPropertiesTempMap.get("TOP_LEVEL_MASTER_HOSTNAME"), "/", startPropertiesTempMap.get("TOP_LEVEL_START_TIME"), "/", startPropertiesTempMap.get("TOP_LEVEL_JOB_NAME"), "/", startPropertiesTempMap.get("TOP_LEVEL_BUILD_NUMBER"), "/", build.getJobVariant(), "/", this.getAxisNumber());
    }

    protected boolean hasLiferayLog() {
        String liferayLog = null;
        try {
            liferayLog = JenkinsResultsParserUtil.toString(this.getLiferayLogURL(), false, 0, 0, 0);
        }
        catch (IOException ioException) {
            return false;
        }
        return !liferayLog.isEmpty();
    }
}

