/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.TestClassResult;
import com.liferay.jenkins.results.parser.TestResult;
import java.util.List;

public abstract class BaseTestClassResult
implements TestClassResult {
    private Status _status;
    private final List<TestResult> _testResults;

    @Override
    public Build getBuild() {
        TestResult firstTestResult = this._getFirstTestResult();
        return firstTestResult.getBuild();
    }

    @Override
    public String getClassName() {
        TestResult firstTestResult = this._getFirstTestResult();
        return firstTestResult.getClassName();
    }

    @Override
    public long getDuration() {
        long duration = 0L;
        for (TestResult testResult : this._testResults) {
            duration += testResult.getDuration();
        }
        return duration;
    }

    @Override
    public String getPackageName() {
        TestResult firstTestResult = this._getFirstTestResult();
        return firstTestResult.getPackageName();
    }

    @Override
    public String getSimpleClassName() {
        TestResult firstTestResult = this._getFirstTestResult();
        return firstTestResult.getSimpleClassName();
    }

    @Override
    public String getStatus() {
        if (this._status != null) {
            return this._status.toString();
        }
        TestResult firstTestResult = this._getFirstTestResult();
        this._status = Status.valueOf(firstTestResult.getStatus());
        for (TestResult testResult : this._testResults) {
            Status status = Status.valueOf(testResult.getStatus());
            if (this._status.getPriority() <= status.getPriority()) continue;
            this._status = status;
        }
        return this._status.toString();
    }

    @Override
    public List<TestResult> getTestResults() {
        return this._testResults;
    }

    @Override
    public boolean isFailing() {
        Status status = Status.valueOf(this.getStatus());
        return status != Status.FIXED && status != Status.PASSED && status != Status.SKIPPED;
    }

    protected BaseTestClassResult(List<TestResult> testResults) {
        if (testResults == null || testResults.isEmpty()) {
            throw new RuntimeException("Please set the test results");
        }
        this._testResults = testResults;
        String testClassName = this.getClassName();
        for (TestResult testResult : this._testResults) {
            if (testClassName.equals(testResult.getClassName())) continue;
            throw new RuntimeException("Mismatched test class name " + testClassName);
        }
    }

    private TestResult _getFirstTestResult() {
        return this._testResults.get(0);
    }

    private static enum Status {
        ABORTED(1),
        FAILED(2),
        FIXED(6),
        PASSED(7),
        REGRESSION(3),
        SKIPPED(5),
        UNSTABLE(4);

        private final Integer _priority;

        public Integer getPriority() {
            return this._priority;
        }

        private Status(Integer priority) {
            this._priority = priority;
        }
    }
}

