/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.AntException;
import com.liferay.jenkins.results.parser.BatchBuildData;
import com.liferay.jenkins.results.parser.JDK;
import com.liferay.jenkins.results.parser.JDKFactory;
import com.liferay.jenkins.results.parser.TestBatch;
import com.liferay.jenkins.results.parser.Workspace;

public abstract class BaseTestBatch<T extends BatchBuildData, S extends Workspace>
implements TestBatch<T, S> {
    private final T _batchBuildData;
    private final JDK _jdk;
    private final S _workspace;

    public JDK getJDK() {
        return this._jdk;
    }

    @Override
    public void run() {
        try {
            this.executeBatch();
        }
        catch (AntException antException) {
            throw new RuntimeException(antException);
        }
        finally {
            this.publishResults();
        }
    }

    protected BaseTestBatch(T batchBuildData, S workspace) {
        this._batchBuildData = batchBuildData;
        this._jdk = JDKFactory.getJDK(batchBuildData.getBatchName());
        this._workspace = workspace;
    }

    protected abstract void executeBatch() throws AntException;

    protected String getAntOpts(String batchName) {
        return this._jdk.getAntOpts();
    }

    protected T getBatchBuildData() {
        return this._batchBuildData;
    }

    protected String getJavaHome(String batchName) {
        return this._jdk.getJavaHome();
    }

    protected String getPath(String batchName) {
        String path = System.getenv("PATH");
        return path.replaceAll("jdk", this._jdk.getName());
    }

    protected S getWorkspace() {
        return this._workspace;
    }

    protected abstract void publishResults();
}

