/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseGitRepository;
import com.liferay.jenkins.results.parser.GitHubDevSyncUtil;
import com.liferay.jenkins.results.parser.GitRemote;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.RemoteGitRepository;
import java.util.List;
import java.util.Objects;

public abstract class BaseRemoteGitRepository
extends BaseGitRepository
implements RemoteGitRepository {
    private static final String[] _KEYS_REQUIRED = new String[]{"hostname", "username"};

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BaseRemoteGitRepository)) {
            return false;
        }
        BaseRemoteGitRepository baseRemoteGitRepository = (BaseRemoteGitRepository)object;
        return Objects.equals(this.getHostname(), baseRemoteGitRepository.getHostname()) && JenkinsResultsParserUtil.isJSONObjectEqual(this.getJSONObject(), baseRemoteGitRepository.getJSONObject()) && Objects.equals(this.getName(), baseRemoteGitRepository.getName()) && Objects.equals(this.getRemoteURL(), baseRemoteGitRepository.getRemoteURL()) && Objects.equals(this.getUsername(), baseRemoteGitRepository.getUsername());
    }

    @Override
    public String getHostname() {
        return this.getString("hostname");
    }

    @Override
    public String getRemoteURL() {
        List<String> gitHubDevNodeHostnames = GitHubDevSyncUtil.getGitHubDevNodeHostnames();
        if (gitHubDevNodeHostnames.contains("slave-" + this.getHostname())) {
            return JenkinsResultsParserUtil.combine("root@", this.getHostname(), ":/opt/dev/projects/github/", this.getName());
        }
        return JenkinsResultsParserUtil.combine("git@", this.getHostname(), ":", this.getUsername(), "/", this.getName());
    }

    @Override
    public String getUsername() {
        return this.getString("username");
    }

    public int hashCode() {
        String hash = JenkinsResultsParserUtil.combine(this.getHostname(), this.getName(), this.getRemoteURL(), this.getUsername());
        return hash.hashCode();
    }

    protected BaseRemoteGitRepository(GitRemote gitRemote) {
        this(gitRemote.getHostname(), gitRemote.getGitRepositoryName(), gitRemote.getUsername());
    }

    protected BaseRemoteGitRepository(String hostname, String gitRepositoryName, String username) {
        super(gitRepositoryName);
        if (hostname == null || hostname.isEmpty()) {
            throw new IllegalArgumentException("Hostname is null");
        }
        if (username == null || username.isEmpty()) {
            throw new IllegalArgumentException("Username is null");
        }
        this.put("hostname", hostname);
        this.put("username", username);
        this.validateKeys(_KEYS_REQUIRED);
    }
}

