/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseWorkspace;
import com.liferay.jenkins.results.parser.BuildData;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.LegacyWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.PortalWorkspace;
import com.liferay.jenkins.results.parser.PortalWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import com.liferay.jenkins.results.parser.WorkspaceUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BasePortalWorkspace
extends BaseWorkspace
implements PortalWorkspace {
    protected final LegacyWorkspaceGitRepository legacyWorkspaceGitRepository;
    private static final String _URL_GITHUB_PORTAL_LEGACY_EE_REPOSITORY = "https://github.com/liferay/liferay-qa-portal-legacy-ee/tree/master";
    private static final Pattern _portalBatchNamePattern = Pattern.compile(".*-(?<databaseName>(?<databaseType>db2|mariadb|mysql|oracle|postgresql|sybase)\\d+)(-.*|$)");
    private static final Pattern _portalGitHubURLPattern = Pattern.compile("https://github.com/[^/]+/(?<gitRepositoryName>liferay-portal(-ee)?)/.*");
    private final WorkspaceGitRepository _companionPortalWorkspaceGitRepository;
    private final WorkspaceGitRepository _otherPortalWorkspaceGitRepository;
    private final WorkspaceGitRepository _pluginsWorkspaceGitRepository;
    private final PortalWorkspaceGitRepository _primaryPortalWorkspaceGitRepository;

    public static boolean isPortalGitHubURL(String gitHubURL) {
        Matcher matcher = _portalGitHubURLPattern.matcher(gitHubURL);
        return matcher.find();
    }

    @Override
    public WorkspaceGitRepository getCompanionPortalWorkspaceGitRepository() {
        return this._companionPortalWorkspaceGitRepository;
    }

    @Override
    public LegacyWorkspaceGitRepository getLegacyWorkspaceGitRepository() {
        return this.legacyWorkspaceGitRepository;
    }

    @Override
    public WorkspaceGitRepository getOtherPortalWorkspaceGitRepository() {
        return this._otherPortalWorkspaceGitRepository;
    }

    @Override
    public WorkspaceGitRepository getPluginsWorkspaceGitRepository() {
        return this._pluginsWorkspaceGitRepository;
    }

    @Override
    public PortalWorkspaceGitRepository getPrimaryPortalWorkspaceGitRepository() {
        return this._primaryPortalWorkspaceGitRepository;
    }

    protected BasePortalWorkspace(String portalGitHubURL, String portalUpstreamBranchName) {
        this(portalGitHubURL, portalUpstreamBranchName, null);
    }

    protected BasePortalWorkspace(String portalGitHubURL, String portalUpstreamBranchName, String portalBranchSHA) {
        WorkspaceGitRepository workspaceGitRepository = WorkspaceUtil.getWorkspaceGitRepository("portal", portalGitHubURL, portalUpstreamBranchName);
        if (!(workspaceGitRepository instanceof PortalWorkspaceGitRepository)) {
            throw new RuntimeException("Invalid workspace Git repository");
        }
        this._primaryPortalWorkspaceGitRepository = (PortalWorkspaceGitRepository)workspaceGitRepository;
        if (portalBranchSHA != null) {
            this._primaryPortalWorkspaceGitRepository.setBranchSHA(portalBranchSHA);
        }
        this._primaryPortalWorkspaceGitRepository.setUp();
        if (portalUpstreamBranchName.endsWith("private")) {
            this._companionPortalWorkspaceGitRepository = WorkspaceUtil.getDependencyWorkspaceGitRepository("portal.companion", this._primaryPortalWorkspaceGitRepository);
            this._companionPortalWorkspaceGitRepository.setUp();
        } else {
            this._companionPortalWorkspaceGitRepository = null;
        }
        workspaceGitRepository = WorkspaceUtil.getWorkspaceGitRepository("legacy", _URL_GITHUB_PORTAL_LEGACY_EE_REPOSITORY, "master");
        if (!(workspaceGitRepository instanceof LegacyWorkspaceGitRepository)) {
            throw new RuntimeException("Invalid workspace Git repository");
        }
        this.legacyWorkspaceGitRepository = (LegacyWorkspaceGitRepository)workspaceGitRepository;
        this._otherPortalWorkspaceGitRepository = WorkspaceUtil.getDependencyWorkspaceGitRepository("portal.other", this._primaryPortalWorkspaceGitRepository);
        this._pluginsWorkspaceGitRepository = WorkspaceUtil.getDependencyWorkspaceGitRepository("portal.plugins", this._primaryPortalWorkspaceGitRepository);
    }

    @Override
    protected void setUpWorkspaceGitRepositories() {
        this.setUpJenkinsWorkspaceGitRepository();
        this._primaryPortalWorkspaceGitRepository.setUp();
        if (this._companionPortalWorkspaceGitRepository != null) {
            this._companionPortalWorkspaceGitRepository.setUp();
        }
        if (this._otherPortalWorkspaceGitRepository != null) {
            this._otherPortalWorkspaceGitRepository.setUp();
        }
        this._pluginsWorkspaceGitRepository.setUp();
    }

    @Override
    protected void setWorkspaceBuildDataProperties(BuildData buildData) {
        String portalBatchName;
        Map<String, String> topLevelBuildParameters = buildData.getTopLevelBuildParameters();
        Properties portalTestProperties = new Properties();
        if (topLevelBuildParameters.containsKey("PORTAL_BATCH_NAME") && topLevelBuildParameters.containsKey("PORTAL_BATCH_TEST_SELECTOR") && ((portalBatchName = topLevelBuildParameters.get("PORTAL_BATCH_NAME")).contains("integration") || portalBatchName.contains("unit"))) {
            portalTestProperties.setProperty(JenkinsResultsParserUtil.combine("test.batch.axis.count[", portalBatchName, "]"), "1");
            portalTestProperties.setProperty(JenkinsResultsParserUtil.combine("test.batch.class.names.includes[", portalBatchName, "]"), topLevelBuildParameters.get("PORTAL_BATCH_TEST_SELECTOR"));
        }
        if (Boolean.valueOf(System.getenv("DOCKER_ENABLED")).booleanValue() && topLevelBuildParameters.containsKey("PORTAL_BATCH_NAME")) {
            portalBatchName = topLevelBuildParameters.get("PORTAL_BATCH_NAME");
            Matcher matcher = _portalBatchNamePattern.matcher(portalBatchName);
            String databaseType = "mysql";
            if (matcher.find()) {
                Properties buildProperties = null;
                try {
                    buildProperties = JenkinsResultsParserUtil.getBuildProperties();
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException);
                }
                String databaseName = matcher.group("databaseName");
                databaseType = matcher.group("databaseType");
                portalTestProperties.setProperty(JenkinsResultsParserUtil.combine("database.", databaseType, ".docker.image"), JenkinsResultsParserUtil.getProperty(buildProperties, JenkinsResultsParserUtil.combine("database.docker.image[", databaseName, "]")));
                portalTestProperties.setProperty(JenkinsResultsParserUtil.combine("database.", databaseType, ".docker.run.options"), JenkinsResultsParserUtil.getProperty(buildProperties, JenkinsResultsParserUtil.combine("database.docker.run.options[", databaseName, "]")));
            }
            String databaseHost = JenkinsResultsParserUtil.combine(System.getenv("HOSTNAME"), "_", databaseType);
            portalTestProperties.setProperty(JenkinsResultsParserUtil.combine("database.", databaseType, ".host"), databaseHost);
            if (databaseType.equals("mariadb")) {
                portalTestProperties.setProperty("database.mariadb.port", "3306");
            } else if (databaseType.equals("oracle")) {
                portalTestProperties.setProperty("database.oracle.url", JenkinsResultsParserUtil.combine("jdbc:oracle:thin:@", databaseHost, ":1521/oracl"));
            }
        }
        this._primaryPortalWorkspaceGitRepository.setPortalTestProperties(portalTestProperties);
    }

    @Override
    protected void setWorkspaceDefaultProperties() {
        Properties portalAppServerProperties = new Properties();
        portalAppServerProperties.put("app.server.parent.dir", this._primaryPortalWorkspaceGitRepository.getDirectory() + "/bundles");
        this._primaryPortalWorkspaceGitRepository.setPortalAppServerProperties(portalAppServerProperties);
        Properties portalBuildProperties = new Properties();
        portalBuildProperties.put("jsp.precompile", "off");
        portalBuildProperties.put("liferay.home", this._primaryPortalWorkspaceGitRepository.getDirectory() + "/bundles");
        this._primaryPortalWorkspaceGitRepository.setPortalBuildProperties(portalBuildProperties);
        Properties portalTestProperties = new Properties();
        portalTestProperties.put("test.url", "http://" + System.getenv("HOSTNAME") + ":8080");
        this._primaryPortalWorkspaceGitRepository.setPortalTestProperties(portalTestProperties);
    }

    @Override
    protected void setWorkspaceJobProperties(Job job) {
        this._primaryPortalWorkspaceGitRepository.setPortalAppServerProperties(this._primaryPortalWorkspaceGitRepository.getWorkspaceJobProperties("portal.app.server.properties", job));
        this._primaryPortalWorkspaceGitRepository.setPortalBuildProperties(this._primaryPortalWorkspaceGitRepository.getWorkspaceJobProperties("portal.build.properties", job));
        this._primaryPortalWorkspaceGitRepository.setPortalReleaseProperties(this._primaryPortalWorkspaceGitRepository.getWorkspaceJobProperties("portal.release.properties", job));
        this._primaryPortalWorkspaceGitRepository.setPortalSQLProperties(this._primaryPortalWorkspaceGitRepository.getWorkspaceJobProperties("portal.sql.properties", job));
        this._primaryPortalWorkspaceGitRepository.setPortalTestProperties(this._primaryPortalWorkspaceGitRepository.getWorkspaceJobProperties("portal.test.properties", job));
    }

    @Override
    protected void tearDownWorkspaceGitRepositories() {
        this.tearDownJenkinsWorkspaceGitRepository();
        this._primaryPortalWorkspaceGitRepository.tearDown();
        if (this._companionPortalWorkspaceGitRepository != null) {
            this._companionPortalWorkspaceGitRepository.tearDown();
        }
        if (this._otherPortalWorkspaceGitRepository != null) {
            this._otherPortalWorkspaceGitRepository.tearDown();
        }
        this._pluginsWorkspaceGitRepository.tearDown();
    }

    @Override
    protected void writeWorkspaceGitRepositoryPropertiesFiles() {
        this._primaryPortalWorkspaceGitRepository.writePropertiesFiles();
        this._pluginsWorkspaceGitRepository.writePropertiesFiles();
    }
}

