/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.AntException;
import com.liferay.jenkins.results.parser.AntUtil;
import com.liferay.jenkins.results.parser.BaseTestBatch;
import com.liferay.jenkins.results.parser.BatchBuildData;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalBatchBuildData;
import com.liferay.jenkins.results.parser.PortalWorkspace;
import com.liferay.jenkins.results.parser.PortalWorkspaceGitRepository;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public abstract class BasePortalTestBatch<T extends PortalBatchBuildData, S extends PortalWorkspace>
extends BaseTestBatch<T, S> {
    protected BasePortalTestBatch(T batchBuildData, S workspace) {
        super(batchBuildData, workspace);
    }

    @Override
    protected void executeBatch() throws AntException {
        BatchBuildData batchBuildData = this.getBatchBuildData();
        HashMap<String, String> buildParameters = new HashMap<String, String>();
        buildParameters.put("axis.variable", JenkinsResultsParserUtil.join(",", batchBuildData.getTestList()));
        buildParameters.put("test.batch.name", batchBuildData.getBatchName());
        HashMap<String, String> environmentVariables = new HashMap<String, String>();
        if (JenkinsResultsParserUtil.isCINode()) {
            String batchName = batchBuildData.getBatchName();
            environmentVariables.put("ANT_OPTS", this.getAntOpts(batchName));
            environmentVariables.put("JAVA_HOME", this.getJavaHome(batchName));
            environmentVariables.put("PATH", this.getPath(batchName));
        }
        AntUtil.callTarget(this.getPrimaryPortalWorkspaceDirectory(), "build-test-batch.xml", batchBuildData.getBatchName(), buildParameters, environmentVariables);
    }

    @Override
    protected T getBatchBuildData() {
        return (T)((PortalBatchBuildData)super.getBatchBuildData());
    }

    protected File getPrimaryPortalWorkspaceDirectory() {
        PortalWorkspace portalWorkspace = (PortalWorkspace)this.getWorkspace();
        PortalWorkspaceGitRepository workspaceGitRepository = portalWorkspace.getPrimaryPortalWorkspaceGitRepository();
        return workspaceGitRepository.getDirectory();
    }

    @Override
    protected void publishResults() {
        try {
            AntUtil.callTarget(this.getPrimaryPortalWorkspaceDirectory(), "build-test.xml", "merge-test-results");
        }
        catch (AntException antException) {
            throw new RuntimeException(antException);
        }
        File sourceFile = new File(this.getPrimaryPortalWorkspaceDirectory(), "test-results/TESTS-TestSuites.xml");
        if (!sourceFile.exists()) {
            return;
        }
        BatchBuildData batchBuildData = this.getBatchBuildData();
        File targetFile = new File(batchBuildData.getWorkspaceDir(), "test-results/TESTS-TestSuites.xml");
        try {
            JenkinsResultsParserUtil.copy(sourceFile, targetFile);
        }
        catch (IOException ioException) {
            throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to copy test results file from ", sourceFile.getPath(), " to ", targetFile.getPath()), ioException);
        }
    }
}

