/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseJob;
import com.liferay.jenkins.results.parser.BatchDependentJob;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.TestSuiteJob;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.SegmentTestClassGroup;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public abstract class BasePortalReleaseJob
extends BaseJob
implements BatchDependentJob,
PortalTestClassJob,
TestSuiteJob {
    private final GitWorkingDirectory _jenkinsGitWorkingDirectory;
    private final String _portalBranchName;
    private final PortalGitWorkingDirectory _portalGitWorkingDirectory;
    private final String _testSuiteName;

    public BasePortalReleaseJob(String jobName, Job.BuildProfile buildProfile, String portalBranchName, String testSuiteName) {
        super(jobName, buildProfile);
        this._portalBranchName = portalBranchName;
        this._testSuiteName = testSuiteName;
        this._jenkinsGitWorkingDirectory = GitWorkingDirectoryFactory.newJenkinsGitWorkingDirectory();
        this._portalGitWorkingDirectory = GitWorkingDirectoryFactory.newPortalGitWorkingDirectory(portalBranchName);
        this.jobPropertiesFiles.add(new File(this._portalGitWorkingDirectory.getWorkingDirectory(), "test.properties"));
        this.readJobProperties();
    }

    @Override
    public Set<String> getDependentBatchNames() {
        return this.getFilteredBatchNames(this.getRawDependentBatchNames());
    }

    @Override
    public List<BatchTestClassGroup> getDependentBatchTestClassGroups() {
        return this.getBatchTestClassGroups(this.getRawDependentBatchNames());
    }

    @Override
    public Set<String> getDependentSegmentNames() {
        return this.getFilteredSegmentNames(this.getRawDependentBatchNames());
    }

    @Override
    public List<SegmentTestClassGroup> getDependentSegmentTestClassGroups() {
        return this.getSegmentTestClassGroups(this.getRawDependentBatchNames());
    }

    @Override
    public Set<String> getDistTypes() {
        return Collections.emptySet();
    }

    @Override
    public PortalGitWorkingDirectory getPortalGitWorkingDirectory() {
        return this._portalGitWorkingDirectory;
    }

    @Override
    public String getTestSuiteName() {
        return this._testSuiteName;
    }

    protected GitWorkingDirectory getJenkinsGitWorkingDirectory() {
        return this._jenkinsGitWorkingDirectory;
    }

    @Override
    protected Set<String> getRawBatchNames() {
        TreeSet<String> batchNames = new TreeSet<String>();
        Properties jobProperties = this.getJobProperties();
        batchNames.addAll(this.getSetFromString(JenkinsResultsParserUtil.getProperty(jobProperties, "test.batch.names", false, this._portalBranchName, this.getTestSuiteName())));
        Job.BuildProfile buildProfile = this.getBuildProfile();
        batchNames.addAll(this.getSetFromString(JenkinsResultsParserUtil.getProperty(jobProperties, "test.batch.names", false, this._portalBranchName, buildProfile.toString(), this.getTestSuiteName())));
        return batchNames;
    }

    protected Set<String> getRawDependentBatchNames() {
        TreeSet<String> dependentBatchNames = new TreeSet<String>();
        dependentBatchNames.addAll(this.getSetFromString(JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "test.batch.names.smoke", false, this._portalBranchName, this.getTestSuiteName())));
        Job.BuildProfile buildProfile = this.getBuildProfile();
        dependentBatchNames.addAll(this.getSetFromString(JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "test.batch.names.smoke", false, this._portalBranchName, buildProfile.toString(), this.getTestSuiteName())));
        return dependentBatchNames;
    }
}

